/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.js;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.Mapping;
import org.jetbrains.kotlin.backend.common.MappingsKt;
import org.jetbrains.kotlin.backend.common.ir.DeclarationFactory;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.ir.backend.js.JsMapping;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.impl.IrConstructorImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrFieldImpl;
import org.jetbrains.kotlin.ir.descriptors.WrappedClassConstructorDescriptor;
import org.jetbrains.kotlin.ir.descriptors.WrappedFieldDescriptor;
import org.jetbrains.kotlin.ir.symbols.impl.IrConstructorSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrFieldSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J0\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0007H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\u00072\u0006\u0010\"\u001a\u00020\tH\u0016J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\tH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/backend/js/JsDeclarationFactory;", "Lorg/jetbrains/kotlin/backend/common/ir/DeclarationFactory;", "mapping", "Lorg/jetbrains/kotlin/ir/backend/js/JsMapping;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsMapping;)V", "innerClassConstructors", "Lorg/jetbrains/kotlin/backend/common/Mapping$Delegate;", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "originalInnerClassPrimaryConstructorByClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "outerThisFieldSymbols", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "singletonFieldDescriptors", "createInnerClassConstructorWithOuterThisParameter", "oldConstructor", "createObjectInstanceFieldDescriptor", "singleton", "origin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "createPropertyWithBackingField", "name", "Lorg/jetbrains/kotlin/name/Name;", "visibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "parent", "fieldType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getFieldForEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "getFieldForObjectInstance", "getInnerClassConstructorWithOuterThisParameter", "innerClassConstructor", "getInnerClassOriginalPrimaryConstructorOrNull", "innerClass", "getOuterThisField", "backend.js"})
public final class JsDeclarationFactory
implements DeclarationFactory {
    private final Mapping.Delegate<IrClass, IrField> singletonFieldDescriptors;
    private final Mapping.Delegate<IrClass, IrField> outerThisFieldSymbols;
    private final Mapping.Delegate<IrConstructor, IrConstructor> innerClassConstructors;
    private final Mapping.Delegate<IrClass, IrConstructor> originalInnerClassPrimaryConstructorByClass;

    @Override
    @NotNull
    public IrField getFieldForEnumEntry(@NotNull IrEnumEntry enumEntry) {
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
        boolean bl = false;
        throw (Throwable)new NotImplementedError(null, 1, null);
    }

    @Override
    @NotNull
    public IrField getOuterThisField(@NotNull IrClass innerClass) {
        Intrinsics.checkNotNullParameter((Object)innerClass, (String)"innerClass");
        if (!innerClass.isInner()) {
            throw (Throwable)((Object)new AssertionError((Object)("Class is not inner: " + DumpIrTreeKt.dump$default(innerClass, false, 1, null))));
        }
        return MappingsKt.getOrPut(this.outerThisFieldSymbols, (IrDeclaration)innerClass, (Function0)new Function0<IrField>(this, innerClass){
            final /* synthetic */ JsDeclarationFactory this$0;
            final /* synthetic */ IrClass $innerClass;

            @NotNull
            public final IrField invoke() {
                IrDeclarationParent irDeclarationParent = this.$innerClass.getParent();
                if (!(irDeclarationParent instanceof IrClass)) {
                    irDeclarationParent = null;
                }
                IrClass irClass2 = (IrClass)irDeclarationParent;
                if (irClass2 == null) {
                    throw (Throwable)((Object)new AssertionError((Object)("No containing class for inner class " + DumpIrTreeKt.dump$default(this.$innerClass, false, 1, null))));
                }
                IrClass outerClass2 = irClass2;
                Name name = Name.identifier("$this");
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.identifier(\"\\$this\")");
                Name name2 = name;
                IrSimpleType fieldType = IrUtilsKt.getDefaultType(outerClass2);
                Visibility visibility = Visibilities.PROTECTED;
                Intrinsics.checkNotNullExpressionValue((Object)visibility, (String)"Visibilities.PROTECTED");
                Visibility visibility2 = visibility;
                return JsDeclarationFactory.access$createPropertyWithBackingField(this.this$0, name2, visibility2, this.$innerClass, fieldType, DeclarationFactory.FIELD_FOR_OUTER_THIS.INSTANCE);
            }
            {
                this.this$0 = jsDeclarationFactory;
                this.$innerClass = irClass2;
                super(0);
            }
        });
    }

    private final IrField createPropertyWithBackingField(Name name, Visibility visibility, IrClass parent2, IrType fieldType, IrDeclarationOrigin origin) {
        WrappedFieldDescriptor descriptor2 = new WrappedFieldDescriptor(null, null, 3, null);
        IrFieldSymbolImpl symbol2 = new IrFieldSymbolImpl(descriptor2);
        IrFieldImpl irFieldImpl = new IrFieldImpl(-1, -1, origin, symbol2, name, fieldType, visibility, true, false, false, false);
        boolean bl = false;
        boolean bl2 = false;
        IrFieldImpl it = irFieldImpl;
        boolean bl3 = false;
        descriptor2.bind((IrDeclaration)it);
        it.setParent(parent2);
        return irFieldImpl;
    }

    @Override
    @NotNull
    public IrConstructor getInnerClassConstructorWithOuterThisParameter(@NotNull IrConstructor innerClassConstructor) {
        Intrinsics.checkNotNullParameter((Object)innerClassConstructor, (String)"innerClassConstructor");
        IrDeclarationParent irDeclarationParent = innerClassConstructor.getParent();
        if (irDeclarationParent == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        }
        IrClass innerClass = (IrClass)irDeclarationParent;
        boolean bl = innerClass.isInner();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Class is not inner: " + innerClass;
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        IrConstructor irConstructor = MappingsKt.getOrPut(this.innerClassConstructors, (IrDeclaration)innerClassConstructor, (Function0)new Function0<IrConstructor>(this, innerClassConstructor){
            final /* synthetic */ JsDeclarationFactory this$0;
            final /* synthetic */ IrConstructor $innerClassConstructor;

            @NotNull
            public final IrConstructor invoke() {
                return JsDeclarationFactory.access$createInnerClassConstructorWithOuterThisParameter(this.this$0, this.$innerClassConstructor);
            }
            {
                this.this$0 = jsDeclarationFactory;
                this.$innerClassConstructor = irConstructor;
                super(0);
            }
        });
        bl2 = false;
        boolean bl4 = false;
        IrConstructor it = irConstructor;
        boolean bl5 = false;
        if (innerClassConstructor.isPrimary()) {
            this.originalInnerClassPrimaryConstructorByClass.set((IrClass)((IrDeclaration)innerClass), innerClassConstructor);
        }
        return irConstructor;
    }

    @Override
    @Nullable
    public IrConstructor getInnerClassOriginalPrimaryConstructorOrNull(@NotNull IrClass innerClass) {
        Intrinsics.checkNotNullParameter((Object)innerClass, (String)"innerClass");
        boolean bl = innerClass.isInner();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Class is not inner: " + innerClass;
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        return this.originalInnerClassPrimaryConstructorByClass.get((IrClass)((IrDeclaration)innerClass));
    }

    private final IrConstructor createInnerClassConstructorWithOuterThisParameter(IrConstructor oldConstructor) {
        IrDeclarationParent irDeclarationParent = oldConstructor.getParent();
        if (irDeclarationParent == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        }
        IrClass irClass2 = (IrClass)irDeclarationParent;
        IrDeclarationParent irDeclarationParent2 = irClass2.getParent();
        if (irDeclarationParent2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        }
        IrSimpleType outerThisType = IrUtilsKt.getDefaultType((IrClass)irDeclarationParent2);
        Annotations annotations2 = oldConstructor.getDescriptor().getAnnotations();
        SourceElement sourceElement = oldConstructor.getDescriptor().getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"oldConstructor.descriptor.source");
        WrappedClassConstructorDescriptor descriptor2 = new WrappedClassConstructorDescriptor(annotations2, sourceElement);
        IrConstructorSymbolImpl symbol2 = new IrConstructorSymbolImpl(descriptor2);
        IrConstructorImpl irConstructorImpl = new IrConstructorImpl(oldConstructor.getStartOffset(), oldConstructor.getEndOffset(), oldConstructor.getOrigin(), symbol2, oldConstructor.getName(), oldConstructor.getVisibility(), oldConstructor.getReturnType(), oldConstructor.isInline(), oldConstructor.isExternal(), oldConstructor.isPrimary(), oldConstructor.isExpect());
        boolean bl = false;
        boolean bl2 = false;
        IrConstructorImpl it = irConstructorImpl;
        boolean bl3 = false;
        descriptor2.bind((IrDeclaration)it);
        it.setParent(oldConstructor.getParent());
        IrConstructorImpl newConstructor2 = irConstructorImpl;
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTypeParametersFrom$default(newConstructor2, oldConstructor, null, null, 6, null);
        IrValueParameter irValueParameter = JsIrBuilder.INSTANCE.buildValueParameter(Namer.INSTANCE.getOUTER_NAME(), 0, outerThisType);
        bl2 = false;
        boolean bl4 = false;
        IrValueParameter it2 = irValueParameter;
        boolean bl5 = false;
        it2.setParent(newConstructor2);
        IrValueParameter outerThisValueParameter = irValueParameter;
        List newValueParameters = CollectionsKt.mutableListOf((Object[])new IrValueParameter[]{outerThisValueParameter});
        for (IrValueParameter p : oldConstructor.getValueParameters()) {
            Collection collection = newValueParameters;
            IrValueParameter irValueParameter2 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(p, newConstructor2, null, p.getIndex() + 1, 0, 0, null, null, null, null, null, false, false, 4090, null);
            boolean bl6 = false;
            collection.add(irValueParameter2);
        }
        IrConstructorImpl irConstructorImpl2 = newConstructor2;
        irConstructorImpl2.setValueParameters(CollectionsKt.plus((Collection)irConstructorImpl2.getValueParameters(), (Iterable)newValueParameters));
        return newConstructor2;
    }

    @Override
    @NotNull
    public IrField getFieldForObjectInstance(@NotNull IrClass singleton) {
        Intrinsics.checkNotNullParameter((Object)singleton, (String)"singleton");
        return MappingsKt.getOrPut(this.singletonFieldDescriptors, (IrDeclaration)singleton, (Function0)new Function0<IrField>(this, singleton){
            final /* synthetic */ JsDeclarationFactory this$0;
            final /* synthetic */ IrClass $singleton;

            @NotNull
            public final IrField invoke() {
                return JsDeclarationFactory.access$createObjectInstanceFieldDescriptor(this.this$0, this.$singleton, JsIrBuilder.SYNTHESIZED_DECLARATION.INSTANCE);
            }
            {
                this.this$0 = jsDeclarationFactory;
                this.$singleton = irClass2;
                super(0);
            }
        });
    }

    private final IrField createObjectInstanceFieldDescriptor(IrClass singleton, IrDeclarationOrigin origin) {
        boolean bl = singleton.getKind() == ClassKind.OBJECT;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Should be an object: " + singleton;
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        Name name = Name.identifier("INSTANCE");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.identifier(\"INSTANCE\")");
        Name name2 = name;
        Visibility visibility = Visibilities.PUBLIC;
        Intrinsics.checkNotNullExpressionValue((Object)visibility, (String)"Visibilities.PUBLIC");
        return this.createPropertyWithBackingField(name2, visibility, singleton, IrUtilsKt.getDefaultType(singleton), origin);
    }

    public JsDeclarationFactory(@NotNull JsMapping mapping2) {
        Intrinsics.checkNotNullParameter((Object)mapping2, (String)"mapping");
        this.singletonFieldDescriptors = mapping2.getSingletonFieldDescriptors();
        this.outerThisFieldSymbols = mapping2.getOuterThisFieldSymbols();
        this.innerClassConstructors = mapping2.getInnerClassConstructors();
        this.originalInnerClassPrimaryConstructorByClass = mapping2.getOriginalInnerClassPrimaryConstructorByClass();
    }

    public static final /* synthetic */ IrField access$createPropertyWithBackingField(JsDeclarationFactory $this, Name name, Visibility visibility, IrClass parent2, IrType fieldType, IrDeclarationOrigin origin) {
        return $this.createPropertyWithBackingField(name, visibility, parent2, fieldType, origin);
    }

    public static final /* synthetic */ IrConstructor access$createInnerClassConstructorWithOuterThisParameter(JsDeclarationFactory $this, IrConstructor oldConstructor) {
        return $this.createInnerClassConstructorWithOuterThisParameter(oldConstructor);
    }

    public static final /* synthetic */ IrField access$createObjectInstanceFieldDescriptor(JsDeclarationFactory $this, IrClass singleton, IrDeclarationOrigin origin) {
        return $this.createObjectInstanceFieldDescriptor(singleton, origin);
    }
}

