/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.multiproject;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.IncrementalModuleEntry;
import org.jetbrains.kotlin.incremental.IncrementalModuleInfo;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistoryBase;
import org.jetbrains.kotlin.incremental.util.Either;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\u0006\u0010\t\u001a\u00020\bH\u0016J\u001c\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\u0006\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryJvm;", "Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryBase;", "modulesInfo", "Lorg/jetbrains/kotlin/incremental/IncrementalModuleInfo;", "(Lorg/jetbrains/kotlin/incremental/IncrementalModuleInfo;)V", "abiSnapshot", "Lorg/jetbrains/kotlin/incremental/util/Either;", "", "Ljava/io/File;", "jar", "getBuildHistoryFilesForJar", "incremental-compilation-impl"})
public final class ModulesApiHistoryJvm
extends ModulesApiHistoryBase {
    public ModulesApiHistoryJvm(@NotNull IncrementalModuleInfo modulesInfo) {
        Intrinsics.checkNotNullParameter((Object)modulesInfo, (String)"modulesInfo");
        super(modulesInfo);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Either<Set<File>> getBuildHistoryFilesForJar(@NotNull File jar) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        void $this$filterTo$iv$iv;
        Iterable classFiles;
        Iterable destination$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
        IncrementalModuleEntry moduleInfoFromJar = this.getModulesInfo().getJarToModule().get(jar);
        if (moduleInfoFromJar != null) {
            return new Either.Success<Set>(SetsKt.setOf((Object)moduleInfoFromJar.getBuildHistoryFile()));
        }
        File file2 = this.getModulesInfo().getJarToClassListFile().get(jar);
        if (file2 == null) {
            return new Either.Error(Intrinsics.stringPlus((String)"Unknown jar: ", (Object)jar));
        }
        File classListFile = file2;
        if (!classListFile.isFile()) {
            return new Either.Error(Intrinsics.stringPlus((String)"Class list file does not exist ", (Object)classListFile));
        }
        try {
            void $this$mapTo$iv$iv;
            CharSequence charSequence2 = FilesKt.readText$default((File)classListFile, null, (int)1, null);
            String[] stringArray = new String[1];
            String string2 = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pathSeparator");
            stringArray[0] = string2;
            $this$map$iv = StringsKt.split$default((CharSequence)charSequence2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string3 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                File file3 = new File((String)p0);
                collection.add(file3);
            }
            $this$map$iv = (List)destination$iv$iv;
        }
        catch (Throwable t) {
            return new Either.Error("Could not read class list for " + jar + " from " + classListFile + ": " + t);
        }
        Iterable $this$filter$iv = classFiles = $this$map$iv;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Object destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!(it.exists() && it.getParentFile() != null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            File it = (File)element$iv$iv;
            boolean bl = false;
            File key$iv$iv = it.getParentFile();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object classFileDirs = destination$iv$iv2;
        HashSet result2 = new HashSet();
        for (File dir : classFileDirs.keySet()) {
            Intrinsics.checkNotNullExpressionValue((Object)dir, (String)"dir");
            Either<Set<File>> historyEither = this.getBuildHistoryForDir(dir);
            if (historyEither instanceof Either.Success) {
                result2.addAll((Collection)((Either.Success)historyEither).getValue());
                continue;
            }
            if (!(historyEither instanceof Either.Error)) continue;
            return historyEither;
        }
        return new Either.Success(result2);
    }

    @Override
    @NotNull
    public Either<Set<File>> abiSnapshot(@NotNull File jar) {
        Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
        IncrementalModuleEntry incrementalModuleEntry = this.getModulesInfo().getJarToModule().get(jar);
        File abiSnapshot2 = incrementalModuleEntry == null ? this.getModulesInfo().getJarToAbiSnapshot().get(jar) : incrementalModuleEntry.getAbiSnapshot();
        return abiSnapshot2 != null ? (Either)new Either.Success<Set>(SetsKt.setOf((Object)abiSnapshot2)) : (Either)new Either.Error(Intrinsics.stringPlus((String)"Failed to find abi snapshot for file ", (Object)jar.getAbsolutePath()));
    }
}

