/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.idea.serialize;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.idea.serialize.IdeaKotlinExtrasSerializer;
import org.jetbrains.kotlin.gradle.idea.serialize.IdeaKotlinSerializationContext;
import org.jetbrains.kotlin.gradle.idea.serialize.IdeaKotlinSerializationLogger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/idea/serialize/IdeaKotlinBooleanExtrasSerializer;", "Lorg/jetbrains/kotlin/gradle/idea/serialize/IdeaKotlinExtrasSerializer;", "", "()V", "deserialize", "context", "Lorg/jetbrains/kotlin/gradle/idea/serialize/IdeaKotlinSerializationContext;", "data", "", "(Lorg/jetbrains/kotlin/gradle/idea/serialize/IdeaKotlinSerializationContext;[B)Ljava/lang/Boolean;", "serialize", "value", "kotlin-gradle-plugin-idea"})
public final class IdeaKotlinBooleanExtrasSerializer
implements IdeaKotlinExtrasSerializer<Boolean> {
    @NotNull
    public static final IdeaKotlinBooleanExtrasSerializer INSTANCE = new IdeaKotlinBooleanExtrasSerializer();

    private IdeaKotlinBooleanExtrasSerializer() {
    }

    @Override
    @NotNull
    public byte[] serialize(@NotNull IdeaKotlinSerializationContext context, boolean value) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        byte[] byArray = new byte[]{value ? (byte)1 : 0};
        return byArray;
    }

    @Override
    @Nullable
    public Boolean deserialize(@NotNull IdeaKotlinSerializationContext context, @NotNull byte[] data) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.length == 0) {
            IdeaKotlinSerializationLogger.DefaultImpls.error$default(context.getLogger(), "Failed to decode Boolean from empty array", null, 2, null);
            return null;
        }
        byte value = ArraysKt.first((byte[])data);
        if (value == 0) {
            bl = false;
        } else if (value == 1) {
            bl = true;
        } else {
            IdeaKotlinSerializationLogger.DefaultImpls.error$default(context.getLogger(), "Failed to decode Boolean from value " + value, null, 2, null);
            bl = null;
        }
        return bl;
    }
}

