/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.logging;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compilerRunner.KotlinLogger;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u001b\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0080\b\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0005H\u0000\u001a\u001b\u0010\u0000\u001a\u00020\u0001*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0080\b\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0005H\u0000\u001a\u0014\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0005H\u0000\u001a.\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b*\u00020\u00062\u0006\u0010\f\u001a\u00020\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0004H\u0080\b\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"kotlinDebug", "", "Lorg/gradle/api/logging/Logger;", "message", "Lkotlin/Function0;", "", "Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;", "fn", "kotlinInfo", "kotlinWarn", "logTime", "T", "action", "(Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "kotlin-gradle-plugin"})
public final class GradleLoggingUtilsKt {
    public static final void kotlinInfo(@NotNull Logger $receiver, @NotNull String message2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        $receiver.info("[KOTLIN] " + message2);
    }

    public static final void kotlinDebug(@NotNull Logger $receiver, @NotNull String message2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        $receiver.debug("[KOTLIN] " + message2);
    }

    public static final void kotlinWarn(@NotNull Logger $receiver, @NotNull String message2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        $receiver.warn("[KOTLIN] " + message2);
    }

    public static final void kotlinDebug(@NotNull Logger $receiver, @NotNull Function0<String> message2) {
        int $i$f$kotlinDebug = 0;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(message2, (String)"message");
        if ($receiver.isDebugEnabled()) {
            GradleLoggingUtilsKt.kotlinDebug($receiver, (String)message2.invoke());
        }
    }

    public static final void kotlinDebug(@NotNull KotlinLogger $receiver, @NotNull Function0<String> fn) {
        int $i$f$kotlinDebug = 0;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
        if ($receiver.isDebugEnabled()) {
            String msg = (String)fn.invoke();
            $receiver.debug("[KOTLIN] " + msg);
        }
    }

    public static final <T> T logTime(@NotNull KotlinLogger $receiver, @NotNull String action, @NotNull Function0<? extends T> fn) {
        int $i$f$logTime = 0;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
        long startNs = System.nanoTime();
        Object result2 = fn.invoke();
        long endNs = System.nanoTime();
        long timeNs = endNs - startNs;
        double timeMs = (double)timeNs / (double)1000000;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%s took %.2f ms";
        Object[] objectArray = new Object[]{action, timeMs};
        KotlinLogger kotlinLogger2 = $receiver;
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        String string3 = string2;
        kotlinLogger2.debug(string3);
        return (T)result2;
    }
}

