/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils;

import java.io.File;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compilerRunner.KonanCompilerRunner;
import org.jetbrains.kotlin.compilerRunner.KotlinNativeToolRunnerKt;
import org.jetbrains.kotlin.gradle.utils.NativeCompilerDownloader;
import org.jetbrains.kotlin.konan.KonanVersion;
import org.jetbrains.kotlin.konan.KonanVersionImpl;
import org.jetbrains.kotlin.konan.MetaVersion;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.util.DependencyDirectories;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 (2\u00020\u0001:\u0001(B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\fH\u0002J\b\u0010 \u001a\u00020!H\u0002J\u0006\u0010\"\u001a\u00020!J\u0010\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020\bH\u0002R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\nR\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/gradle/utils/NativeCompilerDownloader;", "", "project", "Lorg/gradle/api/Project;", "compilerVersion", "Lorg/jetbrains/kotlin/konan/KonanVersion;", "(Lorg/gradle/api/Project;Lorg/jetbrains/kotlin/konan/KonanVersion;)V", "archiveExtension", "", "getArchiveExtension", "()Ljava/lang/String;", "compilerDirectory", "Ljava/io/File;", "getCompilerDirectory", "()Ljava/io/File;", "getCompilerVersion", "()Lorg/jetbrains/kotlin/konan/KonanVersion;", "logger", "Lorg/gradle/api/logging/Logger;", "getLogger", "()Lorg/gradle/api/logging/Logger;", "getProject", "()Lorg/gradle/api/Project;", "simpleOsName", "getSimpleOsName", "useZip", "", "getUseZip", "()Z", "archiveFileTree", "Lorg/gradle/api/file/FileTree;", "archive", "downloadAndExtract", "", "downloadIfNeeded", "removeRepo", "repo", "Lorg/gradle/api/artifacts/repositories/ArtifactRepository;", "setupRepo", "url", "Companion", "kotlin-gradle-plugin"})
public final class NativeCompilerDownloader {
    @NotNull
    private final Project project;
    @NotNull
    private final KonanVersion compilerVersion;
    @NotNull
    private static final KonanVersionImpl DEFAULT_KONAN_VERSION;
    @NotNull
    public static final String BASE_DOWNLOAD_URL = "https://download.jetbrains.com/kotlin/native/builds";
    public static final Companion Companion;

    private final Logger getLogger() {
        Logger logger = this.project.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"project.logger");
        return logger;
    }

    private final String getSimpleOsName() {
        return HostManager.Companion.simpleOsName();
    }

    private final boolean getUseZip() {
        return HostManager.Companion.getHostIsMingw();
    }

    private final String getArchiveExtension() {
        return this.getUseZip() ? "zip" : "tar.gz";
    }

    private final FileTree archiveFileTree(File archive) {
        FileTree fileTree;
        if (this.getUseZip()) {
            FileTree fileTree2 = this.project.zipTree((Object)archive);
            fileTree = fileTree2;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileTree2, (String)"project.zipTree(archive)");
        } else {
            FileTree fileTree3 = this.project.tarTree((Object)archive);
            fileTree = fileTree3;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileTree3, (String)"project.tarTree(archive)");
        }
        return fileTree;
    }

    private final ArtifactRepository setupRepo(String url) {
        IvyArtifactRepository ivyArtifactRepository = this.project.getRepositories().ivy((Action)new Action<IvyArtifactRepository>(url){
            final /* synthetic */ String $url;

            public final void execute(IvyArtifactRepository repo) {
                repo.setUrl((Object)this.$url);
                repo.layout("pattern", (Action)setupRepo.1.INSTANCE);
                repo.metadataSources((Action)setupRepo.2.INSTANCE);
            }
            {
                this.$url = string;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)ivyArtifactRepository, (String)"project.repositories.ivy\u2026)\n            }\n        }");
        return (ArtifactRepository)ivyArtifactRepository;
    }

    private final void removeRepo(ArtifactRepository repo) {
        this.project.getRepositories().remove((Object)repo);
    }

    private final void downloadAndExtract() {
        Configuration configuration2;
        String versionString = this.compilerVersion.toString();
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $receiver = stringBuilder;
        boolean bl4 = false;
        $receiver.append("https://download.jetbrains.com/kotlin/native/builds/");
        $receiver.append(this.compilerVersion.getMeta() == MetaVersion.DEV ? "dev/" : "releases/");
        $receiver.append(versionString + '/');
        $receiver.append(this.getSimpleOsName());
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String url = string;
        ArtifactRepository repo = this.setupRepo(url);
        Dependency compilerDependency = this.project.getDependencies().create((Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"name", (Object)("kotlin-native-" + this.getSimpleOsName())), TuplesKt.to((Object)"version", (Object)versionString), TuplesKt.to((Object)"ext", (Object)this.getArchiveExtension())}));
        Configuration configuration3 = configuration2 = this.project.getConfigurations().detachedConfiguration(new Dependency[]{compilerDependency});
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration3, (String)"configuration");
        Set set = configuration3.getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"configuration.files");
        File archive = (File)CollectionsKt.single((Iterable)set);
        Logger logger = this.getLogger();
        StringBuilder stringBuilder2 = new StringBuilder().append("Use Kotlin/Native compiler archive: ");
        File file = archive;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"archive");
        logger.info(stringBuilder2.append(file.getAbsolutePath()).toString());
        this.getLogger().lifecycle("Unpack Kotlin/Native compiler (version " + versionString + ")...");
        this.project.copy((Action)new Action<CopySpec>(this, archive){
            final /* synthetic */ NativeCompilerDownloader this$0;
            final /* synthetic */ File $archive;

            public final void execute(CopySpec it) {
                Object[] objectArray = new Object[1];
                File file = this.$archive;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"archive");
                objectArray[0] = NativeCompilerDownloader.access$archiveFileTree(this.this$0, file);
                it.from(objectArray);
                it.into((Object)DependencyDirectories.INSTANCE.getLocalKonanDir());
            }
            {
                this.this$0 = nativeCompilerDownloader;
                this.$archive = file;
            }
        });
        this.removeRepo(repo);
    }

    @NotNull
    public final File getCompilerDirectory() {
        return FilesKt.resolve((File)DependencyDirectories.INSTANCE.getLocalKonanDir(), (String)("kotlin-native-" + this.getSimpleOsName() + '-' + this.compilerVersion));
    }

    public final void downloadIfNeeded() {
        if (new KonanCompilerRunner(this.project, null, false, 6, null).getClasspath().isEmpty()) {
            this.downloadAndExtract();
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final KonanVersion getCompilerVersion() {
        return this.compilerVersion;
    }

    public NativeCompilerDownloader(@NotNull Project project, @NotNull KonanVersion compilerVersion) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)compilerVersion, (String)"compilerVersion");
        this.project = project;
        this.compilerVersion = compilerVersion;
    }

    public /* synthetic */ NativeCompilerDownloader(Project project, KonanVersion konanVersion, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            konanVersion = KotlinNativeToolRunnerKt.getKonanVersion(project);
        }
        this(project, konanVersion);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_KONAN_VERSION = new KonanVersionImpl(MetaVersion.RELEASE, 1, 2, 0, 0, 16, null);
    }

    public static final /* synthetic */ FileTree access$archiveFileTree(NativeCompilerDownloader $this, File archive) {
        return $this.archiveFileTree(archive);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/utils/NativeCompilerDownloader$Companion;", "", "()V", "BASE_DOWNLOAD_URL", "", "DEFAULT_KONAN_VERSION", "Lorg/jetbrains/kotlin/konan/KonanVersionImpl;", "getDEFAULT_KONAN_VERSION", "()Lorg/jetbrains/kotlin/konan/KonanVersionImpl;", "kotlin-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final KonanVersionImpl getDEFAULT_KONAN_VERSION() {
            return DEFAULT_KONAN_VERSION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

