/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.compilerRunner.KonanCompilerRunner;
import org.jetbrains.kotlin.compilerRunner.KotlinNativeToolRunnerKt;
import org.jetbrains.kotlin.gradle.dsl.KotlinCommonToolOptions;
import org.jetbrains.kotlin.gradle.plugin.LanguageSettingsBuilder;
import org.jetbrains.kotlin.gradle.plugin.cocoapods.KotlinCocoapodsPluginKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.AbstractKotlinNativeCompilation;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinSharedNativeCompilation;
import org.jetbrains.kotlin.gradle.plugin.sources.DefaultLanguageSettingsBuilder;
import org.jetbrains.kotlin.gradle.tasks.CompilerPluginOptions;
import org.jetbrains.kotlin.gradle.tasks.KotlinNativeTasksKt;
import org.jetbrains.kotlin.konan.target.CompilerOutputKind;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018H\u0002J\u0018\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00070\u00182\b\b\u0002\u0010E\u001a\u00020 H\u0014J\u000e\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018H\u0014J\u000e\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018H$J\b\u0010H\u001a\u00020IH\u0017J\b\u0010J\u001a\u00020\u0012H\u0016J!\u0010)\u001a\u00020I2\u0017\u0010K\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020I0L\u00a2\u0006\u0002\bMH&J\u0014\u0010)\u001a\u00020I2\n\u0010K\u001a\u0006\u0012\u0002\b\u00030NH&J\u0012\u0010O\u001a\u00020I2\b\u0010P\u001a\u0004\u0018\u00010\u0012H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\u0004\u0018\u00010\u00128\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00188G\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u00020\u001c8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070\u00188G\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001aR\u0011\u0010%\u001a\u00020 8G\u00a2\u0006\u0006\u001a\u0004\b&\u0010\"R\u0011\u0010'\u001a\u00020\u00078G\u00a2\u0006\u0006\u001a\u0004\b(\u0010\fR\u0014\u0010)\u001a\u00028\u00008gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020-8G\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0011\u00100\u001a\u00020\u00128G\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0014R\u0014\u00102\u001a\u00020 8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\"R\u001c\u00104\u001a\b\u0012\u0004\u0012\u000206058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0014\u00109\u001a\u00020:8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0011\u0010=\u001a\u00020 8G\u00a2\u0006\u0006\u001a\u0004\b>\u0010\"R\u0017\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00070\u00188G\u00a2\u0006\u0006\u001a\u0004\b@\u0010\u001aR\u0011\u0010A\u001a\u00020\u00078G\u00a2\u0006\u0006\u001a\u0004\bB\u0010\f\u00a8\u0006Q"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/AbstractKotlinNativeCompile;", "T", "Lorg/jetbrains/kotlin/gradle/dsl/KotlinCommonToolOptions;", "Lorg/gradle/api/tasks/compile/AbstractCompile;", "()V", "additionalCompilerOptions", "", "", "getAdditionalCompilerOptions", "()Ljava/util/Collection;", "baseName", "getBaseName", "()Ljava/lang/String;", "compilation", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/AbstractKotlinNativeCompilation;", "getCompilation", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/AbstractKotlinNativeCompilation;", "compilerPluginClasspath", "Lorg/gradle/api/file/FileCollection;", "getCompilerPluginClasspath", "()Lorg/gradle/api/file/FileCollection;", "setCompilerPluginClasspath", "(Lorg/gradle/api/file/FileCollection;)V", "compilerPluginCommandLine", "", "getCompilerPluginCommandLine", "()Ljava/util/List;", "compilerPluginOptions", "Lorg/jetbrains/kotlin/gradle/tasks/CompilerPluginOptions;", "getCompilerPluginOptions", "()Lorg/jetbrains/kotlin/gradle/tasks/CompilerPluginOptions;", "debuggable", "", "getDebuggable", "()Z", "defaultSerializedCompilerArguments", "getDefaultSerializedCompilerArguments", "enableEndorsedLibs", "getEnableEndorsedLibs", "kotlinNativeVersion", "getKotlinNativeVersion", "kotlinOptions", "getKotlinOptions", "()Lorg/jetbrains/kotlin/gradle/dsl/KotlinCommonToolOptions;", "languageSettings", "Lorg/jetbrains/kotlin/gradle/plugin/LanguageSettingsBuilder;", "getLanguageSettings", "()Lorg/jetbrains/kotlin/gradle/plugin/LanguageSettingsBuilder;", "libraries", "getLibraries", "optimized", "getOptimized", "outputFile", "Lorg/gradle/api/provider/Provider;", "Ljava/io/File;", "getOutputFile", "()Lorg/gradle/api/provider/Provider;", "outputKind", "Lorg/jetbrains/kotlin/konan/target/CompilerOutputKind;", "getOutputKind", "()Lorg/jetbrains/kotlin/konan/target/CompilerOutputKind;", "progressiveMode", "getProgressiveMode", "serializedCompilerArguments", "getSerializedCompilerArguments", "target", "getTarget", "buildArgs", "buildCommonArgs", "defaultsOnly", "buildCompilerArgs", "buildSourceArgs", "compile", "", "getClasspath", "fn", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "Lgroovy/lang/Closure;", "setClasspath", "configuration", "kotlin-gradle-plugin"})
public abstract class AbstractKotlinNativeCompile<T extends KotlinCommonToolOptions>
extends AbstractCompile {
    @Internal
    @NotNull
    private final Provider<File> outputFile;
    @Internal
    @NotNull
    private final CompilerPluginOptions compilerPluginOptions;
    @Optional
    @InputFiles
    @Nullable
    private FileCollection compilerPluginClasspath;

    @Internal
    @NotNull
    public abstract AbstractKotlinNativeCompilation getCompilation();

    @Input
    @NotNull
    public abstract CompilerOutputKind getOutputKind();

    @Input
    public abstract boolean getOptimized();

    @Input
    public abstract boolean getDebuggable();

    @Internal
    @NotNull
    public abstract String getBaseName();

    @InputFiles
    @NotNull
    public final FileCollection getLibraries() {
        FileCollection fileCollection = this.getCompilation().getCompileDependencyFiles();
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        return KotlinNativeTasksKt.access$filterOutPublishableInteropLibs(fileCollection, project);
    }

    @NotNull
    public FileCollection getClasspath() {
        return this.getLibraries();
    }

    public void setClasspath(@Nullable FileCollection configuration2) {
        throw (Throwable)new UnsupportedOperationException("Setting classpath directly is unsupported.");
    }

    @Input
    @NotNull
    public final String getTarget() {
        return this.getCompilation().getKonanTarget().getName();
    }

    @Internal
    @NotNull
    public abstract T getKotlinOptions();

    public abstract void kotlinOptions(@NotNull Function1<? super T, Unit> var1);

    public abstract void kotlinOptions(@NotNull Closure<?> var1);

    @Input
    @NotNull
    public abstract Collection<String> getAdditionalCompilerOptions();

    @Internal
    @NotNull
    public final LanguageSettingsBuilder getLanguageSettings() {
        return this.getCompilation().getDefaultSourceSet().getLanguageSettings();
    }

    @Input
    public final boolean getProgressiveMode() {
        return this.getLanguageSettings().getProgressiveMode();
    }

    @Input
    public final boolean getEnableEndorsedLibs() {
        return this.getCompilation().getEnableEndorsedLibs();
    }

    @Input
    @NotNull
    public final String getKotlinNativeVersion() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        return KotlinNativeToolRunnerKt.getKonanVersion(project).toString();
    }

    @NotNull
    public final Provider<File> getOutputFile() {
        return this.outputFile;
    }

    @NotNull
    public final CompilerPluginOptions getCompilerPluginOptions() {
        return this.compilerPluginOptions;
    }

    @Input
    @NotNull
    public final List<String> getCompilerPluginCommandLine() {
        return this.compilerPluginOptions.getArguments();
    }

    @Nullable
    public final FileCollection getCompilerPluginClasspath() {
        return this.compilerPluginClasspath;
    }

    public final void setCompilerPluginClasspath(@Nullable FileCollection fileCollection) {
        this.compilerPluginClasspath = fileCollection;
    }

    @Internal
    @NotNull
    public final List<String> getSerializedCompilerArguments() {
        return AbstractKotlinNativeCompile.buildCommonArgs$default(this, false, 1, null);
    }

    @Internal
    @NotNull
    public final List<String> getDefaultSerializedCompilerArguments() {
        return this.buildCommonArgs(true);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<String> buildCommonArgs(boolean defaultsOnly) {
        List list2;
        block7: {
            LanguageSettingsBuilder languageSettingsBuilder;
            boolean bl;
            boolean bl2;
            Object object;
            boolean bl3 = false;
            list2 = new ArrayList();
            boolean bl4 = false;
            boolean bl5 = false;
            List $receiver = list2;
            boolean bl6 = false;
            $receiver.add("-Xmulti-platform");
            if (!this.getEnableEndorsedLibs()) {
                $receiver.add("-no-endorsed-libs");
            }
            FileCollection fileCollection = this.compilerPluginClasspath;
            if (fileCollection != null) {
                void $this$mapTo$iv$iv;
                object = fileCollection;
                bl2 = false;
                bl = false;
                FileCollection pluginClasspath2 = object;
                boolean bl7 = false;
                Iterable $this$map$iv = (Iterable)pluginClasspath2;
                boolean $i$f$map = false;
                Iterator iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    File file = (File)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl8 = false;
                    void v1 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                    String string = v1.getCanonicalPath();
                    collection.add(string);
                }
                Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String path = (String)element$iv;
                    boolean bl9 = false;
                    $receiver.add("-Xplugin=" + path);
                }
                $this$forEach$iv = this.compilerPluginOptions.getArguments();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl10 = false;
                    $receiver.add("-P");
                    $receiver.add(it);
                }
            }
            KotlinNativeTasksKt.addKey($receiver, "-Werror", this.getKotlinOptions().getAllWarningsAsErrors());
            KotlinNativeTasksKt.addKey($receiver, "-nowarn", this.getKotlinOptions().getSuppressWarnings());
            KotlinNativeTasksKt.addKey($receiver, "-verbose", this.getKotlinOptions().getVerbose());
            KotlinNativeTasksKt.addKey($receiver, "-progressive", this.getProgressiveMode());
            if (!defaultsOnly) {
                $receiver.addAll(this.getAdditionalCompilerOptions());
            }
            if (!((languageSettingsBuilder = this.getCompilation().getDefaultSourceSet().getLanguageSettings()) instanceof DefaultLanguageSettingsBuilder)) {
                languageSettingsBuilder = null;
            }
            DefaultLanguageSettingsBuilder defaultLanguageSettingsBuilder = (DefaultLanguageSettingsBuilder)languageSettingsBuilder;
            if (defaultLanguageSettingsBuilder == null) break block7;
            object = defaultLanguageSettingsBuilder;
            bl2 = false;
            bl = false;
            Object $receiver2 = object;
            boolean bl11 = false;
            $receiver.addAll((Collection)((DefaultLanguageSettingsBuilder)$receiver2).getFreeCompilerArgs());
        }
        return list2;
    }

    public static /* synthetic */ List buildCommonArgs$default(AbstractKotlinNativeCompile abstractKotlinNativeCompile, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildCommonArgs");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return abstractKotlinNativeCompile.buildCommonArgs(bl);
    }

    @NotNull
    protected List<String> buildCompilerArgs() {
        boolean bl = false;
        List list2 = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List $receiver = list2;
        boolean bl4 = false;
        KotlinNativeTasksKt.addKey($receiver, "-opt", this.getOptimized());
        KotlinNativeTasksKt.addKey($receiver, "-g", this.getDebuggable());
        KotlinNativeTasksKt.addKey($receiver, "-ea", this.getDebuggable());
        KotlinNativeTasksKt.addArg($receiver, "-target", this.getTarget());
        String string = this.getOutputKind().name();
        String string2 = "-p";
        List list3 = $receiver;
        boolean bl5 = false;
        String string3 = string;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        String string5 = string4;
        KotlinNativeTasksKt.addArg(list3, string2, string5);
        if (this.getCompilation() instanceof KotlinSharedNativeCompilation) {
            $receiver.add("-Xklib-mpp");
            $receiver.add("-Xmetadata-klib");
        }
        Object object = this.outputFile.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"outputFile.get()");
        String string6 = ((File)object).getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"outputFile.get().absolutePath");
        KotlinNativeTasksKt.addArg($receiver, "-o", string6);
        Set set2 = this.getLibraries().getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"libraries.files");
        Collection collection = set2;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Iterable $this$forEach$iv = KotlinNativeTasksKt.access$filterKlibsPassedToCompiler(collection, project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File library = (File)element$iv;
            boolean bl6 = false;
            String string7 = library.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"library.absolutePath");
            KotlinNativeTasksKt.addArg($receiver, "-l", string7);
        }
        return list2;
    }

    @NotNull
    protected abstract List<String> buildSourceArgs();

    private final List<String> buildArgs() {
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.buildCompilerArgs(), (Iterable)AbstractKotlinNativeCompile.buildCommonArgs$default(this, false, 1, null)), (Iterable)this.buildSourceArgs());
    }

    @TaskAction
    public void compile() {
        File output2;
        File file = output2 = (File)this.outputFile.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"output");
        file.getParentFile().mkdirs();
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        new KonanCompilerRunner(project, null, false, 6, null).run(this.buildArgs());
    }

    public AbstractKotlinNativeCompile() {
        this.setSourceCompatibility("1.6");
        this.setTargetCompatibility("1.6");
        Provider provider = this.getProject().provider((Callable)new Callable<File>(this){
            final /* synthetic */ AbstractKotlinNativeCompile this$0;

            @NotNull
            public final File call() {
                KonanTarget konanTarget = this.this$0.getCompilation().getKonanTarget();
                String prefix = this.this$0.getOutputKind().prefix(konanTarget);
                String suffix = this.this$0.getOutputKind().suffix(konanTarget);
                String string = prefix + this.this$0.getBaseName() + suffix;
                boolean bl = false;
                boolean bl2 = false;
                String it = string;
                boolean bl3 = false;
                String filename = this.this$0.getOutputKind() == CompilerOutputKind.FRAMEWORK ? KotlinCocoapodsPluginKt.asValidFrameworkName(it) : (CollectionsKt.listOf((Object[])new CompilerOutputKind[]{CompilerOutputKind.STATIC, CompilerOutputKind.DYNAMIC}).contains(this.this$0.getOutputKind()) || this.this$0.getOutputKind() == CompilerOutputKind.PROGRAM && Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.WASM32.INSTANCE) ? StringsKt.replace$default((String)it, (char)'-', (char)'_', (boolean)false, (int)4, null) : it);
                File file = this.this$0.getDestinationDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"destinationDir");
                return FilesKt.resolve((File)file, (String)filename);
            }
            {
                this.this$0 = abstractKotlinNativeCompile;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)provider, (String)"project.provider {\n     \u2026r.resolve(filename)\n    }");
        this.outputFile = provider;
        this.compilerPluginOptions = new CompilerPluginOptions();
    }
}

