/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.kapt.incremental;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.internal.kapt.incremental.ClassDependencies;
import org.jetbrains.kotlin.gradle.internal.kapt.incremental.ClasspathEntryData;
import org.jetbrains.kotlin.gradle.internal.kapt.incremental.KaptClasspathChanges;
import org.jetbrains.kotlin.gradle.internal.kapt.incremental.UnknownSnapshot;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001#BA\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fJ\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u000fH\u0002J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014J2\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00170\u0016j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0017`\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0000H\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010\u001f\u001a\u00020\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030!H\u0002J\u0006\u0010\"\u001a\u00020\u001eR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/kapt/incremental/ClasspathSnapshot;", "", "cacheDir", "Ljava/io/File;", "classpath", "", "annotationProcessorClasspath", "dataForFiles", "", "Lorg/jetbrains/kotlin/gradle/internal/kapt/incremental/ClasspathEntryData;", "(Ljava/io/File;Ljava/util/List;Ljava/util/List;Ljava/util/Map;)V", "diff", "Lorg/jetbrains/kotlin/gradle/internal/kapt/incremental/KaptClasspathChanges;", "previousSnapshot", "changedFiles", "", "findAllImpacted", "", "changedClasses", "getAllDataFiles", "", "getHashesToAnalyze", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "filesToLoad", "isCompatible", "", "snapshot", "loadAll", "", "loadEntriesFor", "file", "", "writeToCache", "ClasspathSnapshotFactory", "kotlin-gradle-plugin"})
public class ClasspathSnapshot {
    private final File cacheDir;
    private final List<File> classpath;
    private final List<File> annotationProcessorClasspath;
    private final Map<File, ClasspathEntryData> dataForFiles;

    @NotNull
    public final Set<File> getAllDataFiles() {
        return this.dataForFiles.keySet();
    }

    private final boolean isCompatible(ClasspathSnapshot snapshot) {
        return Intrinsics.areEqual((Object)this, (Object)UnknownSnapshot.INSTANCE) ^ true && Intrinsics.areEqual((Object)snapshot, (Object)UnknownSnapshot.INSTANCE) ^ true && Intrinsics.areEqual(this.classpath, snapshot.classpath) && Intrinsics.areEqual(this.annotationProcessorClasspath, snapshot.annotationProcessorClasspath);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final KaptClasspathChanges diff(@NotNull ClasspathSnapshot previousSnapshot2, @NotNull Set<? extends File> changedFiles2) {
        void $this$filterTo$iv$iv42;
        void $this$filterTo$iv$iv22;
        void $this$filterTo$iv$iv3;
        Object element$iv2;
        boolean bl;
        block14: {
            Intrinsics.checkParameterIsNotNull((Object)previousSnapshot2, (String)"previousSnapshot");
            Intrinsics.checkParameterIsNotNull(changedFiles2, (String)"changedFiles");
            if (!this.isCompatible(previousSnapshot2)) {
                return KaptClasspathChanges.Unknown.INSTANCE;
            }
            Iterable $this$any$iv = this.annotationProcessorClasspath;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    File it = (File)element$iv2;
                    boolean bl2 = false;
                    if (!changedFiles2.contains(it)) continue;
                    bl = true;
                    break block14;
                }
                bl = false;
            }
        }
        if (bl) {
            return KaptClasspathChanges.Unknown.INSTANCE;
        }
        Iterable $this$filter$iv = CollectionsKt.intersect((Iterable)this.dataForFiles.keySet(), (Iterable)previousSnapshot2.dataForFiles.keySet());
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            File it = (File)element$iv$iv;
            boolean bl3 = false;
            if (!(!changedFiles2.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unchangedBetweenCompilations = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = this.dataForFiles.keySet();
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv22) {
            File it = (File)element$iv$iv;
            boolean bl4 = false;
            if (!(!unchangedBetweenCompilations.contains(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv2;
        $i$f$filter2 = false;
        boolean $this$filterTo$iv$iv22 = false;
        Iterable it = $this$filter$iv2;
        boolean bl5 = false;
        this.loadEntriesFor(it);
        Iterable currentToLoad = $this$filter$iv2;
        Iterable $this$filter$iv222 = previousSnapshot2.dataForFiles.keySet();
        boolean $i$f$filter3 = false;
        it = $this$filter$iv222;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv42) {
            File it2 = (File)element$iv$iv;
            boolean bl6 = false;
            if (!(!unchangedBetweenCompilations.contains(it2))) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List previousToLoad = (List)destination$iv$iv3;
        boolean $this$filter$iv222 = currentToLoad.size() == previousToLoad.size();
        $i$f$filter3 = false;
        boolean $this$filterTo$iv$iv42 = false;
        if (!$this$filter$iv222) {
            boolean bl7 = false;
            String $this$filterTo$iv$iv42 = StringsKt.trimIndent((String)("\n            Number of loaded files in snapshots differs. Reported changed files: " + changedFiles2 + "\n            Current snapshot data files: " + this.dataForFiles.keySet() + "\n            Previous snapshot data files: " + previousSnapshot2.dataForFiles.keySet() + "\n        "));
            throw (Throwable)new IllegalStateException($this$filterTo$iv$iv42.toString());
        }
        HashMap<String, byte[]> currentHashesToAnalyze = this.getHashesToAnalyze((List<? extends File>)currentToLoad);
        HashMap<String, byte[]> previousHashesToAnalyze = previousSnapshot2.getHashesToAnalyze(previousToLoad);
        boolean bl7 = false;
        Set changedClasses = new LinkedHashSet();
        Set<String> set2 = previousHashesToAnalyze.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set2, (String)"previousHashesToAnalyze.keys");
        Set<String> set3 = currentHashesToAnalyze.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set3, (String)"currentHashesToAnalyze.keys");
        for (String key : SetsKt.plus(set2, (Iterable)set3)) {
            byte[] previousHash = previousHashesToAnalyze.get(key);
            if (previousHash == null) {
                String string = key;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
                changedClasses.add(string);
                continue;
            }
            byte[] currentHash = currentHashesToAnalyze.get(key);
            if (currentHash == null) {
                String string = key;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
                changedClasses.add(string);
                continue;
            }
            byte[] byArray = previousHash;
            boolean bl8 = false;
            if (Arrays.equals(byArray, currentHash)) continue;
            String string = key;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
            changedClasses.add(string);
        }
        for (File unchanged : unchangedBetweenCompilations) {
            ClasspathEntryData classpathEntryData = previousSnapshot2.dataForFiles.get(unchanged);
            if (classpathEntryData == null) {
                Intrinsics.throwNpe();
            }
            this.dataForFiles.put(unchanged, classpathEntryData);
        }
        Set<String> allImpactedClasses = this.findAllImpacted(changedClasses);
        return new KaptClasspathChanges.Known(allImpactedClasses);
    }

    /*
     * WARNING - void declaration
     */
    private final HashMap<String, byte[]> getHashesToAnalyze(List<? extends File> filesToLoad) {
        Iterable $this$sumBy$iv = filesToLoad;
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            void it;
            File file = (File)element$iv;
            int n = sum$iv;
            boolean bl = false;
            ClasspathEntryData classpathEntryData = this.dataForFiles.get(it);
            if (classpathEntryData == null) {
                Intrinsics.throwNpe();
            }
            int n2 = classpathEntryData.getClassAbiHash().size();
            sum$iv = n + n2;
        }
        int hashAbiSize = sum$iv;
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>(hashAbiSize);
        boolean bl = false;
        boolean bl2 = false;
        HashMap<String, byte[]> hashes = hashMap;
        boolean bl3 = false;
        Iterable $this$forEach$iv = filesToLoad;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl4 = false;
            ClasspathEntryData classpathEntryData = this.dataForFiles.get(it);
            if (classpathEntryData == null) {
                Intrinsics.throwNpe();
            }
            hashes.putAll(classpathEntryData.getClassAbiHash());
        }
        return hashMap;
    }

    private final void loadEntriesFor(Iterable<? extends File> file) {
        for (File file2 : file) {
            if (this.dataForFiles.get(file2) != null) continue;
            this.dataForFiles.put(file2, ClasspathEntryData.ClasspathEntrySerializer.INSTANCE.loadFrom(file2));
        }
    }

    private final void loadAll() {
        this.loadEntriesFor((Iterable<? extends File>)this.dataForFiles.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeToCache() {
        Object object;
        Object object2;
        this.loadAll();
        File classpathEntries = FilesKt.resolve((File)this.cacheDir, (String)"classpath-entries.bin");
        Object object3 = classpathEntries;
        boolean bl = false;
        FileOutputStream fileOutputStream = new FileOutputStream((File)object3);
        OutputStream outputStream = fileOutputStream;
        OutputStream outputStream2 = new BufferedOutputStream(outputStream);
        object3 = new ObjectOutputStream(outputStream2);
        bl = false;
        Throwable throwable = null;
        try {
            ObjectOutputStream it = (ObjectOutputStream)object3;
            boolean bl2 = false;
            it.writeObject(this.classpath);
            object2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable);
        }
        File annotationProcessorClasspathEntries = FilesKt.resolve((File)this.cacheDir, (String)"ap-classpath-entries.bin");
        Object object4 = annotationProcessorClasspathEntries;
        boolean bl3 = false;
        fileOutputStream = new FileOutputStream((File)object4);
        OutputStream outputStream3 = fileOutputStream;
        OutputStream outputStream4 = new BufferedOutputStream(outputStream3);
        object4 = new ObjectOutputStream(outputStream4);
        bl3 = false;
        object2 = null;
        try {
            ObjectOutputStream it = (ObjectOutputStream)object4;
            boolean bl4 = false;
            it.writeObject(this.annotationProcessorClasspath);
            object = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            object2 = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object4, (Throwable)object2);
        }
        File classpathStructureData = FilesKt.resolve((File)this.cacheDir, (String)"classpath-structure.bin");
        Object object5 = classpathStructureData;
        boolean bl5 = false;
        fileOutputStream = new FileOutputStream((File)object5);
        OutputStream outputStream5 = fileOutputStream;
        OutputStream outputStream6 = new BufferedOutputStream(outputStream5);
        object5 = new ObjectOutputStream(outputStream6);
        bl5 = false;
        object = null;
        try {
            ObjectOutputStream it = (ObjectOutputStream)object5;
            boolean bl6 = false;
            it.writeObject(this.dataForFiles);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            object = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object5, (Throwable)object);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> findAllImpacted(Set<String> changedClasses) {
        Object object;
        HashMap transitiveDeps = new HashMap();
        HashMap nonTransitiveDeps = new HashMap();
        Iterator<ClasspathEntryData> iterator = this.dataForFiles.values().iterator();
        while (iterator.hasNext()) {
            ClasspathEntryData entry;
            ClasspathEntryData classpathEntryData = entry = iterator.next();
            if (classpathEntryData == null) {
                Intrinsics.throwNpe();
            }
            Object object2 = classpathEntryData.getClassDependencies();
            boolean bl = false;
            Iterator<Map.Entry<String, ClassDependencies>> iterator2 = object2.entrySet().iterator();
            while (iterator2.hasNext()) {
                void className;
                List it;
                boolean bl2;
                boolean bl3;
                List list2;
                Object object3 = object = iterator2.next();
                boolean bl4 = false;
                object2 = (String)object3.getKey();
                object3 = object;
                bl4 = false;
                ClassDependencies classDependency = (ClassDependencies)object3.getValue();
                for (String abiType : classDependency.getAbiTypes()) {
                    List list3 = (List)transitiveDeps.get(abiType);
                    if (list3 == null) {
                        list3 = new LinkedList();
                    }
                    list2 = list3;
                    bl3 = false;
                    bl2 = false;
                    it = list2;
                    boolean bl5 = false;
                    it.add(className);
                    Map map2 = transitiveDeps;
                    List list4 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list4, (String)"it");
                    map2.put(abiType, list4);
                }
                for (String privateType : classDependency.getPrivateTypes()) {
                    List list5 = (List)nonTransitiveDeps.get(privateType);
                    if (list5 == null) {
                        list5 = new LinkedList();
                    }
                    list2 = list5;
                    bl3 = false;
                    bl2 = false;
                    it = list2;
                    boolean bl6 = false;
                    it.add(className);
                    Map map3 = nonTransitiveDeps;
                    List list6 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list6, (String)"it");
                    map3.put(privateType, list6);
                }
            }
        }
        boolean bl = false;
        Set allImpacted = new LinkedHashSet();
        Set current = changedClasses;
        while (true) {
            object = current;
            boolean bl7 = false;
            if (!(!object.isEmpty())) break;
            bl7 = false;
            Set newRound = new LinkedHashSet();
            for (String klass : current) {
                List it;
                List list7;
                boolean bl8;
                boolean bl9;
                if (!allImpacted.add(klass)) continue;
                if ((List)transitiveDeps.get(klass) != null) {
                    bl9 = false;
                    bl8 = false;
                    it = list7;
                    boolean bl10 = false;
                    List list8 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list8, (String)"it");
                    newRound.addAll(list8);
                }
                if ((List)nonTransitiveDeps.get(klass) == null) continue;
                bl9 = false;
                bl8 = false;
                it = list7;
                boolean bl11 = false;
                List list9 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)list9, (String)"it");
                allImpacted.addAll(list9);
            }
            current = newRound;
        }
        return allImpacted;
    }

    protected ClasspathSnapshot(@NotNull File cacheDir, @NotNull List<? extends File> classpath2, @NotNull List<? extends File> annotationProcessorClasspath, @NotNull Map<File, ClasspathEntryData> dataForFiles) {
        Intrinsics.checkParameterIsNotNull((Object)cacheDir, (String)"cacheDir");
        Intrinsics.checkParameterIsNotNull(classpath2, (String)"classpath");
        Intrinsics.checkParameterIsNotNull(annotationProcessorClasspath, (String)"annotationProcessorClasspath");
        Intrinsics.checkParameterIsNotNull(dataForFiles, (String)"dataForFiles");
        this.cacheDir = cacheDir;
        this.classpath = classpath2;
        this.annotationProcessorClasspath = annotationProcessorClasspath;
        this.dataForFiles = dataForFiles;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/kapt/incremental/ClasspathSnapshot$ClasspathSnapshotFactory;", "", "()V", "createCurrent", "Lorg/jetbrains/kotlin/gradle/internal/kapt/incremental/ClasspathSnapshot;", "cacheDir", "Ljava/io/File;", "classpath", "", "annotationProcessorClasspath", "allStructureData", "", "getEmptySnapshot", "Lorg/jetbrains/kotlin/gradle/internal/kapt/incremental/UnknownSnapshot;", "loadFrom", "kotlin-gradle-plugin"})
    public static final class ClasspathSnapshotFactory {
        public static final ClasspathSnapshotFactory INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final ClasspathSnapshot loadFrom(@NotNull File cacheDir) {
            Map map2;
            Object object;
            Object object2;
            Intrinsics.checkParameterIsNotNull((Object)cacheDir, (String)"cacheDir");
            File classpathEntries = FilesKt.resolve((File)cacheDir, (String)"classpath-entries.bin");
            File classpathStructureData = FilesKt.resolve((File)cacheDir, (String)"classpath-structure.bin");
            File annotationProcessorClasspathEntries = FilesKt.resolve((File)cacheDir, (String)"ap-classpath-entries.bin");
            if (!(classpathEntries.exists() && classpathStructureData.exists() && annotationProcessorClasspathEntries.exists())) {
                return UnknownSnapshot.INSTANCE;
            }
            Object object3 = classpathEntries;
            boolean bl = false;
            FileInputStream fileInputStream = new FileInputStream((File)object3);
            InputStream inputStream = fileInputStream;
            InputStream inputStream2 = new BufferedInputStream(inputStream);
            object3 = new ObjectInputStream(inputStream2);
            bl = false;
            Throwable throwable = null;
            try {
                ObjectInputStream it = (ObjectInputStream)object3;
                boolean bl2 = false;
                Object object4 = it.readObject();
                if (object4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<java.io.File>");
                }
                object2 = (List)object4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable);
            }
            List classpathFiles = object2;
            Object object5 = annotationProcessorClasspathEntries;
            boolean bl3 = false;
            fileInputStream = new FileInputStream((File)object5);
            InputStream inputStream3 = fileInputStream;
            InputStream inputStream4 = new BufferedInputStream(inputStream3);
            object5 = new ObjectInputStream(inputStream4);
            bl3 = false;
            object2 = null;
            try {
                ObjectInputStream it = (ObjectInputStream)object5;
                boolean bl4 = false;
                Object object6 = it.readObject();
                if (object6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<java.io.File>");
                }
                object = (List)object6;
            }
            catch (Throwable throwable3) {
                object2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object5, (Throwable)object2);
            }
            List annotationProcessorClasspathFiles = object;
            Object object7 = classpathStructureData;
            boolean bl5 = false;
            fileInputStream = new FileInputStream((File)object7);
            InputStream inputStream5 = fileInputStream;
            InputStream inputStream6 = new BufferedInputStream(inputStream5);
            object7 = new ObjectInputStream(inputStream6);
            bl5 = false;
            object = null;
            try {
                ObjectInputStream it = (ObjectInputStream)object7;
                boolean bl6 = false;
                Object object8 = it.readObject();
                if (object8 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<java.io.File, org.jetbrains.kotlin.gradle.internal.kapt.incremental.ClasspathEntryData?>");
                }
                map2 = TypeIntrinsics.asMutableMap((Object)object8);
            }
            catch (Throwable throwable4) {
                object = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object7, (Throwable)object);
            }
            Map dataForFiles = map2;
            return new ClasspathSnapshot(cacheDir, classpathFiles, annotationProcessorClasspathFiles, dataForFiles);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ClasspathSnapshot createCurrent(@NotNull File cacheDir, @NotNull List<? extends File> classpath2, @NotNull List<? extends File> annotationProcessorClasspath, @NotNull Set<? extends File> allStructureData) {
            void $this$associateTo$iv;
            Intrinsics.checkParameterIsNotNull((Object)cacheDir, (String)"cacheDir");
            Intrinsics.checkParameterIsNotNull(classpath2, (String)"classpath");
            Intrinsics.checkParameterIsNotNull(annotationProcessorClasspath, (String)"annotationProcessorClasspath");
            Intrinsics.checkParameterIsNotNull(allStructureData, (String)"allStructureData");
            Iterable iterable = allStructureData;
            Map destination$iv = new HashMap(allStructureData.size());
            boolean $i$f$associateTo = false;
            for (Object element$iv : $this$associateTo$iv) {
                Map map2 = destination$iv;
                File it = (File)element$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it, null);
                boolean bl2 = false;
                map2.put(pair.getFirst(), pair.getSecond());
            }
            HashMap data = (HashMap)destination$iv;
            return new ClasspathSnapshot(cacheDir, classpath2, annotationProcessorClasspath, data);
        }

        @NotNull
        public final UnknownSnapshot getEmptySnapshot() {
            return UnknownSnapshot.INSTANCE;
        }

        private ClasspathSnapshotFactory() {
        }

        static {
            ClasspathSnapshotFactory classpathSnapshotFactory;
            INSTANCE = classpathSnapshotFactory = new ClasspathSnapshotFactory();
        }
    }
}

