/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.tasks.IosDsymFiles;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001d\u001a\u00020\u001eR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0011\u0010\u0014\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000bR\u0011\u0010\u0016\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000bR\u0011\u0010\u0018\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000bR\u0011\u0010\u001a\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/IosFrameworkFiles;", "", "parentDir", "Ljava/io/File;", "frameworkName", "", "(Ljava/io/File;Ljava/lang/String;)V", "rootDir", "(Ljava/io/File;)V", "binary", "getBinary", "()Ljava/io/File;", "dSYM", "Lorg/jetbrains/kotlin/gradle/tasks/IosDsymFiles;", "getDSYM", "()Lorg/jetbrains/kotlin/gradle/tasks/IosDsymFiles;", "getFrameworkName", "()Ljava/lang/String;", "header", "getHeader", "headerDir", "getHeaderDir", "infoPlist", "getInfoPlist", "moduleFile", "getModuleFile", "modulesDir", "getModulesDir", "getRootDir", "mkdirs", "", "kotlin-gradle-plugin"})
final class IosFrameworkFiles {
    @NotNull
    private final String frameworkName;
    @NotNull
    private final File headerDir;
    @NotNull
    private final File modulesDir;
    @NotNull
    private final File binary;
    @NotNull
    private final File header;
    @NotNull
    private final File moduleFile;
    @NotNull
    private final File infoPlist;
    @NotNull
    private final IosDsymFiles dSYM;
    @NotNull
    private final File rootDir;

    @NotNull
    public final String getFrameworkName() {
        return this.frameworkName;
    }

    @NotNull
    public final File getHeaderDir() {
        return this.headerDir;
    }

    @NotNull
    public final File getModulesDir() {
        return this.modulesDir;
    }

    @NotNull
    public final File getBinary() {
        return this.binary;
    }

    @NotNull
    public final File getHeader() {
        return this.header;
    }

    @NotNull
    public final File getModuleFile() {
        return this.moduleFile;
    }

    @NotNull
    public final File getInfoPlist() {
        return this.infoPlist;
    }

    @NotNull
    public final IosDsymFiles getDSYM() {
        return this.dSYM;
    }

    public final void mkdirs() {
        this.rootDir.mkdirs();
        this.headerDir.mkdir();
        this.modulesDir.mkdir();
    }

    @NotNull
    public final File getRootDir() {
        return this.rootDir;
    }

    public IosFrameworkFiles(@NotNull File rootDir) {
        Intrinsics.checkParameterIsNotNull((Object)rootDir, (String)"rootDir");
        this.rootDir = rootDir;
        this.frameworkName = FilesKt.getNameWithoutExtension((File)this.rootDir);
        this.headerDir = FilesKt.resolve((File)this.rootDir, (String)"Headers");
        this.modulesDir = FilesKt.resolve((File)this.rootDir, (String)"Modules");
        this.binary = FilesKt.resolve((File)this.rootDir, (String)this.frameworkName);
        this.header = FilesKt.resolve((File)this.headerDir, (String)(this.frameworkName + ".h"));
        this.moduleFile = FilesKt.resolve((File)this.modulesDir, (String)"module.modulemap");
        this.infoPlist = FilesKt.resolve((File)this.rootDir, (String)"Info.plist");
        File file = this.rootDir.getParentFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"rootDir.parentFile");
        this.dSYM = new IosDsymFiles(FilesKt.resolve((File)file, (String)(this.frameworkName + ".framework.dSYM")));
    }

    public IosFrameworkFiles(@NotNull File parentDir, @NotNull String frameworkName) {
        Intrinsics.checkParameterIsNotNull((Object)parentDir, (String)"parentDir");
        Intrinsics.checkParameterIsNotNull((Object)frameworkName, (String)"frameworkName");
        this(FilesKt.resolve((File)parentDir, (String)(frameworkName + ".framework")));
    }
}

