/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u001a:\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0000\u001a\f\u0010\t\u001a\u00020\u0004*\u00020\u0001H\u0000\u001a\f\u0010\n\u001a\u00020\b*\u00020\u0001H\u0000\u001a\u001a\u0010\u000b\u001a\u00020\b*\u00020\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u0000\u001a\u001e\u0010\u000e\u001a\u00020\b*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\b\b\u0002\u0010\u0010\u001a\u00020\bH\u0000\u001a\u001a\u0010\u0011\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0014\u001a\u00020\u0004*\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0015\u001a\u00020\u0004*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a\u001d\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0019*\b\u0012\u0004\u0012\u00020\u00010\u0012H\u0000\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"newTmpFile", "Ljava/io/File;", "kotlin.jvm.PlatformType", "prefix", "", "suffix", "directory", "deleteOnExit", "", "canonicalPathWithoutExtension", "isJavaFile", "isKotlinFile", "sourceFilesExtensions", "", "isParentOf", "childCandidate", "strict", "pathsAsStringRelativeTo", "", "base", "relativeOrCanonical", "relativeToRoot", "project", "Lorg/gradle/api/Project;", "toSortedPathsArray", "", "(Ljava/lang/Iterable;)[Ljava/lang/String;", "kotlin-gradle-plugin"})
public final class FileUtilsKt {
    public static final boolean isJavaFile(@NotNull File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return StringsKt.equals((String)FilesKt.getExtension((File)$receiver), (String)"java", (boolean)true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKotlinFile(@NotNull File $receiver, @NotNull List<String> sourceFilesExtensions2) {
        String it;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(sourceFilesExtensions2, (String)"sourceFilesExtensions");
        if (FileUtilsKt.isJavaFile($receiver)) return false;
        Iterable $this$any$iv = sourceFilesExtensions2;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!StringsKt.equals((String)it, (String)FilesKt.getExtension((File)$receiver), (boolean)true));
        return true;
    }

    @NotNull
    public static final String relativeOrCanonical(@NotNull File $receiver, @NotNull File base) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
        Object object = FilesKt.relativeToOrNull((File)$receiver, (File)base);
        if (object == null || (object = ((File)object).getPath()) == null) {
            String string = $receiver.getCanonicalPath();
            object = string;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"canonicalPath");
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String pathsAsStringRelativeTo(@NotNull Iterable<? extends File> $receiver, @NotNull File base) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
        Iterable<? extends File> $this$map$iv = $receiver;
        boolean $i$f$map = false;
        Iterable<? extends File> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = FileUtilsKt.relativeOrCanonical((File)it, base);
            collection.add(string);
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), null, null, null, (int)0, null, null, (int)63, null);
    }

    @NotNull
    public static final String relativeToRoot(@NotNull File $receiver, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Project project2 = project.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project.rootProject");
        File file = project2.getRootDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.rootProject.rootDir");
        return FileUtilsKt.relativeOrCanonical($receiver, file);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String[] toSortedPathsArray(@NotNull Iterable<? extends File> $receiver) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Iterable<? extends File> $this$map$iv = $receiver;
        boolean $i$f$map = false;
        Iterable<? extends File> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getCanonicalPath();
            collection.add(string);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new String[0]);
        if (objectArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray2 = objectArray;
        boolean bl = false;
        boolean bl2 = false;
        Object[] it = objectArray2;
        boolean bl3 = false;
        Arrays.sort(it);
        return (String[])objectArray2;
    }

    public static final File newTmpFile(@NotNull String prefix, @Nullable String suffix, @Nullable File directory, boolean deleteOnExit) {
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        File file = File.createTempFile(prefix, suffix, directory);
        boolean bl = false;
        boolean bl2 = false;
        File $receiver = file;
        boolean bl3 = false;
        if (deleteOnExit) {
            $receiver.deleteOnExit();
        }
        return file;
    }

    public static /* synthetic */ File newTmpFile$default(String string, String string2, File file, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            file = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return FileUtilsKt.newTmpFile(string, string2, file, bl);
    }

    public static final boolean isParentOf(@NotNull File $receiver, @NotNull File childCandidate, boolean strict) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)childCandidate, (String)"childCandidate");
        Path parentPath = Paths.get($receiver.getAbsolutePath(), new String[0]).normalize();
        Path childCandidatePath = Paths.get(childCandidate.getAbsolutePath(), new String[0]).normalize();
        return strict ? childCandidatePath.startsWith(parentPath) && Intrinsics.areEqual((Object)parentPath, (Object)childCandidate) ^ true : childCandidatePath.startsWith(parentPath);
    }

    public static /* synthetic */ boolean isParentOf$default(File file, File file2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return FileUtilsKt.isParentOf(file, file2, bl);
    }

    @NotNull
    public static final String canonicalPathWithoutExtension(@NotNull File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver.getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"canonicalPath");
        return StringsKt.substringBeforeLast$default((String)string, (String)".", null, (int)2, null);
    }
}

