/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.internal;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compilerRunner.KotlinNativeKlibCommonizerToolRunner;
import org.jetbrains.kotlin.gradle.targets.native.internal.CommonizerTaskKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\rH\u0002\u001a\u001e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u0002\u001a\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0010H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\" \u0010\u0005\u001a\n \u0004*\u0004\u0018\u00010\u00010\u0001*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"COMMONIZER_TASK_NAME", "", "base64Encoder", "Ljava/util/Base64$Encoder;", "kotlin.jvm.PlatformType", "base64", "getBase64", "(Ljava/lang/String;)Ljava/lang/String;", "callCommonizerCLI", "", "project", "Lorg/gradle/api/Project;", "commandLineArguments", "", "cleanUp", "baseDirectory", "Ljava/io/File;", "excludedDirectories", "renameDirectory", "source", "destination", "renameToTempAndDelete", "directory", "kotlin-gradle-plugin"})
public final class CommonizerTaskKt {
    @NotNull
    public static final String COMMONIZER_TASK_NAME = "runCommonizer";
    private static final Base64.Encoder base64Encoder = Base64.getEncoder().withoutPadding();

    private static final void callCommonizerCLI(Project project, List<String> commandLineArguments) {
        if (commandLineArguments.isEmpty()) {
            return;
        }
        new KotlinNativeKlibCommonizerToolRunner(project).run(commandLineArguments);
    }

    /*
     * WARNING - void declaration
     */
    private static final void renameDirectory(File source2, File destination) {
        Path sourcePath = source2.toPath();
        Path destinationPath = destination.toPath();
        int n = 0;
        List suppressedExceptions = new ArrayList();
        n = 0;
        int n2 = 3;
        while (n < n2) {
            try {
                CommonizerTaskKt.renameToTempAndDelete(destination);
                Files.move(sourcePath, destinationPath, StandardCopyOption.ATOMIC_MOVE);
                return;
            }
            catch (IOException e) {
                void it;
                Collection collection = suppressedExceptions;
                boolean bl = false;
                collection.add(e);
                if (e instanceof AtomicMoveNotSupportedException) break;
                ++it;
            }
        }
        IllegalStateException illegalStateException = new IllegalStateException("Failed to rename " + source2 + " to " + destination);
        n2 = 0;
        boolean bl = false;
        IllegalStateException $receiver = illegalStateException;
        boolean bl2 = false;
        Iterable $this$forEach$iv = suppressedExceptions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Throwable p1 = (Throwable)element$iv;
            boolean bl3 = false;
            $receiver.addSuppressed(p1);
        }
        throw (Throwable)illegalStateException;
    }

    /*
     * WARNING - void declaration
     */
    private static final void renameToTempAndDelete(File directory2) {
        File file;
        if (!directory2.exists()) {
            return;
        }
        String string = directory2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"directory.name");
        if (StringsKt.startsWith$default((String)string, (String)"tmp-", (boolean)false, (int)2, null)) {
            file = directory2;
        } else {
            void var2_1;
            File tempDir = FilesKt.createTempFile((String)("tmp-" + directory2.getName()), (String)".old", (File)directory2.getParentFile());
            tempDir.delete();
            Files.move(directory2.toPath(), tempDir.toPath(), StandardCopyOption.ATOMIC_MOVE);
            file = var2_1;
        }
        File dirToRemove = file;
        FilesKt.deleteRecursively((File)dirToRemove);
    }

    /*
     * WARNING - void declaration
     */
    private static final void cleanUp(File baseDirectory, List<? extends File> excludedDirectories) {
        void $this$mapTo$iv$iv;
        cleanUp.1 $fun$getAttributes$1 = cleanUp.1.INSTANCE;
        cleanUp.2 $fun$isSameOrAfter$2 = cleanUp.2.INSTANCE;
        Instant now = Instant.now();
        Instant oneHourAgo = now.minus(Duration.ofHours(1L));
        Instant oneMonthAgo = now.minus(Duration.ofDays(31L));
        File[] $this$map$iv = (File[])excludedDirectories;
        boolean $i$f$map = false;
        File[] fileArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getAbsolutePath();
            collection.add(string);
        }
        Set excludedPaths = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        File[] fileArray2 = baseDirectory.listFiles();
        if (fileArray2 != null) {
            File[] $this$forEach$iv = fileArray2;
            boolean $i$f$forEach = false;
            fileArray = $this$forEach$iv;
            int n = fileArray.length;
            for (int j = 0; j < n; ++j) {
                BasicFileAttributes attributes;
                File element$iv;
                File file = element$iv = fileArray[j];
                boolean bl = false;
                File file2 = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                if (excludedPaths.contains(file2.getAbsolutePath())) continue;
                if (cleanUp.1.INSTANCE.invoke(file) == null) {
                    continue;
                }
                if (attributes.isDirectory()) {
                    String string = file.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
                    if (StringsKt.startsWith$default((String)string, (String)"tmp-", (boolean)false, (int)2, null)) {
                        FileTime fileTime = attributes.creationTime();
                        Intrinsics.checkExpressionValueIsNotNull((Object)fileTime, (String)"attributes.creationTime()");
                        Instant instant = oneHourAgo;
                        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"oneHourAgo");
                        if (cleanUp.2.INSTANCE.invoke(fileTime, instant)) {
                            continue;
                        }
                    } else {
                        FileTime fileTime = attributes.lastAccessTime();
                        Intrinsics.checkExpressionValueIsNotNull((Object)fileTime, (String)"attributes.lastAccessTime()");
                        Instant instant = oneMonthAgo;
                        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"oneMonthAgo");
                        if (cleanUp.2.INSTANCE.invoke(fileTime, instant)) continue;
                    }
                }
                try {
                    CommonizerTaskKt.renameToTempAndDelete(file);
                    continue;
                }
                catch (IOException iOException) {
                }
            }
        }
    }

    private static final String getBase64(String $receiver) {
        String string = $receiver;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
        Charset charset2 = charset;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return base64Encoder.encodeToString(byArray);
    }

    public static final /* synthetic */ String access$getBase64$p(String $receiver) {
        return CommonizerTaskKt.getBase64($receiver);
    }

    public static final /* synthetic */ void access$renameDirectory(File source2, File destination) {
        CommonizerTaskKt.renameDirectory(source2, destination);
    }

    public static final /* synthetic */ void access$renameToTempAndDelete(File directory2) {
        CommonizerTaskKt.renameToTempAndDelete(directory2);
    }

    public static final /* synthetic */ void access$cleanUp(File baseDirectory, List excludedDirectories) {
        CommonizerTaskKt.cleanUp(baseDirectory, excludedDirectories);
    }

    public static final /* synthetic */ void access$callCommonizerCLI(Project project, List commandLineArguments) {
        CommonizerTaskKt.callCommonizerCLI(project, commandLineArguments);
    }
}

