/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.io.File;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.compilerRunner.GradleCompilerRunner;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskExecutionResults;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskLoggers;
import org.jetbrains.kotlin.gradle.utils.FileUtilsKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\fJ\b\u0010\u0010\u001a\u00020\tH\u0002J\u0011\u0010\u0011\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleFinishBuildHandler;", "", "()V", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "shouldReportMemoryUsage", "", "startMemory", "", "Ljava/lang/Long;", "buildFinished", "", "gradle", "Lorg/gradle/api/invocation/Gradle;", "buildStart", "getGcCount", "getUsedMemoryKb", "getUsedMemoryKb$kotlin_gradle_plugin", "()Ljava/lang/Long;", "kotlin-gradle-plugin"})
public final class KotlinGradleFinishBuildHandler {
    private final Logger log = Logging.getLogger(this.getClass());
    private Long startMemory;
    private final boolean shouldReportMemoryUsage = System.getProperty("kotlin.gradle.test.report.memory.usage") != null;

    public final void buildStart() {
        this.startMemory = this.getUsedMemoryKb$kotlin_gradle_plugin();
    }

    public final void buildFinished(@NotNull Gradle gradle) {
        Project rootProject;
        Intrinsics.checkParameterIsNotNull((Object)gradle, (String)"gradle");
        TaskLoggers.INSTANCE.clear();
        TaskExecutionResults.INSTANCE.clear();
        GradleCompilerRunner.Companion.clearBuildModulesInfo$kotlin_gradle_plugin();
        Project project = rootProject = gradle.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"rootProject");
        File sessionsDir = GradleCompilerRunner.Companion.sessionsDir$kotlin_gradle_plugin(project);
        if (sessionsDir.exists()) {
            File[] sessionFiles = sessionsDir.listFiles();
            if (sessionFiles.length > 1) {
                this.log.warn("w: Detected multiple Kotlin daemon sessions at " + FileUtilsKt.relativeToRoot(sessionsDir, rootProject));
            }
            for (File file : sessionFiles) {
                Logger $receiver$iv;
                file.delete();
                Intrinsics.checkExpressionValueIsNotNull((Object)this.log, (String)"log");
                boolean $i$f$kotlinDebug = false;
                if (!$receiver$iv.isDebugEnabled()) continue;
                Logger logger = $receiver$iv;
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder().append("Deleted session-is-alive flag file: ");
                File file2 = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                String string = stringBuilder.append(FileUtilsKt.relativeToRoot(file2, rootProject)).toString();
                GradleLoggingUtilsKt.kotlinDebug(logger, string);
            }
        }
        if (this.shouldReportMemoryUsage) {
            Long l = this.startMemory;
            if (l == null) {
                Intrinsics.throwNpe();
            }
            long startMem = l;
            Long l2 = this.getUsedMemoryKb$kotlin_gradle_plugin();
            if (l2 == null) {
                Intrinsics.throwNpe();
            }
            long endMem = l2;
            StringBuilder stringBuilder = new StringBuilder().append("[KOTLIN][PERF] Used memory after build: ").append(endMem).append(" kb (difference since build start: ");
            String string = "%+d";
            Object[] objectArray = new Object[]{endMem - startMem};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
            this.log.lifecycle(stringBuilder.append(string2).append(" kb)").toString());
        }
        gradle.removeListener((Object)this);
    }

    @Nullable
    public final Long getUsedMemoryKb$kotlin_gradle_plugin() {
        if (!this.shouldReportMemoryUsage) {
            return null;
        }
        this.log.lifecycle("Forcing System.gc()");
        long gcCountBefore = this.getGcCount();
        System.gc();
        while (this.getGcCount() == gcCountBefore) {
        }
        Runtime rt = Runtime.getRuntime();
        return (rt.totalMemory() - rt.freeMemory()) / (long)1024;
    }

    /*
     * WARNING - void declaration
     */
    private final long getGcCount() {
        void var3_3;
        List<GarbageCollectorMXBean> list2 = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"ManagementFactory.getGarbageCollectorMXBeans()");
        Iterable $this$sumByLong$iv = list2;
        boolean $i$f$sumByLong = false;
        long sum$iv = 0L;
        for (Object element$iv : $this$sumByLong$iv) {
            void it;
            GarbageCollectorMXBean garbageCollectorMXBean = (GarbageCollectorMXBean)element$iv;
            long l = sum$iv;
            boolean bl = false;
            long l2 = 0L;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            long l3 = v1.getCollectionCount();
            boolean bl2 = false;
            long l4 = Math.max(l2, l3);
            sum$iv = l + l4;
        }
        return (long)var3_3;
    }
}

