/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp;

import java.io.File;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.mpp.GlobalProjectStructureMetadataStorage;
import org.jetbrains.kotlin.gradle.plugin.mpp.JarArtifactMppDependencyMetadataExtractor;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinProjectStructureMetadata;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/IncludedBuildMetadataExtractor;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/JarArtifactMppDependencyMetadataExtractor;", "project", "Lorg/gradle/api/Project;", "dependency", "Lorg/gradle/api/artifacts/result/ResolvedComponentResult;", "primaryArtifact", "Ljava/io/File;", "(Lorg/gradle/api/Project;Lorg/gradle/api/artifacts/result/ResolvedComponentResult;Ljava/io/File;)V", "id", "Lorg/gradle/api/artifacts/component/ProjectComponentIdentifier;", "getProjectStructureMetadata", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinProjectStructureMetadata;", "kotlin-gradle-plugin"})
final class IncludedBuildMetadataExtractor
extends JarArtifactMppDependencyMetadataExtractor {
    private final ProjectComponentIdentifier id;

    @Override
    @Nullable
    public KotlinProjectStructureMetadata getProjectStructureMetadata() {
        Project project = this.getProject();
        BuildIdentifier buildIdentifier = this.id.getBuild();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildIdentifier, (String)"id.build");
        String string = buildIdentifier.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id.build.name");
        String string2 = this.id.getProjectPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"id.projectPath");
        return GlobalProjectStructureMetadataStorage.INSTANCE.getProjectStructureMetadata(project, string, string2);
    }

    public IncludedBuildMetadataExtractor(@NotNull Project project, @NotNull ResolvedComponentResult dependency, @NotNull File primaryArtifact) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
        Intrinsics.checkParameterIsNotNull((Object)primaryArtifact, (String)"primaryArtifact");
        super(project, dependency, primaryArtifact);
        ComponentIdentifier id = dependency.getId();
        boolean bl = id instanceof ProjectComponentIdentifier;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "dependency should resolve to a project";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ComponentIdentifier componentIdentifier = id;
        if (componentIdentifier == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.artifacts.component.ProjectComponentIdentifier");
        }
        BuildIdentifier buildIdentifier = ((ProjectComponentIdentifier)componentIdentifier).getBuild();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildIdentifier, (String)"(id as ProjectComponentIdentifier).build");
        bl = !buildIdentifier.isCurrentBuild();
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "should be a project from an included build";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.id = (ProjectComponentIdentifier)id;
    }
}

