/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.publish.maven.MavenPublication;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.ModuleDependencyIdentifier;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0014H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/ModuleIds;", "", "()V", "fromComponent", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/ModuleDependencyIdentifier;", "thisProject", "Lorg/gradle/api/Project;", "component", "Lorg/gradle/api/artifacts/result/ResolvedComponentResult;", "fromComponentId", "componentIdentifier", "Lorg/gradle/api/artifacts/component/ComponentIdentifier;", "fromComponentSelector", "componentSelector", "Lorg/gradle/api/artifacts/component/ComponentSelector;", "fromDependency", "dependency", "Lorg/gradle/api/artifacts/Dependency;", "idFromName", "name", "", "idOfRootModule", "project", "idOfRootModuleByProjectPath", "projectPath", "kotlin-gradle-plugin"})
public final class ModuleIds {
    @NotNull
    public static final ModuleIds INSTANCE;

    @NotNull
    public final ModuleDependencyIdentifier fromDependency(@NotNull Dependency dependency) {
        ModuleDependencyIdentifier moduleDependencyIdentifier;
        Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
        Dependency dependency2 = dependency;
        if (dependency2 instanceof ProjectDependency) {
            Project project = ((ProjectDependency)dependency).getDependencyProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"dependency.dependencyProject");
            moduleDependencyIdentifier = this.idOfRootModule(project);
        } else {
            String string = dependency.getGroup();
            String string2 = dependency.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dependency.name");
            moduleDependencyIdentifier = new ModuleDependencyIdentifier(string, string2);
        }
        return moduleDependencyIdentifier;
    }

    @NotNull
    public final ModuleDependencyIdentifier fromComponentSelector(@NotNull Project thisProject, @NotNull ComponentSelector componentSelector) {
        ModuleDependencyIdentifier moduleDependencyIdentifier;
        Intrinsics.checkParameterIsNotNull((Object)thisProject, (String)"thisProject");
        Intrinsics.checkParameterIsNotNull((Object)componentSelector, (String)"componentSelector");
        ComponentSelector componentSelector2 = componentSelector;
        if (componentSelector2 instanceof ProjectComponentSelector) {
            String string = ((ProjectComponentSelector)componentSelector).getProjectPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"componentSelector.projectPath");
            moduleDependencyIdentifier = this.idOfRootModuleByProjectPath(thisProject, string);
        } else if (componentSelector2 instanceof ModuleComponentSelector) {
            String string = ((ModuleComponentSelector)componentSelector).getGroup();
            String string2 = ((ModuleComponentSelector)componentSelector).getModule();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"componentSelector.module");
            moduleDependencyIdentifier = new ModuleDependencyIdentifier(string, string2);
        } else {
            String string = componentSelector.getDisplayName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"componentSelector.displayName");
            moduleDependencyIdentifier = this.idFromName(string);
        }
        return moduleDependencyIdentifier;
    }

    private final ModuleDependencyIdentifier fromComponentId(Project thisProject, ComponentIdentifier componentIdentifier) {
        ModuleDependencyIdentifier moduleDependencyIdentifier;
        ComponentIdentifier componentIdentifier2 = componentIdentifier;
        if (componentIdentifier2 instanceof ProjectComponentIdentifier) {
            String string = ((ProjectComponentIdentifier)componentIdentifier).getProjectPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"componentIdentifier.projectPath");
            moduleDependencyIdentifier = this.idOfRootModuleByProjectPath(thisProject, string);
        } else if (componentIdentifier2 instanceof ModuleComponentIdentifier) {
            String string = ((ModuleComponentIdentifier)componentIdentifier).getGroup();
            String string2 = ((ModuleComponentIdentifier)componentIdentifier).getModule();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"componentIdentifier.module");
            moduleDependencyIdentifier = new ModuleDependencyIdentifier(string, string2);
        } else {
            String string = componentIdentifier.getDisplayName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"componentIdentifier.displayName");
            moduleDependencyIdentifier = this.idFromName(string);
        }
        return moduleDependencyIdentifier;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final ModuleDependencyIdentifier fromComponent(@NotNull Project thisProject, @NotNull ResolvedComponentResult component) {
        ModuleDependencyIdentifier moduleDependencyIdentifier;
        ProjectComponentIdentifier projectComponentIdentifier;
        Intrinsics.checkParameterIsNotNull((Object)thisProject, (String)"thisProject");
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        ComponentIdentifier componentIdentifier = component.getId();
        if (!(componentIdentifier instanceof ProjectComponentIdentifier)) {
            componentIdentifier = null;
        }
        if ((projectComponentIdentifier = (ProjectComponentIdentifier)componentIdentifier) != null && (projectComponentIdentifier = projectComponentIdentifier.getBuild()) != null) {
            if (!projectComponentIdentifier.isCurrentBuild()) {
                Object object;
                Object object2 = component.getModuleVersion();
                if (object2 == null || (object2 = object2.getGroup()) == null) {
                    object2 = "unspecified";
                }
                if ((object = component.getModuleVersion()) == null || (object = object.getName()) == null) {
                    object = "unspecified";
                }
                moduleDependencyIdentifier = new ModuleDependencyIdentifier((String)object2, (String)object);
                return moduleDependencyIdentifier;
            }
        }
        ComponentIdentifier componentIdentifier2 = component.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)componentIdentifier2, (String)"component.id");
        moduleDependencyIdentifier = this.fromComponentId(thisProject, componentIdentifier2);
        return moduleDependencyIdentifier;
    }

    private final ModuleDependencyIdentifier idOfRootModule(Project project) {
        ModuleDependencyIdentifier moduleDependencyIdentifier;
        if (KotlinProjectExtensionKt.getMultiplatformExtensionOrNull(project) != null) {
            Object name;
            Object object;
            Object group;
            MavenPublication rootPublication = KotlinProjectExtensionKt.getMultiplatformExtension(project).getRootSoftwareComponent$kotlin_gradle_plugin().getPublicationDelegate();
            Object object2 = rootPublication;
            if (object2 == null || (object2 = object2.getGroupId()) == null) {
                object2 = group = project.getGroup().toString();
            }
            if ((object = rootPublication) == null || (object = object.getArtifactId()) == null) {
                object = project.getName();
            }
            Object object3 = name = object;
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"name");
            moduleDependencyIdentifier = new ModuleDependencyIdentifier((String)group, (String)object3);
        } else {
            String string = project.getGroup().toString();
            String string2 = project.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"project.name");
            moduleDependencyIdentifier = new ModuleDependencyIdentifier(string, string2);
        }
        return moduleDependencyIdentifier;
    }

    private final ModuleDependencyIdentifier idFromName(String name) {
        return new ModuleDependencyIdentifier(null, name);
    }

    private final ModuleDependencyIdentifier idOfRootModuleByProjectPath(Project thisProject, String projectPath) {
        Project project = thisProject.project(projectPath);
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"thisProject.project(projectPath)");
        return this.idOfRootModule(project);
    }

    private ModuleIds() {
    }

    static {
        ModuleIds moduleIds;
        INSTANCE = moduleIds = new ModuleIds();
    }
}

