/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.internal;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeTargetPresetKt;
import org.jetbrains.kotlin.gradle.targets.native.internal.NativeDistributionType;
import org.jetbrains.kotlin.gradle.utils.SingleWarningPerBuild;
import org.jetbrains.kotlin.konan.CompilerVersion;
import org.jetbrains.kotlin.konan.target.HostManager;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionTypeProvider;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "propertiesProvider", "Lorg/jetbrains/kotlin/gradle/plugin/PropertiesProvider;", "chooseDistributionType", "Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionType;", "prebuiltType", "lightType", "defaultType", "getDistributionType", "version", "Lorg/jetbrains/kotlin/konan/CompilerVersion;", "warning", "", "message", "", "kotlin-gradle-plugin"})
public final class NativeDistributionTypeProvider {
    private final PropertiesProvider propertiesProvider;
    private final Project project;

    private final void warning(String message2) {
        SingleWarningPerBuild.INSTANCE.show(this.project, "Warning: " + message2);
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    private final NativeDistributionType chooseDistributionType(NativeDistributionType prebuiltType, NativeDistributionType lightType, NativeDistributionType defaultType) {
        NativeDistributionType nativeDistributionType;
        String string;
        String string2 = this.propertiesProvider.getNativeDistributionType();
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
        } else {
            string = null;
        }
        String requestedByUser = string;
        Boolean deprecatedRestricted = this.propertiesProvider.getNativeDeprecatedRestricted();
        if (requestedByUser == null && deprecatedRestricted != null) {
            NativeDistributionType nativeDistributionType2;
            if (deprecatedRestricted.booleanValue()) {
                nativeDistributionType2 = lightType;
                return nativeDistributionType2;
            }
            nativeDistributionType2 = defaultType;
            return nativeDistributionType2;
        }
        String string6 = requestedByUser;
        if (string6 == null) {
            nativeDistributionType = defaultType;
            return nativeDistributionType;
        }
        switch (string6) {
            case "prebuilt": {
                nativeDistributionType = prebuiltType;
                return nativeDistributionType;
            }
            case "light": {
                nativeDistributionType = lightType;
                return nativeDistributionType;
            }
        }
        this.warning("Unknown Kotlin/Native distribution type: " + requestedByUser + ". Available values: prebuilt, light");
        nativeDistributionType = defaultType;
        return nativeDistributionType;
    }

    @NotNull
    public final NativeDistributionType getDistributionType(@NotNull CompilerVersion version) {
        NativeDistributionType nativeDistributionType;
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        if (this.propertiesProvider.getNativeDeprecatedRestricted() != null) {
            this.warning("Project property 'kotlin.native.restrictedDistribution' is deprecated. Please use 'kotlin.native.distribution.type=light' instead");
        }
        if (KotlinNativeTargetPresetKt.isAtLeast(version, 1, 4, 0)) {
            nativeDistributionType = this.chooseDistributionType(NativeDistributionType.PREBUILT, NativeDistributionType.LIGHT, NativeDistributionType.PREBUILT);
        } else {
            if (!HostManager.Companion.getHostIsMac()) {
                return NativeDistributionType.PREBUILT_1_3;
            }
            nativeDistributionType = this.chooseDistributionType(NativeDistributionType.PREBUILT_1_3, NativeDistributionType.LIGHT_1_3, NativeDistributionType.PREBUILT_1_3);
        }
        return nativeDistributionType;
    }

    public NativeDistributionTypeProvider(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.propertiesProvider = PropertiesProvider.Companion.invoke(this.project);
    }
}

