/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.tasks;

import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.cocoapods.CocoapodsExtension;
import org.jetbrains.kotlin.gradle.plugin.cocoapods.KotlinCocoapodsPluginKt;
import org.jetbrains.kotlin.gradle.targets.native.tasks.DownloadCocoapodsTask;
import org.jetbrains.kotlin.gradle.targets.native.tasks.PodDownloadUrlTask;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u0010\u001f\u001a\n \u0011*\u0004\u0018\u00010 0 2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\b\u0010\"\u001a\u00020\u001bH\u0007J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0005H\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8AX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR:\u0010\u000f\u001a&\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010 \u0011*\u0012\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010\u0018\u00010\t0\t8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0016\u0010\u0013\u001a\u00020\u00108AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/tasks/PodDownloadUrlTask;", "Lorg/jetbrains/kotlin/gradle/targets/native/tasks/DownloadCocoapodsTask;", "()V", "permittedFileExtensions", "", "", "getPermittedFileExtensions$kotlin_gradle_plugin", "()Ljava/util/List;", "podSource", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/plugin/cocoapods/CocoapodsExtension$CocoapodsDependency$PodLocation$Url;", "getPodSource$kotlin_gradle_plugin", "()Lorg/gradle/api/provider/Provider;", "setPodSource$kotlin_gradle_plugin", "(Lorg/gradle/api/provider/Provider;)V", "podSourceDir", "Ljava/io/File;", "kotlin.jvm.PlatformType", "getPodSourceDir$kotlin_gradle_plugin", "urlDir", "getUrlDir$kotlin_gradle_plugin", "()Ljava/io/File;", "archiveTree", "Lorg/gradle/api/file/FileTree;", "path", "extension", "copyArtifactToUrlDir", "", "artifact", "flatten", "", "createDependency", "Lorg/gradle/api/artifacts/Dependency;", "fileNameWithoutExtension", "download", "setupRepo", "Lorg/gradle/api/artifacts/repositories/ArtifactRepository;", "repoUrl", "kotlin-gradle-plugin"})
public class PodDownloadUrlTask
extends DownloadCocoapodsTask {
    public Provider<CocoapodsExtension.CocoapodsDependency.PodLocation.Url> podSource;
    private final File urlDir;
    private final Provider<File> podSourceDir;
    private final List<String> permittedFileExtensions;

    @Nested
    @NotNull
    public final Provider<CocoapodsExtension.CocoapodsDependency.PodLocation.Url> getPodSource$kotlin_gradle_plugin() {
        Provider<CocoapodsExtension.CocoapodsDependency.PodLocation.Url> provider = this.podSource;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"podSource");
        }
        return provider;
    }

    public final void setPodSource$kotlin_gradle_plugin(@NotNull Provider<CocoapodsExtension.CocoapodsDependency.PodLocation.Url> provider) {
        Intrinsics.checkParameterIsNotNull(provider, (String)"<set-?>");
        this.podSource = provider;
    }

    @Internal
    @NotNull
    public final File getUrlDir$kotlin_gradle_plugin() {
        return this.urlDir;
    }

    @OutputDirectory
    public final Provider<File> getPodSourceDir$kotlin_gradle_plugin() {
        return this.podSourceDir;
    }

    @Internal
    @NotNull
    public final List<String> getPermittedFileExtensions$kotlin_gradle_plugin() {
        return this.permittedFileExtensions;
    }

    @TaskAction
    public final void download() {
        File artifact;
        Configuration configuration2;
        String url;
        Provider<CocoapodsExtension.CocoapodsDependency.PodLocation.Url> provider = this.podSource;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"podSource");
        }
        CocoapodsExtension.CocoapodsDependency.PodLocation.Url podLocation = (CocoapodsExtension.CocoapodsDependency.PodLocation.Url)provider.get();
        String string = url = podLocation.getUrl().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url");
        String repoUrl = StringsKt.substringBeforeLast$default((String)string, (String)"/", null, (int)2, null);
        String fileName = StringsKt.substringAfterLast$default((String)url, (String)"/", null, (int)2, null);
        String fileNameWithoutExtension = StringsKt.substringBefore$default((String)fileName, (String)".", null, (int)2, null);
        String extension = StringsKt.substringAfter$default((String)fileName, (String)".", null, (int)2, null);
        boolean bl = this.permittedFileExtensions.contains(extension);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Unknown file extension";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        ArtifactRepository repo2 = this.setupRepo(repoUrl);
        Dependency dependency = this.createDependency(fileNameWithoutExtension, extension);
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Configuration configuration3 = configuration2 = project.getConfigurations().detachedConfiguration(new Dependency[]{dependency});
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration3, (String)"configuration");
        File file = artifact = configuration3.getSingleFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"artifact");
        this.copyArtifactToUrlDir(file, extension, podLocation.getFlatten());
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        project2.getRepositories().remove((Object)repo2);
    }

    private final ArtifactRepository setupRepo(String repoUrl) {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        IvyArtifactRepository ivyArtifactRepository = project.getRepositories().ivy((Action)new Action<IvyArtifactRepository>(repoUrl){
            final /* synthetic */ String $repoUrl;

            public final void execute(IvyArtifactRepository repo2) {
                repo2.setUrl((Object)this.$repoUrl);
                repo2.patternLayout((Action)setupRepo.1.INSTANCE);
                repo2.metadataSources((Action)setupRepo.2.INSTANCE);
            }
            {
                this.$repoUrl = string;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)ivyArtifactRepository, (String)"project.repositories.ivy\u2026)\n            }\n        }");
        return (ArtifactRepository)ivyArtifactRepository;
    }

    private final Dependency createDependency(String fileNameWithoutExtension, String extension) {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        return project.getDependencies().create((Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"name", (Object)fileNameWithoutExtension), TuplesKt.to((Object)"version", (Object)"1.0"), TuplesKt.to((Object)"ext", (Object)extension)}));
    }

    private final void copyArtifactToUrlDir(File artifact, String extension, boolean flatten) {
        String string = artifact.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"artifact.absolutePath");
        FileTree archiveTree = this.archiveTree(string, extension);
        this.getProject().copy((Action)new Action<CopySpec>(this, archiveTree, extension, flatten){
            final /* synthetic */ PodDownloadUrlTask this$0;
            final /* synthetic */ FileTree $archiveTree;
            final /* synthetic */ String $extension;
            final /* synthetic */ boolean $flatten;

            public final void execute(CopySpec it) {
                File destinationDir2 = (File)this.this$0.getPodSourceDir$kotlin_gradle_plugin().get();
                it.into((Object)destinationDir2);
                it.from(new Object[]{this.$archiveTree});
                if (Intrinsics.areEqual((Object)this.$extension, (Object)"jar")) {
                    it.exclude(new String[]{"META-INF/"});
                }
                if (!this.$flatten) {
                    it.eachFile((Action)copyArtifactToUrlDir.1.INSTANCE);
                    CopySpec copySpec = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)copySpec, (String)"it");
                    copySpec.setIncludeEmptyDirs(false);
                }
            }
            {
                this.this$0 = podDownloadUrlTask;
                this.$archiveTree = fileTree;
                this.$extension = string;
                this.$flatten = bl;
            }
        });
    }

    private final FileTree archiveTree(String path, String extension) {
        FileTree fileTree;
        if (Intrinsics.areEqual((Object)extension, (Object)"zip") || Intrinsics.areEqual((Object)extension, (Object)"jar")) {
            FileTree fileTree2 = this.getProject().zipTree((Object)path);
            fileTree = fileTree2;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileTree2, (String)"project.zipTree(path)");
        } else {
            FileTree fileTree3 = this.getProject().tarTree((Object)path);
            fileTree = fileTree3;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileTree3, (String)"project.tarTree(path)");
        }
        return fileTree;
    }

    public PodDownloadUrlTask() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        this.urlDir = KotlinCocoapodsPluginKt.getCocoapodsBuildDirs(project).externalSources("url");
        this.podSourceDir = this.getProject().provider((Callable)new Callable<File>(this){
            final /* synthetic */ PodDownloadUrlTask this$0;

            @NotNull
            public final File call() {
                File file = this.this$0.getUrlDir$kotlin_gradle_plugin();
                Object object = this.this$0.getPodName$kotlin_gradle_plugin().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"podName.get()");
                return FilesKt.resolve((File)file, (String)((String)object));
            }
            {
                this.this$0 = podDownloadUrlTask;
            }
        });
        this.permittedFileExtensions = CollectionsKt.listOf((Object[])new String[]{"zip", "tar", "tgz", "tbz", "txz", "gzip", "tar.gz", "tar.bz2", "tar.xz", "jar"});
    }
}

