/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.compilerRunner.KotlinLogger;
import org.jetbrains.kotlin.compilerRunner.ReportUtilsKt;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.daemon.client.DaemonReportingTargets;
import org.jetbrains.kotlin.daemon.client.NativePlatformUtilKt;
import org.jetbrains.kotlin.gradle.logging.GradleKotlinLogger;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0000\u001aQ\u0010\r\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\u0010\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\f2\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0015H\u0000\u00a2\u0006\u0002\u0010\u0016\u001a#\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fH\u0002\u00a2\u0006\u0002\u0010\u0019\u001a\u0014\u0010\u001a\u001a\u00020\u001b*\u00020\u00032\u0006\u0010\u001c\u001a\u00020\tH\u0000\u00a8\u0006\u001d"}, d2={"createLoggingMessageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "log", "Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;", "exitCodeFromProcessExitCode", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "code", "", "loadCompilerVersion", "", "compilerClasspath", "", "Ljava/io/File;", "runToolInSeparateProcess", "argsArray", "", "compilerClassName", "classpath", "logger", "buildDir", "jvmArgs", "", "([Ljava/lang/String;Ljava/lang/String;Ljava/lang/Iterable;Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;Ljava/io/File;Ljava/util/List;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "writeArgumentsToFile", "directory", "(Ljava/io/File;[Ljava/lang/String;)Ljava/io/File;", "logFinish", "", "strategy", "kotlin-gradle-plugin"})
public final class ReportUtilsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String loadCompilerVersion(@NotNull Iterable<? extends File> compilerClasspath) {
        String string;
        Intrinsics.checkParameterIsNotNull(compilerClasspath, (String)"compilerClasspath");
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        try {
            String string2 = KotlinCompilerVersion.class.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"KotlinCompilerVersion::class.java.name");
            String versionClassFileName = Intrinsics.stringPlus((String)StringsKt.replace$default((String)string2, (char)'.', (char)'/', (boolean)false, (int)4, null), (Object)".class");
            for (File file : compilerClasspath) {
                Serializable serializable;
                if (file.isFile()) {
                    Object object = FilesKt.getExtension((File)file);
                    boolean bl = false;
                    String string3 = object;
                    if (string3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                    if (Intrinsics.areEqual((Object)string4, (Object)"jar")) {
                        object = new ZipFile(file);
                        bl = false;
                        boolean bl2 = false;
                        serializable = null;
                        try {
                            Object object2;
                            ZipFile jar = (ZipFile)object;
                            boolean bl3 = false;
                            ZipEntry versionFileEntry = jar.getEntry("/META-INF/compiler.version");
                            if (versionFileEntry != null) {
                                Object object3;
                                Closeable closeable = jar.getInputStream(versionFileEntry);
                                Intrinsics.checkExpressionValueIsNotNull((Object)closeable, (String)"jar.getInputStream(versionFileEntry)");
                                Charset charset = Charsets.UTF_8;
                                boolean bl4 = false;
                                object2 = closeable;
                                int n = 0;
                                object2 = new InputStreamReader((InputStream)object2, charset);
                                n = 8192;
                                boolean bl5 = false;
                                closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                                Ref.ObjectRef objectRef = result2;
                                boolean bl6 = false;
                                bl4 = false;
                                Throwable throwable = null;
                                try {
                                    BufferedReader it = (BufferedReader)closeable;
                                    boolean bl7 = false;
                                    object2 = TextStreamsKt.readText((Reader)it);
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                }
                                objectRef.element = object3 = object2;
                            } else {
                                byte[] byArray;
                                Closeable closeable = jar.getInputStream(jar.getEntry(versionClassFileName));
                                boolean bl8 = false;
                                boolean bl9 = false;
                                object2 = null;
                                try {
                                    InputStream it = (InputStream)closeable;
                                    boolean bl10 = false;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                                    byArray = ByteStreamsKt.readBytes((InputStream)it);
                                }
                                catch (Throwable throwable) {
                                    object2 = throwable;
                                    throw throwable;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
                                }
                                byte[] bytes = byArray;
                                ReportUtilsKt.loadCompilerVersion$checkVersion((Ref.ObjectRef<String>)result2, bytes);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable) {
                            serializable = throwable;
                            throw throwable;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object, (Throwable)serializable);
                        }
                    }
                }
                if (file.isDirectory()) {
                    File versionFile = new File(file, "/META-INF/compiler.version");
                    if (versionFile.isFile()) {
                        result2.element = FilesKt.readText$default((File)versionFile, null, (int)1, null);
                    } else {
                        Serializable serializable2;
                        serializable = new File(file, versionClassFileName);
                        boolean bl = false;
                        boolean bl11 = false;
                        File it = serializable;
                        boolean bl12 = false;
                        Serializable serializable3 = serializable2 = it.isFile() ? serializable : null;
                        if (serializable2 != null) {
                            serializable = serializable2;
                            bl = false;
                            bl11 = false;
                            it = serializable;
                            boolean bl13 = false;
                            ReportUtilsKt.loadCompilerVersion$checkVersion((Ref.ObjectRef<String>)result2, FilesKt.readBytes((File)it));
                        }
                    }
                }
                if (result2.element == null) continue;
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return (string = (String)result2.element) == null ? "<unknown>" : string;
    }

    @NotNull
    public static final ExitCode runToolInSeparateProcess(@NotNull String[] argsArray, @NotNull String compilerClassName, @NotNull Iterable<? extends File> classpath2, @NotNull KotlinLogger logger, @NotNull File buildDir2, @NotNull List<String> jvmArgs2) {
        Intrinsics.checkParameterIsNotNull((Object)argsArray, (String)"argsArray");
        Intrinsics.checkParameterIsNotNull((Object)compilerClassName, (String)"compilerClassName");
        Intrinsics.checkParameterIsNotNull(classpath2, (String)"classpath");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)buildDir2, (String)"buildDir");
        Intrinsics.checkParameterIsNotNull(jvmArgs2, (String)"jvmArgs");
        String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        String string = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"pathSeparator");
        String classpathString2 = CollectionsKt.joinToString$default(classpath2, (CharSequence)string, null, null, (int)0, null, (Function1)runToolInSeparateProcess.classpathString.1.INSTANCE, (int)30, null);
        File compilerOptions = ReportUtilsKt.writeArgumentsToFile(buildDir2, argsArray);
        SpreadBuilder spreadBuilder = new SpreadBuilder(6);
        spreadBuilder.add((Object)javaBin);
        Collection $this$toTypedArray$iv = jvmArgs2;
        boolean $i$f$toTypedArray = false;
        Object thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        spreadBuilder.addSpread((Object)stringArray);
        spreadBuilder.add((Object)"-cp");
        spreadBuilder.add((Object)classpathString2);
        spreadBuilder.add((Object)compilerClassName);
        spreadBuilder.add((Object)Intrinsics.stringPlus((String)"@", (Object)compilerOptions.getAbsolutePath()));
        ProcessBuilder builder = new ProcessBuilder((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
        MessageCollector messageCollector = ReportUtilsKt.createLoggingMessageCollector(logger);
        Process process = NativePlatformUtilKt.launchProcessWithFallback$default((ProcessBuilder)builder, (DaemonReportingTargets)new DaemonReportingTargets(null, null, messageCollector, null, 11, null), null, (int)4, null);
        Thread readErrThread2 = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(process, logger){
            final /* synthetic */ Process $process;
            final /* synthetic */ KotlinLogger $logger;
            {
                this.$process = $process;
                this.$logger = $logger;
                super(0);
            }

            public final void invoke() {
                InputStream inputStream = this.$process.getErrorStream();
                if (inputStream == null) {
                    Intrinsics.throwNpe();
                }
                InputStream inputStream2 = inputStream;
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                Closeable closeable = inputStream2;
                int n = 0;
                closeable = new InputStreamReader((InputStream)closeable, charset);
                n = 8192;
                boolean bl2 = false;
                TextStreamsKt.forEachLine((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)), (Function1)((Function1)new Function1<String, Unit>(this.$logger){
                    final /* synthetic */ KotlinLogger $logger;
                    {
                        this.$logger = $logger;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        this.$logger.error(it);
                    }
                }));
            }
        }), (int)31, null);
        if (logger instanceof GradleKotlinLogger) {
            InputStream inputStream = process.getInputStream();
            if (inputStream == null) {
                Intrinsics.throwNpe();
            }
            thisCollection$iv = inputStream;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Object object = thisCollection$iv;
            int n = 0;
            object = new InputStreamReader((InputStream)object, charset);
            n = 8192;
            boolean bl2 = false;
            TextStreamsKt.forEachLine((Reader)(object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n)), (Function1)((Function1)new Function1<String, Unit>(logger){
                final /* synthetic */ KotlinLogger $logger;
                {
                    this.$logger = $logger;
                    super(1);
                }

                public final void invoke(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    ((GradleKotlinLogger)this.$logger).lifecycle(it);
                }
            }));
        } else {
            InputStream inputStream = process.getInputStream();
            if (inputStream == null) {
                Intrinsics.throwNpe();
            }
            thisCollection$iv = inputStream;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Object object = thisCollection$iv;
            int n = 0;
            object = new InputStreamReader((InputStream)object, charset);
            n = 8192;
            boolean bl3 = false;
            TextStreamsKt.forEachLine((Reader)(object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n)), (Function1)runToolInSeparateProcess.2.INSTANCE);
        }
        readErrThread2.join();
        int exitCode = process.waitFor();
        ReportUtilsKt.logFinish(logger, "out-of-process");
        return ReportUtilsKt.exitCodeFromProcessExitCode(logger, exitCode);
    }

    public static /* synthetic */ ExitCode runToolInSeparateProcess$default(String[] stringArray, String string, Iterable iterable, KotlinLogger kotlinLogger2, File file, List list2, int n, Object object) {
        if ((n & 0x20) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return ReportUtilsKt.runToolInSeparateProcess(stringArray, string, iterable, kotlinLogger2, file, list2);
    }

    private static final File writeArgumentsToFile(File directory2, String[] argsArray) {
        String prefix = Intrinsics.stringPlus((String)LocalDateTime.now().format(DateTimeFormatter.BASIC_ISO_DATE), (Object)"_");
        String suffix = ".compiler.options";
        File compilerOptions = directory2.exists() ? Files.createTempFile(directory2.toPath(), prefix, suffix, new FileAttribute[0]).toFile() : Files.createTempFile(prefix, suffix, new FileAttribute[0]).toFile();
        compilerOptions.deleteOnExit();
        Intrinsics.checkExpressionValueIsNotNull((Object)compilerOptions, (String)"compilerOptions");
        FilesKt.writeText$default((File)compilerOptions, (String)ArraysKt.joinToString$default((Object[])argsArray, (CharSequence)" ", null, null, (int)0, null, (Function1)writeArgumentsToFile.1.INSTANCE, (int)30, null), null, (int)2, null);
        return compilerOptions;
    }

    private static final MessageCollector createLoggingMessageCollector(KotlinLogger log) {
        return new MessageCollector(log){
            private boolean hasErrors;
            private final MessageRenderer messageRenderer;
            final /* synthetic */ KotlinLogger $log;
            {
                this.$log = $log;
                this.messageRenderer = MessageRenderer.PLAIN_FULL_PATHS;
            }

            public void clear() {
                this.hasErrors = false;
            }

            public boolean hasErrors() {
                return this.hasErrors;
            }

            public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message2, @Nullable CompilerMessageSourceLocation location) {
                Intrinsics.checkParameterIsNotNull((Object)severity, (String)"severity");
                Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
                String locMessage = this.messageRenderer.render(severity, message2, location);
                CompilerMessageSeverity compilerMessageSeverity = severity;
                int n = createLoggingMessageCollector.WhenMappings.$EnumSwitchMapping$0[compilerMessageSeverity.ordinal()];
                switch (n) {
                    case 1: {
                        Intrinsics.checkExpressionValueIsNotNull((Object)locMessage, (String)"locMessage");
                        this.$log.error(locMessage);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        Intrinsics.checkExpressionValueIsNotNull((Object)locMessage, (String)"locMessage");
                        this.$log.info(locMessage);
                        break;
                    }
                    case 6: {
                        Intrinsics.checkExpressionValueIsNotNull((Object)locMessage, (String)"locMessage");
                        this.$log.debug(locMessage);
                    }
                }
            }
        };
    }

    public static final void logFinish(@NotNull KotlinLogger $this$logFinish, @NotNull String strategy) {
        Intrinsics.checkParameterIsNotNull((Object)$this$logFinish, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)strategy, (String)"strategy");
        $this$logFinish.debug("Finished executing kotlin compiler using " + strategy + " strategy");
    }

    @NotNull
    public static final ExitCode exitCodeFromProcessExitCode(@NotNull KotlinLogger log, int code) {
        ExitCode exitCode;
        block2: {
            ExitCode exitCode2;
            Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
            ExitCode[] exitCodeArray = ExitCode.values();
            boolean bl = false;
            ExitCode[] exitCodeArray2 = exitCodeArray;
            boolean bl2 = false;
            ExitCode[] exitCodeArray3 = exitCodeArray2;
            int n = exitCodeArray3.length;
            for (int j = 0; j < n; ++j) {
                ExitCode exitCode3;
                ExitCode it = exitCode3 = exitCodeArray3[j];
                boolean bl3 = false;
                if (!(it.getCode() == code)) continue;
                exitCode2 = exitCode3;
                break block2;
            }
            exitCode2 = exitCode = null;
        }
        if (exitCode != null) {
            return exitCode;
        }
        log.debug(Intrinsics.stringPlus((String)"Could not find exit code by value: ", (Object)code));
        return code == 0 ? ExitCode.OK : ExitCode.COMPILATION_ERROR;
    }

    private static final void loadCompilerVersion$checkVersion(Ref.ObjectRef<String> result2, byte[] bytes) {
        new ClassReader(bytes).accept(new ClassVisitor(result2){
            final /* synthetic */ Ref.ObjectRef<String> $result;
            {
                this.$result = $result;
                super(524288);
            }

            @NotNull
            public FieldVisitor visitField(int access, @NotNull String name2, @NotNull String desc, @Nullable String signature, @Nullable Object value) {
                Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
                Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
                if (Intrinsics.areEqual((Object)name2, (Object)"VERSION") && value instanceof String) {
                    this.$result.element = value;
                }
                FieldVisitor fieldVisitor = super.visitField(access, name2, desc, signature, value);
                Intrinsics.checkExpressionValueIsNotNull((Object)fieldVisitor, (String)"super.visitField(access,\u2026, desc, signature, value)");
                return fieldVisitor;
            }
        }, 7);
    }
}

