/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.kapt.incremental;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.internal.kapt.incremental.ClassAbiExtractor;
import org.jetbrains.kotlin.gradle.internal.kapt.incremental.ClassDependencies;
import org.jetbrains.kotlin.gradle.internal.kapt.incremental.ClassTypeExtractorVisitor;
import org.jetbrains.kotlin.gradle.internal.kapt.incremental.ClasspathEntryData;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassWriter;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"CLASS_STRUCTURE_ARTIFACT_TYPE", "", "MODULE_INFO", "analyzeInputStream", "", "input", "Ljava/io/InputStream;", "internalName", "entryData", "Lorg/jetbrains/kotlin/gradle/internal/kapt/incremental/ClasspathEntryData;", "transform", "Ljava/io/File;", "outputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "visitDirectory", "directory", "visitJar", "jar", "kotlin-gradle-plugin"})
public final class ClasspathAnalyzerKt {
    @NotNull
    public static final String CLASS_STRUCTURE_ARTIFACT_TYPE = "class-structure";
    @NotNull
    private static final String MODULE_INFO = "module-info.class";

    private static final void transform(File input, TransformOutputs outputs) {
        ClasspathEntryData data = input.isDirectory() ? ClasspathAnalyzerKt.visitDirectory(input) : ClasspathAnalyzerKt.visitJar(input);
        File dataFile = outputs.file((Object)"output.bin");
        Intrinsics.checkExpressionValueIsNotNull((Object)dataFile, (String)"dataFile");
        data.saveTo(dataFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ClasspathEntryData visitDirectory(File directory2) {
        ClasspathEntryData entryData = new ClasspathEntryData();
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)directory2, null, (int)1, null)), (Function1)((Function1)new Function1<File, Boolean>(directory2){
            final /* synthetic */ File $directory;
            {
                this.$directory = $directory;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull File it) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"class")) {
                    String string = FilesKt.relativeTo((File)it, (File)this.$directory).toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.relativeTo(directory).toString()");
                    boolean bl2 = false;
                    String string2 = string.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
                    if (!StringsKt.startsWith$default((String)string2, (String)"meta-inf", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)it.getName(), (Object)"module-info.class")) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            String internalName = StringsKt.dropLast((String)FilesKt.getInvariantSeparatorsPath((File)FilesKt.relativeTo((File)it, (File)directory2)), (int)".class".length());
            Object object = it;
            boolean bl2 = false;
            object = new BufferedInputStream(new FileInputStream((File)object));
            bl2 = false;
            boolean bl3 = false;
            Throwable throwable = null;
            try {
                BufferedInputStream inputStream = (BufferedInputStream)object;
                boolean bl4 = false;
                ClasspathAnalyzerKt.analyzeInputStream(inputStream, internalName, entryData);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        return entryData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ClasspathEntryData visitJar(File jar) {
        ClasspathEntryData entryData = new ClasspathEntryData();
        Closeable closeable = new ZipFile(jar);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ZipFile zipFile = (ZipFile)closeable;
            boolean bl3 = false;
            Enumeration<? extends ZipEntry> entries2 = zipFile.entries();
            while (entries2.hasMoreElements()) {
                ZipEntry entry = entries2.nextElement();
                Object object = entry.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"entry.name");
                if (!StringsKt.endsWith$default((String)object, (String)"class", (boolean)false, (int)2, null)) continue;
                object = entry.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"entry.name");
                boolean bl4 = false;
                String string = ((String)object).toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase()");
                if (StringsKt.startsWith$default((String)string, (String)"meta-inf", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)entry.getName(), (Object)MODULE_INFO)) continue;
                object = new BufferedInputStream(zipFile.getInputStream(entry));
                bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    BufferedInputStream inputStream = (BufferedInputStream)object;
                    boolean bl6 = false;
                    InputStream inputStream2 = inputStream;
                    String string2 = entry.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"entry.name");
                    ClasspathAnalyzerKt.analyzeInputStream(inputStream2, StringsKt.dropLast((String)string2, (int)".class".length()), entryData);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return entryData;
    }

    private static final void analyzeInputStream(InputStream input, String internalName, ClasspathEntryData entryData) {
        ClassAbiExtractor abiExtractor = new ClassAbiExtractor(new ClassWriter(0));
        ClassTypeExtractorVisitor typeDependenciesExtractor = new ClassTypeExtractorVisitor(abiExtractor);
        new ClassReader(ByteStreamsKt.readBytes((InputStream)input)).accept(typeDependenciesExtractor, 7);
        byte[] bytes = abiExtractor.getBytes();
        byte[] digest = MessageDigest.getInstance("MD5").digest(bytes);
        Map<String, Object> map = entryData.getClassAbiHash();
        Intrinsics.checkExpressionValueIsNotNull((Object)digest, (String)"digest");
        Object object = digest;
        boolean bl = false;
        map.put(internalName, object);
        map = entryData.getClassDependencies();
        object = new ClassDependencies((Collection<String>)typeDependenciesExtractor.getAbiTypes(), (Collection<String>)typeDependenciesExtractor.getPrivateTypes());
        bl = false;
        map.put(internalName, object);
    }

    public static final /* synthetic */ void access$transform(File input, TransformOutputs outputs) {
        ClasspathAnalyzerKt.transform(input, outputs);
    }
}

