/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.dsl.KotlinTopLevelExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.ExtractableMetadataFiles;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinProjectStructureMetadata;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinProjectStructureMetadataKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.MppDependencyMetadataExtractor;
import org.jetbrains.kotlin.gradle.plugin.mpp.pm20.KotlinGradleFragment;
import org.jetbrains.kotlin.gradle.plugin.mpp.pm20.KotlinGradleModule;
import org.jetbrains.kotlin.gradle.plugin.mpp.pm20.KotlinPm20ProjectExtension;
import org.jetbrains.kotlin.gradle.plugin.mpp.pm20.MetadataCompilationRegistry;
import org.jetbrains.kotlin.project.model.KotlinModuleIdentifier;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/ProjectMppDependencyMetadataExtractor;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/MppDependencyMetadataExtractor;", "project", "Lorg/gradle/api/Project;", "dependency", "Lorg/gradle/api/artifacts/result/ResolvedComponentResult;", "moduleIdentifier", "Lorg/jetbrains/kotlin/project/model/KotlinModuleIdentifier;", "dependencyProject", "(Lorg/gradle/api/Project;Lorg/gradle/api/artifacts/result/ResolvedComponentResult;Lorg/jetbrains/kotlin/project/model/KotlinModuleIdentifier;Lorg/gradle/api/Project;)V", "getDependencyProject", "()Lorg/gradle/api/Project;", "getModuleIdentifier", "()Lorg/jetbrains/kotlin/project/model/KotlinModuleIdentifier;", "getExtractableMetadataFiles", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/ExtractableMetadataFiles;", "visibleSourceSetNames", "", "", "baseDir", "Ljava/io/File;", "getProjectStructureMetadata", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinProjectStructureMetadata;", "kotlin-gradle-plugin"})
final class ProjectMppDependencyMetadataExtractor
extends MppDependencyMetadataExtractor {
    @NotNull
    private final KotlinModuleIdentifier moduleIdentifier;
    @NotNull
    private final Project dependencyProject;

    public ProjectMppDependencyMetadataExtractor(@NotNull Project project, @NotNull ResolvedComponentResult dependency2, @NotNull KotlinModuleIdentifier moduleIdentifier, @NotNull Project dependencyProject) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dependency2, (String)"dependency");
        Intrinsics.checkNotNullParameter((Object)moduleIdentifier, (String)"moduleIdentifier");
        Intrinsics.checkNotNullParameter((Object)dependencyProject, (String)"dependencyProject");
        super(project, dependency2);
        this.moduleIdentifier = moduleIdentifier;
        this.dependencyProject = dependencyProject;
    }

    @NotNull
    public final KotlinModuleIdentifier getModuleIdentifier() {
        return this.moduleIdentifier;
    }

    @NotNull
    public final Project getDependencyProject() {
        return this.dependencyProject;
    }

    @Override
    @Nullable
    public KotlinProjectStructureMetadata getProjectStructureMetadata() {
        KotlinProjectStructureMetadata kotlinProjectStructureMetadata;
        KotlinTopLevelExtension topLevelExtension = KotlinProjectExtensionKt.getTopLevelExtension(this.dependencyProject);
        if (topLevelExtension instanceof KotlinPm20ProjectExtension) {
            Iterable $this$single$iv = (Iterable)((KotlinPm20ProjectExtension)topLevelExtension).getModules();
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                KotlinGradleModule it = (KotlinGradleModule)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getModuleIdentifier(), (Object)this.getModuleIdentifier())) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Object var2_10 = single$iv;
            Intrinsics.checkNotNullExpressionValue(var2_10, (String)"topLevelExtension.module\u2026ier == moduleIdentifier }");
            kotlinProjectStructureMetadata = KotlinProjectStructureMetadataKt.buildProjectStructureMetadata(var2_10);
        } else {
            kotlinProjectStructureMetadata = KotlinProjectStructureMetadataKt.buildKotlinProjectStructureMetadata(this.dependencyProject);
        }
        return kotlinProjectStructureMetadata;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ExtractableMetadataFiles getExtractableMetadataFiles(@NotNull Set<String> visibleSourceSetNames, @NotNull File baseDir) {
        Map map;
        Intrinsics.checkNotNullParameter(visibleSourceSetNames, (String)"visibleSourceSetNames");
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        KotlinTopLevelExtension projectExtension = KotlinProjectExtensionKt.getTopLevelExtension(this.dependencyProject);
        if (projectExtension instanceof KotlinMultiplatformExtension) {
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable iterable = (Iterable)((KotlinTarget)((KotlinMultiplatformExtension)projectExtension).getTargets().getByName("metadata")).getCompilations();
            boolean $i$f$filter = false;
            void var7_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Iterator element$iv$iv : $this$filterTo$iv$iv) {
                KotlinCompilation it = (KotlinCompilation)element$iv$iv;
                boolean bl = false;
                if (!visibleSourceSetNames.contains(it.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map bl = destination$iv$iv2;
                KotlinCompilation it = (KotlinCompilation)element$iv$iv;
                boolean bl2 = false;
                it = TuplesKt.to((Object)it.getDefaultSourceSet().getName(), (Object)it.getOutput().getClassesDirs());
                bl2 = false;
                bl.put(it.getFirst(), it.getSecond());
            }
            map = destination$iv$iv2;
        } else if (projectExtension instanceof KotlinPm20ProjectExtension) {
            KotlinModuleIdentifier moduleId = this.moduleIdentifier;
            Iterable $this$single$iv = (Iterable)((KotlinPm20ProjectExtension)projectExtension).getModules();
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                KotlinGradleModule it = (KotlinGradleModule)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getModuleIdentifier(), (Object)moduleId)) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            KotlinGradleModule module2 = single$iv;
            MetadataCompilationRegistry metadataCompilationRegistry = (MetadataCompilationRegistry)MapsKt.getValue(((KotlinPm20ProjectExtension)projectExtension).getMetadataCompilationRegistryByModuleId$kotlin_gradle_plugin(), (Object)moduleId);
            Iterable $this$associateWith$iv = visibleSourceSetNames;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                String bl2 = (String)element$iv$iv;
                Object t = element$iv$iv;
                Map map2 = result$iv;
                boolean bl = false;
                Object object = module2.getFragments().getByName((String)it);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"module.fragments.getByName(it)");
                ConfigurableFileCollection configurableFileCollection = metadataCompilationRegistry.byFragment((KotlinGradleFragment)object).getOutput().getClassesDirs();
                map2.put(t, configurableFileCollection);
            }
            map = result$iv;
        } else {
            throw (Throwable)new IllegalStateException(Intrinsics.stringPlus((String)"unexpected top-level Kotlin extension ", (Object)projectExtension).toString());
        }
        Map result2 = map;
        return new ExtractableMetadataFiles(result2){
            final /* synthetic */ Map<String, ConfigurableFileCollection> $result;
            {
                this.$result = $result;
            }

            @NotNull
            public Map<String, FileCollection> getMetadataFilesPerSourceSet(boolean doProcessFiles) {
                return this.$result;
            }
        };
    }
}

