/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.performance;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.mpp.NativeBinary;
import org.jetbrains.kotlin.gradle.plugin.performance.TrackableMetric;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u00072\b\b\u0002\u0010 \u001a\u00020\bH\u0007R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u0011\u0010\u001b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/performance/PerformanceExtension;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "binaryNamesForReport", "", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/NativeBinary;", "", "getBinaryNamesForReport", "()Ljava/util/Map;", "includeAssociatedTasks", "", "getIncludeAssociatedTasks", "()Z", "setIncludeAssociatedTasks", "(Z)V", "metrics", "", "Lorg/jetbrains/kotlin/gradle/plugin/performance/TrackableMetric;", "getMetrics", "()Ljava/util/List;", "setMetrics", "(Ljava/util/List;)V", "trackedBinaries", "", "getTrackedBinaries", "version", "getVersion", "()Ljava/lang/String;", "binary", "", "nameForReport", "kotlin-gradle-plugin"})
public class PerformanceExtension {
    @NotNull
    private final Project project;
    @NotNull
    private List<? extends TrackableMetric> metrics;
    @NotNull
    private final List<NativeBinary> trackedBinaries;
    @NotNull
    private final Map<NativeBinary, String> binaryNamesForReport;
    private boolean includeAssociatedTasks;

    public PerformanceExtension(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        TrackableMetric[] trackableMetricArray = new TrackableMetric[]{TrackableMetric.COMPILE_TIME, TrackableMetric.CODE_SIZE};
        this.metrics = CollectionsKt.listOf((Object[])trackableMetricArray);
        this.trackedBinaries = new ArrayList();
        this.binaryNamesForReport = new LinkedHashMap();
        this.includeAssociatedTasks = true;
    }

    @NotNull
    public final String getVersion() {
        return this.project.getVersion().toString();
    }

    @NotNull
    public final List<TrackableMetric> getMetrics() {
        return this.metrics;
    }

    public final void setMetrics(@NotNull List<? extends TrackableMetric> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.metrics = list2;
    }

    @NotNull
    public final List<NativeBinary> getTrackedBinaries() {
        return this.trackedBinaries;
    }

    @NotNull
    public final Map<NativeBinary, String> getBinaryNamesForReport() {
        return this.binaryNamesForReport;
    }

    public final boolean getIncludeAssociatedTasks() {
        return this.includeAssociatedTasks;
    }

    public final void setIncludeAssociatedTasks(boolean bl) {
        this.includeAssociatedTasks = bl;
    }

    @JvmOverloads
    public final void binary(@NotNull NativeBinary binary, @NotNull String nameForReport) {
        Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
        Intrinsics.checkNotNullParameter((Object)nameForReport, (String)"nameForReport");
        this.trackedBinaries.add(binary);
        this.binaryNamesForReport.put(binary, nameForReport);
    }

    public static /* synthetic */ void binary$default(PerformanceExtension performanceExtension, NativeBinary nativeBinary, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: binary");
        }
        if ((n & 2) != 0) {
            string = nativeBinary.getName();
        }
        performanceExtension.binary(nativeBinary, string);
    }

    @JvmOverloads
    public final void binary(@NotNull NativeBinary binary) {
        Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
        PerformanceExtension.binary$default(this, binary, null, 2, null);
    }
}

