/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.compilerRunner.KotlinNativeCInteropRunner;
import org.jetbrains.kotlin.compilerRunner.NativeToolRunnersKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.DefaultCInteropSettings;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeTargetPresetKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.pm20.KotlinCompilationData;
import org.jetbrains.kotlin.gradle.plugin.mpp.pm20.KotlinCompilationDataKt;
import org.jetbrains.kotlin.gradle.targets.native.tasks.CInteropRunnerExecutionContextFactoryKt;
import org.jetbrains.kotlin.gradle.tasks.KotlinNativeTasksKt;
import org.jetbrains.kotlin.gradle.utils.ConfigurationCacheKt;
import org.jetbrains.kotlin.gradle.utils.KlibUtilsKt;
import org.jetbrains.kotlin.konan.target.CompilerOutputKind;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010;\u001a\u00020<H\u0007R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068G\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f8G\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00078G\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00168\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f8G\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0011R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068G\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\tR\u0011\u0010\u001f\u001a\u00020 8G\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b$\u0010\rR\u0011\u0010%\u001a\u00020&8G\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b*\u0010\rR\u0011\u0010+\u001a\u00020 8G\u00a2\u0006\u0006\u001a\u0004\b,\u0010\"R\u0017\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f8G\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0011R\u0011\u0010/\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b0\u0010\rR\u0011\u00101\u001a\u00020\u00078G\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0014R\u0011\u00103\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b4\u0010\rR\u001c\u00105\u001a\b\u0012\u0004\u0012\u00020\u00070\u00168\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u0018R\u0013\u00107\u001a\u0004\u0018\u00010\u000b8G\u00a2\u0006\u0006\u001a\u0004\b8\u0010\rR\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/CInteropProcess;", "Lorg/gradle/api/DefaultTask;", "settings", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/DefaultCInteropSettings;", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/DefaultCInteropSettings;)V", "allHeadersDirs", "", "Ljava/io/File;", "getAllHeadersDirs", "()Ljava/util/Set;", "baseKlibName", "", "getBaseKlibName", "()Ljava/lang/String;", "compilerOpts", "", "getCompilerOpts", "()Ljava/util/List;", "defFile", "getDefFile", "()Ljava/io/File;", "destinationDir", "Lorg/gradle/api/provider/Provider;", "getDestinationDir", "()Lorg/gradle/api/provider/Provider;", "setDestinationDir", "(Lorg/gradle/api/provider/Provider;)V", "extraOpts", "getExtraOpts", "headerFilterDirs", "getHeaderFilterDirs", "headers", "Lorg/gradle/api/file/FileCollection;", "getHeaders", "()Lorg/gradle/api/file/FileCollection;", "interopName", "getInteropName", "konanTarget", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "getKonanTarget", "()Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "kotlinNativeVersion", "getKotlinNativeVersion", "libraries", "getLibraries", "linkerOpts", "getLinkerOpts", "moduleName", "getModuleName", "outputFile", "getOutputFile", "outputFileName", "getOutputFileName", "outputFileProvider", "getOutputFileProvider", "packageName", "getPackageName", "getSettings", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/DefaultCInteropSettings;", "processInterop", "", "kotlin-gradle-plugin"})
public class CInteropProcess
extends DefaultTask {
    @NotNull
    private final DefaultCInteropSettings settings;
    @Internal
    public Provider<File> destinationDir;
    @OutputFile
    @NotNull
    private final Provider<File> outputFileProvider;

    @Inject
    public CInteropProcess(@NotNull DefaultCInteropSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
        this.getOutputs().upToDateWhen(new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                return this.getOutputFile().exists();
            }
        });
        ConfigurationCacheKt.notCompatibleWithConfigurationCache((Task)this, "Task " + this.getName() + " does not support Gradle Configuration Cache. Check KT-43293 for more info");
        Provider provider = this.getProject().provider(new Callable(this){
            final /* synthetic */ CInteropProcess this$0;
            {
                this.this$0 = $receiver;
            }

            public final File call() {
                Object object = this.this$0.getDestinationDir().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"destinationDir.get()");
                return FilesKt.resolve((File)((File)object), (String)this.this$0.getOutputFileName());
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project.provider { desti\u2026resolve(outputFileName) }");
        this.outputFileProvider = provider;
    }

    @Internal
    @NotNull
    public final DefaultCInteropSettings getSettings() {
        return this.settings;
    }

    @NotNull
    public final Provider<File> getDestinationDir() {
        Provider<File> provider = this.destinationDir;
        if (provider != null) {
            return provider;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"destinationDir");
        return null;
    }

    public final void setDestinationDir(@NotNull Provider<File> provider) {
        Intrinsics.checkNotNullParameter(provider, (String)"<set-?>");
        this.destinationDir = provider;
    }

    @Input
    @NotNull
    public final KonanTarget getKonanTarget() {
        return this.settings.getCompilation().getKonanTarget();
    }

    @Input
    @NotNull
    public final String getInteropName() {
        return this.settings.getName();
    }

    @Input
    @NotNull
    public final String getBaseKlibName() {
        KotlinCompilationData kotlinCompilationData;
        KotlinCompilationData it = kotlinCompilationData = this.settings.getCompilation();
        boolean bl = false;
        String compilationPrefix = KotlinCompilationDataKt.isMainCompilationData(it) ? this.getProject().getName() : it.getCompilationPurpose();
        return compilationPrefix + "-cinterop-" + this.getInteropName();
    }

    @Internal
    @NotNull
    public final String getOutputFileName() {
        CompilerOutputKind compilerOutputKind;
        CompilerOutputKind $this$_get_outputFileName__u24lambda_u2d1 = compilerOutputKind = CompilerOutputKind.LIBRARY;
        boolean bl = false;
        return this.getBaseKlibName() + $this$_get_outputFileName__u24lambda_u2d1.suffix(this.getKonanTarget());
    }

    @Input
    @NotNull
    public final String getModuleName() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return KlibUtilsKt.klibModuleName(project, this.getBaseKlibName());
    }

    @Internal
    @NotNull
    public final File getOutputFile() {
        Object object = this.outputFileProvider.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"outputFileProvider.get()");
        return (File)object;
    }

    @NotNull
    public final Provider<File> getOutputFileProvider() {
        return this.outputFileProvider;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final File getDefFile() {
        Object object = this.settings.getDefFileProperty().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"settings.defFileProperty.get()");
        return (File)object;
    }

    @Optional
    @Input
    @Nullable
    public final String getPackageName() {
        return this.settings.getPackageName();
    }

    @Input
    @NotNull
    public final List<String> getCompilerOpts() {
        return this.settings.getCompilerOpts();
    }

    @Input
    @NotNull
    public final List<String> getLinkerOpts() {
        return this.settings.getLinkerOpts();
    }

    @IgnoreEmptyDirectories
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final FileCollection getHeaders() {
        return this.settings.getHeaders();
    }

    @Input
    @NotNull
    public final Set<File> getAllHeadersDirs() {
        Set set2 = this.settings.getIncludeDirs().getAllHeadersDirs().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"settings.includeDirs.allHeadersDirs.files");
        return set2;
    }

    @Input
    @NotNull
    public final Set<File> getHeaderFilterDirs() {
        Set set2 = this.settings.getIncludeDirs().getHeaderFilterDirs().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"settings.includeDirs.headerFilterDirs.files");
        return set2;
    }

    @IgnoreEmptyDirectories
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final FileCollection getLibraries() {
        FileCollection fileCollection = this.settings.getDependencyFiles();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return KotlinNativeTasksKt.access$filterOutPublishableInteropLibs(fileCollection, project);
    }

    @Input
    @NotNull
    public final List<String> getExtraOpts() {
        return this.settings.getExtraOpts();
    }

    @Input
    @NotNull
    public final String getKotlinNativeVersion() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return NativeToolRunnersKt.getKonanVersion(project).toString();
    }

    @TaskAction
    public final void processInterop() {
        File it;
        Collection<String> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        String it2;
        List list2;
        List $this$processInterop_u24lambda_u2d7 = list2 = (List)new ArrayList();
        boolean bl = false;
        String string = this.getOutputFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"outputFile.absolutePath");
        KotlinNativeTasksKt.addArg($this$processInterop_u24lambda_u2d7, "-o", string);
        KotlinNativeTasksKt.addArgIfNotNull($this$processInterop_u24lambda_u2d7, "-target", this.getKonanTarget().getVisibleName());
        KotlinNativeTasksKt.addArgIfNotNull($this$processInterop_u24lambda_u2d7, "-def", this.getDefFile().getCanonicalPath());
        KotlinNativeTasksKt.addArgIfNotNull($this$processInterop_u24lambda_u2d7, "-pkg", this.getPackageName());
        KotlinNativeTasksKt.addFileArgs((List<String>)$this$processInterop_u24lambda_u2d7, "-header", this.getHeaders());
        Iterable $this$forEach$iv = this.getCompilerOpts();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (String)element$iv;
            boolean bl2 = false;
            KotlinNativeTasksKt.addArg($this$processInterop_u24lambda_u2d7, "-compiler-option", it2);
        }
        $this$forEach$iv = this.getLinkerOpts();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (String)element$iv;
            boolean bl3 = false;
            KotlinNativeTasksKt.addArg($this$processInterop_u24lambda_u2d7, "-linker-option", it2);
        }
        Set set2 = this.getLibraries().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"libraries.files");
        $this$forEach$iv = KotlinNativeTasksKt.access$filterKlibsPassedToCompiler(set2);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File library2 = (File)element$iv;
            boolean bl4 = false;
            String string2 = library2.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"library.absolutePath");
            KotlinNativeTasksKt.addArg($this$processInterop_u24lambda_u2d7, "-library", string2);
        }
        $this$forEach$iv = this.getAllHeadersDirs();
        String string3 = "-compiler-option";
        List list3 = $this$processInterop_u24lambda_u2d7;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl5 = false;
            collection.add("-I" + it.getAbsolutePath());
        }
        collection = (List)destination$iv$iv;
        KotlinNativeTasksKt.addArgs(list3, string3, (Iterable<String>)collection);
        $this$map$iv = this.getHeaderFilterDirs();
        string3 = "-headerFilterAdditionalSearchPrefix";
        list3 = $this$processInterop_u24lambda_u2d7;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl6 = false;
            collection.add(it.getAbsolutePath());
        }
        collection = (List)destination$iv$iv;
        KotlinNativeTasksKt.addArgs(list3, string3, (Iterable<String>)collection);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        if (KotlinNativeTargetPresetKt.isAtLeast(NativeToolRunnersKt.getKonanVersion(project), 1, 4, 0)) {
            KotlinNativeTasksKt.addArg($this$processInterop_u24lambda_u2d7, "-Xmodule-name", this.getModuleName());
        }
        $this$processInterop_u24lambda_u2d7.addAll((Collection)this.getExtraOpts());
        List args = list2;
        this.getOutputFile().getParentFile().mkdirs();
        KotlinNativeCInteropRunner.Companion.run(CInteropRunnerExecutionContextFactoryKt.createExecutionContext(KotlinNativeCInteropRunner.Companion, (Task)this), args);
    }
}

