/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.mpp.GlobalProjectStructureMetadataStorage;
import org.jetbrains.kotlin.gradle.plugin.mpp.JarMppDependencyProjectStructureMetadataExtractor;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinProjectStructureMetadata;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/IncludedBuildMppDependencyProjectStructureMetadataExtractor;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/JarMppDependencyProjectStructureMetadataExtractor;", "project", "Lorg/gradle/api/Project;", "dependency", "Lorg/gradle/api/artifacts/result/ResolvedComponentResult;", "primaryArtifact", "Ljava/io/File;", "(Lorg/gradle/api/Project;Lorg/gradle/api/artifacts/result/ResolvedComponentResult;Ljava/io/File;)V", "id", "Lorg/gradle/api/artifacts/component/ProjectComponentIdentifier;", "getProjectStructureMetadata", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinProjectStructureMetadata;", "kotlin-gradle-plugin_common"})
public final class IncludedBuildMppDependencyProjectStructureMetadataExtractor
extends JarMppDependencyProjectStructureMetadataExtractor {
    @NotNull
    private final Project project;
    @NotNull
    private final ProjectComponentIdentifier id;

    public IncludedBuildMppDependencyProjectStructureMetadataExtractor(@NotNull Project project, @NotNull ResolvedComponentResult dependency2, @NotNull File primaryArtifact) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dependency2, (String)"dependency");
        Intrinsics.checkNotNullParameter((Object)primaryArtifact, (String)"primaryArtifact");
        super(primaryArtifact);
        this.project = project;
        ComponentIdentifier id = dependency2.getId();
        boolean bl = id instanceof ProjectComponentIdentifier;
        if (!bl) {
            boolean $i$a$-require-IncludedBuildMppDependencyProjectStructureMetadataExtractor$32 = false;
            String $i$a$-require-IncludedBuildMppDependencyProjectStructureMetadataExtractor$32 = "dependency should resolve to a project";
            throw (Throwable)new IllegalArgumentException($i$a$-require-IncludedBuildMppDependencyProjectStructureMetadataExtractor$32.toString());
        }
        boolean bl2 = bl = !((ProjectComponentIdentifier)id).getBuild().isCurrentBuild();
        if (!bl) {
            boolean bl3 = false;
            String string = "should be a project from an included build";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
        this.id = (ProjectComponentIdentifier)id;
    }

    @Override
    @Nullable
    public KotlinProjectStructureMetadata getProjectStructureMetadata() {
        String string = this.id.getBuild().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id.build.name");
        String string2 = this.id.getProjectPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"id.projectPath");
        return GlobalProjectStructureMetadataStorage.INSTANCE.getProjectStructureMetadata(this.project, string, string2);
    }
}

