/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp.apple;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.mpp.Framework;
import org.jetbrains.kotlin.gradle.plugin.mpp.NativeBuildType;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.AppleTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.XCFrameworkTask;
import org.jetbrains.kotlin.gradle.tasks.FrameworkDescriptor;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\b&\u0018\u0000 32\u00020\u0001:\u00013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010%\u001a\u00020&H\u0007J&\u0010'\u001a\u00020&2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00180)2\u0006\u0010*\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001f\u0010+\u001a\u00020&2\u0012\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020.0-\"\u00020.\u00a2\u0006\u0002\u0010/J\u001f\u00100\u001a\u00020&2\u0012\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180-\"\u00020\u0018\u00a2\u0006\u0002\u00101J\u0014\u00100\u001a\u00020&2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001802R$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118EX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a8G\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u00020\u00118GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0013\"\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u00118EX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0013R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0007\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/XCFrameworkTask;", "Lorg/gradle/api/DefaultTask;", "()V", "baseName", "Lorg/gradle/api/provider/Provider;", "", "getBaseName", "()Lorg/gradle/api/provider/Provider;", "setBaseName", "(Lorg/gradle/api/provider/Provider;)V", "buildType", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/NativeBuildType;", "getBuildType", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/NativeBuildType;", "setBuildType", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/NativeBuildType;)V", "fatFrameworksDir", "Ljava/io/File;", "getFatFrameworksDir", "()Ljava/io/File;", "groupedFrameworkFiles", "", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/AppleTarget;", "", "Lorg/jetbrains/kotlin/gradle/tasks/FrameworkDescriptor;", "inputFrameworkFiles", "", "getInputFrameworkFiles", "()Ljava/util/Collection;", "outputDir", "getOutputDir", "setOutputDir", "(Ljava/io/File;)V", "outputXCFrameworkFile", "getOutputXCFrameworkFile", "xcFrameworkName", "getXcFrameworkName$kotlin_gradle_plugin_common", "assemble", "", "createXCFramework", "frameworkFiles", "", "output", "from", "frameworks", "", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/Framework;", "([Lorg/jetbrains/kotlin/gradle/plugin/mpp/Framework;)V", "fromFrameworkDescriptors", "([Lorg/jetbrains/kotlin/gradle/tasks/FrameworkDescriptor;)V", "", "Companion", "kotlin-gradle-plugin_common"})
public abstract class XCFrameworkTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Input
    @NotNull
    private Provider<String> baseName;
    @Input
    @NotNull
    private NativeBuildType buildType;
    @NotNull
    private final Map<AppleTarget, List<FrameworkDescriptor>> groupedFrameworkFiles;
    @NotNull
    private File outputDir;

    public XCFrameworkTask() {
        this.onlyIf(1.INSTANCE);
        Provider provider = this.getProject().provider(new Callable(this){
            final /* synthetic */ XCFrameworkTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final String call() {
                return this.this$0.getProject().getName();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project.provider { project.name }");
        this.baseName = provider;
        this.buildType = NativeBuildType.RELEASE;
        this.groupedFrameworkFiles = new LinkedHashMap();
        File file = this.getProject().getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
        this.outputDir = FilesKt.resolve((File)file, (String)"XCFrameworks");
    }

    @NotNull
    public final Provider<String> getBaseName() {
        return this.baseName;
    }

    public final void setBaseName(@NotNull Provider<String> provider) {
        Intrinsics.checkNotNullParameter(provider, (String)"<set-?>");
        this.baseName = provider;
    }

    @Internal
    @NotNull
    public final Provider<String> getXcFrameworkName$kotlin_gradle_plugin_common() {
        Provider provider = this.baseName.map((Transformer)xcFrameworkName.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"baseName.map { it.asValidFrameworkName() }");
        return provider;
    }

    @NotNull
    public final NativeBuildType getBuildType() {
        return this.buildType;
    }

    public final void setBuildType(@NotNull NativeBuildType nativeBuildType) {
        Intrinsics.checkNotNullParameter((Object)((Object)nativeBuildType), (String)"<set-?>");
        this.buildType = nativeBuildType;
    }

    /*
     * WARNING - void declaration
     */
    @IgnoreEmptyDirectories
    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @SkipWhenEmpty
    @NotNull
    public final Collection<File> getInputFrameworkFiles() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.flatten((Iterable)this.groupedFrameworkFiles.values());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FrameworkDescriptor frameworkDescriptor = (FrameworkDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFile());
        }
        return (List)destination$iv$iv;
    }

    @Internal
    @NotNull
    public final File getOutputDir() {
        return this.outputDir;
    }

    public final void setOutputDir(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.outputDir = file;
    }

    @Internal
    @NotNull
    protected final File getFatFrameworksDir() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Object object = this.getXcFrameworkName$kotlin_gradle_plugin_common().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"xcFrameworkName.get()");
        return org.jetbrains.kotlin.gradle.plugin.mpp.apple.XCFrameworkTask$Companion.fatFrameworkDir$default(Companion, project, (String)object, this.buildType, null, 8, null);
    }

    @OutputDirectory
    @NotNull
    protected final File getOutputXCFrameworkFile() {
        return FilesKt.resolve((File)FilesKt.resolve((File)this.outputDir, (String)this.buildType.getName()), (String)((String)this.getXcFrameworkName$kotlin_gradle_plugin_common().get() + ".xcframework"));
    }

    /*
     * WARNING - void declaration
     */
    public final void from(Framework ... frameworks) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)frameworks, (String)"frameworks");
        Framework[] $this$forEach$iv = frameworks;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            Framework element$iv;
            Framework framework2 = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            if (!framework2.getKonanTarget$kotlin_gradle_plugin_common().getFamily().isAppleFamily()) {
                boolean $i$a$-require-XCFrameworkTask$from$1$22 = false;
                String $i$a$-require-XCFrameworkTask$from$1$22 = "XCFramework supports Apple frameworks only";
                throw new IllegalArgumentException($i$a$-require-XCFrameworkTask$from$1$22.toString());
            }
            objectArray = new Object[]{framework2.getLinkTask()};
            this.dependsOn(objectArray);
        }
        $this$forEach$iv = frameworks;
        XCFrameworkTask xCFrameworkTask = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            objectArray = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new FrameworkDescriptor((Framework)it));
        }
        xCFrameworkTask.fromFrameworkDescriptors((List)destination$iv$iv);
    }

    public final void fromFrameworkDescriptors(FrameworkDescriptor ... frameworks) {
        Intrinsics.checkNotNullParameter((Object)frameworks, (String)"frameworks");
        this.fromFrameworkDescriptors(ArraysKt.toList((Object[])frameworks));
    }

    public final void fromFrameworkDescriptors(@NotNull Iterable<FrameworkDescriptor> frameworks) {
        Intrinsics.checkNotNullParameter(frameworks, (String)"frameworks");
        FrameworkDescriptor frameworkDescriptor = (FrameworkDescriptor)CollectionsKt.firstOrNull((List)CollectionsKt.flatten((Iterable)this.groupedFrameworkFiles.values()));
        String frameworkName2 = frameworkDescriptor != null ? frameworkDescriptor.getName() : null;
        Iterable<FrameworkDescriptor> $this$forEach$iv = frameworks;
        boolean $i$f$forEach = false;
        Iterator<FrameworkDescriptor> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            List list2;
            AppleTarget element$iv;
            FrameworkDescriptor framework2;
            block6: {
                FrameworkDescriptor element$iv2;
                framework2 = element$iv2 = iterator.next();
                boolean bl = false;
                if (frameworkName2 != null && !Intrinsics.areEqual((Object)framework2.getName(), (Object)frameworkName2)) {
                    throw new IllegalStateException(("All inner frameworks in XCFramework '" + (String)this.baseName.get() + "' should have same names. But there are two with '" + frameworkName2 + "' and '" + framework2.getName() + "' names").toString());
                }
                AppleTarget[] $this$first$iv = AppleTarget.values();
                boolean $i$f$first = false;
                int n = $this$first$iv.length;
                for (int j = 0; j < n; ++j) {
                    AppleTarget it = element$iv = $this$first$iv[j];
                    boolean bl2 = false;
                    if (!it.getTargets().contains(framework2.getTarget())) {
                        continue;
                    }
                    break block6;
                }
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            AppleTarget group2 = element$iv;
            Map<AppleTarget, List<FrameworkDescriptor>> $this$getOrPut$iv = this.groupedFrameworkFiles;
            boolean $i$f$getOrPut = false;
            List value$iv = $this$getOrPut$iv.get((Object)group2);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(group2, answer$iv);
                list2 = answer$iv;
            } else {
                list2 = value$iv;
            }
            list2.add((FrameworkDescriptor)framework2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void assemble() {
        void $this$mapNotNullTo$iv$iv;
        List frameworks = CollectionsKt.flatten((Iterable)this.groupedFrameworkFiles.values());
        if (!((Collection)frameworks).isEmpty()) {
            boolean bl;
            String name2;
            String xcfName;
            block14: {
                xcfName = (String)this.baseName.get();
                name2 = ((FrameworkDescriptor)CollectionsKt.first((List)frameworks)).getName();
                Iterable $this$any$iv = frameworks;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FrameworkDescriptor it = (FrameworkDescriptor)element$iv;
                        boolean bl2 = false;
                        if (!(!Intrinsics.areEqual((Object)it.getName(), (Object)name2))) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            if (bl) {
                throw new IllegalStateException(("All inner frameworks in XCFramework '" + xcfName + "' should have same names!" + CollectionsKt.joinToString$default((Iterable)frameworks, (CharSequence)"\n", null, null, (int)0, null, (Function1)assemble.2.INSTANCE, (int)30, null)).toString());
            }
            if (!Intrinsics.areEqual((Object)name2, (Object)xcfName)) {
                this.getLogger().warn("Name of XCFramework '" + xcfName + "' differs from inner frameworks name '" + name2 + "'! Framework renaming is not supported yet");
            }
        }
        Iterable $this$mapNotNull$iv = this.groupedFrameworkFiles.entrySet();
        boolean $i$f$mapNotNull = false;
        Iterable $i$f$any = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            FrameworkDescriptor frameworkDescriptor;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl3 = false;
            AppleTarget group2 = (AppleTarget)((Object)entry.getKey());
            List files = (List)entry.getValue();
            if (files.size() == 1) {
                frameworkDescriptor = (FrameworkDescriptor)CollectionsKt.first((List)files);
            } else if (files.size() > 1) {
                boolean bl4;
                File file;
                block15: {
                    void $this$all$iv;
                    Iterable iterable = files;
                    file = FilesKt.resolve((File)FilesKt.resolve((File)this.getFatFrameworksDir(), (String)group2.getTargetName()), (String)((String)this.getXcFrameworkName$kotlin_gradle_plugin_common().get() + ".framework"));
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl4 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            FrameworkDescriptor it = (FrameworkDescriptor)element$iv;
                            boolean bl5 = false;
                            if (it.isStatic()) continue;
                            bl4 = false;
                            break block15;
                        }
                        bl4 = true;
                    }
                }
                boolean bl6 = bl4;
                KonanTarget konanTarget2 = (KonanTarget)CollectionsKt.first(group2.getTargets());
                boolean bl7 = bl6;
                File file2 = file;
                frameworkDescriptor = new FrameworkDescriptor(file2, bl7, konanTarget2);
            } else {
                frameworkDescriptor = null;
            }
            if (frameworkDescriptor == null) continue;
            FrameworkDescriptor it$iv$iv = frameworkDescriptor;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List frameworksForXCFramework = (List)destination$iv$iv;
        this.createXCFramework(frameworksForXCFramework, this.getOutputXCFrameworkFile(), this.buildType);
    }

    private final void createXCFramework(List<FrameworkDescriptor> frameworkFiles, File output2, NativeBuildType buildType) {
        if (output2.exists()) {
            FilesKt.deleteRecursively((File)output2);
        }
        Object[] objectArray = new String[]{"xcodebuild", "-create-xcframework"};
        List cmdArgs = CollectionsKt.mutableListOf((Object[])objectArray);
        Iterable $this$forEach$iv = frameworkFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File dsymFile;
            FrameworkDescriptor frameworkFile = (FrameworkDescriptor)element$iv;
            boolean bl = false;
            cmdArgs.add("-framework");
            String string = frameworkFile.getFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"frameworkFile.file.path");
            cmdArgs.add(string);
            if (frameworkFile.isStatic() || !(dsymFile = new File(frameworkFile.getFile().getPath() + ".dSYM")).exists()) continue;
            cmdArgs.add("-debug-symbols");
            String string2 = dsymFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dsymFile.path");
            cmdArgs.add(string2);
        }
        cmdArgs.add("-output");
        String string = output2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"output.path");
        cmdArgs.add(string);
        this.getProject().exec(new Action(cmdArgs){
            final /* synthetic */ List<String> $cmdArgs;
            {
                this.$cmdArgs = $cmdArgs;
            }

            public final void execute(ExecSpec it) {
                it.commandLine((Iterable)this.$cmdArgs);
            }
        });
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0016\u0010\r\u001a\u00020\u0004*\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/XCFrameworkTask$Companion;", "", "()V", "fatFrameworkDir", "Ljava/io/File;", "project", "Lorg/gradle/api/Project;", "xcFrameworkName", "", "buildType", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/NativeBuildType;", "appleTarget", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/AppleTarget;", "resolveIfNotNull", "relative", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final File fatFrameworkDir(@NotNull Project project, @NotNull String xcFrameworkName2, @NotNull NativeBuildType buildType, @Nullable AppleTarget appleTarget) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)xcFrameworkName2, (String)"xcFrameworkName");
            Intrinsics.checkNotNullParameter((Object)((Object)buildType), (String)"buildType");
            File file = project.getBuildDir();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
            AppleTarget appleTarget2 = appleTarget;
            return this.resolveIfNotNull(FilesKt.resolve((File)FilesKt.resolve((File)FilesKt.resolve((File)file, (String)(xcFrameworkName2 + "XCFrameworkTemp")), (String)"fatframework"), (String)buildType.getName()), appleTarget2 != null ? appleTarget2.getTargetName() : null);
        }

        public static /* synthetic */ File fatFrameworkDir$default(Companion companion, Project project, String string, NativeBuildType nativeBuildType, AppleTarget appleTarget, int n, Object object) {
            if ((n & 8) != 0) {
                appleTarget = null;
            }
            return companion.fatFrameworkDir(project, string, nativeBuildType, appleTarget);
        }

        private final File resolveIfNotNull(File $this$resolveIfNotNull, String relative) {
            String string = relative;
            return string == null ? $this$resolveIfNotNull : FilesKt.resolve((File)$this$resolveIfNotNull, (String)string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

