/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp.pm20;

import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.component.SoftwareComponentFactory;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.VariantVersionMappingStrategy;
import org.gradle.api.publish.VersionMappingStrategy;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.internal.KotlinDependenciesManagementKt;
import org.jetbrains.kotlin.gradle.kpm.idea.IdeaKpmBuildProjectModelTaskKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.pm20.GradleKpmDependencyGraphResolverKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.pm20.GradleKpmModule;
import org.jetbrains.kotlin.gradle.plugin.mpp.pm20.GradlePluginKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.pm20.KotlinPm20GradlePlugin;
import org.jetbrains.kotlin.gradle.plugin.mpp.pm20.KotlinPm20ProjectExtension;
import org.jetbrains.kotlin.gradle.plugin.mpp.pm20.RegisterDefaultVariantFactoriesKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.pm20.SetupFragmentsMetadataForKpmModulesKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.pm20.SetupKpmModulesPublicationKt;
import org.jetbrains.kotlin.gradle.utils.CompatibiltiyKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/pm20/KotlinPm20GradlePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "softwareComponentFactory", "Lorg/gradle/api/component/SoftwareComponentFactory;", "toolingModelBuilderRegistry", "Lorg/gradle/tooling/provider/model/ToolingModelBuilderRegistry;", "(Lorg/gradle/api/component/SoftwareComponentFactory;Lorg/gradle/tooling/provider/model/ToolingModelBuilderRegistry;)V", "apply", "", "project", "createDefaultModules", "setupPublicationForModule", "module", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/pm20/GradleKpmModule;", "setupToolingModelBuilder", "kotlin-gradle-plugin_common"})
public abstract class KotlinPm20GradlePlugin
implements Plugin<Project> {
    @Inject
    @NotNull
    private final SoftwareComponentFactory softwareComponentFactory;
    @Inject
    @NotNull
    private final ToolingModelBuilderRegistry toolingModelBuilderRegistry;

    @Inject
    public KotlinPm20GradlePlugin(@NotNull SoftwareComponentFactory softwareComponentFactory, @NotNull ToolingModelBuilderRegistry toolingModelBuilderRegistry) {
        Intrinsics.checkNotNullParameter((Object)softwareComponentFactory, (String)"softwareComponentFactory");
        Intrinsics.checkNotNullParameter((Object)toolingModelBuilderRegistry, (String)"toolingModelBuilderRegistry");
        this.softwareComponentFactory = softwareComponentFactory;
        this.toolingModelBuilderRegistry = toolingModelBuilderRegistry;
    }

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GradleVersion gradleVersion = GradleVersion.version((String)"6.1");
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion, (String)"version(\"6.1\")");
        CompatibiltiyKt.checkGradleCompatibility("the Kotlin Multiplatform plugin", gradleVersion);
        project.getPlugins().apply(JavaBasePlugin.class);
        this.createDefaultModules(project);
        KotlinDependenciesManagementKt.customizeKotlinDependencies(project);
        RegisterDefaultVariantFactoriesKt.registerDefaultVariantFactories(project);
        SetupFragmentsMetadataForKpmModulesKt.setupFragmentsMetadataForKpmModules(project);
        SetupKpmModulesPublicationKt.setupKpmModulesPublication(project);
        this.setupToolingModelBuilder(project);
    }

    private final void createDefaultModules(Project project) {
        KotlinPm20ProjectExtension kotlinPm20ProjectExtension;
        KotlinPm20ProjectExtension $this$createDefaultModules_u24lambda_u240 = kotlinPm20ProjectExtension = KotlinProjectExtensionKt.getPm20Extension(project);
        boolean bl = false;
        $this$createDefaultModules_u24lambda_u240.getModules().create("main");
        $this$createDefaultModules_u24lambda_u240.getModules().create("test");
        $this$createDefaultModules_u24lambda_u240.main((Function1<? super GradleKpmModule, Unit>)((Function1)createDefaultModules.1.1.INSTANCE));
    }

    private final void setupPublicationForModule(GradleKpmModule module2) {
        AdhocComponentWithVariants adhocComponentWithVariants;
        Project project = module2.getProject();
        Configuration metadataElements = project.getConfigurations().getByName(SetupFragmentsMetadataForKpmModulesKt.metadataElementsConfigurationName(module2));
        Configuration sourceElements = project.getConfigurations().getByName(SetupFragmentsMetadataForKpmModulesKt.sourceElementsConfigurationName(module2));
        String componentName = GradlePluginKt.rootPublicationComponentName(module2);
        AdhocComponentWithVariants it = adhocComponentWithVariants = this.softwareComponentFactory.adhoc(componentName);
        boolean bl = false;
        project.getComponents().add((Object)it);
        it.addVariantsFromConfiguration(metadataElements, (Action)setupPublicationForModule.rootSoftwareComponent.1.1.INSTANCE);
        it.addVariantsFromConfiguration(sourceElements, (Action)setupPublicationForModule.rootSoftwareComponent.1.2.INSTANCE);
        AdhocComponentWithVariants rootSoftwareComponent2 = adhocComponentWithVariants;
        module2.ifMadePublic((Function0<Unit>)((Function0)new Function0<Unit>(module2, project, componentName, rootSoftwareComponent2){
            final /* synthetic */ GradleKpmModule $module;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $componentName;
            final /* synthetic */ AdhocComponentWithVariants $rootSoftwareComponent;
            {
                this.$module = $module;
                this.$project = $project;
                this.$componentName = $componentName;
                this.$rootSoftwareComponent = $rootSoftwareComponent;
                super(0);
            }

            public final void invoke() {
                Configuration metadataDependencyConfiguration = GradleKpmDependencyGraphResolverKt.resolvableMetadataConfiguration(this.$module);
                this.$project.getPluginManager().withPlugin("maven-publish", new Action(this.$project, this.$componentName, this.$rootSoftwareComponent, metadataDependencyConfiguration){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ String $componentName;
                    final /* synthetic */ AdhocComponentWithVariants $rootSoftwareComponent;
                    final /* synthetic */ Configuration $metadataDependencyConfiguration;
                    {
                        this.$project = $project;
                        this.$componentName = $componentName;
                        this.$rootSoftwareComponent = $rootSoftwareComponent;
                        this.$metadataDependencyConfiguration = $metadataDependencyConfiguration;
                    }

                    public final void execute(AppliedPlugin it) {
                        ((PublishingExtension)this.$project.getExtensions().getByType(PublishingExtension.class)).getPublications().create(this.$componentName, MavenPublication.class, new Action(this.$rootSoftwareComponent, this.$metadataDependencyConfiguration){
                            final /* synthetic */ AdhocComponentWithVariants $rootSoftwareComponent;
                            final /* synthetic */ Configuration $metadataDependencyConfiguration;
                            {
                                this.$rootSoftwareComponent = $rootSoftwareComponent;
                                this.$metadataDependencyConfiguration = $metadataDependencyConfiguration;
                            }

                            public final void execute(MavenPublication publication) {
                                publication.from((SoftwareComponent)this.$rootSoftwareComponent);
                                publication.versionMapping(new Action(this.$metadataDependencyConfiguration){
                                    final /* synthetic */ Configuration $metadataDependencyConfiguration;
                                    {
                                        this.$metadataDependencyConfiguration = $metadataDependencyConfiguration;
                                    }

                                    public final void execute(VersionMappingStrategy versionMapping) {
                                        versionMapping.allVariants(new Action(this.$metadataDependencyConfiguration){
                                            final /* synthetic */ Configuration $metadataDependencyConfiguration;
                                            {
                                                this.$metadataDependencyConfiguration = $metadataDependencyConfiguration;
                                            }

                                            public final void execute(VariantVersionMappingStrategy it) {
                                                it.fromResolutionOf(this.$metadataDependencyConfiguration);
                                            }
                                        });
                                    }
                                });
                            }
                        });
                    }
                });
            }
        }));
    }

    private final void setupToolingModelBuilder(Project project) {
        this.toolingModelBuilderRegistry.register((ToolingModelBuilder)KotlinProjectExtensionKt.getPm20Extension(project).getIdeaKpmProjectModelBuilder$kotlin_gradle_plugin_common());
        IdeaKpmBuildProjectModelTaskKt.locateOrRegisterIdeaKpmBuildProjectModelTask(project);
    }
}

