/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.cocoapods.CocoapodsExtension;
import org.jetbrains.kotlin.gradle.targets.native.cocoapods.MissingCocoapodsMessage;
import org.jetbrains.kotlin.gradle.targets.native.cocoapods.MissingSpecReposMessage;
import org.jetbrains.kotlin.gradle.tasks.PodspecTask;
import org.jetbrains.kotlin.konan.target.Family;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ&\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tJ.\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tJ0\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0007\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\t\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/tasks/CocoapodsErrorHandlingUtil;", "", "()V", "handle", "", "e", "Ljava/io/IOException;", "command", "", "", "handlePodDownloadError", "podName", "retCode", "", "error", "handlePodInstallError", "project", "Lorg/gradle/api/Project;", "frameworkName", "handlePodInstallSyntheticError", "family", "Lorg/jetbrains/kotlin/konan/target/Family;", "kotlin-gradle-plugin_common"})
final class CocoapodsErrorHandlingUtil {
    @NotNull
    public static final CocoapodsErrorHandlingUtil INSTANCE = new CocoapodsErrorHandlingUtil();

    private CocoapodsErrorHandlingUtil() {
    }

    public final void handle(@NotNull IOException e, @NotNull List<String> command) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter(command, (String)"command");
        String string = e.getMessage();
        boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"No such file or directory", (boolean)false, (int)2, null) : false;
        if (bl) {
            String message2 = StringsKt.trimMargin$default((String)(" \n               |'" + CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)command, (int)2), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "' command failed with an exception:\n               | " + e.getMessage() + "\n               |        \n               |        Full command: " + CollectionsKt.joinToString$default((Iterable)command, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "\n               |        \n               |        Possible reason: CocoaPods is not installed\n               |        Please check that CocoaPods v1.10 or above is installed.\n               |        \n               |        To check CocoaPods version type 'pod --version' in the terminal\n               |        \n               |        To install CocoaPods execute 'sudo gem install cocoapods'\n               |\n            "), null, (int)1, null);
            throw new IllegalStateException(message2);
        }
        throw e;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String handlePodInstallError(@NotNull String command, int retCode, @NotNull String error, @NotNull Project project, @NotNull String frameworkName) {
        Object object;
        Object object2;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        List list2;
        String it;
        Object[] objectArray;
        void $this$mapTo$iv$iv;
        Object destination$iv$iv;
        Iterable $this$map$iv;
        String string;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)frameworkName, (String)"frameworkName");
        CocoapodsExtension.SpecRepos specRepos2 = PodspecTask.Companion.retrieveSpecRepos$kotlin_gradle_plugin_common(project);
        if (specRepos2 != null) {
            CocoapodsExtension.SpecRepos it2 = specRepos2;
            boolean bl = false;
            string = new MissingSpecReposMessage(it2).getMissingMessage();
        } else {
            string = null;
        }
        String specReposMessages = string;
        List<CocoapodsExtension.CocoapodsDependency> list3 = PodspecTask.Companion.retrievePods$kotlin_gradle_plugin_common(project);
        if (list3 != null) {
            $this$map$iv = list3;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = (Object[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                CocoapodsExtension.CocoapodsDependency cocoapodsDependency = (CocoapodsExtension.CocoapodsDependency)item$iv$iv;
                objectArray = destination$iv$iv;
                boolean bl = false;
                objectArray.add(new MissingCocoapodsMessage((CocoapodsExtension.CocoapodsDependency)((Object)it), project).getMissingMessage());
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        List cocoapodsMessages = list2;
        Object[] objectArray2 = new String[6];
        objectArray2[0] = "'pod install' command failed with code " + retCode + '.';
        objectArray2[1] = "Full command: " + command;
        objectArray2[2] = "Error message:";
        $this$map$iv = StringsKt.lines((CharSequence)error);
        int n = 3;
        objectArray = objectArray2;
        boolean $i$f$filter2 = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Object object3 = (List)destination$iv$iv;
        objectArray[n] = CollectionsKt.joinToString$default((Iterable)((Iterable)object3), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        Object[] objectArray3 = objectArray2;
        int n2 = 4;
        String string2 = specReposMessages;
        if (string2 != null) {
            void it3;
            String $i$f$filter2 = string2;
            n = n2;
            objectArray = objectArray3;
            boolean bl = false;
            object3 = StringsKt.trimMargin$default((String)("\n                    |        Please, check that podfile contains following lines in header:\n                    |        " + (String)it3 + "\n                    |\n                "), null, (int)1, null);
            objectArray3 = objectArray;
            n2 = n;
            object2 = object3;
        } else {
            object2 = null;
        }
        objectArray3[n2] = object2;
        Object[] objectArray4 = objectArray2;
        int n3 = 5;
        List list4 = cocoapodsMessages;
        if (list4 != null) {
            List it3 = list4;
            n = n3;
            objectArray = objectArray4;
            boolean bl = false;
            object3 = StringsKt.trimMargin$default((String)("\n                   |         Please, check that each target depended on " + frameworkName + " contains following dependencies:\n                   |         " + CollectionsKt.joinToString$default((Iterable)it3, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "\n                   |        \n                "), null, (int)1, null);
            objectArray4 = objectArray;
            n3 = n;
            object = object3;
        } else {
            object = null;
        }
        objectArray4[n3] = object;
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray2), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String handlePodInstallSyntheticError(@NotNull String command, int retCode, @NotNull String error, @NotNull Family family, @NotNull String podName) {
        String message2;
        block6: {
            block5: {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkNotNullParameter((Object)command, (String)"command");
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                Intrinsics.checkNotNullParameter((Object)((Object)family), (String)"family");
                Intrinsics.checkNotNullParameter((Object)podName, (String)"podName");
                Object object = StringsKt.lines((CharSequence)error);
                StringBuilder stringBuilder = new StringBuilder().append("\n            |'pod install' command on the synthetic project failed with return code: ").append(retCode).append("\n            |\n            |        Full command: ").append(command).append("\n            |\n            |        Error: ");
                boolean $i$f$filter = false;
                void var9_9 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"[!]", (boolean)false, (int)2, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                message2 = StringsKt.trimMargin$default((String)stringBuilder.append(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).append("\n            |       \n        ").toString(), null, (int)1, null);
                if (StringsKt.contains$default((CharSequence)error, (CharSequence)"deployment target", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)error, (CharSequence)"no platform was specified", (boolean)false, (int)2, null)) break block5;
                object = error;
                if (!new Regex("The platform of the target .+ is not compatible with `" + podName).containsMatchIn((CharSequence)object)) break block6;
            }
            StringBuilder stringBuilder = new StringBuilder().append(message2);
            StringBuilder stringBuilder2 = new StringBuilder().append("\n                |\n                |        Possible reason: ");
            String string = family.name().toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
            StringBuilder stringBuilder3 = stringBuilder2.append(string).append(" deployment target is not configured\n                |        Configure deployment_target for ALL targets as follows:\n                |        cocoapods {\n                |           ...\n                |           ");
            String string2 = family.name().toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase()");
            message2 = stringBuilder.append(StringsKt.trimMargin$default((String)stringBuilder3.append(string2).append(".deploymentTarget = \"...\"\n                |           ...\n                |        }\n                |       \n            ").toString(), null, (int)1, null)).toString();
            return message2;
        }
        if (StringsKt.contains$default((CharSequence)error, (CharSequence)"Unable to add a source with url", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)error, (CharSequence)"Couldn't determine repo name for URL", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)error, (CharSequence)"Unable to find a specification", (boolean)false, (int)2, null)) {
            message2 = message2 + "\n        Possible reason: spec repos are not configured correctly.\n        Ensure that spec repos are correctly configured for all private pod dependencies:\n        cocoapods {\n           specRepos {\n               url(\"<private spec repo url>\")\n           }\n        }\n       ";
            return message2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String handlePodDownloadError(@NotNull String podName, @NotNull String command, int retCode, @NotNull String error) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)podName, (String)"podName");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Iterable iterable = StringsKt.lines((CharSequence)error);
        StringBuilder stringBuilder = new StringBuilder().append("\n            |'git clone' command failed with return code: ").append(retCode).append("\n            |\n            |       Full command: ").append(command).append("\n            |\n            |       Error: ");
        boolean $i$f$filter = false;
        void var7_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.contains((CharSequence)it, (CharSequence)"fatal", (boolean)true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return StringsKt.trimMargin$default((String)stringBuilder.append(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).append("\n            |       \n            |       Possible reason: source of a pod '").append(podName).append("' is invalid or inaccessible\n            |       \n        ").toString(), null, (int)1, null);
    }
}

