/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.sources.android.checker;

import com.android.build.gradle.api.AndroidSourceSet;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinAndroidTarget;
import org.jetbrains.kotlin.gradle.plugin.sources.android.KotlinAndroidSourceSetLayout;
import org.jetbrains.kotlin.gradle.plugin.sources.android.checker.KotlinAndroidSourceSetLayoutChecker;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/sources/android/checker/MultiplatformLayoutV2AndroidStyleSourceDirUsageChecker;", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/checker/KotlinAndroidSourceSetLayoutChecker;", "()V", "checkCreatedSourceSet", "", "diagnosticReporter", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/checker/KotlinAndroidSourceSetLayoutChecker$DiagnosticReporter;", "target", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;", "layout", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/KotlinAndroidSourceSetLayout;", "kotlinSourceSet", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "androidSourceSet", "Lcom/android/build/gradle/api/AndroidSourceSet;", "AndroidStyleSourceDirUsageDiagnostic", "kotlin-gradle-plugin_common"})
public final class MultiplatformLayoutV2AndroidStyleSourceDirUsageChecker
implements KotlinAndroidSourceSetLayoutChecker {
    @NotNull
    public static final MultiplatformLayoutV2AndroidStyleSourceDirUsageChecker INSTANCE = new MultiplatformLayoutV2AndroidStyleSourceDirUsageChecker();

    private MultiplatformLayoutV2AndroidStyleSourceDirUsageChecker() {
    }

    @Override
    public void checkCreatedSourceSet(@NotNull KotlinAndroidSourceSetLayoutChecker.DiagnosticReporter diagnosticReporter, @NotNull KotlinAndroidTarget target2, @NotNull KotlinAndroidSourceSetLayout layout, @NotNull KotlinSourceSet kotlinSourceSet, @NotNull AndroidSourceSet androidSourceSet) {
        Intrinsics.checkNotNullParameter((Object)diagnosticReporter, (String)"diagnosticReporter");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        Intrinsics.checkNotNullParameter((Object)kotlinSourceSet, (String)"kotlinSourceSet");
        Intrinsics.checkNotNullParameter((Object)androidSourceSet, (String)"androidSourceSet");
        File androidStyleSourceDir = target2.getProject().file((Object)("src/" + androidSourceSet.getName() + "/kotlin"));
        if (kotlinSourceSet.getKotlin().getSrcDirs().contains(androidStyleSourceDir) && androidStyleSourceDir.exists()) {
            File kotlinStyleSourceDirToUse = target2.getProject().file((Object)("src/" + kotlinSourceSet.getName() + "/kotlin"));
            Intrinsics.checkNotNullExpressionValue((Object)androidStyleSourceDir, (String)"androidStyleSourceDir");
            Intrinsics.checkNotNullExpressionValue((Object)kotlinStyleSourceDirToUse, (String)"kotlinStyleSourceDirToUse");
            diagnosticReporter.warning(new AndroidStyleSourceDirUsageDiagnostic(androidStyleSourceDir, kotlinStyleSourceDirToUse));
        }
    }

    @Override
    public void checkBeforeLayoutApplied(@NotNull KotlinAndroidSourceSetLayoutChecker.DiagnosticReporter diagnosticReporter, @NotNull KotlinAndroidTarget target2, @NotNull KotlinAndroidSourceSetLayout layout) {
        KotlinAndroidSourceSetLayoutChecker.DefaultImpls.checkBeforeLayoutApplied(this, diagnosticReporter, target2, layout);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\nH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/sources/android/checker/MultiplatformLayoutV2AndroidStyleSourceDirUsageChecker$AndroidStyleSourceDirUsageDiagnostic;", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/checker/KotlinAndroidSourceSetLayoutChecker$Diagnostic;", "androidStyleSourceDirInUse", "Ljava/io/File;", "kotlinStyleSourceDirToUse", "(Ljava/io/File;Ljava/io/File;)V", "getAndroidStyleSourceDirInUse", "()Ljava/io/File;", "getKotlinStyleSourceDirToUse", "message", "", "getMessage", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "kotlin-gradle-plugin_common"})
    public static final class AndroidStyleSourceDirUsageDiagnostic
    implements KotlinAndroidSourceSetLayoutChecker.Diagnostic {
        @NotNull
        private final File androidStyleSourceDirInUse;
        @NotNull
        private final File kotlinStyleSourceDirToUse;

        public AndroidStyleSourceDirUsageDiagnostic(@NotNull File androidStyleSourceDirInUse, @NotNull File kotlinStyleSourceDirToUse) {
            Intrinsics.checkNotNullParameter((Object)androidStyleSourceDirInUse, (String)"androidStyleSourceDirInUse");
            Intrinsics.checkNotNullParameter((Object)kotlinStyleSourceDirToUse, (String)"kotlinStyleSourceDirToUse");
            this.androidStyleSourceDirInUse = androidStyleSourceDirInUse;
            this.kotlinStyleSourceDirToUse = kotlinStyleSourceDirToUse;
        }

        @NotNull
        public final File getAndroidStyleSourceDirInUse() {
            return this.androidStyleSourceDirInUse;
        }

        @NotNull
        public final File getKotlinStyleSourceDirToUse() {
            return this.kotlinStyleSourceDirToUse;
        }

        @Override
        @NotNull
        public String getMessage() {
            return StringsKt.trimIndent((String)("\n                Usage of 'Android Style' source directory " + this.androidStyleSourceDirInUse + " is deprecated.\n                Use " + this.kotlinStyleSourceDirToUse + " instead.\n            "));
        }

        @NotNull
        public final File component1() {
            return this.androidStyleSourceDirInUse;
        }

        @NotNull
        public final File component2() {
            return this.kotlinStyleSourceDirToUse;
        }

        @NotNull
        public final AndroidStyleSourceDirUsageDiagnostic copy(@NotNull File androidStyleSourceDirInUse, @NotNull File kotlinStyleSourceDirToUse) {
            Intrinsics.checkNotNullParameter((Object)androidStyleSourceDirInUse, (String)"androidStyleSourceDirInUse");
            Intrinsics.checkNotNullParameter((Object)kotlinStyleSourceDirToUse, (String)"kotlinStyleSourceDirToUse");
            return new AndroidStyleSourceDirUsageDiagnostic(androidStyleSourceDirInUse, kotlinStyleSourceDirToUse);
        }

        public static /* synthetic */ AndroidStyleSourceDirUsageDiagnostic copy$default(AndroidStyleSourceDirUsageDiagnostic androidStyleSourceDirUsageDiagnostic, File file, File file2, int n, Object object) {
            if ((n & 1) != 0) {
                file = androidStyleSourceDirUsageDiagnostic.androidStyleSourceDirInUse;
            }
            if ((n & 2) != 0) {
                file2 = androidStyleSourceDirUsageDiagnostic.kotlinStyleSourceDirToUse;
            }
            return androidStyleSourceDirUsageDiagnostic.copy(file, file2);
        }

        @NotNull
        public String toString() {
            return "AndroidStyleSourceDirUsageDiagnostic(androidStyleSourceDirInUse=" + this.androidStyleSourceDirInUse + ", kotlinStyleSourceDirToUse=" + this.kotlinStyleSourceDirToUse + ')';
        }

        public int hashCode() {
            int result2 = this.androidStyleSourceDirInUse.hashCode();
            result2 = result2 * 31 + this.kotlinStyleSourceDirToUse.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AndroidStyleSourceDirUsageDiagnostic)) {
                return false;
            }
            AndroidStyleSourceDirUsageDiagnostic androidStyleSourceDirUsageDiagnostic = (AndroidStyleSourceDirUsageDiagnostic)other;
            if (!Intrinsics.areEqual((Object)this.androidStyleSourceDirInUse, (Object)androidStyleSourceDirUsageDiagnostic.androidStyleSourceDirInUse)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.kotlinStyleSourceDirToUse, (Object)androidStyleSourceDirUsageDiagnostic.kotlinStyleSourceDirToUse);
        }
    }
}

