/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.d8;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.internal.ConfigurationPhaseAware;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.targets.js.d8.D8Env;
import org.jetbrains.kotlin.gradle.targets.js.d8.D8Platform;
import org.jetbrains.kotlin.gradle.tasks.internal.CleanableStore;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 )2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001)B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010(\u001a\u00020\u0002H\u0014R+\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR+\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u000f\u001a\u0004\b\u0011\u0010\u000b\"\u0004\b\u0012\u0010\rR\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u00158F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u000f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0019\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0 8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R+\u0010$\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b'\u0010\u000f\u001a\u0004\b%\u0010\u000b\"\u0004\b&\u0010\r\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/d8/D8RootExtension;", "Lorg/jetbrains/kotlin/gradle/internal/ConfigurationPhaseAware;", "Lorg/jetbrains/kotlin/gradle/targets/js/d8/D8Env;", "Ljava/io/Serializable;", "rootProject", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "<set-?>", "", "downloadBaseUrl", "getDownloadBaseUrl", "()Ljava/lang/String;", "setDownloadBaseUrl", "(Ljava/lang/String;)V", "downloadBaseUrl$delegate", "Lorg/jetbrains/kotlin/gradle/internal/ConfigurationPhaseAware$Property;", "edition", "getEdition", "setEdition", "edition$delegate", "gradleHome", "Ljava/io/File;", "kotlin.jvm.PlatformType", "installationPath", "getInstallationPath", "()Ljava/io/File;", "setInstallationPath", "(Ljava/io/File;)V", "installationPath$delegate", "getRootProject", "()Lorg/gradle/api/Project;", "setupTaskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/gradle/api/tasks/Copy;", "getSetupTaskProvider", "()Lorg/gradle/api/tasks/TaskProvider;", "version", "getVersion", "setVersion", "version$delegate", "finalizeConfiguration", "Companion", "kotlin-gradle-plugin_common"})
public class D8RootExtension
extends ConfigurationPhaseAware<D8Env>
implements Serializable {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final transient Project rootProject;
    private final File gradleHome;
    @NotNull
    private final ConfigurationPhaseAware.Property installationPath$delegate;
    @NotNull
    private final ConfigurationPhaseAware.Property downloadBaseUrl$delegate;
    @NotNull
    private final ConfigurationPhaseAware.Property version$delegate;
    @NotNull
    private final ConfigurationPhaseAware.Property edition$delegate;
    @NotNull
    public static final String EXTENSION_NAME = "kotlinD8";

    /*
     * WARNING - void declaration
     */
    public D8RootExtension(@NotNull Project rootProject) {
        void it;
        File file;
        Intrinsics.checkNotNullParameter((Object)rootProject, (String)"rootProject");
        this.rootProject = rootProject;
        if (!Intrinsics.areEqual((Object)this.rootProject.getRootProject(), (Object)this.rootProject)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        File file2 = file = this.rootProject.getGradle().getGradleUserHomeDir();
        D8RootExtension d8RootExtension = this;
        boolean bl = false;
        Logger logger = this.rootProject.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"rootProject.logger");
        GradleLoggingUtilsKt.kotlinInfo(logger, "Storing cached files in " + it);
        d8RootExtension.gradleHome = file;
        ConfigurationPhaseAware configurationPhaseAware = this;
        File file3 = this.gradleHome;
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"gradleHome");
        this.installationPath$delegate = configurationPhaseAware.new ConfigurationPhaseAware.Property<File>(FilesKt.resolve((File)file3, (String)"d8"));
        this.downloadBaseUrl$delegate = new ConfigurationPhaseAware.Property<String>("https://storage.googleapis.com/chromium-v8/official/canary/");
        this.version$delegate = new ConfigurationPhaseAware.Property<String>("10.2.9");
        this.edition$delegate = new ConfigurationPhaseAware.Property<String>("rel");
    }

    @NotNull
    public final Project getRootProject() {
        return this.rootProject;
    }

    @NotNull
    public final File getInstallationPath() {
        return (File)this.installationPath$delegate.getValue(this, $$delegatedProperties[0]);
    }

    public final void setInstallationPath(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.installationPath$delegate.setValue(this, $$delegatedProperties[0], file);
    }

    @NotNull
    public final String getDownloadBaseUrl() {
        return (String)this.downloadBaseUrl$delegate.getValue(this, $$delegatedProperties[1]);
    }

    public final void setDownloadBaseUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.downloadBaseUrl$delegate.setValue(this, $$delegatedProperties[1], string);
    }

    @NotNull
    public final String getVersion() {
        return (String)this.version$delegate.getValue(this, $$delegatedProperties[2]);
    }

    public final void setVersion(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.version$delegate.setValue(this, $$delegatedProperties[2], string);
    }

    @NotNull
    public final String getEdition() {
        return (String)this.edition$delegate.getValue(this, $$delegatedProperties[3]);
    }

    public final void setEdition(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.edition$delegate.setValue(this, $$delegatedProperties[3], string);
    }

    @NotNull
    public final TaskProvider<? extends Copy> getSetupTaskProvider() {
        TaskProvider taskProvider = this.rootProject.getTasks().withType(Copy.class).named("d8Install");
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"rootProject.tasks.withTy\u2026Plugin.INSTALL_TASK_NAME)");
        return taskProvider;
    }

    @Override
    @NotNull
    protected D8Env finalizeConfiguration() {
        String requiredVersionName = "v8-" + D8Platform.INSTANCE.getPlatform() + '-' + this.getEdition() + '-' + this.getVersion();
        String requiredZipName = requiredVersionName + ".zip";
        String string = this.getInstallationPath().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"installationPath.absolutePath");
        CleanableStore cleanableStore = CleanableStore.Companion.get(string);
        File targetPath = cleanableStore.get(requiredVersionName).use();
        boolean isWindows = Intrinsics.areEqual((Object)D8Platform.INSTANCE.getName(), (Object)"win");
        char[] cArray = new char[]{'/'};
        return new D8Env(cleanableStore, cleanableStore.get(requiredZipName).use(), targetPath, FilesKt.resolve((File)targetPath, (String)(isWindows ? "d8.exe" : "d8")), isWindows, new URL(StringsKt.trimEnd((String)this.getDownloadBaseUrl(), (char[])cArray) + '/' + requiredZipName));
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(D8RootExtension.class), "installationPath", "getInstallationPath()Ljava/io/File;"))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(D8RootExtension.class), "downloadBaseUrl", "getDownloadBaseUrl()Ljava/lang/String;"))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(D8RootExtension.class), "version", "getVersion()Ljava/lang/String;"))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(D8RootExtension.class), "edition", "getEdition()Ljava/lang/String;")))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/d8/D8RootExtension$Companion;", "", "()V", "EXTENSION_NAME", "", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

