/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.tooling.Failure;
import org.gradle.tooling.events.FailureResult;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.gradle.tooling.events.task.TaskFailureResult;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationResult;
import org.gradle.tooling.events.task.TaskSkippedResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskExecutionResults;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatsService;
import org.jetbrains.kotlin.gradle.report.BuildMetricsService;
import org.jetbrains.kotlin.gradle.report.ConfigureReporingKt;
import org.jetbrains.kotlin.gradle.report.ReportingSettings;
import org.jetbrains.kotlin.gradle.report.TaskExecutionResult;
import org.jetbrains.kotlin.gradle.report.TaskRecord;
import org.jetbrains.kotlin.gradle.report.TransformRecord;
import org.jetbrains.kotlin.gradle.report.UsesBuildMetricsService;
import org.jetbrains.kotlin.gradle.report.data.BuildOperationRecord;
import org.jetbrains.kotlin.gradle.utils.SingleActionPerProject;
import org.jetbrains.kotlin.statistics.metrics.BooleanMetrics;
import org.jetbrains.kotlin.statistics.metrics.IStatisticsValuesConsumer;
import org.jetbrains.kotlin.statistics.metrics.NumericalMetrics;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u0012H\u0016JF\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u000b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010%\u001a\u00020\u00152\b\u0010&\u001a\u0004\u0018\u00010'H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/gradle/report/BuildMetricsService;", "Lorg/gradle/api/services/BuildService;", "Lorg/gradle/api/services/BuildServiceParameters$None;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "()V", "buildOperationRecords", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lorg/jetbrains/kotlin/gradle/report/data/BuildOperationRecord;", "getBuildOperationRecords$kotlin_gradle_plugin_common", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "failureMessages", "", "getFailureMessages$kotlin_gradle_plugin_common", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "taskPathToMetricsReporter", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "taskPathToTaskClass", "addTask", "", "taskPath", "taskClass", "Ljava/lang/Class;", "metricsReporter", "addTransformMetrics", "transformPath", "transformClass", "isKotlinTransform", "", "startTimeMs", "", "totalTimeMs", "buildMetrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetrics;", "failureMessage", "onFinish", "event", "Lorg/gradle/tooling/events/FinishEvent;", "Companion", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nBuildMetricsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildMetricsService.kt\norg/jetbrains/kotlin/gradle/report/BuildMetricsService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n1#2:192\n1549#3:193\n1620#3,3:194\n*E\n*S KotlinDebug\n*F\n+ 1 BuildMetricsService.kt\norg/jetbrains/kotlin/gradle/report/BuildMetricsService\n*L\n130#1:193\n130#1,3:194\n*E\n"})
public abstract class BuildMetricsService
implements BuildService<BuildServiceParameters.None>,
OperationCompletionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger log = Logging.getLogger(this.getClass());
    @NotNull
    private final ConcurrentLinkedQueue<BuildOperationRecord> buildOperationRecords = new ConcurrentLinkedQueue();
    @NotNull
    private final ConcurrentLinkedQueue<String> failureMessages = new ConcurrentLinkedQueue();
    @NotNull
    private final ConcurrentHashMap<String, BuildMetricsReporter> taskPathToMetricsReporter = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<String, String> taskPathToTaskClass = new ConcurrentHashMap();
    @NotNull
    private static final Class<BuildMetricsService> serviceClass = BuildMetricsService.class;
    @NotNull
    private static final String serviceName = serviceClass.getName() + '_' + serviceClass.getClassLoader().hashCode();

    @NotNull
    public final ConcurrentLinkedQueue<BuildOperationRecord> getBuildOperationRecords$kotlin_gradle_plugin_common() {
        return this.buildOperationRecords;
    }

    @NotNull
    public final ConcurrentLinkedQueue<String> getFailureMessages$kotlin_gradle_plugin_common() {
        return this.failureMessages;
    }

    public void addTask(@NotNull String taskPath, @NotNull Class<?> taskClass, @NotNull BuildMetricsReporter metricsReporter) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)taskPath, (String)"taskPath");
        Intrinsics.checkNotNullParameter(taskClass, (String)"taskClass");
        Intrinsics.checkNotNullParameter((Object)metricsReporter, (String)"metricsReporter");
        Object it = object = this.taskPathToMetricsReporter.put(taskPath, metricsReporter);
        boolean bl = false;
        if (it != null) {
            this.log.warn("Duplicate task path: " + taskPath);
        }
        object = this.taskPathToTaskClass.put(taskPath, taskClass.getName());
        it = (String)object;
        boolean bl2 = false;
        if (it != null) {
            this.log.warn("Duplicate task path: " + taskPath);
        }
    }

    public void addTransformMetrics(@NotNull String transformPath, @NotNull Class<?> transformClass, boolean isKotlinTransform, long startTimeMs, long totalTimeMs, @NotNull BuildMetrics buildMetrics, @Nullable String failureMessage) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)transformPath, (String)"transformPath");
            Intrinsics.checkNotNullParameter(transformClass, (String)"transformClass");
            Intrinsics.checkNotNullParameter((Object)buildMetrics, (String)"buildMetrics");
            String string = transformClass.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"transformClass.name");
            this.buildOperationRecords.add(new TransformRecord(transformPath, string, isKotlinTransform, startTimeMs, totalTimeMs, buildMetrics));
            String string2 = failureMessage;
            if (string2 == null) break block0;
            String it = string2;
            boolean bl = false;
            this.failureMessages.add(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onFinish(@Nullable FinishEvent event) {
        if (event instanceof TaskFinishEvent) {
            String string;
            Object it;
            TaskOperationResult result2 = ((TaskFinishEvent)event).getResult();
            String taskPath = ((TaskFinishEvent)event).getDescriptor().getTaskPath();
            long totalTimeMs = result2.getEndTime() - result2.getStartTime();
            BuildMetrics buildMetrics = new BuildMetrics(null, null, null, 7, null);
            buildMetrics.getBuildTimes().addTimeMs(BuildTime.GRADLE_TASK, totalTimeMs);
            BuildMetricsReporter buildMetricsReporter = this.taskPathToMetricsReporter.get(taskPath);
            if (buildMetricsReporter != null) {
                it = buildMetricsReporter;
                boolean bl = false;
                buildMetrics.addAll(it.getMetrics());
            }
            Intrinsics.checkNotNullExpressionValue((Object)taskPath, (String)"taskPath");
            TaskExecutionResult taskExecutionResult = TaskExecutionResults.INSTANCE.get(taskPath);
            TaskExecutionResult taskExecutionResult2 = taskExecutionResult;
            if (taskExecutionResult2 != null && (taskExecutionResult2 = taskExecutionResult2.getBuildMetrics()) != null) {
                Object it2 = it = taskExecutionResult2;
                boolean bl = false;
                buildMetrics.addAll((BuildMetrics)it2);
                KotlinBuildStatsService.Companion.applyIfInitialised((Function1<? super IStatisticsValuesConsumer, Unit>)((Function1)new Function1<IStatisticsValuesConsumer, Unit>(totalTimeMs, event, buildMetrics, taskExecutionResult){
                    final /* synthetic */ long $totalTimeMs;
                    final /* synthetic */ FinishEvent $event;
                    final /* synthetic */ BuildMetrics $buildMetrics;
                    final /* synthetic */ TaskExecutionResult $taskExecutionResult;
                    {
                        this.$totalTimeMs = $totalTimeMs;
                        this.$event = $event;
                        this.$buildMetrics = $buildMetrics;
                        this.$taskExecutionResult = $taskExecutionResult;
                        super(1);
                    }

                    public final void invoke(@NotNull IStatisticsValuesConsumer collector) {
                        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
                        IStatisticsValuesConsumer.DefaultImpls.report$default(collector, NumericalMetrics.COMPILATION_DURATION, this.$totalTimeMs, null, null, 12, null);
                        IStatisticsValuesConsumer.DefaultImpls.report$default(collector, BooleanMetrics.KOTLIN_COMPILATION_FAILED, ((TaskFinishEvent)this.$event).getResult() instanceof FailureResult, null, null, 12, null);
                        Map metricsMap = this.$buildMetrics.getBuildPerformanceMetrics().asMap();
                        Long linesOfCode = (Long)metricsMap.get(BuildPerformanceMetric.ANALYZED_LINES_NUMBER);
                        if (linesOfCode != null && linesOfCode > 0L && this.$totalTimeMs > 0L) {
                            Long l;
                            IStatisticsValuesConsumer.DefaultImpls.report$default(collector, NumericalMetrics.COMPILED_LINES_OF_CODE, linesOfCode, null, null, 12, null);
                            collector.report(NumericalMetrics.COMPILATION_LINES_PER_SECOND, linesOfCode * (long)1000 / this.$totalTimeMs, null, linesOfCode);
                            Long l2 = (Long)metricsMap.get(BuildPerformanceMetric.ANALYSIS_LPS);
                            if (l2 != null) {
                                l = l2;
                                long it = ((Number)l).longValue();
                                boolean bl = false;
                                collector.report(NumericalMetrics.ANALYSIS_LINES_PER_SECOND, it, null, linesOfCode);
                            }
                            Long l3 = (Long)metricsMap.get(BuildPerformanceMetric.CODE_GENERATION_LPS);
                            if (l3 != null) {
                                l = l3;
                                long value = ((Number)l).longValue();
                                boolean bl = false;
                                collector.report(NumericalMetrics.CODE_GENERATION_LINES_PER_SECOND, value, null, linesOfCode);
                            }
                        }
                        IStatisticsValuesConsumer.DefaultImpls.report$default(collector, NumericalMetrics.COMPILATIONS_COUNT, 1L, null, null, 12, null);
                        IStatisticsValuesConsumer.DefaultImpls.report$default(collector, NumericalMetrics.INCREMENTAL_COMPILATIONS_COUNT, this.$taskExecutionResult.getBuildMetrics().getBuildAttributes().asMap().isEmpty() ? 1L : 0L, null, null, 12, null);
                    }
                }));
            }
            if ((string = this.taskPathToTaskClass.get(taskPath)) == null) {
                string = "unknown";
            }
            long l = result2.getStartTime();
            boolean bl = result2 instanceof org.gradle.tooling.events.task.TaskExecutionResult;
            TaskSkippedResult taskSkippedResult = result2 instanceof TaskSkippedResult ? (TaskSkippedResult)result2 : null;
            String string2 = taskSkippedResult != null ? taskSkippedResult.getSkipMessage() : null;
            Object object = taskExecutionResult;
            if (object == null || (object = ((TaskExecutionResult)object).getIcLogLines()) == null) {
                object = CollectionsKt.emptyList();
            }
            this.buildOperationRecords.add(new TaskRecord(taskPath, string, l, totalTimeMs, buildMetrics, bl, string2, (List<String>)object));
            if (result2 instanceof TaskFailureResult) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List list2 = ((TaskFailureResult)result2).getFailures();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"result.failures");
                Iterable iterable = list2;
                ConcurrentLinkedQueue<String> concurrentLinkedQueue = this.failureMessages;
                boolean $i$f$map = false;
                void it2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    Failure failure = (Failure)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it3.getMessage());
                }
                concurrentLinkedQueue.addAll((List)destination$iv$iv);
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/gradle/report/BuildMetricsService$Companion;", "", "()V", "serviceClass", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/gradle/report/BuildMetricsService;", "serviceName", "", "registerIfAbsent", "Lorg/gradle/api/provider/Provider;", "project", "Lorg/gradle/api/Project;", "registerIfAbsentImpl", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        private final Provider<BuildMetricsService> registerIfAbsentImpl(Project project) {
            BuildServiceRegistration buildServiceRegistration = (BuildServiceRegistration)project.getGradle().getSharedServices().getRegistrations().findByName(serviceName);
            if (buildServiceRegistration != null) {
                BuildServiceRegistration it = buildServiceRegistration;
                boolean bl = false;
                Provider provider = it.getService();
                Intrinsics.checkNotNull((Object)provider, (String)"null cannot be cast to non-null type org.gradle.api.provider.Provider<org.jetbrains.kotlin.gradle.report.BuildMetricsService>");
                return provider;
            }
            ReportingSettings reportingSettings = ConfigureReporingKt.reportingSettings(project);
            if (reportingSettings.getBuildReportOutputs().isEmpty()) {
                return null;
            }
            Function1 function1 = registerIfAbsentImpl.2.INSTANCE;
            Provider provider = project.getGradle().getSharedServices().registerIfAbsent(serviceName, serviceClass, new Action(function1){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ void execute(Object p0) {
                    this.function.invoke(p0);
                }
            });
            Intrinsics.checkNotNull((Object)provider);
            return provider;
        }

        @Nullable
        public final Provider<BuildMetricsService> registerIfAbsent(@NotNull Project project) {
            Provider<BuildMetricsService> provider;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Provider<BuildMetricsService> provider2 = this.registerIfAbsentImpl(project);
            if (provider2 != null) {
                Provider<BuildMetricsService> provider3;
                Provider<BuildMetricsService> serviceProvider = provider3 = provider2;
                boolean bl = false;
                String string = UsesBuildMetricsService.class.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UsesBuildMetricsService::class.java.name");
                SingleActionPerProject.INSTANCE.run(project, string, (Function0<Unit>)((Function0)new Function0<Unit>(project, serviceProvider){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Provider<BuildMetricsService> $serviceProvider;
                    {
                        this.$project = $project;
                        this.$serviceProvider = $serviceProvider;
                        super(0);
                    }

                    public final void invoke() {
                        TaskContainer taskContainer = this.$project.getTasks();
                        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
                        TaskCollection $this$withType$iv = (TaskCollection)taskContainer;
                        boolean $i$f$withType = false;
                        TaskCollection taskCollection = $this$withType$iv.withType(UsesBuildMetricsService.class);
                        Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"withType(S::class.java)");
                        Function1 function1 = (Function1)new Function1<UsesBuildMetricsService, Unit>(this.$serviceProvider){
                            final /* synthetic */ Provider<BuildMetricsService> $serviceProvider;
                            {
                                this.$serviceProvider = $serviceProvider;
                                super(1);
                            }

                            public final void invoke(UsesBuildMetricsService task2) {
                                task2.usesService(this.$serviceProvider);
                            }
                        };
                        taskCollection.configureEach(new /* invalid duplicate definition of identical inner class */);
                    }
                }));
                provider = provider3;
            } else {
                provider = null;
            }
            return provider;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

