/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.File;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.compilerRunner.CompilerExecutionSettings;
import org.jetbrains.kotlin.compilerRunner.GradleCompilerRunner;
import org.jetbrains.kotlin.compilerRunner.GradleKotlinCompilerWork;
import org.jetbrains.kotlin.compilerRunner.GradleKotlinCompilerWorkArguments;
import org.jetbrains.kotlin.gradle.tasks.CompilationErrorException;
import org.jetbrains.kotlin.gradle.tasks.FailedCompilationException;
import org.jetbrains.kotlin.gradle.tasks.GradleCompileTaskProvider;
import org.jetbrains.kotlin.gradle.tasks.OOMErrorException;
import org.jetbrains.kotlin.gradle.tasks.TaskOutputsBackup;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerRunnerWithWorkers;", "Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerRunner;", "taskProvider", "Lorg/jetbrains/kotlin/gradle/tasks/GradleCompileTaskProvider;", "jdkToolsJar", "Ljava/io/File;", "compilerExecutionSettings", "Lorg/jetbrains/kotlin/compilerRunner/CompilerExecutionSettings;", "buildMetrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/jetbrains/kotlin/gradle/tasks/GradleCompileTaskProvider;Ljava/io/File;Lorg/jetbrains/kotlin/compilerRunner/CompilerExecutionSettings;Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;Lorg/gradle/workers/WorkerExecutor;)V", "runCompilerAsync", "Lorg/gradle/workers/WorkQueue;", "workArgs", "Lorg/jetbrains/kotlin/compilerRunner/GradleKotlinCompilerWorkArguments;", "taskOutputsBackup", "Lorg/jetbrains/kotlin/gradle/tasks/TaskOutputsBackup;", "GradleKotlinCompilerWorkAction", "GradleKotlinCompilerWorkParameters", "kotlin-gradle-plugin_common"})
public final class GradleCompilerRunnerWithWorkers
extends GradleCompilerRunner {
    @NotNull
    private final WorkerExecutor workerExecutor;

    public GradleCompilerRunnerWithWorkers(@NotNull GradleCompileTaskProvider taskProvider, @Nullable File jdkToolsJar, @NotNull CompilerExecutionSettings compilerExecutionSettings, @NotNull BuildMetricsReporter buildMetrics, @NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkNotNullParameter((Object)taskProvider, (String)"taskProvider");
        Intrinsics.checkNotNullParameter((Object)compilerExecutionSettings, (String)"compilerExecutionSettings");
        Intrinsics.checkNotNullParameter((Object)buildMetrics, (String)"buildMetrics");
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        super(taskProvider, jdkToolsJar, compilerExecutionSettings, buildMetrics);
        this.workerExecutor = workerExecutor;
    }

    @Override
    @NotNull
    protected WorkQueue runCompilerAsync(@NotNull GradleKotlinCompilerWorkArguments workArgs, @Nullable TaskOutputsBackup taskOutputsBackup) {
        Intrinsics.checkNotNullParameter((Object)workArgs, (String)"workArgs");
        this.getBuildMetrics().addTimeMetric(BuildPerformanceMetric.CALL_WORKER);
        WorkQueue workQueue2 = this.workerExecutor.noIsolation();
        Function1 function1 = (Function1)new Function1<GradleKotlinCompilerWorkParameters, Unit>(workArgs, taskOutputsBackup, this){
            final /* synthetic */ GradleKotlinCompilerWorkArguments $workArgs;
            final /* synthetic */ TaskOutputsBackup $taskOutputsBackup;
            final /* synthetic */ GradleCompilerRunnerWithWorkers this$0;
            {
                this.$workArgs = $workArgs;
                this.$taskOutputsBackup = $taskOutputsBackup;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(GradleKotlinCompilerWorkParameters params) {
                params.getCompilerWorkArguments().set((Object)this.$workArgs);
                if (this.$taskOutputsBackup != null) {
                    params.getTaskOutputsToRestore().set((Iterable)this.$taskOutputsBackup.getOutputsToRestore());
                    params.getBuildDir().set((Provider)this.$taskOutputsBackup.getBuildDirectory());
                    params.getSnapshotsDir().set(this.$taskOutputsBackup.getSnapshotsDir());
                    params.getMetricsReporter().set((Object)this.this$0.getBuildMetrics());
                }
            }
        };
        workQueue2.submit(GradleKotlinCompilerWorkAction.class, new Action(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void execute(Object p0) {
                this.function.invoke(p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)workQueue2, (String)"workQueue");
        return workQueue2;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerRunnerWithWorkers$GradleKotlinCompilerWorkAction;", "Lorg/gradle/workers/WorkAction;", "Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerRunnerWithWorkers$GradleKotlinCompilerWorkParameters;", "fileSystemOperations", "Lorg/gradle/api/file/FileSystemOperations;", "(Lorg/gradle/api/file/FileSystemOperations;)V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "execute", "", "kotlin-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\nGradleCompilerRunnerWithWorkers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleCompilerRunnerWithWorkers.kt\norg/jetbrains/kotlin/compilerRunner/GradleCompilerRunnerWithWorkers$GradleKotlinCompilerWorkAction\n+ 2 BuildMetricsReporter.kt\norg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporterKt\n*L\n1#1,105:1\n24#2,5:106\n*E\n*S KotlinDebug\n*F\n+ 1 GradleCompilerRunnerWithWorkers.kt\norg/jetbrains/kotlin/compilerRunner/GradleCompilerRunnerWithWorkers$GradleKotlinCompilerWorkAction\n*L\n85#1,5:106\n*E\n"})
    public static abstract class GradleKotlinCompilerWorkAction
    implements WorkAction<GradleKotlinCompilerWorkParameters> {
        @NotNull
        private final FileSystemOperations fileSystemOperations;
        private final Logger logger;

        @Inject
        public GradleKotlinCompilerWorkAction(@NotNull FileSystemOperations fileSystemOperations) {
            Intrinsics.checkNotNullParameter((Object)fileSystemOperations, (String)"fileSystemOperations");
            this.fileSystemOperations = fileSystemOperations;
            this.logger = Logging.getLogger((String)"kotlin-compile-worker");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void execute() {
            TaskOutputsBackup taskOutputsBackup;
            if (((GradleKotlinCompilerWorkParameters)this.getParameters()).getSnapshotsDir().isPresent()) {
                DirectoryProperty directoryProperty = ((GradleKotlinCompilerWorkParameters)this.getParameters()).getBuildDir();
                Provider provider = (Provider)((GradleKotlinCompilerWorkParameters)this.getParameters()).getSnapshotsDir();
                Object object = ((GradleKotlinCompilerWorkParameters)this.getParameters()).getTaskOutputsToRestore().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.taskOutputsToRestore.get()");
                List list2 = (List)object;
                Logger logger = this.logger;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
                taskOutputsBackup = new TaskOutputsBackup(this.fileSystemOperations, directoryProperty, (Provider<Directory>)provider, list2, logger);
            } else {
                taskOutputsBackup = null;
            }
            TaskOutputsBackup taskOutputsBackup2 = taskOutputsBackup;
            try {
                Object object = ((GradleKotlinCompilerWorkParameters)this.getParameters()).getCompilerWorkArguments().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.compilerWorkArguments.get()");
                new GradleKotlinCompilerWork((GradleKotlinCompilerWorkArguments)object).run();
            }
            catch (FailedCompilationException e) {
                if (taskOutputsBackup2 != null && (e instanceof CompilationErrorException || e instanceof OOMErrorException)) {
                    void $this$measure$iv;
                    Object object = ((GradleKotlinCompilerWorkParameters)this.getParameters()).getMetricsReporter().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.metricsReporter.get()");
                    BuildMetricsReporter buildMetricsReporter = (BuildMetricsReporter)object;
                    BuildTime time$iv = BuildTime.RESTORE_OUTPUT_FROM_BACKUP;
                    boolean $i$f$measure = false;
                    $this$measure$iv.startMeasure(time$iv);
                    try {
                        boolean bl = false;
                        this.logger.info("Restoring task outputs to pre-compilation state");
                        taskOutputsBackup2.restoreOutputs();
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        $this$measure$iv.endMeasure(time$iv);
                    }
                }
                throw e;
            }
            finally {
                TaskOutputsBackup taskOutputsBackup3 = taskOutputsBackup2;
                if (taskOutputsBackup3 != null) {
                    taskOutputsBackup3.deleteSnapshot();
                }
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b`\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\nR\u0012\u0010\u000e\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0005R\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerRunnerWithWorkers$GradleKotlinCompilerWorkParameters;", "Lorg/gradle/workers/WorkParameters;", "buildDir", "Lorg/gradle/api/file/DirectoryProperty;", "getBuildDir", "()Lorg/gradle/api/file/DirectoryProperty;", "compilerWorkArguments", "Lorg/gradle/api/provider/Property;", "Lorg/jetbrains/kotlin/compilerRunner/GradleKotlinCompilerWorkArguments;", "getCompilerWorkArguments", "()Lorg/gradle/api/provider/Property;", "metricsReporter", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "getMetricsReporter", "snapshotsDir", "getSnapshotsDir", "taskOutputsToRestore", "Lorg/gradle/api/provider/ListProperty;", "Ljava/io/File;", "getTaskOutputsToRestore", "()Lorg/gradle/api/provider/ListProperty;", "kotlin-gradle-plugin_common"})
    public static interface GradleKotlinCompilerWorkParameters
    extends WorkParameters {
        @NotNull
        public Property<GradleKotlinCompilerWorkArguments> getCompilerWorkArguments();

        @NotNull
        public ListProperty<File> getTaskOutputsToRestore();

        @NotNull
        public DirectoryProperty getSnapshotsDir();

        @NotNull
        public DirectoryProperty getBuildDir();

        @NotNull
        public Property<BuildMetricsReporter> getMetricsReporter();
    }
}

