/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildAttributeKind;
import org.jetbrains.kotlin.build.report.metrics.BuildAttributes;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.BuildTimes;
import org.jetbrains.kotlin.build.report.metrics.ValueType;
import org.jetbrains.kotlin.gradle.plugin.stat.GradleBuildStartParameters;
import org.jetbrains.kotlin.gradle.report.PlainTextBuildReportWriter;
import org.jetbrains.kotlin.gradle.report.PlainTextBuildReportWriterKt;
import org.jetbrains.kotlin.gradle.report.TextTable;
import org.jetbrains.kotlin.gradle.report.data.BuildExecutionData;
import org.jetbrains.kotlin.gradle.report.data.BuildOperationRecord;
import org.jetbrains.kotlin.gradle.utils.FormattingUtilsKt;
import org.jetbrains.kotlin.gradle.utils.Printer;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u0004\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0005H\u0002J\u0018\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\"\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010#\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/gradle/report/PlainTextBuildReportWriter;", "Ljava/io/Serializable;", "outputFile", "Ljava/io/File;", "printMetrics", "", "(Ljava/io/File;Z)V", "p", "Lorg/jetbrains/kotlin/gradle/utils/Printer;", "printBuildAttributes", "", "buildAttributes", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttributes;", "printBuildInfo", "build", "Lorg/jetbrains/kotlin/gradle/report/data/BuildExecutionData;", "printBuildPerformanceMetrics", "buildMetrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildPerformanceMetrics;", "printBuildReport", "printBuildTimes", "buildTimes", "Lorg/jetbrains/kotlin/build/report/metrics/BuildTimes;", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetrics;", "newLineBetweenSections", "printSizeMetric", "sizeMetric", "Lorg/jetbrains/kotlin/build/report/metrics/BuildPerformanceMetric;", "value", "", "printTaskLog", "task", "Lorg/jetbrains/kotlin/gradle/report/data/BuildOperationRecord;", "printTaskOverview", "printTasksLog", "process", "log", "Lorg/gradle/api/logging/Logger;", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nPlainTextBuildReportWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlainTextBuildReportWriter.kt\norg/jetbrains/kotlin/gradle/report/PlainTextBuildReportWriter\n+ 2 Printer.kt\norg/jetbrains/kotlin/gradle/utils/Printer\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,266:1\n70#2,10:267\n69#2,11:277\n70#2,7:288\n78#2,2:296\n70#2,7:298\n78#2,2:323\n70#2,7:325\n78#2,2:334\n69#2,8:336\n78#2,2:346\n1#3:295\n1477#4:305\n1502#4,3:306\n1505#4,3:316\n1549#4:319\n1620#4,3:320\n1855#4,2:332\n1855#4,2:344\n1855#4,2:348\n361#5,7:309\n*E\n*S KotlinDebug\n*F\n+ 1 PlainTextBuildReportWriter.kt\norg/jetbrains/kotlin/gradle/report/PlainTextBuildReportWriter\n*L\n63#1,10:267\n96#1,11:277\n125#1,7:288\n125#1,2:296\n157#1,7:298\n157#1,2:323\n214#1,7:325\n214#1,2:334\n104#1,8:336\n104#1,2:346\n158#1:305\n158#1,3:306\n158#1,3:316\n160#1:319\n160#1,3:320\n215#1,2:332\n105#1,2:344\n109#1,2:348\n158#1,7:309\n*E\n"})
public final class PlainTextBuildReportWriter
implements Serializable {
    @NotNull
    private final File outputFile;
    private final boolean printMetrics;
    private Printer p;

    public PlainTextBuildReportWriter(@NotNull File outputFile2, boolean printMetrics) {
        Intrinsics.checkNotNullParameter((Object)outputFile2, (String)"outputFile");
        this.outputFile = outputFile2;
        this.printMetrics = printMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(@NotNull BuildExecutionData build, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)build, (String)"build");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        String string = this.outputFile.toPath().toUri().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"outputFile.toPath().toUri().toString()");
        String buildReportPath = string;
        try {
            this.outputFile.getParentFile().mkdirs();
            if (!this.outputFile.getParentFile().exists() || !this.outputFile.getParentFile().isDirectory()) {
                log.error("Kotlin build report cannot be created: '" + this.outputFile + ".parentFile' is a file or do not have permissions to create");
                return;
            }
            Object object = this.outputFile;
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            Object object3 = object;
            object = (object3 = (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2)) instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
            object2 = null;
            try {
                BufferedWriter writer = (BufferedWriter)object;
                boolean bl = false;
                this.p = new Printer(writer, null, null, 6, null);
                this.printBuildReport(build);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            log.lifecycle("Kotlin build report is written to " + buildReportPath);
        }
        catch (Exception e) {
            log.error("Could not write Kotlin build report to " + buildReportPath, (Throwable)e);
        }
    }

    private final void printBuildReport(BuildExecutionData build) {
        this.printBuildInfo(build);
        if (this.printMetrics) {
            this.printMetrics(build.getAggregatedMetrics(), true);
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                printer = null;
            }
            printer.println(new String[0]);
        }
        this.printTaskOverview(build);
        this.printTasksLog(build);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printBuildInfo(BuildExecutionData build) {
        void this_$iv;
        String[] stringArray = this.p;
        if (this.p == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            stringArray = null;
        }
        String[] stringArray2 = stringArray;
        String headLine$iv = "Gradle start parameters:";
        boolean $i$f$withIndent = false;
        String[] stringArray3 = new String[]{headLine$iv};
        this_$iv.println(stringArray3);
        this_$iv.pushIndent();
        try {
            boolean bl = false;
            GradleBuildStartParameters it = build.getStartParameters();
            boolean bl2 = false;
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                printer = null;
            }
            String[] stringArray4 = new String[]{"tasks = " + it.getTasks()};
            printer.println(stringArray4);
            Printer printer2 = this.p;
            if (printer2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                printer2 = null;
            }
            stringArray4 = new String[]{"excluded tasks = " + it.getExcludedTasks()};
            printer2.println(stringArray4);
            Printer printer3 = this.p;
            if (printer3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                printer3 = null;
            }
            stringArray4 = new String[]{"current dir = " + it.getCurrentDir()};
            printer3.println(stringArray4);
            Printer printer4 = this.p;
            if (printer4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                printer4 = null;
            }
            stringArray4 = new String[]{"project properties args = " + it.getProjectProperties()};
            printer4.println(stringArray4);
            Printer printer5 = this.p;
            if (printer5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                printer5 = null;
            }
            stringArray4 = new String[]{" system properties args = " + it.getSystemProperties()};
            printer5.println(stringArray4);
            stringArray3 = Unit.INSTANCE;
        }
        finally {
            this_$iv.popIndent();
        }
        Printer printer = this.p;
        if (printer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            printer = null;
        }
        printer.println(new String[0]);
        if (!((Collection)build.getFailureMessages()).isEmpty()) {
            Printer printer6 = this.p;
            if (printer6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                printer6 = null;
            }
            stringArray2 = new String[]{"Build failed: " + build.getFailureMessages()};
            printer6.println(stringArray2);
            Printer printer7 = this.p;
            if (printer7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                printer7 = null;
            }
            printer7.println(new String[0]);
        }
    }

    private final void printMetrics(BuildMetrics buildMetrics, boolean newLineBetweenSections) {
        this.printBuildTimes(buildMetrics.getBuildTimes());
        if (newLineBetweenSections) {
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                printer = null;
            }
            printer.println(new String[0]);
        }
        this.printBuildPerformanceMetrics(buildMetrics.getBuildPerformanceMetrics());
        if (newLineBetweenSections) {
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                printer = null;
            }
            printer.println(new String[0]);
        }
        this.printBuildAttributes(buildMetrics.getBuildAttributes());
    }

    static /* synthetic */ void printMetrics$default(PlainTextBuildReportWriter plainTextBuildReportWriter, BuildMetrics buildMetrics, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        plainTextBuildReportWriter.printMetrics(buildMetrics, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void printBuildTimes(BuildTimes buildTimes) {
        Map buildTimesMs = buildTimes.asMapMs();
        if (buildTimesMs.isEmpty()) {
            return;
        }
        Printer printer = this.p;
        if (printer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            printer = null;
        }
        String[] stringArray = new String[]{"Time metrics:"};
        printer.println(stringArray);
        Printer printer2 = this.p;
        if (printer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            printer2 = null;
        }
        Printer $this$iv = printer2;
        Object headLine$iv = null;
        boolean $i$f$withIndent = false;
        $this$iv.pushIndent();
        try {
            boolean bl = false;
            HashSet<BuildTime> visitedBuildTimes = new HashSet<BuildTime>();
            for (BuildTime buildTime : BuildTime.values()) {
                if (buildTime.getParent() != null) continue;
                PlainTextBuildReportWriter.printBuildTimes$lambda$6$printBuildTime(visitedBuildTimes, buildTimesMs, this, buildTime);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$iv.popIndent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printBuildPerformanceMetrics(BuildPerformanceMetrics buildMetrics) {
        void this_$iv;
        Map allBuildMetrics = buildMetrics.asMap();
        if (allBuildMetrics.isEmpty()) {
            return;
        }
        Printer printer = this.p;
        if (printer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            printer = null;
        }
        Printer printer2 = printer;
        String headLine$iv = "Size metrics:";
        boolean $i$f$withIndent = false;
        String[] stringArray = new String[]{headLine$iv};
        this_$iv.println(stringArray);
        this_$iv.pushIndent();
        try {
            boolean bl = false;
            for (BuildPerformanceMetric metric : BuildPerformanceMetric.values()) {
                Long l = (Long)allBuildMetrics.get(metric);
                if (l == null) continue;
                long it = ((Number)l).longValue();
                boolean bl2 = false;
                this.printSizeMetric(metric, it);
            }
            stringArray = Unit.INSTANCE;
        }
        finally {
            this_$iv.popIndent();
        }
    }

    private final void printSizeMetric(BuildPerformanceMetric sizeMetric, long value) {
        int it;
        int n;
        int indentLevel = PlainTextBuildReportWriter.printSizeMetric$numberOfAncestors(sizeMetric);
        for (n = 0; n < indentLevel; ++n) {
            it = n;
            boolean bl = false;
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                printer = null;
            }
            printer.pushIndent();
        }
        switch (WhenMappings.$EnumSwitchMapping$0[sizeMetric.getType().ordinal()]) {
            case 1: {
                Printer printer = this.p;
                if (printer == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                    printer = null;
                }
                String[] bl = new String[]{sizeMetric.getReadableString() + ": " + FormattingUtilsKt.formatSize(value)};
                printer.println(bl);
                break;
            }
            case 2: {
                Printer printer = this.p;
                if (printer == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                    printer = null;
                }
                String[] bl = new String[]{sizeMetric.getReadableString() + ": " + value};
                printer.println(bl);
            }
        }
        for (n = 0; n < indentLevel; ++n) {
            it = n;
            boolean bl = false;
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                printer = null;
            }
            printer.popIndent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printBuildAttributes(BuildAttributes buildAttributes) {
        void this_$iv;
        Map allAttributes = buildAttributes.asMap();
        if (allAttributes.isEmpty()) {
            return;
        }
        Printer printer = this.p;
        if (printer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            printer = null;
        }
        Printer printer2 = printer;
        String headLine$iv = "Build attributes:";
        boolean $i$f$withIndent = false;
        String[] stringArray = new String[]{headLine$iv};
        this_$iv.println(stringArray);
        this_$iv.pushIndent();
        try {
            void $this$groupByTo$iv$iv;
            boolean bl = false;
            Iterable $this$groupBy$iv = allAttributes.entrySet();
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                BuildAttributeKind key$iv$iv = ((BuildAttribute)it.getKey()).getKind();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            SortedMap attributesByKind = MapsKt.toSortedMap((Map)destination$iv$iv);
            for (Map.Entry entry2 : ((Map)attributesByKind).entrySet()) {
                Collection<Pair> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object element$iv$iv;
                BuildAttributeKind kind = (BuildAttributeKind)entry2.getKey();
                List attributesCounts = (List)entry2.getValue();
                Printer printer3 = this.p;
                if (printer3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                    printer3 = null;
                }
                String string = kind.name();
                Intrinsics.checkNotNullExpressionValue((Object)attributesCounts, (String)"attributesCounts");
                Iterable $i$f$groupByTo2 = attributesCounts;
                String string2 = string;
                Printer printer4 = printer3;
                boolean $i$f$map = false;
                element$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Map.Entry entry3 = (Map.Entry)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl4 = false;
                    BuildAttribute k = (BuildAttribute)entry3.getKey();
                    int v = ((Number)entry3.getValue()).intValue();
                    collection.add(TuplesKt.to((Object)k.getReadableString(), (Object)v));
                }
                collection = (List)destination$iv$iv2;
                PlainTextBuildReportWriterKt.access$printMap(printer4, string2, MapsKt.toMap((Iterable)collection));
            }
            stringArray = Unit.INSTANCE;
        }
        finally {
            this_$iv.popIndent();
        }
    }

    private final void printTaskOverview(BuildExecutionData build) {
        long allTasksTimeMs = 0L;
        long kotlinTotalTimeMs = 0L;
        ArrayList<BuildOperationRecord> kotlinTasks = new ArrayList<BuildOperationRecord>();
        for (BuildOperationRecord buildOperationRecord : build.getBuildOperationRecord()) {
            long taskTimeMs = buildOperationRecord.getTotalTimeMs();
            allTasksTimeMs += taskTimeMs;
            if (!buildOperationRecord.isFromKotlinPlugin()) continue;
            kotlinTotalTimeMs += taskTimeMs;
            kotlinTasks.add(buildOperationRecord);
        }
        if (kotlinTasks.isEmpty()) {
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                printer = null;
            }
            String[] stringArray = new String[]{"No Kotlin task was run"};
            printer.println(stringArray);
            return;
        }
        String ktTaskPercent = FormattingUtilsKt.asString((double)kotlinTotalTimeMs / (double)allTasksTimeMs * (double)100, 1);
        Printer printer = this.p;
        if (printer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            printer = null;
        }
        String[] stringArray = new String[]{"Total time for Kotlin tasks: " + FormattingUtilsKt.formatTime(kotlinTotalTimeMs) + " (" + ktTaskPercent + " % of all tasks time)"};
        printer.println(stringArray);
        String[] stringArray2 = new String[]{"Time", "% of Kotlin time", "Task"};
        TextTable textTable = new TextTable(stringArray2);
        Function1[] function1Array = new Function1[]{printTaskOverview.1.INSTANCE, printTaskOverview.2.INSTANCE};
        for (BuildOperationRecord task3 : CollectionsKt.sortedWith((Iterable)kotlinTasks, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array))) {
            long timeMs = task3.getTotalTimeMs();
            String percent = FormattingUtilsKt.asString((double)timeMs / (double)kotlinTotalTimeMs * (double)100, 1);
            String[] stringArray3 = new String[]{FormattingUtilsKt.formatTime(timeMs), percent + " %", task3.getPath()};
            textTable.addRow(stringArray3);
        }
        Printer printer2 = this.p;
        if (printer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            printer2 = null;
        }
        textTable.printTo(printer2);
        Printer printer3 = this.p;
        if (printer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            printer3 = null;
        }
        printer3.println(new String[0]);
    }

    private final void printTasksLog(BuildExecutionData build) {
        Function1[] function1Array = new Function1[]{printTasksLog.1.INSTANCE, printTasksLog.2.INSTANCE};
        for (BuildOperationRecord task2 : CollectionsKt.sortedWith((Iterable)build.getBuildOperationRecord(), (Comparator)ComparisonsKt.compareBy((Function1[])function1Array))) {
            this.printTaskLog(task2);
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                printer = null;
            }
            printer.println(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printTaskLog(BuildOperationRecord task2) {
        Object object;
        String skipMessage = task2.getSkipMessage();
        if (skipMessage != null) {
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                printer = null;
            }
            object = new String[]{"Task '" + task2.getPath() + "' was skipped: " + skipMessage};
            printer.println((String)object);
        } else {
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                printer = null;
            }
            object = new String[]{"Task '" + task2.getPath() + "' finished in " + FormattingUtilsKt.formatTime(task2.getTotalTimeMs())};
            printer.println((String)object);
        }
        if (!((Collection)task2.getIcLogLines()).isEmpty()) {
            void this_$iv;
            String[] stringArray;
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                printer = null;
            }
            object = printer;
            String headLine$iv = "Compilation log for task '" + task2.getPath() + "':";
            boolean $i$f$withIndent = false;
            if (headLine$iv != null) {
                stringArray = new String[]{headLine$iv};
                this_$iv.println(stringArray);
            }
            this_$iv.pushIndent();
            try {
                boolean bl = false;
                Iterable $this$forEach$iv = task2.getIcLogLines();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    Printer printer2 = this.p;
                    if (printer2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                        printer2 = null;
                    }
                    String[] stringArray2 = new String[]{it};
                    printer2.println(stringArray2);
                }
                stringArray = Unit.INSTANCE;
            }
            finally {
                this_$iv.popIndent();
            }
        }
        if (this.printMetrics) {
            PlainTextBuildReportWriter.printMetrics$default(this, task2.getBuildMetrics(), false, 2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void printBuildTimes$lambda$6$printBuildTime(HashSet<BuildTime> visitedBuildTimes, Map<BuildTime, Long> buildTimesMs, PlainTextBuildReportWriter this$0, BuildTime buildTime) {
        block11: {
            if (!visitedBuildTimes.add(buildTime)) {
                return;
            }
            Long timeMs = buildTimesMs.get(buildTime);
            if (timeMs != null) {
                Printer printer = this$0.p;
                if (printer == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                    printer = null;
                }
                String[] stringArray = new String[]{buildTime.getReadableString() + ": " + FormattingUtilsKt.formatTime(timeMs)};
                printer.println(stringArray);
                Printer printer2 = this$0.p;
                if (printer2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                    printer2 = null;
                }
                Printer $this$iv = printer2;
                Object headLine$iv = null;
                boolean $i$f$withIndent = false;
                $this$iv.pushIndent();
                try {
                    Unit unit;
                    boolean bl = false;
                    List list2 = (List)BuildTime.Companion.getChildren().get(buildTime);
                    if (list2 != null) {
                        Iterable $this$forEach$iv = list2;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            BuildTime it = (BuildTime)element$iv;
                            boolean bl2 = false;
                            PlainTextBuildReportWriter.printBuildTimes$lambda$6$printBuildTime(visitedBuildTimes, buildTimesMs, this$0, it);
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    Unit unit2 = unit;
                }
                finally {
                    $this$iv.popIndent();
                }
            }
            List list3 = (List)BuildTime.Companion.getChildren().get(buildTime);
            if (list3 == null) break block11;
            Iterable $this$forEach$iv = list3;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BuildTime it = (BuildTime)element$iv;
                boolean bl = false;
                PlainTextBuildReportWriter.printBuildTimes$lambda$6$printBuildTime(visitedBuildTimes, buildTimesMs, this$0, it);
            }
        }
    }

    private static final int printSizeMetric$numberOfAncestors(BuildPerformanceMetric $this$printSizeMetric_u24numberOfAncestors) {
        int count = 0;
        for (BuildPerformanceMetric parent = $this$printSizeMetric_u24numberOfAncestors.getParent(); parent != null; parent = parent.getParent()) {
            ++count;
        }
        return count;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValueType.values().length];
            try {
                nArray[ValueType.BYTES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.NUMBER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

