/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.utils.CompatibilityKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00012\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0014\u0010\f\u001a\u00020\b*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0002\u001a\u00020\u0003*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"minSupportedGradleVersion", "", "archivePathCompatible", "Ljava/io/File;", "Lorg/gradle/api/tasks/bundling/AbstractArchiveTask;", "getArchivePathCompatible", "(Lorg/gradle/api/tasks/bundling/AbstractArchiveTask;)Ljava/io/File;", "checkGradleCompatibility", "", "withComponent", "minSupportedVersion", "Lorg/gradle/util/GradleVersion;", "doNotTrackStateCompat", "Lorg/gradle/api/Task;", "because", "kotlin-gradle-plugin_common"})
public final class CompatibilityKt {
    @NotNull
    public static final String minSupportedGradleVersion = "6.8.3";

    public static final void checkGradleCompatibility(@NotNull String withComponent, @NotNull GradleVersion minSupportedVersion) {
        Intrinsics.checkNotNullParameter((Object)withComponent, (String)"withComponent");
        Intrinsics.checkNotNullParameter((Object)minSupportedVersion, (String)"minSupportedVersion");
        GradleVersion currentVersion2 = GradleVersion.current();
        if (currentVersion2.compareTo(minSupportedVersion) < 0) {
            throw new GradleException("The current Gradle version " + currentVersion2.getVersion() + " is not compatible with " + withComponent + ". Please use Gradle " + minSupportedVersion.getVersion() + " or newer, or the previous version of the Kotlin plugin.");
        }
    }

    public static /* synthetic */ void checkGradleCompatibility$default(String string, GradleVersion gradleVersion, int n, Object object) {
        if ((n & 1) != 0) {
            string = "the Kotlin Gradle plugin";
        }
        if ((n & 2) != 0) {
            GradleVersion gradleVersion2 = GradleVersion.version((String)minSupportedGradleVersion);
            Intrinsics.checkNotNullExpressionValue((Object)gradleVersion2, (String)"version(minSupportedGradleVersion)");
            gradleVersion = gradleVersion2;
        }
        CompatibilityKt.checkGradleCompatibility(string, gradleVersion);
    }

    @NotNull
    public static final File getArchivePathCompatible(@NotNull AbstractArchiveTask $this$archivePathCompatible) {
        Intrinsics.checkNotNullParameter((Object)$this$archivePathCompatible, (String)"<this>");
        File file = ((RegularFile)$this$archivePathCompatible.getArchiveFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"archiveFile.get().asFile");
        return file;
    }

    public static final void doNotTrackStateCompat(@NotNull Task $this$doNotTrackStateCompat, @NotNull String because) {
        Intrinsics.checkNotNullParameter((Object)$this$doNotTrackStateCompat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)because, (String)"because");
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"7.3")) < 0) {
            $this$doNotTrackStateCompat.getLogger().info("Not UP-TO-DATE because " + because);
            Function1 function1 = doNotTrackStateCompat.1.INSTANCE;
            $this$doNotTrackStateCompat.getOutputs().upToDateWhen(new Spec(function1){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ boolean isSatisfiedBy(Object p0) {
                    return (Boolean)this.function.invoke(p0);
                }
            });
        } else {
            $this$doNotTrackStateCompat.doNotTrackState(because);
        }
    }
}

