/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.nodejs;

import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.hash.FileHasher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatsService;
import org.jetbrains.kotlin.gradle.targets.js.UtilsKt;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsEnv;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsRootExtension;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsRootPlugin;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsSetupTask;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.PlatformKt;
import org.jetbrains.kotlin.statistics.metrics.IStatisticsValuesConsumer;
import org.jetbrains.kotlin.statistics.metrics.NumericalMetrics;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 >2\u00020\u0001:\u0001>B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u00103\u001a\u000204H\u0007J(\u00105\u001a\u0002042\u0006\u00106\u001a\u00020\u00152\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u000f2\u0006\u0010:\u001a\u000202H\u0002J \u0010;\u001a\u0002042\u0006\u0010<\u001a\u00020\u000f2\u0006\u0010:\u001a\u0002022\u0006\u0010=\u001a\u000202H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8AX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8G\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f8G\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u00158G\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001e\u001a\u00020\u001f8QX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#8aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020\u00158G\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0017R\u001d\u0010(\u001a\u0004\u0018\u00010\u000f8GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010\u001d\u001a\u0004\b)\u0010\u0011R\u0014\u0010+\u001a\u00020,8aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/nodejs/NodeJsSetupTask;", "Lorg/gradle/api/DefaultTask;", "()V", "archiveOperations", "Lorg/gradle/api/file/ArchiveOperations;", "getArchiveOperations$kotlin_gradle_plugin_common", "()Lorg/gradle/api/file/ArchiveOperations;", "configuration", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/artifacts/Configuration;", "getConfiguration$kotlin_gradle_plugin_common", "()Lorg/gradle/api/provider/Provider;", "setConfiguration$kotlin_gradle_plugin_common", "(Lorg/gradle/api/provider/Provider;)V", "destination", "Ljava/io/File;", "getDestination", "()Ljava/io/File;", "destinationHashFile", "getDestinationHashFile", "downloadBaseUrl", "", "getDownloadBaseUrl", "()Ljava/lang/String;", "env", "Lorg/jetbrains/kotlin/gradle/targets/js/nodejs/NodeJsEnv;", "getEnv", "()Lorg/jetbrains/kotlin/gradle/targets/js/nodejs/NodeJsEnv;", "env$delegate", "Lkotlin/Lazy;", "fileHasher", "Lorg/gradle/internal/hash/FileHasher;", "getFileHasher$kotlin_gradle_plugin_common", "()Lorg/gradle/internal/hash/FileHasher;", "fs", "Lorg/gradle/api/file/FileSystemOperations;", "getFs$kotlin_gradle_plugin_common", "()Lorg/gradle/api/file/FileSystemOperations;", "ivyDependency", "getIvyDependency", "nodeJsDist", "getNodeJsDist", "nodeJsDist$delegate", "objects", "Lorg/gradle/api/model/ObjectFactory;", "getObjects$kotlin_gradle_plugin_common", "()Lorg/gradle/api/model/ObjectFactory;", "settings", "Lorg/jetbrains/kotlin/gradle/targets/js/nodejs/NodeJsRootExtension;", "shouldDownload", "", "exec", "", "fixBrokenSymlink", "name", "nodeBinDirPath", "Ljava/nio/file/Path;", "nodeDirProvider", "isWindows", "fixBrokenSymlinks", "destinationDir", "necessaryToFix", "Companion", "kotlin-gradle-plugin_common"})
public abstract class NodeJsSetupTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final transient NodeJsRootExtension settings;
    @NotNull
    private final Lazy env$delegate;
    private final boolean shouldDownload;
    public transient Provider<Configuration> configuration;
    @NotNull
    private final Lazy nodeJsDist$delegate;
    @NotNull
    public static final String NAME = "kotlinNodeJsSetup";

    public NodeJsSetupTask() {
        Project project = this.getProject().getRootProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project.rootProject");
        this.settings = NodeJsRootPlugin.Companion.getKotlinNodeJsExtension(project);
        this.env$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NodeJsEnv>(this){
            final /* synthetic */ NodeJsSetupTask this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final NodeJsEnv invoke() {
                return (NodeJsEnv)NodeJsSetupTask.access$getSettings$p(this.this$0).requireConfigured();
            }
        }));
        this.shouldDownload = this.settings.getDownload();
        this.nodeJsDist$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ NodeJsSetupTask this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final File invoke() {
                File file;
                if (NodeJsSetupTask.access$getShouldDownload$p(this.this$0)) {
                    KotlinBuildStatsService kotlinBuildStatsService;
                    Function1 function1 = (Function1)new Function1<IvyArtifactRepository, Unit>(this.this$0){
                        final /* synthetic */ NodeJsSetupTask this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(IvyArtifactRepository repo2) {
                            repo2.setName("Node Distributions at " + this.this$0.getDownloadBaseUrl());
                            repo2.setUrl(new URI(this.this$0.getDownloadBaseUrl()));
                            Function1 function1 = nodeJsDist.repo.1.INSTANCE;
                            repo2.patternLayout(new Action(function1){
                                private final /* synthetic */ Function1 function;
                                {
                                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                                    this.function = function;
                                }

                                public final /* synthetic */ void execute(Object p0) {
                                    this.function.invoke(p0);
                                }
                            });
                            function1 = nodeJsDist.repo.2.INSTANCE;
                            repo2.metadataSources(new /* invalid duplicate definition of identical inner class */);
                            function1 = nodeJsDist.repo.3.INSTANCE;
                            repo2.content(new /* invalid duplicate definition of identical inner class */);
                        }
                    };
                    IvyArtifactRepository repo2 = this.this$0.getProject().getRepositories().ivy(new /* invalid duplicate definition of identical inner class */);
                    long startDownloadTime = System.currentTimeMillis();
                    Set set2 = ((Configuration)this.this$0.getConfiguration$kotlin_gradle_plugin_common().get()).getFiles();
                    Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"configuration.get().files");
                    File dist = (File)CollectionsKt.single((Iterable)set2);
                    long downloadDuration = System.currentTimeMillis() - startDownloadTime;
                    if (downloadDuration > 0L && (kotlinBuildStatsService = KotlinBuildStatsService.Companion.getInstance()) != null) {
                        IStatisticsValuesConsumer.DefaultImpls.report$default((IStatisticsValuesConsumer)kotlinBuildStatsService, NumericalMetrics.ARTIFACTS_DOWNLOAD_SPEED, dist.length() * (long)1000 / downloadDuration, null, null, 12, null);
                    }
                    this.this$0.getProject().getRepositories().remove((Object)repo2);
                    file = dist;
                } else {
                    file = null;
                }
                return file;
            }
        }));
        Function1 function1 = (Function1)new Function1<Task, Boolean>(){

            @NotNull
            public final Boolean invoke(Task it) {
                return shouldDownload;
            }
        };
        this.onlyIf(new Spec(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ boolean isSatisfiedBy(Object p0) {
                return (Boolean)this.function.invoke(p0);
            }
        });
    }

    private final NodeJsEnv getEnv() {
        Lazy lazy = this.env$delegate;
        return (NodeJsEnv)lazy.getValue();
    }

    @Inject
    @NotNull
    public abstract ArchiveOperations getArchiveOperations$kotlin_gradle_plugin_common();

    @Inject
    @NotNull
    public FileHasher getFileHasher$kotlin_gradle_plugin_common() {
        throw new IllegalStateException("Should be injected".toString());
    }

    @Inject
    @NotNull
    public abstract ObjectFactory getObjects$kotlin_gradle_plugin_common();

    @Inject
    @NotNull
    public abstract FileSystemOperations getFs$kotlin_gradle_plugin_common();

    @Input
    @NotNull
    public final String getIvyDependency() {
        return this.getEnv().getIvyDependency();
    }

    @Input
    @NotNull
    public final String getDownloadBaseUrl() {
        return this.getEnv().getDownloadBaseUrl();
    }

    @OutputDirectory
    @NotNull
    public final File getDestination() {
        return this.getEnv().getNodeDir();
    }

    @OutputFile
    @NotNull
    public final File getDestinationHashFile() {
        File file = this.getDestination().getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"destination.parentFile");
        return FilesKt.resolve((File)file, (String)(this.getDestination().getName() + ".hash"));
    }

    @Internal
    @NotNull
    public final Provider<Configuration> getConfiguration$kotlin_gradle_plugin_common() {
        Provider<Configuration> provider = this.configuration;
        if (provider != null) {
            return provider;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
        return null;
    }

    public final void setConfiguration$kotlin_gradle_plugin_common(@NotNull Provider<Configuration> provider) {
        Intrinsics.checkNotNullParameter(provider, (String)"<set-?>");
        this.configuration = provider;
    }

    @Classpath
    @Optional
    @Nullable
    public final File getNodeJsDist() {
        Lazy lazy = this.nodeJsDist$delegate;
        return (File)lazy.getValue();
    }

    @TaskAction
    public final void exec() {
        if (!this.shouldDownload) {
            return;
        }
        Logger logger = this.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        GradleLoggingUtilsKt.kotlinInfo(logger, "Using node distribution from '" + this.getNodeJsDist() + '\'');
        File file = this.getDestination();
        File file2 = this.getDestinationHashFile();
        File file3 = this.getNodeJsDist();
        Intrinsics.checkNotNull((Object)file3);
        UtilsKt.extractWithUpToDate(file, file2, file3, this.getFileHasher$kotlin_gradle_plugin_common(), (Function2<? super File, ? super File, Unit>)((Function2)new Function2<File, File, Unit>(this){
            final /* synthetic */ NodeJsSetupTask this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull File dist, @NotNull File destination) {
                Intrinsics.checkNotNullParameter((Object)dist, (String)"dist");
                Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
                Ref.BooleanRef fixBrokenSymLinks = new Ref.BooleanRef();
                Function1 function1 = (Function1)new Function1<CopySpec, Unit>(dist, this.this$0, fixBrokenSymLinks, destination){
                    final /* synthetic */ File $dist;
                    final /* synthetic */ NodeJsSetupTask this$0;
                    final /* synthetic */ Ref.BooleanRef $fixBrokenSymLinks;
                    final /* synthetic */ File $destination;
                    {
                        this.$dist = $dist;
                        this.this$0 = $receiver;
                        this.$fixBrokenSymLinks = $fixBrokenSymLinks;
                        this.$destination = $destination;
                        super(1);
                    }

                    public final void invoke(CopySpec it) {
                        FileTree fileTree;
                        Object[] objectArray = new Object[1];
                        String string = this.$dist.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dist.name");
                        if (StringsKt.endsWith$default((String)string, (String)"zip", (boolean)false, (int)2, null)) {
                            fileTree = this.this$0.getArchiveOperations$kotlin_gradle_plugin_common().zipTree((Object)this.$dist);
                        } else {
                            this.$fixBrokenSymLinks.element = true;
                            fileTree = this.this$0.getArchiveOperations$kotlin_gradle_plugin_common().tarTree((Object)this.$dist);
                        }
                        objectArray[0] = fileTree;
                        it.from(objectArray);
                        it.into((Object)this.$destination);
                    }
                };
                this.this$0.getFs$kotlin_gradle_plugin_common().copy(new /* invalid duplicate definition of identical inner class */);
                NodeJsSetupTask.access$fixBrokenSymlinks(this.this$0, destination, NodeJsSetupTask.access$getEnv(this.this$0).isWindows(), fixBrokenSymLinks.element);
                if (!NodeJsSetupTask.access$getEnv(this.this$0).isWindows()) {
                    new File(NodeJsSetupTask.access$getEnv(this.this$0).getNodeExecutable()).setExecutable(true);
                }
            }
        }));
    }

    private final void fixBrokenSymlinks(File destinationDir, boolean isWindows, boolean necessaryToFix) {
        if (necessaryToFix) {
            Path nodeBinDir = PlatformKt.computeNodeBinDir(destinationDir, isWindows).toPath();
            Intrinsics.checkNotNullExpressionValue((Object)nodeBinDir, (String)"nodeBinDir");
            this.fixBrokenSymlink("npm", nodeBinDir, destinationDir, isWindows);
            this.fixBrokenSymlink("npx", nodeBinDir, destinationDir, isWindows);
        }
    }

    private final void fixBrokenSymlink(String name2, Path nodeBinDirPath, File nodeDirProvider, boolean isWindows) {
        Path script = nodeBinDirPath.resolve(name2);
        String scriptFile = PlatformKt.computeNpmScriptFile(nodeDirProvider, name2, isWindows);
        if (Files.deleteIfExists(script)) {
            Files.createSymbolicLink(script, nodeBinDirPath.relativize(Paths.get(scriptFile, new String[0])), new FileAttribute[0]);
        }
    }

    public static final /* synthetic */ void access$fixBrokenSymlinks(NodeJsSetupTask $this, File destinationDir, boolean isWindows, boolean necessaryToFix) {
        $this.fixBrokenSymlinks(destinationDir, isWindows, necessaryToFix);
    }

    public static final /* synthetic */ NodeJsEnv access$getEnv(NodeJsSetupTask $this) {
        return $this.getEnv();
    }

    public static final /* synthetic */ NodeJsRootExtension access$getSettings$p(NodeJsSetupTask $this) {
        return $this.settings;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/nodejs/NodeJsSetupTask$Companion;", "", "()V", "NAME", "", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

