/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.testing.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceSpec;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.testing.internal.TestReportService;
import org.jetbrains.kotlin.gradle.testing.internal.UsesTestReportService;
import org.jetbrains.kotlin.gradle.utils.SingleActionPerProject;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0010\b \u0018\u0000 )2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002)*B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0018\u001a\u00020\u0019H\u0016J(\u0010\u001a\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u00060\u0015j\u0002`\u00160\u0014j\u0002`\u00170\u001b2\u0006\u0010\u001c\u001a\u00020\u000eJ\u000e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u000eJ\u000e\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u000eJ\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\"\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u000e2\n\u0010$\u001a\u00060\u0015j\u0002`\u0016J\u0016\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u000eJ\b\u0010(\u001a\u00020\u0019H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u0012\u001a(\u0012\u0004\u0012\u00020\u000e\u0012\u001e\u0012\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u00060\u0015j\u0002`\u00160\u0014j\u0002`\u00170\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/gradle/testing/internal/TestReportService;", "Lorg/gradle/api/services/BuildService;", "Lorg/jetbrains/kotlin/gradle/testing/internal/TestReportService$TestReportServiceParameters;", "Ljava/lang/AutoCloseable;", "()V", "binaryStateFile", "Ljava/io/File;", "getBinaryStateFile", "()Ljava/io/File;", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "previouslyFailedTestTasks", "", "", "reportHasFailedTests", "Ljava/util/concurrent/ConcurrentHashMap;", "", "testTaskSuppressedFailures", "", "Lkotlin/Pair;", "Ljava/lang/Error;", "Lkotlin/Error;", "Lorg/jetbrains/kotlin/gradle/testing/internal/TaskError;", "close", "", "getAggregatedTaskFailures", "", "taskPath", "hasFailedTests", "path", "hasTestTaskFailedPreviously", "readPreviouslyFailedTasks", "reportFailure", "failedTaskPath", "parentTaskPath", "failure", "testFailed", "reportTaskPath", "testTaskPath", "writePreviouslyFailedTasks", "Companion", "TestReportServiceParameters", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nTestReportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestReportService.kt\norg/jetbrains/kotlin/gradle/testing/internal/TestReportService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1360#2:130\n1446#2,2:131\n1549#2:133\n1620#2,3:134\n1448#2,3:137\n*E\n*S KotlinDebug\n*F\n+ 1 TestReportService.kt\norg/jetbrains/kotlin/gradle/testing/internal/TestReportService\n*L\n102#1:130\n102#1,2:131\n102#1:133\n102#1,3:134\n102#1,3:137\n*E\n"})
public abstract class TestReportService
implements BuildService<TestReportServiceParameters>,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger log = Logging.getLogger(this.getClass());
    @NotNull
    private final Set<String> previouslyFailedTestTasks = this.readPreviouslyFailedTasks();
    @NotNull
    private final ConcurrentHashMap<String, Boolean> reportHasFailedTests = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<String, List<Pair<String, Error>>> testTaskSuppressedFailures = new ConcurrentHashMap();

    public final void testFailed(@NotNull String reportTaskPath, @NotNull String testTaskPath) {
        Intrinsics.checkNotNullParameter((Object)reportTaskPath, (String)"reportTaskPath");
        Intrinsics.checkNotNullParameter((Object)testTaskPath, (String)"testTaskPath");
        ((Map)this.reportHasFailedTests).put(reportTaskPath, true);
        this.previouslyFailedTestTasks.add(testTaskPath);
    }

    public final boolean hasFailedTests(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Boolean bl = this.reportHasFailedTests.get(path);
        return bl == null ? false : bl;
    }

    public final void reportFailure(@NotNull String failedTaskPath, @NotNull String parentTaskPath, @NotNull Error failure) {
        Intrinsics.checkNotNullParameter((Object)failedTaskPath, (String)"failedTaskPath");
        Intrinsics.checkNotNullParameter((Object)parentTaskPath, (String)"parentTaskPath");
        Intrinsics.checkNotNullParameter((Object)failure, (String)"failure");
        Function1 function1 = reportFailure.1.INSTANCE;
        this.testTaskSuppressedFailures.computeIfAbsent(parentTaskPath, new Function(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object apply(Object p0) {
                return this.function.invoke(p0);
            }
        }).add((Pair<String, Error>)TuplesKt.to((Object)failedTaskPath, (Object)failure));
    }

    @NotNull
    public final List<Pair<String, Error>> getAggregatedTaskFailures(@NotNull String taskPath) {
        Intrinsics.checkNotNullParameter((Object)taskPath, (String)"taskPath");
        List list2 = this.testTaskSuppressedFailures.get(taskPath);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Override
    public void close() {
        this.writePreviouslyFailedTasks();
    }

    public final boolean hasTestTaskFailedPreviously(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.previouslyFailedTestTasks.remove(path);
    }

    private final File getBinaryStateFile() {
        File file = ((RegularFile)((TestReportServiceParameters)this.getParameters()).getTestTasksStateFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"parameters.testTasksStateFile.get().asFile");
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<String> readPreviouslyFailedTasks() {
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet()");
        Set failedTasksSet = keySetView;
        if (!this.getBinaryStateFile().exists()) {
            return failedTasksSet;
        }
        try {
            Closeable closeable = new ObjectInputStream(new FileInputStream(this.getBinaryStateFile()));
            Throwable throwable = null;
            try {
                ObjectInputStream it = (ObjectInputStream)closeable;
                boolean bl = false;
                Object object = it.readObject();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Set<kotlin.String>");
                boolean bl2 = failedTasksSet.addAll((Set)object);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            this.log.error("Cannot read test tasks state from " + this.getBinaryStateFile(), (Throwable)e);
        }
        return failedTasksSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void writePreviouslyFailedTasks() {
        void $this$flatMapTo$iv$iv;
        Object object = this.previouslyFailedTestTasks;
        Collection<List<Pair<String, Error>>> collection = this.testTaskSuppressedFailures.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"testTaskSuppressedFailures.values");
        Iterable $this$flatMap$iv = collection;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            List taskErrors = (List)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)taskErrors, (String)"taskErrors");
            Iterable $this$map$iv = taskErrors;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                String taskPath = (String)pair.component1();
                collection2.add(taskPath);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Object object2 = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)object, (Iterable)object2);
        this.getBinaryStateFile().getParentFile().mkdirs();
        try {
            object = new ObjectOutputStream(new FileOutputStream(this.getBinaryStateFile()));
            object2 = null;
            try {
                ObjectOutputStream it = (ObjectOutputStream)object;
                boolean bl = false;
                it.writeObject(CollectionsKt.toSet((Iterable)this.previouslyFailedTestTasks));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        catch (Exception e) {
            this.log.error("Cannot store test tasks state into " + this.getBinaryStateFile(), (Throwable)e);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/testing/internal/TestReportService$Companion;", "", "()V", "registerIfAbsent", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/testing/internal/TestReportService;", "project", "Lorg/gradle/api/Project;", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Provider<TestReportService> registerIfAbsent(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Function1 function1 = (Function1)new Function1<BuildServiceSpec<TestReportServiceParameters>, Unit>(project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(1);
                }

                public final void invoke(BuildServiceSpec<TestReportServiceParameters> spec) {
                    RegularFileProperty regularFileProperty = ((TestReportServiceParameters)spec.getParameters()).getTestTasksStateFile();
                    File file = this.$project.getBuildDir();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
                    regularFileProperty.set(FilesKt.resolve((File)file, (String)"test-results/kotlin-test-tasks-state.bin"));
                }
            };
            Function1 serviceProvider = function1 = project.getGradle().getSharedServices().registerIfAbsent(TestReportService.class.getCanonicalName() + '_' + project.getPath(), TestReportService.class, new Action(function1){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ void execute(Object p0) {
                    this.function.invoke(p0);
                }
            });
            boolean bl = false;
            String string = UsesTestReportService.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UsesTestReportService::class.java.name");
            SingleActionPerProject.INSTANCE.run(project, string, (Function0<Unit>)((Function0)new Function0<Unit>(project, (Provider<TestReportService>)serviceProvider){
                final /* synthetic */ Project $project;
                final /* synthetic */ Provider<TestReportService> $serviceProvider;
                {
                    this.$project = $project;
                    this.$serviceProvider = $serviceProvider;
                    super(0);
                }

                public final void invoke() {
                    TaskContainer taskContainer = this.$project.getTasks();
                    Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
                    TaskCollection $this$withType$iv = (TaskCollection)taskContainer;
                    boolean $i$f$withType = false;
                    TaskCollection taskCollection = $this$withType$iv.withType(UsesTestReportService.class);
                    Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"withType(S::class.java)");
                    Function1 function1 = (Function1)new Function1<UsesTestReportService, Unit>(this.$serviceProvider){
                        final /* synthetic */ Provider<TestReportService> $serviceProvider;
                        {
                            this.$serviceProvider = $serviceProvider;
                            super(1);
                        }

                        public final void invoke(UsesTestReportService task2) {
                            task2.usesService(this.$serviceProvider);
                        }
                    };
                    taskCollection.configureEach(new /* invalid duplicate definition of identical inner class */);
                }
            }));
            Function1 function12 = function1;
            Intrinsics.checkNotNullExpressionValue((Object)function12, (String)"project: Project): Provi\u2026      }\n                }");
            return function12;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b`\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/gradle/testing/internal/TestReportService$TestReportServiceParameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "testTasksStateFile", "Lorg/gradle/api/file/RegularFileProperty;", "getTestTasksStateFile", "()Lorg/gradle/api/file/RegularFileProperty;", "kotlin-gradle-plugin_common"})
    public static interface TestReportServiceParameters
    extends BuildServiceParameters {
        @NotNull
        public RegularFileProperty getTestTasksStateFile();
    }
}

