/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginLifecycle;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginLifecycleKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.internal.DeprecationDiagnosticsKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.internal.HierarchicalStructureMigrationHandlingKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.internal.ReportDeprecatedPreHmppDependenciesKt;
import org.jetbrains.kotlin.gradle.plugin.sources.InternalKotlinSourceSetKt;
import org.jetbrains.kotlin.gradle.utils.GradleAttributesContainerUtilsKt;
import org.jetbrains.kotlin.gradle.utils.RunProjectConfigurationHealthCheckKt;
import org.jetbrains.kotlin.gradle.utils.SingleWarningPerBuild;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0000\u001a\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\f\u0010\u0011\u001a\u00020\b*\u00020\nH\u0002\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"deprecatedMppProperties", "", "", "getDeprecatedMppProperties", "()Ljava/util/List;", "propertiesSetByPlugin", "", "checkAndReportDeprecatedMppProperties", "", "project", "Lorg/gradle/api/Project;", "checkAndReportDeprecatedNativeTargets", "checkAndReportDeprecatedSourceSetsLayouts", "getMppDeprecationWarningMessageForProperty", "property", "reportTargetsWithNonUniqueConsumableConfigurations", "runDeprecationDiagnostics", "reportCommonMainDependsOnOtherSourceSets", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\ndeprecationDiagnostics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 deprecationDiagnostics.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/internal/DeprecationDiagnosticsKt\n+ 2 runProjectConfigurationHealthCheck.kt\norg/jetbrains/kotlin/gradle/utils/RunProjectConfigurationHealthCheckKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n102#2,4:137\n766#3:141\n857#3,2:142\n1603#3,9:144\n1855#3:153\n1856#3:156\n1612#3:157\n1855#3,2:158\n1#4:154\n1#4:155\n*E\n*S KotlinDebug\n*F\n+ 1 deprecationDiagnostics.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/internal/DeprecationDiagnosticsKt\n*L\n31#1,4:137\n40#1:141\n40#1,2:142\n90#1,9:144\n90#1:153\n90#1:156\n90#1:157\n98#1,2:158\n90#1:155\n*E\n"})
public final class DeprecationDiagnosticsKt {
    @NotNull
    private static final List<String> deprecatedMppProperties;
    @NotNull
    private static final Set<String> propertiesSetByPlugin;

    public static final void runDeprecationDiagnostics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DeprecationDiagnosticsKt.checkAndReportDeprecatedMppProperties(project);
        HierarchicalStructureMigrationHandlingKt.handleHierarchicalStructureFlagsMigration(project);
        DeprecationDiagnosticsKt.checkAndReportDeprecatedSourceSetsLayouts(project);
        Project $this$runProjectConfigurationHealthCheckWhenEvaluated$iv = project;
        boolean $i$f$runProjectConfigurationHealthCheckWhenEvaluated = false;
        KotlinPluginLifecycleKt.launchInStage($this$runProjectConfigurationHealthCheckWhenEvaluated$iv, KotlinPluginLifecycle.Stage.ReadyForExecution, (Function2<? super KotlinPluginLifecycle, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<KotlinPluginLifecycle, Continuation<? super Unit>, Object>($this$runProjectConfigurationHealthCheckWhenEvaluated$iv, null, project){
            int label;
            final /* synthetic */ Project $this_runProjectConfigurationHealthCheckWhenEvaluated;
            final /* synthetic */ Project $project$inlined;
            {
                this.$this_runProjectConfigurationHealthCheckWhenEvaluated = $receiver;
                this.$project$inlined = project;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Project $this$runProjectConfigurationHealthCheck$iv = this.$this_runProjectConfigurationHealthCheckWhenEvaluated;
                        boolean $i$f$runProjectConfigurationHealthCheck = false;
                        if (!($this$runProjectConfigurationHealthCheck$iv.getState().getFailure() != null || RunProjectConfigurationHealthCheckKt.access$inLenientMode($this$runProjectConfigurationHealthCheck$iv) && RunProjectConfigurationHealthCheckKt.access$syncExceptionsAreNotEmpty($this$runProjectConfigurationHealthCheck$iv))) {
                            boolean bl = false;
                            DeprecationDiagnosticsKt.access$checkAndReportDeprecatedNativeTargets(this.$project$inlined);
                            DeprecationDiagnosticsKt.access$reportTargetsWithNonUniqueConsumableConfigurations(this.$project$inlined);
                            ReportDeprecatedPreHmppDependenciesKt.checkAndReportPreHmppDependenciesUsage$default(this.$project$inlined, null, 2, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull KotlinPluginLifecycle p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkAndReportDeprecatedNativeTargets(Project project) {
        void $this$filterTo$iv$iv;
        NamedDomainObjectCollection<KotlinTarget> targets = ((KotlinMultiplatformExtension)project.getExtensions().getByType(KotlinMultiplatformExtension.class)).getTargets();
        Iterable $this$filter$iv = (Iterable)targets;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KotlinTarget it = (KotlinTarget)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof KotlinNativeTarget && KonanTarget.Companion.getDeprecatedTargets().contains(((KotlinNativeTarget)it).getKonanTarget()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List usedDeprecatedTargets = (List)destination$iv$iv;
        if (usedDeprecatedTargets.isEmpty()) {
            return;
        }
        SingleWarningPerBuild.INSTANCE.show(project, "w: The following deprecated Kotlin/Native targets were used in the project: " + CollectionsKt.joinToString$default((Iterable)usedDeprecatedTargets, null, null, null, (int)0, null, (Function1)checkAndReportDeprecatedNativeTargets.1.INSTANCE, (int)31, null));
    }

    private static final void reportTargetsWithNonUniqueConsumableConfigurations(Project project) {
        Function1 function1 = (Function1)new Function1<Project, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(Project it) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                void $this$groupByTo$iv$iv;
                Iterable $this$groupBy$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv;
                NamedDomainObjectCollection<KotlinTarget> allTargets = KotlinProjectExtensionKt.getMultiplatformExtension(this.$project).getTargets();
                Iterable iterable = (Iterable)allTargets;
                Project project = this.$project;
                boolean $i$f$mapNotNull22 = false;
                void var7_8 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach2 = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Pair pair;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    KotlinTarget target2 = (KotlinTarget)element$iv$iv;
                    boolean bl2 = false;
                    if ((Configuration)project.getConfigurations().findByName(target2.getApiElementsConfigurationName()) == null) {
                        pair = null;
                    } else {
                        Configuration configuration;
                        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.configurations.f\u2026?: return@mapNotNull null");
                        pair = TuplesKt.to((Object)target2.getName(), (Object)configuration);
                    }
                    if (pair == null) continue;
                    Pair it$iv$iv = pair;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$groupBy = false;
                void $i$f$mapNotNull22 = $this$groupBy$iv;
                Object destination$iv$iv2 = new LinkedHashMap<K, V>();
                boolean $i$f$groupByTo = false;
                for (T element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object;
                    Pair $i$f$forEach2 = (Pair)element$iv$iv;
                    boolean bl = false;
                    Configuration consumableConfiguration = (Configuration)$i$f$forEach2.component2();
                    AttributeContainer attributeContainer = consumableConfiguration.getAttributes();
                    Intrinsics.checkNotNullExpressionValue((Object)attributeContainer, (String)"consumableConfiguration.attributes");
                    Map<Attribute<?>, Object> key$iv$iv = GradleAttributesContainerUtilsKt.toMap(attributeContainer);
                    Object $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                    boolean $i$f$getOrPut = false;
                    V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl4 = false;
                        List answer$iv$iv$iv = new ArrayList<E>();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                $this$groupBy$iv = destination$iv$iv2.values();
                boolean $i$f$filter = false;
                $this$groupByTo$iv$iv = $this$filter$iv;
                destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    List targetGroup = (List)element$iv$iv;
                    boolean bl = false;
                    if (!(targetGroup.size() > 1)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv2;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void $this$mapTo$iv$iv2;
                    List targetGroup = (List)item$iv$iv;
                    Object object = destination$iv$iv2;
                    boolean bl = false;
                    Iterable $this$map$iv2 = targetGroup;
                    boolean $i$f$map2 = false;
                    Iterable $this$getOrPut$iv$iv$iv = $this$map$iv2;
                    Collection destination$iv$iv3 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (T item$iv$iv2 : $this$mapTo$iv$iv2) {
                        Pair pair = (Pair)item$iv$iv2;
                        Collection collection = destination$iv$iv3;
                        boolean bl5 = false;
                        String targetName2 = (String)pair.component1();
                        collection.add(targetName2);
                    }
                    object.add((List)destination$iv$iv3);
                }
                List nonDistinguishableTargets = (List)destination$iv$iv2;
                if (nonDistinguishableTargets.isEmpty()) {
                    return;
                }
                String nonUniqueTargetsString2 = CollectionsKt.joinToString$default((Iterable)nonDistinguishableTargets, (CharSequence)"\n", null, null, (int)0, null, (Function1)reportTargetsWithNonUniqueConsumableConfigurations.nonUniqueTargetsString.1.INSTANCE, (int)30, null);
                SingleWarningPerBuild.INSTANCE.show(this.$project, "w: The following targets are not distinguishable:\n" + nonUniqueTargetsString2 + "\nUse distinguish attribute. See https://kotlinlang.org/docs/multiplatform-set-up-targets.html#distinguish-several-targets-for-one-platform for more details.");
            }
        };
        project.afterEvaluate(new Action(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void execute(Object p0) {
                this.function.invoke(p0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkAndReportDeprecatedMppProperties(Project project) {
        void $this$mapNotNullTo$iv$iv;
        PropertiesProvider projectProperties = PropertiesProvider.Companion.getKotlinPropertiesProvider$kotlin_gradle_plugin_common(project);
        if (Intrinsics.areEqual((Object)projectProperties.getIgnoreHmppDeprecationWarnings(), (Object)true)) {
            return;
        }
        Iterable $this$mapNotNull$iv = deprecatedMppProperties;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String propertyName = (String)element$iv$iv;
            boolean bl2 = false;
            if (propertiesSetByPlugin.contains(propertyName) && projectProperties.getMpp13XFlagsSetByPlugin()) {
                string = null;
            } else if (projectProperties.property$kotlin_gradle_plugin_common(propertyName) != null) {
                boolean bl3 = false;
                string = DeprecationDiagnosticsKt.getMppDeprecationWarningMessageForProperty(propertyName);
            } else {
                string = null;
            }
            if (string == null) continue;
            String it$iv$iv = string;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List warnings = (List)destination$iv$iv;
        Iterable $this$forEach$iv = warnings;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            String message2 = (String)element$iv;
            boolean bl = false;
            SingleWarningPerBuild.INSTANCE.show(project, message2);
        }
    }

    private static final void checkAndReportDeprecatedSourceSetsLayouts(Project project) {
        DeprecationDiagnosticsKt.reportCommonMainDependsOnOtherSourceSets(project);
    }

    private static final void reportCommonMainDependsOnOtherSourceSets(Project $this$reportCommonMainDependsOnOtherSourceSets) {
        block0: {
            NamedDomainObjectContainer<KotlinSourceSet> namedDomainObjectContainer = KotlinProjectExtensionKt.getMultiplatformExtensionOrNull($this$reportCommonMainDependsOnOtherSourceSets);
            if (namedDomainObjectContainer == null || (namedDomainObjectContainer = namedDomainObjectContainer.getSourceSets()) == null) break block0;
            Function1 function1 = (Function1)new Function1<KotlinSourceSet, Unit>($this$reportCommonMainDependsOnOtherSourceSets){
                final /* synthetic */ Project $this_reportCommonMainDependsOnOtherSourceSets;
                {
                    this.$this_reportCommonMainDependsOnOtherSourceSets = $receiver;
                    super(1);
                }

                public final void invoke(KotlinSourceSet it) {
                    if (Intrinsics.areEqual((Object)it.getName(), (Object)"commonMain")) {
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        InternalKotlinSourceSetKt.getInternal(it).getDependsOn().forAll((Function1<KotlinSourceSet, Unit>)((Function1)new Function1<KotlinSourceSet, Unit>(this.$this_reportCommonMainDependsOnOtherSourceSets){
                            final /* synthetic */ Project $this_reportCommonMainDependsOnOtherSourceSets;
                            {
                                this.$this_reportCommonMainDependsOnOtherSourceSets = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull KotlinSourceSet it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                Project project = this.$this_reportCommonMainDependsOnOtherSourceSets.getProject();
                                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                                SingleWarningPerBuild.INSTANCE.show(project, "w: 'commonMain' source set can't depend on other source sets.");
                            }
                        }));
                    }
                }
            };
            namedDomainObjectContainer.all(new /* invalid duplicate definition of identical inner class */);
        }
    }

    @NotNull
    public static final List<String> getDeprecatedMppProperties() {
        return deprecatedMppProperties;
    }

    @NotNull
    public static final String getMppDeprecationWarningMessageForProperty(@NotNull String property2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        return "w: The property '" + property2 + "' is obsolete and will be removed in Kotlin 1.9.20. Read the details here: https://kotlinlang.org/docs/multiplatform-compatibility-guide.html#deprecate-hmpp-properties";
    }

    public static final /* synthetic */ void access$checkAndReportDeprecatedNativeTargets(Project project) {
        DeprecationDiagnosticsKt.checkAndReportDeprecatedNativeTargets(project);
    }

    public static final /* synthetic */ void access$reportTargetsWithNonUniqueConsumableConfigurations(Project project) {
        DeprecationDiagnosticsKt.reportTargetsWithNonUniqueConsumableConfigurations(project);
    }

    static {
        Object[] objectArray = new String[]{"kotlin.mpp.enableCompatibilityMetadataVariant", "kotlin.mpp.enableGranularSourceSetsMetadata", "kotlin.internal.mpp.hierarchicalStructureByDefault", "kotlin.mpp.hierarchicalStructureSupport", "kotlin.native.enableDependencyPropagation"};
        deprecatedMppProperties = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"kotlin.mpp.enableGranularSourceSetsMetadata", "kotlin.native.enableDependencyPropagation"};
        propertiesSetByPlugin = SetsKt.setOf((Object[])objectArray);
    }
}

