/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.gradle.api.provider.ValueSourceSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compilerRunner.KotlinNativeToolRunner;
import org.jetbrains.kotlin.compilerRunner.NativeToolRunnersKt;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.plugin.internal.ConfigurationTimePropertiesAccessorKt;
import org.jetbrains.kotlin.gradle.targets.native.internal.NativeDistributionType;
import org.jetbrains.kotlin.gradle.targets.native.internal.NativeDistributionTypeProvider;
import org.jetbrains.kotlin.gradle.utils.ConfigurationsKt;
import org.jetbrains.kotlin.gradle.utils.FormattingUtilsKt;
import org.jetbrains.kotlin.gradle.utils.NativeCompilerDownloader;
import org.jetbrains.kotlin.gradle.utils.ResourceUtilsKt;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.util.DependencyDirectories;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 72\u00020\u0001:\u000278B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u000bH\u0002J\b\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u000200H\u0002J\u0006\u00102\u001a\u000200J\u0010\u00103\u001a\u0002002\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u0002052\u0006\u0010\"\u001a\u00020\u0005H\u0002R\u0014\u0010\u0007\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u0014\u0010\u0010\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\tR\u0014\u0010\u0012\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\tR\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001b\u0010\"\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b#\u0010\tR\u0014\u0010&\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\tR\u0014\u0010(\u001a\u00020)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/gradle/utils/NativeCompilerDownloader;", "", "project", "Lorg/gradle/api/Project;", "compilerVersion", "", "(Lorg/gradle/api/Project;Ljava/lang/String;)V", "archiveExtension", "getArchiveExtension", "()Ljava/lang/String;", "compilerDirectory", "Ljava/io/File;", "getCompilerDirectory", "()Ljava/io/File;", "dependencyFileName", "getDependencyFileName", "dependencyName", "getDependencyName", "dependencyNameWithOsAndVersion", "getDependencyNameWithOsAndVersion", "distributionType", "Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionType;", "getDistributionType", "()Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionType;", "kotlinProperties", "Lorg/jetbrains/kotlin/gradle/plugin/PropertiesProvider;", "getKotlinProperties", "()Lorg/jetbrains/kotlin/gradle/plugin/PropertiesProvider;", "logger", "Lorg/gradle/api/logging/Logger;", "getLogger", "()Lorg/gradle/api/logging/Logger;", "getProject", "()Lorg/gradle/api/Project;", "repoUrl", "getRepoUrl", "repoUrl$delegate", "Lkotlin/Lazy;", "simpleOsName", "getSimpleOsName", "useZip", "", "getUseZip", "()Z", "archiveFileTree", "Lorg/gradle/api/file/FileTree;", "archive", "checkClassPath", "", "downloadAndExtract", "downloadIfNeeded", "removeRepo", "repo", "Lorg/gradle/api/artifacts/repositories/ArtifactRepository;", "setupRepo", "Companion", "NativeCompilerDownloaderClassPathChecker", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nNativeCompilerDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeCompilerDownloader.kt\norg/jetbrains/kotlin/gradle/utils/NativeCompilerDownloader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 formattingUtils.kt\norg/jetbrains/kotlin/gradle/utils/FormattingUtilsKt\n*L\n1#1,242:1\n1#2:243\n38#3,7:244\n38#3,7:251\n*S KotlinDebug\n*F\n+ 1 NativeCompilerDownloader.kt\norg/jetbrains/kotlin/gradle/utils/NativeCompilerDownloader\n*L\n163#1:244,7\n170#1:251,7\n*E\n"})
public final class NativeCompilerDownloader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String compilerVersion;
    @NotNull
    private final Lazy repoUrl$delegate;
    @NotNull
    private static final Lazy<String> DEFAULT_KONAN_VERSION$delegate = LazyKt.lazy((Function0)Companion.DEFAULT_KONAN_VERSION.2.INSTANCE);
    private static boolean NEED_TO_DOWNLOAD_FLAG = true;
    @NotNull
    public static final String BASE_DOWNLOAD_URL = "https://download.jetbrains.com/kotlin/native/builds";
    @NotNull
    public static final String KOTLIN_GROUP_ID = "org.jetbrains.kotlin";

    public NativeCompilerDownloader(@NotNull Project project, @NotNull String compilerVersion2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)compilerVersion2, (String)"compilerVersion");
        this.project = project;
        this.compilerVersion = compilerVersion2;
        this.repoUrl$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NativeCompilerDownloader this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                StringBuilder stringBuilder;
                Regex versionPattern = new Regex("(\\d+)\\.(\\d+)(?:\\.(\\d+))?(?:-(\\p{Alpha}*\\p{Alnum}|[\\p{Alpha}-]*))?(?:-(\\d+))?");
                MatchResult matchResult = versionPattern.matchEntire((CharSequence)NativeCompilerDownloader.access$getCompilerVersion$p(this.this$0));
                if (matchResult == null || (matchResult = matchResult.getDestructured()) == null) {
                    throw new IllegalStateException(("Unable to parse version " + NativeCompilerDownloader.access$getCompilerVersion$p(this.this$0)).toString());
                }
                String buildType = (String)matchResult.getMatch().getGroupValues().get(4);
                NativeCompilerDownloader nativeCompilerDownloader = this.this$0;
                StringBuilder $this$invoke_u24lambda_u240 = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$invoke_u24lambda_u240.append(NativeCompilerDownloader.access$getKotlinProperties(nativeCompilerDownloader).getNativeBaseDownloadUrl() + '/');
                Object[] objectArray = new String[]{"RC", "RC2", "Beta", "Beta2"};
                $this$invoke_u24lambda_u240.append(CollectionsKt.listOf((Object[])objectArray).contains(buildType) || ((CharSequence)buildType).length() == 0 ? "releases/" : "dev/");
                $this$invoke_u24lambda_u240.append(NativeCompilerDownloader.access$getCompilerVersion$p(nativeCompilerDownloader) + '/');
                $this$invoke_u24lambda_u240.append(NativeCompilerDownloader.access$getSimpleOsName(nativeCompilerDownloader));
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }
        }));
    }

    public /* synthetic */ NativeCompilerDownloader(Project project, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = NativeToolRunnersKt.getKonanVersion(project);
        }
        this(project, string);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final File getCompilerDirectory() {
        return FilesKt.resolve((File)DependencyDirectories.INSTANCE.getLocalKonanDir(NativeToolRunnersKt.getKonanDataDir(this.project)), (String)this.getDependencyNameWithOsAndVersion());
    }

    private final Logger getLogger() {
        Logger logger = this.project.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"project.logger");
        return logger;
    }

    private final PropertiesProvider getKotlinProperties() {
        return PropertiesProvider.Companion.invoke(this.project);
    }

    private final NativeDistributionType getDistributionType() {
        return new NativeDistributionTypeProvider(this.project).getDistributionType();
    }

    private final String getSimpleOsName() {
        return HostManager.Companion.platformName();
    }

    private final String getDependencyName() {
        String dependencySuffix = this.getDistributionType().getSuffix();
        return dependencySuffix != null ? "kotlin-native-" + dependencySuffix : "kotlin-native";
    }

    private final String getDependencyNameWithOsAndVersion() {
        return this.getDependencyName() + '-' + this.getSimpleOsName() + '-' + this.compilerVersion;
    }

    private final String getDependencyFileName() {
        return this.getDependencyNameWithOsAndVersion() + '.' + this.getArchiveExtension();
    }

    private final boolean getUseZip() {
        return HostManager.Companion.getHostIsMingw();
    }

    private final String getArchiveExtension() {
        return this.getUseZip() ? "zip" : "tar.gz";
    }

    private final FileTree archiveFileTree(File archive) {
        FileTree fileTree;
        if (this.getUseZip()) {
            FileTree fileTree2 = this.project.zipTree((Object)archive);
            fileTree = fileTree2;
            Intrinsics.checkNotNullExpressionValue((Object)fileTree2, (String)"{\n            project.zipTree(archive)\n        }");
        } else {
            FileTree fileTree3 = this.project.tarTree((Object)archive);
            fileTree = fileTree3;
            Intrinsics.checkNotNullExpressionValue((Object)fileTree3, (String)"{\n            project.tarTree(archive)\n        }");
        }
        return fileTree;
    }

    private final ArtifactRepository setupRepo(String repoUrl2) {
        IvyArtifactRepository ivyArtifactRepository = this.project.getRepositories().ivy(new Action(repoUrl2){
            final /* synthetic */ String $repoUrl;
            {
                this.$repoUrl = $repoUrl;
            }

            public final void execute(IvyArtifactRepository repo2) {
                repo2.setUrl((Object)this.$repoUrl);
                repo2.patternLayout((Action)setupRepo.1.INSTANCE);
                repo2.metadataSources((Action)setupRepo.2.INSTANCE);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)ivyArtifactRepository, (String)"repoUrl: String): Artifa\u2026)\n            }\n        }");
        return (ArtifactRepository)ivyArtifactRepository;
    }

    private final void removeRepo(ArtifactRepository repo2) {
        this.project.getRepositories().remove((Object)repo2);
    }

    private final String getRepoUrl() {
        Lazy lazy = this.repoUrl$delegate;
        return (String)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void downloadAndExtract() {
        Logger $this$lifecycleWithDuration$iv;
        Logger lengthSuffix;
        Dependency dependency2;
        Pair[] pairArray;
        ArtifactRepository repo2;
        ArtifactRepository artifactRepository = repo2 = !this.getKotlinProperties().getNativeDownloadFromMaven() ? this.setupRepo(this.getRepoUrl()) : null;
        if (this.getKotlinProperties().getNativeDownloadFromMaven()) {
            pairArray = new Pair[]{TuplesKt.to((Object)"group", (Object)KOTLIN_GROUP_ID), TuplesKt.to((Object)"name", (Object)this.getDependencyName()), TuplesKt.to((Object)"version", (Object)this.compilerVersion.toString()), TuplesKt.to((Object)"classifier", (Object)this.getSimpleOsName()), TuplesKt.to((Object)"ext", (Object)this.getArchiveExtension())};
            dependency2 = this.project.getDependencies().create((Object)MapsKt.mapOf((Pair[])pairArray));
        } else {
            pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)(this.getDependencyName() + '-' + this.getSimpleOsName())), TuplesKt.to((Object)"version", (Object)this.compilerVersion.toString()), TuplesKt.to((Object)"ext", (Object)this.getArchiveExtension())};
            dependency2 = this.project.getDependencies().create((Object)MapsKt.mapOf((Pair[])pairArray));
        }
        Dependency compilerDependency = dependency2;
        Dependency[] dependencyArray = new Dependency[]{compilerDependency};
        Configuration configuration2 = this.project.getConfigurations().detachedConfiguration(dependencyArray);
        Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"project.configurations.d\u2026ation(compilerDependency)");
        Configuration configuration3 = ConfigurationsKt.markResolvable(configuration2);
        this.getLogger().lifecycle("\nPlease wait while Kotlin/Native compiler " + this.compilerVersion + " is being installed.");
        if (!this.getKotlinProperties().getNativeDownloadFromMaven()) {
            String string;
            String string2;
            String dependencyUrl = this.getRepoUrl() + '/' + this.getDependencyFileName();
            Long l = ResourceUtilsKt.probeRemoteFileLength(this.project, dependencyUrl, 200);
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl = false;
                string2 = " (" + FormattingUtilsKt.formatContentLength(it) + ')';
            } else {
                string2 = string = null;
            }
            if (string2 == null) {
                string = "";
            }
            lengthSuffix = string;
            this.getLogger().lifecycle("Download " + dependencyUrl + (String)lengthSuffix);
        }
        lengthSuffix = this.getLogger();
        String messagePrefix$iv = "Download " + this.getDependencyFileName() + " finished,";
        boolean $i$f$lifecycleWithDuration = false;
        long startTime$iv = System.currentTimeMillis();
        boolean bl = false;
        Set set2 = configuration3.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"configuration.files");
        File result$iv = (File)CollectionsKt.single((Iterable)set2);
        long finishTime$iv = System.currentTimeMillis();
        $this$lifecycleWithDuration$iv.lifecycle(messagePrefix$iv + " took " + FormattingUtilsKt.formatDuration(finishTime$iv - startTime$iv));
        File archive = result$iv;
        GradleLoggingUtilsKt.kotlinInfo(this.getLogger(), "Using Kotlin/Native compiler archive: " + archive.getAbsolutePath());
        this.getLogger().lifecycle("Unpack Kotlin/Native compiler to " + this.getCompilerDirectory());
        $this$lifecycleWithDuration$iv = this.getLogger();
        messagePrefix$iv = "Unpack Kotlin/Native compiler to " + this.getCompilerDirectory() + " finished,";
        $i$f$lifecycleWithDuration = false;
        startTime$iv = System.currentTimeMillis();
        boolean bl2 = false;
        File it = finishTime$iv = this.getCompilerDirectory().getParentFile();
        boolean bl3 = false;
        it.mkdirs();
        File kotlinNativeDir = finishTime$iv;
        File tmpDir = Files.createTempDirectory(kotlinNativeDir.toPath(), "compiler-", new FileAttribute[0]).toFile();
        try {
            this.getLogger().debug("Unpacking Kotlin/Native compiler to tmp directory " + tmpDir);
            this.project.copy(new Action(this, archive, tmpDir){
                final /* synthetic */ NativeCompilerDownloader this$0;
                final /* synthetic */ File $archive;
                final /* synthetic */ File $tmpDir;
                {
                    this.this$0 = $receiver;
                    this.$archive = $archive;
                    this.$tmpDir = $tmpDir;
                }

                public final void execute(CopySpec it) {
                    Object[] objectArray = new Object[1];
                    File file = this.$archive;
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"archive");
                    objectArray[0] = NativeCompilerDownloader.access$archiveFileTree(this.this$0, file);
                    it.from(objectArray);
                    it.into((Object)this.$tmpDir);
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)tmpDir, (String)"tmpDir");
            File compilerTmp = FilesKt.resolve((File)tmpDir, (String)this.getDependencyNameWithOsAndVersion());
            if (!compilerTmp.renameTo(this.getCompilerDirectory())) {
                this.project.copy(new Action(compilerTmp, this){
                    final /* synthetic */ File $compilerTmp;
                    final /* synthetic */ NativeCompilerDownloader this$0;
                    {
                        this.$compilerTmp = $compilerTmp;
                        this.this$0 = $receiver;
                    }

                    public final void execute(CopySpec it) {
                        Object[] objectArray = new Object[]{this.$compilerTmp};
                        it.from(objectArray);
                        it.into((Object)this.this$0.getCompilerDirectory());
                    }
                });
            }
            this.getLogger().debug("Moved Kotlin/Native compiler from " + tmpDir + " to " + this.getCompilerDirectory());
        }
        catch (Throwable throwable) {
            Intrinsics.checkNotNullExpressionValue((Object)tmpDir, (String)"tmpDir");
            FilesKt.deleteRecursively((File)tmpDir);
            throw throwable;
        }
        FilesKt.deleteRecursively((File)tmpDir);
        Unit result$iv2 = Unit.INSTANCE;
        long finishTime$iv2 = System.currentTimeMillis();
        $this$lifecycleWithDuration$iv.lifecycle(messagePrefix$iv + " took " + FormattingUtilsKt.formatDuration(finishTime$iv2 - startTime$iv));
        if (repo2 != null) {
            this.removeRepo(repo2);
        }
    }

    public final void downloadIfNeeded() {
        this.checkClassPath();
        if (NEED_TO_DOWNLOAD_FLAG) {
            this.downloadAndExtract();
        }
    }

    private final void checkClassPath() {
        Provider provider = this.project.getProviders().of(NativeCompilerDownloaderClassPathChecker.class, new Action(this){
            final /* synthetic */ NativeCompilerDownloader this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(ValueSourceSpec<NativeCompilerDownloaderClassPathChecker.Params> it) {
                ((NativeCompilerDownloaderClassPathChecker.Params)it.getParameters()).getClassPath().setFrom((Iterable)KotlinNativeToolRunner.Settings.Companion.of(NativeToolRunnersKt.getKonanHome(this.this$0.getProject()), NativeToolRunnersKt.getKonanDataDir(this.this$0.getProject()), this.this$0.getProject()).getClasspath());
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"private fun checkClassPa\u2026tiesAccessor).get()\n    }");
        ConfigurationTimePropertiesAccessorKt.usedAtConfigurationTime(provider, ConfigurationTimePropertiesAccessorKt.getConfigurationTimePropertiesAccessor(this.project)).get();
    }

    public static final /* synthetic */ FileTree access$archiveFileTree(NativeCompilerDownloader $this, File archive) {
        return $this.archiveFileTree(archive);
    }

    public static final /* synthetic */ String access$getCompilerVersion$p(NativeCompilerDownloader $this) {
        return $this.compilerVersion;
    }

    public static final /* synthetic */ PropertiesProvider access$getKotlinProperties(NativeCompilerDownloader $this) {
        return $this.getKotlinProperties();
    }

    public static final /* synthetic */ String access$getSimpleOsName(NativeCompilerDownloader $this) {
        return $this.getSimpleOsName();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/gradle/utils/NativeCompilerDownloader$Companion;", "", "()V", "BASE_DOWNLOAD_URL", "", "DEFAULT_KONAN_VERSION", "getDEFAULT_KONAN_VERSION", "()Ljava/lang/String;", "DEFAULT_KONAN_VERSION$delegate", "Lkotlin/Lazy;", "KOTLIN_GROUP_ID", "NEED_TO_DOWNLOAD_FLAG", "", "getNEED_TO_DOWNLOAD_FLAG$kotlin_gradle_plugin_common", "()Z", "setNEED_TO_DOWNLOAD_FLAG$kotlin_gradle_plugin_common", "(Z)V", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDEFAULT_KONAN_VERSION() {
            Lazy lazy = DEFAULT_KONAN_VERSION$delegate;
            return (String)lazy.getValue();
        }

        public final boolean getNEED_TO_DOWNLOAD_FLAG$kotlin_gradle_plugin_common() {
            return NEED_TO_DOWNLOAD_FLAG;
        }

        public final void setNEED_TO_DOWNLOAD_FLAG$kotlin_gradle_plugin_common(boolean bl) {
            NEED_TO_DOWNLOAD_FLAG = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0005\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/utils/NativeCompilerDownloader$NativeCompilerDownloaderClassPathChecker;", "Lorg/gradle/api/provider/ValueSource;", "", "Lorg/jetbrains/kotlin/gradle/utils/NativeCompilerDownloader$NativeCompilerDownloaderClassPathChecker$Params;", "()V", "obtain", "()Ljava/lang/Boolean;", "Params", "kotlin-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\nNativeCompilerDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeCompilerDownloader.kt\norg/jetbrains/kotlin/gradle/utils/NativeCompilerDownloader$NativeCompilerDownloaderClassPathChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,242:1\n2624#2,3:243\n*S KotlinDebug\n*F\n+ 1 NativeCompilerDownloader.kt\norg/jetbrains/kotlin/gradle/utils/NativeCompilerDownloader$NativeCompilerDownloaderClassPathChecker\n*L\n215#1:243,3\n*E\n"})
    public static abstract class NativeCompilerDownloaderClassPathChecker
    implements ValueSource<Boolean, Params> {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public Boolean obtain() {
            boolean bl;
            Companion companion;
            block3: {
                void $this$none$iv;
                Set set2 = ((Params)this.getParameters()).getClassPath().getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"parameters.classPath.files");
                Iterable iterable = set2;
                companion = Companion;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        File it = (File)element$iv;
                        boolean bl2 = false;
                        if (!it.exists()) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            boolean bl3 = bl;
            companion.setNEED_TO_DOWNLOAD_FLAG$kotlin_gradle_plugin_common(bl3);
            return true;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/gradle/utils/NativeCompilerDownloader$NativeCompilerDownloaderClassPathChecker$Params;", "Lorg/gradle/api/provider/ValueSourceParameters;", "classPath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClassPath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "kotlin-gradle-plugin_common"})
        public static interface Params
        extends ValueSourceParameters {
            @NotNull
            public ConfigurableFileCollection getClassPath();
        }
    }
}

