/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.io.monitor;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.kotlin.org.apache.commons.io.FileUtils;
import org.jetbrains.kotlin.org.apache.commons.io.IOCase;
import org.jetbrains.kotlin.org.apache.commons.io.comparator.NameFileComparator;
import org.jetbrains.kotlin.org.apache.commons.io.filefilter.TrueFileFilter;
import org.jetbrains.kotlin.org.apache.commons.io.monitor.FileAlterationListener;
import org.jetbrains.kotlin.org.apache.commons.io.monitor.FileEntry;

public class FileAlterationObserver
implements Serializable {
    private static final long serialVersionUID = 1185122225658782848L;
    private final transient List<FileAlterationListener> listeners = new CopyOnWriteArrayList<FileAlterationListener>();
    private final FileEntry rootEntry;
    private final transient FileFilter fileFilter;
    private final Comparator<File> comparator;

    public FileAlterationObserver(File directory) {
        this(directory, null);
    }

    public FileAlterationObserver(File directory, FileFilter fileFilter) {
        this(directory, fileFilter, null);
    }

    public FileAlterationObserver(File directory, FileFilter fileFilter, IOCase ioCase) {
        this(new FileEntry(directory), fileFilter, ioCase);
    }

    protected FileAlterationObserver(FileEntry rootEntry, FileFilter fileFilter, IOCase ioCase) {
        Objects.requireNonNull(rootEntry, "rootEntry");
        Objects.requireNonNull(rootEntry.getFile(), "rootEntry.getFile()");
        this.rootEntry = rootEntry;
        this.fileFilter = fileFilter != null ? fileFilter : TrueFileFilter.INSTANCE;
        switch (IOCase.value(ioCase, IOCase.SYSTEM)) {
            case SYSTEM: {
                this.comparator = NameFileComparator.NAME_SYSTEM_COMPARATOR;
                break;
            }
            case INSENSITIVE: {
                this.comparator = NameFileComparator.NAME_INSENSITIVE_COMPARATOR;
                break;
            }
            default: {
                this.comparator = NameFileComparator.NAME_COMPARATOR;
            }
        }
    }

    public FileAlterationObserver(String directoryName) {
        this(new File(directoryName));
    }

    public FileAlterationObserver(String directoryName, FileFilter fileFilter) {
        this(new File(directoryName), fileFilter);
    }

    public FileAlterationObserver(String directoryName, FileFilter fileFilter, IOCase ioCase) {
        this(new File(directoryName), fileFilter, ioCase);
    }

    public void addListener(FileAlterationListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void checkAndNotify() {
        this.listeners.forEach(listener -> listener.onStart(this));
        File rootFile = this.rootEntry.getFile();
        if (rootFile.exists()) {
            this.checkAndNotify(this.rootEntry, this.rootEntry.getChildren(), this.listFiles(rootFile));
        } else if (this.rootEntry.isExists()) {
            this.checkAndNotify(this.rootEntry, this.rootEntry.getChildren(), FileUtils.EMPTY_FILE_ARRAY);
        }
        this.listeners.forEach(listener -> listener.onStop(this));
    }

    private void checkAndNotify(FileEntry parent, FileEntry[] previous, File[] files) {
        int c = 0;
        FileEntry[] current2 = files.length > 0 ? new FileEntry[files.length] : FileEntry.EMPTY_FILE_ENTRY_ARRAY;
        for (FileEntry entry2 : previous) {
            while (c < files.length && this.comparator.compare(entry2.getFile(), files[c]) > 0) {
                current2[c] = this.createFileEntry(parent, files[c]);
                this.doCreate(current2[c]);
                ++c;
            }
            if (c < files.length && this.comparator.compare(entry2.getFile(), files[c]) == 0) {
                this.doMatch(entry2, files[c]);
                this.checkAndNotify(entry2, entry2.getChildren(), this.listFiles(files[c]));
                current2[c] = entry2;
                ++c;
                continue;
            }
            this.checkAndNotify(entry2, entry2.getChildren(), FileUtils.EMPTY_FILE_ARRAY);
            this.doDelete(entry2);
        }
        while (c < files.length) {
            current2[c] = this.createFileEntry(parent, files[c]);
            this.doCreate(current2[c]);
            ++c;
        }
        parent.setChildren(current2);
    }

    private FileEntry createFileEntry(FileEntry parent, File file) {
        FileEntry entry2 = parent.newChildInstance(file);
        entry2.refresh(file);
        entry2.setChildren(this.doListFiles(file, entry2));
        return entry2;
    }

    public void destroy() throws Exception {
    }

    private void doCreate(FileEntry entry2) {
        this.listeners.forEach(listener -> {
            if (entry2.isDirectory()) {
                listener.onDirectoryCreate(entry2.getFile());
            } else {
                listener.onFileCreate(entry2.getFile());
            }
        });
        Stream.of(entry2.getChildren()).forEach(this::doCreate);
    }

    private void doDelete(FileEntry entry2) {
        this.listeners.forEach(listener -> {
            if (entry2.isDirectory()) {
                listener.onDirectoryDelete(entry2.getFile());
            } else {
                listener.onFileDelete(entry2.getFile());
            }
        });
    }

    private FileEntry[] doListFiles(File file, FileEntry entry2) {
        File[] files = this.listFiles(file);
        FileEntry[] children = files.length > 0 ? new FileEntry[files.length] : FileEntry.EMPTY_FILE_ENTRY_ARRAY;
        Arrays.setAll(children, i2 -> this.createFileEntry(entry2, files[i2]));
        return children;
    }

    private void doMatch(FileEntry entry2, File file) {
        if (entry2.refresh(file)) {
            this.listeners.forEach(listener -> {
                if (entry2.isDirectory()) {
                    listener.onDirectoryChange(file);
                } else {
                    listener.onFileChange(file);
                }
            });
        }
    }

    public File getDirectory() {
        return this.rootEntry.getFile();
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public Iterable<FileAlterationListener> getListeners() {
        return new ArrayList<FileAlterationListener>(this.listeners);
    }

    public void initialize() throws Exception {
        this.rootEntry.refresh(this.rootEntry.getFile());
        this.rootEntry.setChildren(this.doListFiles(this.rootEntry.getFile(), this.rootEntry));
    }

    private File[] listFiles(File file) {
        File[] children = null;
        if (file.isDirectory()) {
            children = file.listFiles(this.fileFilter);
        }
        if (children == null) {
            children = FileUtils.EMPTY_FILE_ARRAY;
        }
        if (children.length > 1) {
            Arrays.sort(children, this.comparator);
        }
        return children;
    }

    public void removeListener(FileAlterationListener listener) {
        if (listener != null) {
            this.listeners.removeIf((Predicate<FileAlterationListener>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lorg/jetbrains/kotlin/org/apache/commons/io/monitor/FileAlterationListener;)Z)((FileAlterationListener)listener));
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("[file='");
        builder.append(this.getDirectory().getPath());
        builder.append('\'');
        builder.append(", ");
        builder.append(this.fileFilter.toString());
        builder.append(", listeners=");
        builder.append(this.listeners.size());
        builder.append("]");
        return builder.toString();
    }
}

