/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.binaryen;

import java.io.File;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.ExperimentalWasmDsl;
import org.jetbrains.kotlin.gradle.targets.js.EnvSpec;
import org.jetbrains.kotlin.gradle.targets.js.binaryen.BinaryenEnv;
import org.jetbrains.kotlin.gradle.targets.js.binaryen.BinaryenPlatform;
import org.jetbrains.kotlin.gradle.targets.js.binaryen.BinaryenRootEnvSpec;
import org.jetbrains.kotlin.gradle.tasks.internal.CleanableStore;
import org.jetbrains.kotlin.gradle.utils.FileUtilsKt;

@ExperimentalWasmDsl
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001b\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0010\u00a2\u0006\u0002\b\rR\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/binaryen/BinaryenRootEnvSpec;", "Lorg/jetbrains/kotlin/gradle/targets/js/EnvSpec;", "Lorg/jetbrains/kotlin/gradle/targets/js/binaryen/BinaryenEnv;", "()V", "platform", "Lorg/gradle/api/provider/Property;", "Lorg/jetbrains/kotlin/gradle/targets/js/binaryen/BinaryenPlatform;", "getPlatform$kotlin_gradle_plugin_common", "()Lorg/gradle/api/provider/Property;", "produceEnv", "Lorg/gradle/api/provider/Provider;", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "produceEnv$kotlin_gradle_plugin_common", "Companion", "kotlin-gradle-plugin_common"})
public abstract class BinaryenRootEnvSpec
extends EnvSpec<BinaryenEnv> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String EXTENSION_NAME = "kotlinBinaryenSpec";

    @NotNull
    public abstract Property<BinaryenPlatform> getPlatform$kotlin_gradle_plugin_common();

    @Override
    @NotNull
    public Provider<BinaryenEnv> produceEnv$kotlin_gradle_plugin_common(@NotNull ProviderFactory providerFactory) {
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        Provider provider = providerFactory.provider(new Callable(this){
            final /* synthetic */ BinaryenRootEnvSpec this$0;
            {
                this.this$0 = $receiver;
            }

            public final BinaryenEnv call() {
                String versionValue = (String)this.this$0.getVersion().get();
                String requiredVersionName = "binaryen-version_" + versionValue;
                String string2 = FileUtilsKt.getDirectoryAsFile((Provider<Directory>)((Provider)this.this$0.getInstallationDirectory())).getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"installationDirectory.getFile().absolutePath");
                CleanableStore cleanableStore = CleanableStore.Companion.get(string2);
                File targetPath = cleanableStore.get(requiredVersionName).use();
                BinaryenPlatform platformValue = (BinaryenPlatform)this.this$0.getPlatform$kotlin_gradle_plugin_common().get();
                boolean isWindows2 = platformValue.isWindows();
                Boolean downloadValue = (Boolean)this.this$0.getDownload().get();
                Intrinsics.checkNotNullExpressionValue((Object)downloadValue, (String)"downloadValue");
                boolean bl = downloadValue;
                String string3 = (String)this.this$0.getDownloadBaseUrl().getOrNull();
                String string4 = "com.github.webassembly:binaryen:" + versionValue + ':' + platformValue.getPlatform() + "@tar.gz";
                Object object = this.this$0.getCommand().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"command.get()");
                return new BinaryenEnv(bl, string3, string4, produceEnv.1.call$getExecutable(isWindows2, downloadValue, targetPath, "wasm-opt", (String)object, "exe"), targetPath, cleanableStore, isWindows2);
            }

            private static final String call$getExecutable(boolean isWindows2, Boolean downloadValue, File targetPath, String command, String customCommand, String windowsExtension) {
                String string2;
                String finalCommand = isWindows2 && Intrinsics.areEqual((Object)customCommand, (Object)command) ? command + '.' + windowsExtension : customCommand;
                Intrinsics.checkNotNullExpressionValue((Object)downloadValue, (String)"downloadValue");
                if (downloadValue.booleanValue()) {
                    String string3 = FilesKt.resolve((File)FilesKt.resolve((File)targetPath, (String)"bin"), (String)finalCommand).getAbsolutePath();
                    string2 = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"targetPath\n             \u2026            .absolutePath");
                } else {
                    string2 = finalCommand;
                }
                return string2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"override fun produceEnv(\u2026        )\n        }\n    }");
        return provider;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/binaryen/BinaryenRootEnvSpec$Companion;", "", "()V", "EXTENSION_NAME", "", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

