/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jdom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.JDOMUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.org.jdom.Attribute;
import org.jetbrains.kotlin.org.jdom.AttributeList;
import org.jetbrains.kotlin.org.jdom.AttributeType;
import org.jetbrains.kotlin.org.jdom.Content;
import org.jetbrains.kotlin.org.jdom.Element;
import org.jetbrains.kotlin.org.jdom.ImmutableAttribute;
import org.jetbrains.kotlin.org.jdom.ImmutableSameTypeAttributeList;
import org.jetbrains.kotlin.org.jdom.JDOMInterner;
import org.jetbrains.kotlin.org.jdom.Namespace;
import org.jetbrains.kotlin.org.jdom.Parent;
import org.jetbrains.kotlin.org.jdom.Text;
import org.jetbrains.kotlin.org.jdom.filter.Filter;
import org.jetbrains.kotlin.org.jdom.filter2.ElementFilter;

final class ImmutableElement
extends Element {
    private static final List<Attribute> EMPTY_LIST = new ImmutableSameTypeAttributeList(ArrayUtilRt.EMPTY_STRING_ARRAY, null, Namespace.NO_NAMESPACE);
    private final Content[] myContent;
    private static final Content[] EMPTY_CONTENT = new Content[0];
    private final List<Attribute> myAttributes;

    ImmutableElement(@NotNull Element origin, @NotNull JDOMInterner interner) {
        if (origin == null) {
            ImmutableElement.$$$reportNull$$$0(0);
        }
        if (interner == null) {
            ImmutableElement.$$$reportNull$$$0(1);
        }
        this.name = interner.internString(origin.getName());
        this.myAttributes = ImmutableElement.internAttributes(origin, interner);
        List origContent = origin.getContent();
        if (origContent.isEmpty()) {
            this.myContent = EMPTY_CONTENT;
        } else {
            Content[] newContent = new Content[origContent.size()];
            int index = 0;
            for (Content o : origContent) {
                if (o instanceof Element) {
                    Element newElement = interner.internElement((Element)o);
                    newContent[index++] = newElement;
                    continue;
                }
                if (o instanceof Text) {
                    Text newText = interner.internText((Text)o);
                    newContent[index++] = newText;
                    continue;
                }
                throw new RuntimeException(o.toString());
            }
            this.myContent = index == newContent.length ? newContent : Arrays.copyOf(newContent, index);
        }
        this.namespace = origin.getNamespace();
        for (Namespace namespace : origin.getAdditionalNamespaces()) {
            super.addNamespaceDeclaration(namespace);
        }
    }

    @NotNull
    private static List<Attribute> internAttributes(@NotNull Element origin, @NotNull JDOMInterner interner) {
        List<Attribute> originAttributes;
        if (origin == null) {
            ImmutableElement.$$$reportNull$$$0(2);
        }
        if (interner == null) {
            ImmutableElement.$$$reportNull$$$0(3);
        }
        if ((originAttributes = JDOMUtil.getAttributes(origin)).isEmpty()) {
            List<Attribute> list = EMPTY_LIST;
            if (list == null) {
                ImmutableElement.$$$reportNull$$$0(4);
            }
            return list;
        }
        AttributeType type = null;
        String[] nameValues = new String[originAttributes.size() * 2];
        Namespace namespace = null;
        for (int i2 = 0; i2 < originAttributes.size(); ++i2) {
            Attribute origAttribute = originAttributes.get(i2);
            if (type == null) {
                type = origAttribute.getAttributeType();
                namespace = origAttribute.getNamespace();
            } else if (type != origAttribute.getAttributeType() || !origAttribute.getNamespace().equals((Object)namespace)) {
                type = null;
                break;
            }
            String name2 = interner.internString(origAttribute.getName());
            String value2 = interner.internString(origAttribute.getValue());
            nameValues[i2 * 2] = name2;
            nameValues[i2 * 2 + 1] = value2;
        }
        if (type == null) {
            List<Attribute> list = Collections.unmodifiableList(originAttributes.stream().map(attribute -> new ImmutableAttribute(interner.internString(attribute.getName()), interner.internString(attribute.getValue()), attribute.getAttributeType(), attribute.getNamespace())).collect(Collectors.toList()));
            if (list == null) {
                ImmutableElement.$$$reportNull$$$0(5);
            }
            return list;
        }
        return new ImmutableSameTypeAttributeList(nameValues, type, namespace);
    }

    public int getContentSize() {
        return this.myContent.length;
    }

    @NotNull
    public List<Content> getContent() {
        List<Content> list = Arrays.asList(this.myContent);
        if (list == null) {
            ImmutableElement.$$$reportNull$$$0(6);
        }
        return list;
    }

    public <T extends Content> List<T> getContent(@NotNull Filter<T> filter2) {
        if (filter2 == null) {
            ImmutableElement.$$$reportNull$$$0(7);
        }
        return this.content().filter(arg_0 -> filter2.matches(arg_0)).map(it -> it).collect(Collectors.toList());
    }

    public Stream<Content> content() {
        return Arrays.stream(this.myContent);
    }

    public Content getContent(int index) {
        return this.myContent[index];
    }

    public Iterator<Content> getDescendants() {
        throw ImmutableElement.immutableError((Object)this);
    }

    @NotNull
    public List<Element> getChildren() {
        List<Element> list = Arrays.stream(this.myContent).filter(Element.class::isInstance).map(it -> (Element)it).collect(Collectors.toList());
        if (list == null) {
            ImmutableElement.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public List<Element> getChildren(String name2, Namespace ns) {
        ElementFilter predicate = new ElementFilter(name2, ns);
        List<Element> list = Arrays.stream(this.myContent).filter(arg_0 -> ((ElementFilter)predicate).matches(arg_0)).map(it -> (Element)it).collect(Collectors.toList());
        if (list == null) {
            ImmutableElement.$$$reportNull$$$0(9);
        }
        return list;
    }

    public Element getChild(String name2, Namespace ns) {
        List<Element> children = this.getChildren(name2, ns);
        return children.isEmpty() ? null : children.get(0);
    }

    public String getText() {
        if (this.myContent.length == 0) {
            return "";
        }
        if (this.myContent.length == 1) {
            Content obj2 = this.myContent[0];
            return obj2 instanceof Text ? ((Text)obj2).getText() : "";
        }
        StringBuilder textContent = new StringBuilder();
        boolean hasText = false;
        for (Content content : this.myContent) {
            if (!(content instanceof Text)) continue;
            textContent.append(((Text)content).getText());
            hasText = true;
        }
        return hasText ? textContent.toString() : "";
    }

    public int indexOf(Content child) {
        return ArrayUtilRt.indexOf(this.myContent, child, 0, this.myContent.length);
    }

    public Namespace getNamespace(String prefix) {
        Namespace ns = super.getNamespace(prefix);
        if (ns == null) {
            for (Attribute a : this.myAttributes) {
                if (!prefix.equals(a.getNamespacePrefix())) continue;
                return a.getNamespace();
            }
        }
        return ns;
    }

    public boolean hasAttributes() {
        return !this.myAttributes.isEmpty();
    }

    public List<Attribute> getAttributes() {
        return this.myAttributes;
    }

    public Attribute getAttribute(String name2, Namespace ns) {
        if (this.myAttributes instanceof ImmutableSameTypeAttributeList) {
            return ((ImmutableSameTypeAttributeList)this.myAttributes).get(name2, ns);
        }
        String uri = this.namespace.getURI();
        for (Attribute a : this.myAttributes) {
            String oldURI = a.getNamespaceURI();
            String oldName = a.getName();
            if (!oldURI.equals(uri) || !oldName.equals(name2)) continue;
            return a;
        }
        return null;
    }

    @Nullable
    public String getAttributeValue(String name2) {
        return this.getAttributeValue(name2, Namespace.NO_NAMESPACE);
    }

    public String getAttributeValue(String name2, String def) {
        return this.getAttributeValue(name2, Namespace.NO_NAMESPACE, def);
    }

    public String getAttributeValue(String name2, Namespace ns) {
        return this.getAttributeValue(name2, ns, null);
    }

    public String getAttributeValue(String name2, Namespace ns, String defaultValue) {
        if (this.myAttributes instanceof ImmutableSameTypeAttributeList) {
            return ((ImmutableSameTypeAttributeList)this.myAttributes).getValue(name2, ns, defaultValue);
        }
        Attribute attribute = this.getAttribute(name2, ns);
        return attribute == null ? defaultValue : attribute.getValue();
    }

    public Element clone() {
        Element element = new Element();
        element.attributes = new AttributeList(element);
        element.name = this.getName();
        element.namespace = this.getNamespace();
        List<Attribute> attributes2 = this.getAttributes();
        if (attributes2 != null) {
            for (Attribute attribute : attributes2) {
                element.attributes.add(attribute.clone());
            }
        }
        if (this.additionalNamespaces != null) {
            element.additionalNamespaces = new ArrayList(this.additionalNamespaces);
        }
        for (Content c : this.myContent) {
            element.content.add((Object)c.clone());
        }
        return element;
    }

    public Element getParent() {
        throw ImmutableElement.immutableError((Object)this);
    }

    boolean attributesEqual(Element element) {
        List attrs = element.getAttributes();
        if (this.myAttributes instanceof ImmutableSameTypeAttributeList) {
            return this.myAttributes.equals(attrs);
        }
        if (this.myAttributes.size() != attrs.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.myAttributes.size(); ++i2) {
            Attribute oAttr;
            Attribute attribute = this.myAttributes.get(i2);
            if (ImmutableElement.attributesEqual(attribute, oAttr = (Attribute)attrs.get(i2))) continue;
            return false;
        }
        return true;
    }

    static boolean attributesEqual(Attribute a1, Attribute a2) {
        return a1.getName().equals(a2.getName()) && Objects.equals(a1.getValue(), a2.getValue()) && a1.getAttributeType() == a2.getAttributeType() && a1.getNamespace().equals((Object)a2.getNamespace());
    }

    @NotNull
    static IncorrectOperationException immutableError(Object element) {
        return new IncorrectOperationException("Can't change immutable element: " + element.getClass() + ". To obtain mutable Element call .clone()");
    }

    public Element detach() {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element setName(String name2) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element setNamespace(Namespace namespace) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public void addNamespaceDeclaration(Namespace additionalNamespace) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element setText(String text) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public List<Content> removeContent() {
        throw ImmutableElement.immutableError((Object)this);
    }

    public <T extends Content> List<T> removeContent(Filter<T> filter2) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element setContent(Collection<? extends Content> newContent) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element setContent(int index, Content child) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Parent setContent(int index, Collection<? extends Content> newContent) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element addContent(String str) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element addContent(Content child) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element addContent(Element child) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element addContent(Collection<? extends Content> newContent) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element addContent(int index, Content child) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element addContent(int index, Collection<? extends Content> newContent) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public boolean removeContent(Content child) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Content removeContent(int index) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element setContent(Content child) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element setAttributes(Collection newAttributes) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element setAttributes(List newAttributes) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element setAttribute(@NotNull String name2, @NotNull String value2) {
        if (name2 == null) {
            ImmutableElement.$$$reportNull$$$0(10);
        }
        if (value2 == null) {
            ImmutableElement.$$$reportNull$$$0(11);
        }
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element setAttribute(@NotNull String name2, @NotNull String value2, Namespace ns) {
        if (name2 == null) {
            ImmutableElement.$$$reportNull$$$0(12);
        }
        if (value2 == null) {
            ImmutableElement.$$$reportNull$$$0(13);
        }
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element setAttribute(@NotNull Attribute attribute) {
        if (attribute == null) {
            ImmutableElement.$$$reportNull$$$0(14);
        }
        throw ImmutableElement.immutableError((Object)this);
    }

    public boolean removeAttribute(String name2) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public boolean removeAttribute(String name2, Namespace ns) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public boolean removeAttribute(Attribute attribute) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public boolean removeChild(String name2) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public boolean removeChild(String name2, Namespace ns) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public boolean removeChildren(String name2) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public boolean removeChildren(String name2, Namespace ns) {
        throw ImmutableElement.immutableError((Object)this);
    }

    protected Content setParent(Parent parent) {
        throw ImmutableElement.immutableError((Object)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interner";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/org/jdom/ImmutableElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/org/jdom/ImmutableElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "internAttributes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "internAttributes";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setAttribute";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

