/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.transforms;

import java.io.File;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.buildtools.api.CompilationService;
import org.jetbrains.kotlin.buildtools.api.jvm.ClassSnapshotGranularity;
import org.jetbrains.kotlin.buildtools.api.jvm.ClasspathEntrySnapshot;
import org.jetbrains.kotlin.compilerRunner.btapi.SharedApiClassesClassLoaderProvider;
import org.jetbrains.kotlin.gradle.internal.ClassLoadersCachingBuildService;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnostics;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnostic;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.TransformActionUsingKotlinToolingDiagnostics;

@CacheableTransform
@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0002J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/transforms/BuildToolsApiClasspathEntrySnapshotTransform;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lorg/jetbrains/kotlin/gradle/internal/transforms/BuildToolsApiClasspathEntrySnapshotTransform$Parameters;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/TransformActionUsingKotlinToolingDiagnostics;", "()V", "inputArtifact", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getInputArtifact", "()Lorg/gradle/api/provider/Provider;", "checkVersionConsistency", "", "getClassSnapshotGranularity", "Lorg/jetbrains/kotlin/buildtools/api/jvm/ClassSnapshotGranularity;", "classpathEntryDirOrJar", "Ljava/io/File;", "gradleUserHomeDir", "gradleReadOnlyDependenciesCacheDir", "transform", "outputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "Parameters", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nBuildToolsApiClasspathEntrySnapshotTransform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildToolsApiClasspathEntrySnapshotTransform.kt\norg/jetbrains/kotlin/gradle/internal/transforms/BuildToolsApiClasspathEntrySnapshotTransform\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1#2:122\n*E\n"})
public abstract class BuildToolsApiClasspathEntrySnapshotTransform
implements TransformAction<Parameters>,
TransformActionUsingKotlinToolingDiagnostics<Parameters> {
    @Classpath
    @InputArtifact
    @NotNull
    public abstract Provider<FileSystemLocation> getInputArtifact();

    private final void checkVersionConsistency() {
        Object object = ((Parameters)this.getParameters()).getSuppressVersionInconsistencyChecks$kotlin_gradle_plugin_common().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.suppressVersi\u2026InconsistencyChecks.get()");
        if (((Boolean)object).booleanValue()) {
            return;
        }
        String kgpVersion = (String)((Parameters)this.getParameters()).getKgpVersion$kotlin_gradle_plugin_common().get();
        Object object2 = ((Parameters)this.getParameters()).getBuildToolsImplVersion$kotlin_gradle_plugin_common().getOrNull();
        String it = (String)object2;
        boolean bl = false;
        String buildToolsImplVersion = (String)(!Intrinsics.areEqual((Object)it, (Object)"null") ? object2 : null);
        if (!Intrinsics.areEqual((Object)kgpVersion, (Object)buildToolsImplVersion)) {
            Intrinsics.checkNotNullExpressionValue((Object)kgpVersion, (String)"kgpVersion");
            this.reportDiagnostic(KotlinToolingDiagnostics.BuildToolsApiVersionInconsistency.INSTANCE.invoke(kgpVersion, buildToolsImplVersion));
        }
    }

    public void transform(@NotNull TransformOutputs outputs) {
        File classpathEntryInputDirOrJar;
        Intrinsics.checkNotNullParameter((Object)outputs, (String)"outputs");
        if (!((Boolean)((Parameters)this.getParameters()).getCompilationViaBuildToolsApi$kotlin_gradle_plugin_common().get()).booleanValue()) {
            this.checkVersionConsistency();
        }
        if (!(classpathEntryInputDirOrJar = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile()).exists()) {
            Intrinsics.checkNotNullExpressionValue((Object)classpathEntryInputDirOrJar, (String)"classpathEntryInputDirOrJar");
            this.reportDiagnostic(KotlinToolingDiagnostics.DependencyDoesNotPhysicallyExist.INSTANCE.invoke(classpathEntryInputDirOrJar));
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = classpathEntryInputDirOrJar.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"classpathEntryInputDirOrJar.name");
        File snapshotOutputFile = outputs.file((Object)stringBuilder.append(StringsKt.replace$default((String)string, (char)'.', (char)'_', (boolean)false, (int)4, null)).append("-snapshot.bin").toString());
        Intrinsics.checkNotNullExpressionValue((Object)classpathEntryInputDirOrJar, (String)"classpathEntryInputDirOrJar");
        File file2 = ((Directory)((Parameters)this.getParameters()).getGradleUserHomeDir().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"parameters.gradleUserHomeDir.get().asFile");
        Directory directory = (Directory)((Parameters)this.getParameters()).getGradleReadOnlyDependenciesCacheDir$kotlin_gradle_plugin_common().getOrNull();
        ClassSnapshotGranularity granularity = this.getClassSnapshotGranularity(classpathEntryInputDirOrJar, file2, directory != null ? directory.getAsFile() : null);
        Boolean parseInlinedLocalClasses = (Boolean)((Parameters)this.getParameters()).getParseInlinedLocalClasses().get();
        ClassLoader classLoader = ((ClassLoadersCachingBuildService)((Parameters)this.getParameters()).getClassLoadersCachingService$kotlin_gradle_plugin_common().get()).getClassLoader(CollectionsKt.toList((Iterable)((Iterable)((Parameters)this.getParameters()).getClasspath$kotlin_gradle_plugin_common())), SharedApiClassesClassLoaderProvider.INSTANCE);
        CompilationService compilationService = CompilationService.Companion.loadImplementation(classLoader);
        Intrinsics.checkNotNullExpressionValue((Object)parseInlinedLocalClasses, (String)"parseInlinedLocalClasses");
        ClasspathEntrySnapshot snapshot = compilationService.calculateClasspathSnapshot(classpathEntryInputDirOrJar, granularity, parseInlinedLocalClasses.booleanValue());
        Intrinsics.checkNotNullExpressionValue((Object)snapshotOutputFile, (String)"snapshotOutputFile");
        snapshot.saveSnapshot(snapshotOutputFile);
    }

    private final ClassSnapshotGranularity getClassSnapshotGranularity(File classpathEntryDirOrJar, File gradleUserHomeDir, File gradleReadOnlyDependenciesCacheDir) {
        return FilesKt.startsWith((File)classpathEntryDirOrJar, (File)gradleUserHomeDir) || gradleReadOnlyDependenciesCacheDir != null && FilesKt.startsWith((File)classpathEntryDirOrJar, (File)gradleReadOnlyDependenciesCacheDir) || Intrinsics.areEqual((Object)classpathEntryDirOrJar.getName(), (Object)"android.jar") ? ClassSnapshotGranularity.CLASS_LEVEL : ClassSnapshotGranularity.CLASS_MEMBER_LEVEL;
    }

    @Override
    public void reportDiagnostic(@NotNull ToolingDiagnostic diagnostic) {
        TransformActionUsingKotlinToolingDiagnostics.DefaultImpls.reportDiagnostic(this, diagnostic);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00058aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0014\u0010\f\u001a\u00020\r8aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00058aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\bR\u0014\u0010\u0013\u001a\u00020\u00148aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\bR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\bR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u00058aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\b\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/transforms/BuildToolsApiClasspathEntrySnapshotTransform$Parameters;", "Lorg/gradle/api/artifacts/transform/TransformParameters;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/TransformActionUsingKotlinToolingDiagnostics$Parameters;", "()V", "buildToolsImplVersion", "Lorg/gradle/api/provider/Property;", "", "getBuildToolsImplVersion$kotlin_gradle_plugin_common", "()Lorg/gradle/api/provider/Property;", "classLoadersCachingService", "Lorg/jetbrains/kotlin/gradle/internal/ClassLoadersCachingBuildService;", "getClassLoadersCachingService$kotlin_gradle_plugin_common", "classpath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClasspath$kotlin_gradle_plugin_common", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "compilationViaBuildToolsApi", "", "getCompilationViaBuildToolsApi$kotlin_gradle_plugin_common", "gradleReadOnlyDependenciesCacheDir", "Lorg/gradle/api/file/DirectoryProperty;", "getGradleReadOnlyDependenciesCacheDir$kotlin_gradle_plugin_common", "()Lorg/gradle/api/file/DirectoryProperty;", "gradleUserHomeDir", "getGradleUserHomeDir", "kgpVersion", "getKgpVersion$kotlin_gradle_plugin_common", "parseInlinedLocalClasses", "getParseInlinedLocalClasses", "suppressVersionInconsistencyChecks", "getSuppressVersionInconsistencyChecks$kotlin_gradle_plugin_common", "kotlin-gradle-plugin_common"})
    public static abstract class Parameters
    implements TransformParameters,
    TransformActionUsingKotlinToolingDiagnostics.Parameters {
        @Internal
        @NotNull
        public abstract DirectoryProperty getGradleUserHomeDir();

        @Internal
        @NotNull
        public abstract DirectoryProperty getGradleReadOnlyDependenciesCacheDir$kotlin_gradle_plugin_common();

        @Internal
        @NotNull
        public abstract Property<ClassLoadersCachingBuildService> getClassLoadersCachingService$kotlin_gradle_plugin_common();

        @Classpath
        @NotNull
        public abstract ConfigurableFileCollection getClasspath$kotlin_gradle_plugin_common();

        @Input
        @NotNull
        public abstract Property<Boolean> getCompilationViaBuildToolsApi$kotlin_gradle_plugin_common();

        @Internal
        @NotNull
        public abstract Property<String> getBuildToolsImplVersion$kotlin_gradle_plugin_common();

        @Internal
        @NotNull
        public abstract Property<String> getKgpVersion$kotlin_gradle_plugin_common();

        @Internal
        @NotNull
        public abstract Property<Boolean> getSuppressVersionInconsistencyChecks$kotlin_gradle_plugin_common();

        @Input
        @NotNull
        public abstract Property<Boolean> getParseInlinedLocalClasses();
    }
}

