/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.diagnostics;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.AbstractToolingDiagnostic;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.StyledToolingDiagnostic;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.TerminalColorSupport;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnostic;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0016J\u0014\u0010\u000f\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\u0010\u001a\u00020\u0011*\u00060\u0012j\u0002`\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/DefaultStyledToolingDiagnostic;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/AbstractToolingDiagnostic;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/StyledToolingDiagnostic;", "diagnostic", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "showEmoji", "", "severity", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic$Severity;", "(Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;ZLorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic$Severity;)V", "buildDocumentation", "", "buildMessage", "buildName", "buildSolution", "applyColor", "processCodeBlocks", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "lines", "", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nStyledToolingDiagnostic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StyledToolingDiagnostic.kt\norg/jetbrains/kotlin/gradle/plugin/diagnostics/DefaultStyledToolingDiagnostic\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,234:1\n1851#2,2:235\n*S KotlinDebug\n*F\n+ 1 StyledToolingDiagnostic.kt\norg/jetbrains/kotlin/gradle/plugin/diagnostics/DefaultStyledToolingDiagnostic\n*L\n163#1:235,2\n*E\n"})
final class DefaultStyledToolingDiagnostic
extends AbstractToolingDiagnostic
implements StyledToolingDiagnostic {
    public DefaultStyledToolingDiagnostic(@NotNull ToolingDiagnostic diagnostic, boolean showEmoji, @NotNull ToolingDiagnostic.Severity severity) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        super(diagnostic, showEmoji, severity);
    }

    public /* synthetic */ DefaultStyledToolingDiagnostic(ToolingDiagnostic toolingDiagnostic, boolean bl, ToolingDiagnostic.Severity severity, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            severity = toolingDiagnostic.getSeverity();
        }
        this(toolingDiagnostic, bl, severity);
    }

    @Override
    @NotNull
    public String buildName() {
        return this.applyColor(TerminalColorSupport.TerminalStyle.INSTANCE.bold(super.buildName()), this.getSeverity());
    }

    @Override
    @NotNull
    public String buildMessage() {
        StringBuilder stringBuilder;
        StringBuilder $this$buildMessage_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (!StringsKt.contains$default((CharSequence)this.getDiagnostic().getMessage(), (CharSequence)"```", (boolean)false, (int)2, null)) {
            StringBuilder stringBuilder2 = $this$buildMessage_u24lambda_u240.append(super.buildMessage());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        } else {
            this.processCodeBlocks($this$buildMessage_u24lambda_u240, StringsKt.lines((CharSequence)this.getDiagnostic().getMessage()));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return ((Object)StringsKt.trimEnd((CharSequence)string)).toString();
    }

    @Override
    @Nullable
    public String buildSolution() {
        StringBuilder stringBuilder;
        List<String> solutions = this.getDiagnostic().getSolutions();
        if (solutions.isEmpty()) {
            return null;
        }
        StringBuilder $this$buildSolution_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String prefix = solutions.size() == 1 ? "Solution" : "Solutions";
        StringBuilder stringBuilder2 = $this$buildSolution_u24lambda_u242.append(TerminalColorSupport.TerminalStyle.INSTANCE.green(TerminalColorSupport.TerminalStyle.INSTANCE.bold(prefix + ':')));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        if (solutions.size() == 1) {
            $this$buildSolution_u24lambda_u242.append(TerminalColorSupport.TerminalStyle.INSTANCE.green(TerminalColorSupport.TerminalStyle.INSTANCE.italic((String)CollectionsKt.single(solutions))));
        } else {
            Iterable $this$forEach$iv = solutions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String solution2 = (String)element$iv;
                boolean bl2 = false;
                StringBuilder stringBuilder3 = $this$buildSolution_u24lambda_u242.append(TerminalColorSupport.TerminalStyle.INSTANCE.green(" \u2022 " + TerminalColorSupport.TerminalStyle.INSTANCE.italic(solution2)));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return ((Object)StringsKt.trimEnd((CharSequence)string)).toString();
    }

    @Override
    @Nullable
    public String buildDocumentation() {
        ToolingDiagnostic.Documentation documentation2 = this.getDiagnostic().getDocumentation();
        if (documentation2 != null) {
            String string;
            ToolingDiagnostic.Documentation doc = documentation2;
            boolean bl = false;
            String highlightedUrl = TerminalColorSupport.TerminalStyle.INSTANCE.blue(doc.getUrl());
            String[] stringArray = new String[]{doc.getUrl()};
            List parts = StringsKt.split$default((CharSequence)doc.getAdditionalUrlContext(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            switch (parts.size()) {
                case 1: {
                    string = TerminalColorSupport.TerminalStyle.INSTANCE.lightBlue(StringsKt.replace$default((String)doc.getAdditionalUrlContext(), (String)doc.getUrl(), (String)highlightedUrl, (boolean)false, (int)4, null));
                    break;
                }
                case 2: {
                    string = TerminalColorSupport.TerminalStyle.INSTANCE.lightBlue((String)parts.get(0)) + highlightedUrl + TerminalColorSupport.TerminalStyle.INSTANCE.lightBlue((String)parts.get(1));
                    break;
                }
                default: {
                    string = TerminalColorSupport.TerminalStyle.INSTANCE.lightBlue(doc.getAdditionalUrlContext());
                }
            }
            return ((Object)StringsKt.trimEnd((CharSequence)string)).toString();
        }
        return null;
    }

    private final String applyColor(String $this$applyColor, ToolingDiagnostic.Severity severity) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
            case 1: {
                string = TerminalColorSupport.TerminalStyle.INSTANCE.yellow($this$applyColor);
                break;
            }
            case 2: 
            case 3: {
                string = TerminalColorSupport.TerminalStyle.INSTANCE.red($this$applyColor);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final void processCodeBlocks(StringBuilder $this$processCodeBlocks, List<String> lines) {
        boolean inCodeBlock = false;
        for (String line : lines) {
            if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)line)).toString(), (Object)"```")) {
                inCodeBlock = !inCodeBlock;
                continue;
            }
            if (inCodeBlock) {
                StringBuilder stringBuilder = $this$processCodeBlocks.append(TerminalColorSupport.TerminalStyle.INSTANCE.orange(line));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
                continue;
            }
            StringBuilder stringBuilder = $this$processCodeBlocks.append(line);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        }
    }

    @Metadata(mv={1, 7, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ToolingDiagnostic.Severity.values().length];
            try {
                nArray[ToolingDiagnostic.Severity.WARNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolingDiagnostic.Severity.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolingDiagnostic.Severity.FATAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

