/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer;

import java.io.File;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.CommonizerOutputFileLayout;
import org.jetbrains.kotlin.commonizer.CommonizerTarget;
import org.jetbrains.kotlin.commonizer.CommonizerTargetKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0015\u0010\t\u001a\u00020\u0006*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0018\u0010\u000f\u001a\u00020\u0006*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/commonizer/CommonizerOutputFileLayout;", "", "()V", "maxFileNameLength", "", "base64Hash", "", "getBase64Hash", "(Ljava/lang/String;)Ljava/lang/String;", "fileName", "", "Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;", "getFileName", "(Ljava/util/Set;)Ljava/lang/String;", "(Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;)Ljava/lang/String;", "identityStringHash", "getIdentityStringHash", "resolveCommonizedDirectory", "Ljava/io/File;", "root", "target", "kotlin-klib-commonizer-api"})
public final class CommonizerOutputFileLayout {
    @NotNull
    public static final CommonizerOutputFileLayout INSTANCE = new CommonizerOutputFileLayout();
    public static final int maxFileNameLength = 150;

    private CommonizerOutputFileLayout() {
    }

    @NotNull
    public final File resolveCommonizedDirectory(@NotNull File root, @NotNull CommonizerTarget target) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return FilesKt.resolve((File)root, (String)this.getFileName(target));
    }

    @NotNull
    public final String getFileName(@NotNull CommonizerTarget $this$fileName) {
        Intrinsics.checkNotNullParameter((Object)$this$fileName, (String)"<this>");
        String identityString = CommonizerTargetKt.getIdentityString($this$fileName);
        if (identityString.length() > 150) {
            String hashSuffix = "[--" + this.getIdentityStringHash($this$fileName) + ']';
            return Intrinsics.stringPlus((String)StringsKt.take((String)identityString, (int)(150 - hashSuffix.length())), (Object)hashSuffix);
        }
        return identityString;
    }

    @NotNull
    public final String getFileName(@NotNull Set<? extends CommonizerTarget> $this$fileName) {
        Intrinsics.checkNotNullParameter($this$fileName, (String)"<this>");
        return this.getBase64Hash(CollectionsKt.joinToString$default((Iterable)$this$fileName, (CharSequence)";", null, null, (int)0, null, (Function1)fileName.1.INSTANCE, (int)30, null));
    }

    private final String getIdentityStringHash(CommonizerTarget $this$identityStringHash) {
        return this.getBase64Hash(CommonizerTargetKt.getIdentityString($this$identityStringHash));
    }

    private final String getBase64Hash(String $this$base64Hash) {
        MessageDigest sha = MessageDigest.getInstance("SHA-1");
        Base64.Encoder base64 = Base64.getUrlEncoder();
        byte[] byArray = base64.encode(sha.digest(StringsKt.encodeToByteArray((String)$this$base64Hash)));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"base64.encode(sha.digest\u2026his.encodeToByteArray()))");
        return StringsKt.decodeToString((byte[])byArray);
    }
}

