/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.experimental.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.experimental.KotlinNativeFramework;
import org.jetbrains.kotlin.gradle.plugin.experimental.internal.AbstractKotlinNativeBinary;
import org.jetbrains.kotlin.gradle.plugin.experimental.internal.BitcodeEmbeddingMode;
import org.jetbrains.kotlin.gradle.plugin.experimental.tasks.KotlinNativeCompile;
import org.jetbrains.kotlin.gradle.plugin.experimental.tasks.KotlinNativeCompile$WhenMappings;
import org.jetbrains.kotlin.gradle.plugin.konan.KonanCompilerRunner;
import org.jetbrains.kotlin.gradle.plugin.konan.KonanPluginKt;
import shadow.org.jetbrains.kotlin.gradle.tasks.CompilerPluginOptions;
import shadow.org.jetbrains.kotlin.konan.target.CompilerOutputKind;
import shadow.org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010C\u001a\u00020DH\u0015J\b\u0010E\u001a\u00020\rH\u0016J\b\u0010F\u001a\u00020GH\u0016J\u0012\u0010H\u001a\u00020D2\b\u0010I\u001a\u0004\u0018\u00010\rH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068G\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000f\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198G\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8G\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010 \u001a\u0004\u0018\u00010\u00078G\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\r8G\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u000fR\u0011\u0010%\u001a\u00020&8G\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020\u00078G\u00a2\u0006\u0006\u001a\u0004\b*\u0010\"R\u0011\u0010+\u001a\u00020,8G\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0017\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0007008G\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0011\u00103\u001a\u00020\u00198G\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u001bR\u0011\u00105\u001a\u0002068F\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0019\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020;0:\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u0014\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00070:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010?\u001a\u00020\r8G\u00a2\u0006\u0006\u001a\u0004\b@\u0010\u000fR\u0011\u0010A\u001a\u00020\u00078G\u00a2\u0006\u0006\u001a\u0004\bB\u0010\"\u00a8\u0006J"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/experimental/tasks/KotlinNativeCompile;", "Lorg/gradle/api/tasks/compile/AbstractCompile;", "binary", "Lorg/jetbrains/kotlin/gradle/plugin/experimental/internal/AbstractKotlinNativeBinary;", "(Lorg/jetbrains/kotlin/gradle/plugin/experimental/internal/AbstractKotlinNativeBinary;)V", "additionalCompilerOptions", "", "", "getAdditionalCompilerOptions", "()Ljava/util/Collection;", "getBinary$kotlin_native_gradle_plugin", "()Lorg/jetbrains/kotlin/gradle/plugin/experimental/internal/AbstractKotlinNativeBinary;", "commonSources", "Lorg/gradle/api/file/FileCollection;", "getCommonSources", "()Lorg/gradle/api/file/FileCollection;", "compilerPluginClasspath", "getCompilerPluginClasspath", "setCompilerPluginClasspath", "(Lorg/gradle/api/file/FileCollection;)V", "compilerPluginOptions", "Lshadow/org/jetbrains/kotlin/gradle/tasks/CompilerPluginOptions;", "getCompilerPluginOptions", "()Lorg/jetbrains/kotlin/gradle/tasks/CompilerPluginOptions;", "debuggable", "", "getDebuggable", "()Z", "embedBitcode", "Lorg/jetbrains/kotlin/gradle/plugin/experimental/internal/BitcodeEmbeddingMode;", "getEmbedBitcode", "()Lorg/jetbrains/kotlin/gradle/plugin/experimental/internal/BitcodeEmbeddingMode;", "entryPoint", "getEntryPoint", "()Ljava/lang/String;", "exportLibraries", "getExportLibraries", "kind", "Lshadow/org/jetbrains/kotlin/konan/target/CompilerOutputKind;", "getKind", "()Lorg/jetbrains/kotlin/konan/target/CompilerOutputKind;", "konanVersion", "getKonanVersion", "libraries", "Lorg/gradle/api/artifacts/Configuration;", "getLibraries", "()Lorg/gradle/api/artifacts/Configuration;", "linkerOpts", "", "getLinkerOpts", "()Ljava/util/List;", "optimized", "getOptimized", "outputFile", "Ljava/io/File;", "getOutputFile", "()Ljava/io/File;", "outputLocationProvider", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getOutputLocationProvider", "()Lorg/gradle/api/provider/Provider;", "outputPathProvider", "sources", "getSources", "target", "getTarget", "compile", "", "getClasspath", "getSource", "Lorg/gradle/api/file/FileTree;", "setClasspath", "configuration", "kotlin-native-gradle-plugin"})
public class KotlinNativeCompile
extends AbstractCompile {
    @NotNull
    private final CompilerPluginOptions compilerPluginOptions;
    @Nullable
    private FileCollection compilerPluginClasspath;
    private final Provider<String> outputPathProvider;
    @NotNull
    private final Provider<? extends FileSystemLocation> outputLocationProvider;
    @NotNull
    private final AbstractKotlinNativeBinary binary;

    @InputFiles
    @NotNull
    public final FileCollection getSources() {
        return this.binary.getSources();
    }

    @NotNull
    public FileTree getSource() {
        FileTree fileTree = this.getSources().getAsFileTree();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileTree, (String)"sources.asFileTree");
        return fileTree;
    }

    private final FileCollection getCommonSources() {
        return this.binary.getCommonSources();
    }

    @InputFiles
    @NotNull
    public final Configuration getLibraries() {
        Configuration configuration2 = this.binary.getKlibs();
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"binary.klibs");
        return configuration2;
    }

    @InputFiles
    @NotNull
    public final FileCollection getExportLibraries() {
        FileCollection fileCollection;
        if (this.binary instanceof KotlinNativeFramework) {
            fileCollection = ((KotlinNativeFramework)((Object)this.binary)).getExport();
        } else {
            ConfigurableFileCollection configurableFileCollection = this.getProject().files(new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection, (String)"project.files()");
            fileCollection = (FileCollection)configurableFileCollection;
        }
        return fileCollection;
    }

    @NotNull
    public FileCollection getClasspath() {
        return (FileCollection)this.getLibraries();
    }

    public void setClasspath(@Nullable FileCollection configuration2) {
        throw (Throwable)new UnsupportedOperationException("Use klibs to set compile classpath in Kotlin/Native");
    }

    @Input
    public final boolean getOptimized() {
        return this.binary.getOptimized();
    }

    @Input
    public final boolean getDebuggable() {
        return this.binary.getDebuggable();
    }

    @Input
    @NotNull
    public final CompilerOutputKind getKind() {
        return this.binary.getKind();
    }

    @Input
    @NotNull
    public final String getTarget() {
        return this.binary.getKonanTarget().getName();
    }

    @Input
    @NotNull
    public final Collection<String> getAdditionalCompilerOptions() {
        return this.binary.getAdditionalCompilerOptions();
    }

    @Input
    @NotNull
    public final List<String> getLinkerOpts() {
        return this.binary.getLinkerOpts();
    }

    @Optional
    @Input
    @Nullable
    public final String getEntryPoint() {
        return this.binary.getComponent().getEntryPoint();
    }

    @NotNull
    public final CompilerPluginOptions getCompilerPluginOptions() {
        return this.compilerPluginOptions;
    }

    @Nullable
    public final FileCollection getCompilerPluginClasspath() {
        return this.compilerPluginClasspath;
    }

    public final void setCompilerPluginClasspath(@Nullable FileCollection fileCollection) {
        this.compilerPluginClasspath = fileCollection;
    }

    @NotNull
    public final File getOutputFile() {
        Object object = this.outputLocationProvider.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"outputLocationProvider.get()");
        File file = ((FileSystemLocation)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputLocationProvider.get().asFile");
        return file;
    }

    @Input
    @NotNull
    public final BitcodeEmbeddingMode getEmbedBitcode() {
        return this.binary instanceof KotlinNativeFramework ? ((KotlinNativeFramework)((Object)this.binary)).getEmbedBitcode() : BitcodeEmbeddingMode.DISABLE;
    }

    @Input
    @NotNull
    public final String getKonanVersion() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        return KonanPluginKt.getKonanVersion(project).toString(true, true);
    }

    @NotNull
    public final Provider<? extends FileSystemLocation> getOutputLocationProvider() {
        return this.outputLocationProvider;
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    protected void compile() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object it;
        Iterator pluginClasspath;
        this.getOutputFile().getParentFile().mkdirs();
        boolean bl = false;
        List list2 = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List $this$apply = list2;
        boolean bl4 = false;
        String string = this.getOutputFile().getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"outputFile.absolutePath");
        KonanPluginKt.addArg($this$apply, "-o", string);
        KonanPluginKt.addKey($this$apply, "-opt", this.getOptimized());
        KonanPluginKt.addKey($this$apply, "-g", this.getDebuggable());
        KonanPluginKt.addKey($this$apply, "-ea", this.getDebuggable());
        KonanPluginKt.addArg($this$apply, "-target", this.getTarget());
        String string2 = this.getKind().name();
        Object object = "-p";
        Collection<Object> collection = $this$apply;
        boolean bl5 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        String string5 = string4;
        KonanPluginKt.addArg((List<String>)collection, (String)object, string5);
        $this$apply.add("-Xmulti-platform");
        KonanPluginKt.addArgIfNotNull($this$apply, "-entry", this.getEntryPoint());
        FileCollection fileCollection = this.compilerPluginClasspath;
        if (fileCollection != null) {
            Iterator $this$mapTo$iv$iv2;
            string2 = fileCollection;
            bl5 = false;
            boolean bl6 = false;
            pluginClasspath = string2;
            boolean bl7 = false;
            Iterable $this$map$iv2 = (Iterable)((Object)pluginClasspath);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv2.iterator();
            while (iterator.hasNext()) {
                void it2;
                Object item$iv$iv = iterator.next();
                File file = (File)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl8 = false;
                void v4 = it2;
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it");
                String string6 = v4.getCanonicalPath();
                collection2.add(string6);
            }
            Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String path = (String)element$iv;
                boolean bl9 = false;
                $this$apply.add("-Xplugin=" + path);
            }
            $this$forEach$iv = this.compilerPluginOptions.getArguments();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it3 = (String)element$iv;
                boolean bl10 = false;
                $this$apply.add("-P" + it3);
            }
        }
        $this$apply.addAll(this.getAdditionalCompilerOptions());
        compile.args.1.2 $fun$filterKlibs$2 = compile.args.1.2.INSTANCE;
        Set set2 = this.getLibraries().getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"libraries.files");
        Iterable $this$forEach$iv = $fun$filterKlibs$2.invoke(set2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (File)element$iv;
            boolean bl11 = false;
            String string7 = ((File)it).getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"it.absolutePath");
            KonanPluginKt.addArg($this$apply, "-l", string7);
        }
        Set set3 = this.getExportLibraries().getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set3, (String)"exportLibraries.files");
        $this$forEach$iv = $fun$filterKlibs$2.invoke(set3);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (File)element$iv;
            boolean bl12 = false;
            $this$apply.add("-Xexport-library=" + ((File)it).getAbsolutePath());
        }
        switch (KotlinNativeCompile$WhenMappings.$EnumSwitchMapping$0[this.getEmbedBitcode().ordinal()]) {
            case 1: {
                $this$apply.add("-Xembed-bitcode-marker");
                break;
            }
            case 2: {
                $this$apply.add("-Xembed-bitcode");
            }
        }
        $this$forEach$iv = this.getLinkerOpts();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl13 = false;
            KonanPluginKt.addArg($this$apply, "-linker-option", (String)it);
        }
        Set set4 = this.getSources().getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set4, (String)"sources.files");
        $this$forEach$iv = set4;
        collection = $this$apply;
        boolean $i$f$map = false;
        pluginClasspath = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it4;
            Object element$iv;
            element$iv = (File)item$iv$iv;
            object = destination$iv$iv;
            boolean bl14 = false;
            void v9 = it4;
            Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"it");
            string5 = v9.getAbsolutePath();
            object.add(string5);
        }
        object = (List)destination$iv$iv;
        collection.addAll((Collection)object);
        Set set5 = this.getCommonSources().getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set5, (String)"commonSources.files");
        Iterable $this$mapTo$iv = set5;
        boolean $i$f$mapTo2 = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it5;
            File $i$f$mapTo3 = (File)item$iv;
            collection = $this$apply;
            boolean bl15 = false;
            StringBuilder stringBuilder = new StringBuilder().append("-Xcommon-sources=");
            void v12 = it5;
            Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"it");
            object = stringBuilder.append(v12.getAbsolutePath()).toString();
            collection.add(object);
        }
        List args2 = list2;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        new KonanCompilerRunner(project, null, false, 6, null).run(args2);
    }

    @NotNull
    public final AbstractKotlinNativeBinary getBinary$kotlin_native_gradle_plugin() {
        return this.binary;
    }

    @Inject
    public KotlinNativeCompile(@NotNull AbstractKotlinNativeBinary binary) {
        Provider provider;
        Provider provider2;
        Intrinsics.checkParameterIsNotNull((Object)binary, (String)"binary");
        this.binary = binary;
        super.dependsOn(new Object[]{"checkKonanCompiler"});
        this.compilerPluginOptions = new CompilerPluginOptions();
        Provider provider3 = this.getProject().provider((Callable)new Callable<String>(this){
            final /* synthetic */ KotlinNativeCompile this$0;

            @NotNull
            public final String call() {
                AbstractKotlinNativeBinary abstractKotlinNativeBinary = this.this$0.getBinary$kotlin_native_gradle_plugin();
                boolean bl = false;
                boolean bl2 = false;
                AbstractKotlinNativeBinary $this$with = abstractKotlinNativeBinary;
                boolean bl3 = false;
                String root = $this$with.getOutputRootName$kotlin_native_gradle_plugin();
                String prefix = $this$with.getKind().prefix($this$with.getKonanTarget());
                String suffix = $this$with.getKind().suffix($this$with.getKonanTarget());
                String baseName = (String)$this$with.getBaseName().get();
                String fileName = prefix + baseName + suffix;
                if ($this$with.getKind() == CompilerOutputKind.FRAMEWORK || $this$with.getKind() == CompilerOutputKind.STATIC || $this$with.getKind() == CompilerOutputKind.DYNAMIC || $this$with.getKind() == CompilerOutputKind.PROGRAM && Intrinsics.areEqual((Object)$this$with.getKonanTarget(), (Object)KonanTarget.WASM32.INSTANCE)) {
                    fileName = StringsKt.replace$default((String)fileName, (char)'-', (char)'_', (boolean)false, (int)4, null);
                }
                return root + '/' + this.this$0.getBinary$kotlin_native_gradle_plugin().getNames().getDirName() + '/' + fileName;
            }
            {
                this.this$0 = kotlinNativeCompile;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)provider3, (String)"project.provider {\n     \u2026fileName\"\n        }\n    }");
        this.outputPathProvider = provider3;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        ProjectLayout projectLayout = project.getLayout();
        KotlinNativeCompile kotlinNativeCompile = this;
        boolean bl = false;
        boolean bl2 = false;
        ProjectLayout $this$with = projectLayout;
        boolean bl3 = false;
        if (this.getKind() == CompilerOutputKind.FRAMEWORK) {
            DirectoryProperty directoryProperty = this.newOutputDirectory();
            boolean bl4 = false;
            boolean bl5 = false;
            DirectoryProperty $this$apply = directoryProperty;
            boolean bl6 = false;
            $this$apply.set($this$with.getBuildDirectory().dir(this.outputPathProvider));
            this.getOutputs().dir((Object)$this$apply);
            DirectoryProperty directoryProperty2 = directoryProperty;
            Intrinsics.checkExpressionValueIsNotNull((Object)directoryProperty2, (String)"newOutputDirectory().app\u2026s.dir(this)\n            }");
            provider2 = (Provider)directoryProperty2;
        } else {
            RegularFileProperty regularFileProperty = this.newOutputFile();
            boolean bl7 = false;
            boolean bl8 = false;
            RegularFileProperty $this$apply = regularFileProperty;
            boolean bl9 = false;
            $this$apply.set($this$with.getBuildDirectory().file(this.outputPathProvider));
            this.getOutputs().file((Object)$this$apply);
            RegularFileProperty regularFileProperty2 = regularFileProperty;
            Intrinsics.checkExpressionValueIsNotNull((Object)regularFileProperty2, (String)"newOutputFile().apply {\n\u2026.file(this)\n            }");
            provider2 = (Provider)regularFileProperty2;
        }
        kotlinNativeCompile.outputLocationProvider = provider = provider2;
        this.setDestinationDir(this.getProject().provider((Callable)new Callable<File>(){

            @Override
            public final File call() {
                return this.getKind() == CompilerOutputKind.FRAMEWORK ? this.getOutputFile() : this.getOutputFile().getParentFile();
            }
        }));
        this.setSourceCompatibility("1.6");
        this.setTargetCompatibility("1.6");
    }
}

