/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.konan;

import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.tasks.Exec;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.konan.KonanArtifactContainer;
import org.jetbrains.kotlin.gradle.plugin.konan.KonanBuildingConfig;
import org.jetbrains.kotlin.gradle.plugin.konan.KonanExtension;
import org.jetbrains.kotlin.gradle.plugin.konan.KonanPlugin;
import org.jetbrains.kotlin.gradle.plugin.konan.KonanPluginKt;
import org.jetbrains.kotlin.gradle.plugin.konan.KonanProgram;
import org.jetbrains.kotlin.gradle.plugin.konan.KonanSoftwareComponent;
import org.jetbrains.kotlin.gradle.plugin.konan.KotlinNativePlatformPlugin;
import org.jetbrains.kotlin.gradle.plugin.model.KonanToolingModelBuilder;
import shadow.org.jetbrains.kotlin.gradle.plugin.tasks.KonanBuildingTask;
import shadow.org.jetbrains.kotlin.gradle.plugin.tasks.KonanCompileProgramTask;
import shadow.org.jetbrains.kotlin.gradle.plugin.tasks.KonanCompilerDownloadTask;
import shadow.org.jetbrains.kotlin.gradle.plugin.tasks.KonanGenerateCMakeTask;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\f\rB\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0002J\f\u0010\n\u001a\u00020\u0007*\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/konan/KonanPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/internal/project/ProjectInternal;", "registry", "Lorg/gradle/tooling/provider/model/ToolingModelBuilderRegistry;", "(Lorg/gradle/tooling/provider/model/ToolingModelBuilderRegistry;)V", "apply", "", "project", "checkGradleVersion", "cleanKonan", "Lorg/gradle/api/Project;", "Companion", "ProjectProperty", "kotlin-native-gradle-plugin"})
public final class KonanPlugin
implements Plugin<ProjectInternal> {
    private final ToolingModelBuilderRegistry registry;
    @NotNull
    public static final String ARTIFACTS_CONTAINER_NAME = "konanArtifacts";
    @NotNull
    public static final String KONAN_DOWNLOAD_TASK_NAME = "checkKonanCompiler";
    @NotNull
    public static final String KONAN_GENERATE_CMAKE_TASK_NAME = "generateCMake";
    @NotNull
    public static final String COMPILE_ALL_TASK_NAME = "compileKonan";
    @NotNull
    public static final String KONAN_EXTENSION_NAME = "konan";
    private static final GradleVersion REQUIRED_GRADLE_VERSION;
    public static final Companion Companion;

    private final void cleanKonan(@NotNull Project $this$cleanKonan) {
        Project project = $this$cleanKonan.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        TaskCollection taskCollection = project.getTasks().withType(KonanBuildingTask.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)taskCollection, (String)"project.tasks.withType(K\u2026BuildingTask::class.java)");
        Iterable $this$forEach$iv = (Iterable)taskCollection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KonanBuildingTask it = (KonanBuildingTask)element$iv;
            boolean bl = false;
            $this$cleanKonan.getProject().delete(new Object[]{it.getArtifact()});
        }
    }

    private final void checkGradleVersion() {
        GradleVersion gradleVersion = GradleVersion.current();
        boolean bl = false;
        boolean bl2 = false;
        GradleVersion current2 = gradleVersion;
        boolean bl3 = false;
        boolean bl4 = current2.compareTo(REQUIRED_GRADLE_VERSION) >= 0;
        boolean bl5 = false;
        boolean bl6 = false;
        if (!bl4) {
            boolean bl7 = false;
            String string = "Kotlin/Native Gradle plugin is incompatible with this version of Gradle.\n" + "The minimal required version is " + REQUIRED_GRADLE_VERSION + '\n' + "Current version is " + current2;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    public void apply(@Nullable ProjectInternal project) {
        if (project == null) {
            return;
        }
        this.checkGradleVersion();
        this.registry.register((ToolingModelBuilder)KonanToolingModelBuilder.INSTANCE);
        project.getPlugins().apply("base");
        project.getTasks().create(KONAN_DOWNLOAD_TASK_NAME, KonanCompilerDownloadTask.class);
        project.getTasks().create(KONAN_GENERATE_CMAKE_TASK_NAME, KonanGenerateCMakeTask.class);
        project.getExtensions().create(KONAN_EXTENSION_NAME, KonanExtension.class, new Object[0]);
        KonanArtifactContainer container = (KonanArtifactContainer)((Object)project.getExtensions().create(KonanArtifactContainer.class, ARTIFACTS_CONTAINER_NAME, KonanArtifactContainer.class, new Object[]{project}));
        GradleInternal gradleInternal = project.getGradle();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleInternal, (String)"project.gradle");
        boolean isPublicationEnabled = ((FeaturePreviews)gradleInternal.getServices().get(FeaturePreviews.class)).isFeatureEnabled(FeaturePreviews.Feature.GRADLE_METADATA);
        KonanPluginKt.setProperty((Project)project, ProjectProperty.KONAN_PUBLICATION_ENABLED, isPublicationEnabled);
        if (!isPublicationEnabled) {
            project.getLogger().warn("feature GRADLE_METADATA is not enabled: publication is disabled");
        }
        KonanPluginKt.warnAboutDeprecatedProperty((Project)project, ProjectProperty.KONAN_HOME);
        if (!KonanPluginKt.hasProperty((Project)project, ProjectProperty.KONAN_HOME)) {
            KonanPluginKt.setProperty((Project)project, ProjectProperty.KONAN_HOME, KonanPluginKt.konanCompilerDownloadDir((Project)project));
            KonanPluginKt.setProperty((Project)project, ProjectProperty.DOWNLOAD_COMPILER, true);
        }
        Task task = KonanPluginKt.access$getOrCreateTask((Project)project, COMPILE_ALL_TASK_NAME);
        boolean bl = false;
        boolean bl2 = false;
        Task $this$apply = task;
        boolean bl3 = false;
        $this$apply.setGroup("build");
        $this$apply.setDescription("Compiles all the Kotlin/Native artifacts");
        Task compileKonanTask = task;
        task = KonanPluginKt.access$getTask((Project)project, "build");
        bl = false;
        bl2 = false;
        $this$apply = task;
        boolean bl4 = false;
        $this$apply.dependsOn(new Object[]{compileKonanTask});
        task = KonanPluginKt.access$getTask((Project)project, "clean");
        bl = false;
        bl2 = false;
        $this$apply = task;
        boolean bl5 = false;
        $this$apply.doLast((Action)new Action<Task>(this, project){
            final /* synthetic */ KonanPlugin this$0;
            final /* synthetic */ ProjectInternal $project$inlined;
            {
                this.this$0 = konanPlugin;
                this.$project$inlined = projectInternal;
            }

            public final void execute(Task it) {
                KonanPlugin.access$cleanKonan(this.this$0, (Project)this.$project$inlined);
            }
        });
        Task runTask2 = KonanPluginKt.access$getOrCreateTask((Project)project, "run");
        project.afterEvaluate((Action)new Action<Project>(project, runTask2){
            final /* synthetic */ ProjectInternal $project;
            final /* synthetic */ Task $runTask;

            public final void execute(Project it) {
                Iterable $this$forEach$iv = CollectionsKt.filterIsInstance((Iterable)((Iterable)((Object)KonanPluginKt.getKonanArtifactsContainer((Project)this.$project))), KonanProgram.class);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    KonanProgram program = (KonanProgram)element$iv;
                    boolean bl = false;
                    Iterable $this$forEach$iv2 = (Iterable)((Object)program);
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        Exec exec2;
                        KonanCompileProgramTask compile2 = (KonanCompileProgramTask)element$iv2;
                        boolean bl2 = false;
                        if (compile2.getRunTask() == null) continue;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        Exec it2 = exec2;
                        boolean bl5 = false;
                        this.$runTask.dependsOn(new Object[]{it2});
                    }
                }
            }
            {
                this.$project = projectInternal;
                this.$runTask = task;
            }
        });
        ((PluginManagerInternal)project.getPluginManager()).apply(KotlinNativePlatformPlugin.class);
        project.afterEvaluate((Action)new Action<Project>(isPublicationEnabled, project, container){
            final /* synthetic */ boolean $isPublicationEnabled;
            final /* synthetic */ ProjectInternal $project;
            final /* synthetic */ KonanArtifactContainer $container;

            public final void execute(Project it) {
                if (!this.$isPublicationEnabled) {
                    return;
                }
                ((PluginManagerInternal)this.$project.getPluginManager()).withPlugin("maven-publish", (Action)new Action<AppliedPlugin>(this){
                    final /* synthetic */ apply.4 this$0;

                    public final void execute(AppliedPlugin it) {
                        this.this$0.$container.all((Action)new Action<KonanBuildingConfig<?>>(this){
                            final /* synthetic */ apply.1 this$0;

                            public final void execute(KonanBuildingConfig<?> buildingConfig) {
                                KonanSoftwareComponent konanSoftwareComponent = buildingConfig.getMainVariant$kotlin_native_gradle_plugin();
                                this.this$0.this$0.$project.getExtensions().configure(PublishingExtension.class, (Action)new Action<PublishingExtension>(this, buildingConfig, konanSoftwareComponent){
                                    final /* synthetic */ apply.1 this$0;
                                    final /* synthetic */ KonanBuildingConfig $buildingConfig;
                                    final /* synthetic */ KonanSoftwareComponent $konanSoftwareComponent;

                                    public final void execute(PublishingExtension it) {
                                        MavenPublication mavenPublication;
                                        KonanBuildingConfig konanBuildingConfig = this.$buildingConfig;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)konanBuildingConfig, (String)"buildingConfig");
                                        String builtArtifact = konanBuildingConfig.getName();
                                        PublishingExtension publishingExtension = it;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)publishingExtension, (String)"it");
                                        MavenPublication mavenPublication2 = mavenPublication = (MavenPublication)publishingExtension.getPublications().maybeCreate(builtArtifact, MavenPublication.class);
                                        boolean bl = false;
                                        boolean bl2 = false;
                                        MavenPublication $this$apply = mavenPublication2;
                                        boolean bl3 = false;
                                        $this$apply.setArtifactId(builtArtifact);
                                        $this$apply.setGroupId(this.this$0.this$0.this$0.$project.getGroup().toString());
                                        $this$apply.from((SoftwareComponent)this.$konanSoftwareComponent);
                                        MavenPublication mavenPublication3 = mavenPublication;
                                        if (mavenPublication3 == null) {
                                            throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal");
                                        }
                                        ((MavenPublicationInternal)mavenPublication3).publishWithOriginalFileName();
                                        Iterable $this$forEach$iv = this.$buildingConfig.getPomActions$kotlin_native_gradle_plugin();
                                        boolean $i$f$forEach = false;
                                        for (T element$iv : $this$forEach$iv) {
                                            Action it2 = (Action)element$iv;
                                            boolean bl4 = false;
                                            mavenPublication.pom(it2);
                                        }
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$buildingConfig = konanBuildingConfig;
                                        this.$konanSoftwareComponent = konanSoftwareComponent;
                                    }
                                });
                                this.this$0.this$0.$project.getExtensions().configure(PublishingExtension.class, (Action)new Action<PublishingExtension>(this, konanSoftwareComponent, buildingConfig){
                                    final /* synthetic */ apply.1 this$0;
                                    final /* synthetic */ KonanSoftwareComponent $konanSoftwareComponent;
                                    final /* synthetic */ KonanBuildingConfig $buildingConfig;

                                    public final void execute(PublishingExtension it) {
                                        PublishingExtension publishing = it;
                                        for (SoftwareComponent v : this.$konanSoftwareComponent.getVariants()) {
                                            PublishingExtension publishingExtension = publishing;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)publishingExtension, (String)"publishing");
                                            publishingExtension.getPublications().create(v.getName(), MavenPublication.class, (Action)new Action<MavenPublication>(this, v){
                                                final /* synthetic */ apply.2 this$0;
                                                final /* synthetic */ SoftwareComponent $v;

                                                public final void execute(MavenPublication mavenPublication) {
                                                    SoftwareComponent softwareComponent = this.$v;
                                                    if (softwareComponent == null) {
                                                        throw new TypeCastException("null cannot be cast to non-null type org.gradle.language.cpp.internal.NativeVariantIdentity");
                                                    }
                                                    ModuleVersionIdentifier coordinates = ((NativeVariantIdentity)softwareComponent).getCoordinates();
                                                    Logger logger = this.this$0.this$0.this$0.this$0.$project.getLogger();
                                                    StringBuilder stringBuilder = new StringBuilder().append("variant with coordinates(").append(coordinates).append(") and module: ");
                                                    ModuleVersionIdentifier moduleVersionIdentifier = coordinates;
                                                    Intrinsics.checkExpressionValueIsNotNull((Object)moduleVersionIdentifier, (String)"coordinates");
                                                    logger.info(stringBuilder.append(moduleVersionIdentifier.getModule()).toString());
                                                    MavenPublication mavenPublication2 = mavenPublication;
                                                    Intrinsics.checkExpressionValueIsNotNull((Object)mavenPublication2, (String)"mavenPublication");
                                                    ModuleIdentifier moduleIdentifier = coordinates.getModule();
                                                    Intrinsics.checkExpressionValueIsNotNull((Object)moduleIdentifier, (String)"coordinates.module");
                                                    mavenPublication2.setArtifactId(moduleIdentifier.getName());
                                                    mavenPublication.setGroupId(coordinates.getGroup());
                                                    mavenPublication.setVersion(coordinates.getVersion());
                                                    mavenPublication.from(this.$v);
                                                    ((MavenPublicationInternal)mavenPublication).publishWithOriginalFileName();
                                                    Iterable $this$forEach$iv = this.this$0.$buildingConfig.getPomActions$kotlin_native_gradle_plugin();
                                                    boolean $i$f$forEach = false;
                                                    for (T element$iv : $this$forEach$iv) {
                                                        Action it = (Action)element$iv;
                                                        boolean bl = false;
                                                        mavenPublication.pom(it);
                                                    }
                                                }
                                                {
                                                    this.this$0 = var1_1;
                                                    this.$v = softwareComponent;
                                                }
                                            });
                                        }
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$konanSoftwareComponent = konanSoftwareComponent;
                                        this.$buildingConfig = konanBuildingConfig;
                                    }
                                });
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$isPublicationEnabled = bl;
                this.$project = projectInternal;
                this.$container = konanArtifactContainer;
            }
        });
    }

    @Inject
    public KonanPlugin(@NotNull ToolingModelBuilderRegistry registry) {
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        this.registry = registry;
    }

    static {
        Companion = new Companion(null);
        REQUIRED_GRADLE_VERSION = GradleVersion.version((String)"4.7");
    }

    public static final /* synthetic */ void access$cleanKonan(KonanPlugin $this, Project $this$access_u24cleanKonan) {
        $this.cleanKonan($this$access_u24cleanKonan);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001b\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/konan/KonanPlugin$ProjectProperty;", "", "propertyName", "", "deprecatedPropertyName", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getDeprecatedPropertyName", "()Ljava/lang/String;", "getPropertyName", "KONAN_HOME", "KONAN_VERSION", "KONAN_BUILD_TARGETS", "KONAN_JVM_ARGS", "KONAN_USE_ENVIRONMENT_VARIABLES", "DOWNLOAD_COMPILER", "KONAN_CONFIGURATION_BUILD_DIR", "KONAN_DEBUGGING_SYMBOLS", "KONAN_OPTIMIZATIONS_ENABLE", "KONAN_PUBLICATION_ENABLED", "kotlin-native-gradle-plugin"})
    public static final class ProjectProperty
    extends Enum<ProjectProperty> {
        public static final /* enum */ ProjectProperty KONAN_HOME;
        public static final /* enum */ ProjectProperty KONAN_VERSION;
        public static final /* enum */ ProjectProperty KONAN_BUILD_TARGETS;
        public static final /* enum */ ProjectProperty KONAN_JVM_ARGS;
        public static final /* enum */ ProjectProperty KONAN_USE_ENVIRONMENT_VARIABLES;
        public static final /* enum */ ProjectProperty DOWNLOAD_COMPILER;
        public static final /* enum */ ProjectProperty KONAN_CONFIGURATION_BUILD_DIR;
        public static final /* enum */ ProjectProperty KONAN_DEBUGGING_SYMBOLS;
        public static final /* enum */ ProjectProperty KONAN_OPTIMIZATIONS_ENABLE;
        public static final /* enum */ ProjectProperty KONAN_PUBLICATION_ENABLED;
        private static final /* synthetic */ ProjectProperty[] $VALUES;
        @NotNull
        private final String propertyName;
        @Nullable
        private final String deprecatedPropertyName;

        static {
            ProjectProperty[] projectPropertyArray = new ProjectProperty[10];
            ProjectProperty[] projectPropertyArray2 = projectPropertyArray;
            projectPropertyArray[0] = KONAN_HOME = new ProjectProperty("org.jetbrains.kotlin.native.home", "konan.home");
            projectPropertyArray[1] = KONAN_VERSION = new ProjectProperty("KONAN_VERSION", 1, "org.jetbrains.kotlin.native.version", null, 2, null);
            projectPropertyArray[2] = KONAN_BUILD_TARGETS = new ProjectProperty("KONAN_BUILD_TARGETS", 2, "konan.build.targets", null, 2, null);
            projectPropertyArray[3] = KONAN_JVM_ARGS = new ProjectProperty("KONAN_JVM_ARGS", 3, "konan.jvmArgs", null, 2, null);
            projectPropertyArray[4] = KONAN_USE_ENVIRONMENT_VARIABLES = new ProjectProperty("KONAN_USE_ENVIRONMENT_VARIABLES", 4, "konan.useEnvironmentVariables", null, 2, null);
            projectPropertyArray[5] = DOWNLOAD_COMPILER = new ProjectProperty("DOWNLOAD_COMPILER", 5, "download.compiler", null, 2, null);
            projectPropertyArray[6] = KONAN_CONFIGURATION_BUILD_DIR = new ProjectProperty("KONAN_CONFIGURATION_BUILD_DIR", 6, "konan.configuration.build.dir", null, 2, null);
            projectPropertyArray[7] = KONAN_DEBUGGING_SYMBOLS = new ProjectProperty("KONAN_DEBUGGING_SYMBOLS", 7, "konan.debugging.symbols", null, 2, null);
            projectPropertyArray[8] = KONAN_OPTIMIZATIONS_ENABLE = new ProjectProperty("KONAN_OPTIMIZATIONS_ENABLE", 8, "konan.optimizations.enable", null, 2, null);
            projectPropertyArray[9] = KONAN_PUBLICATION_ENABLED = new ProjectProperty("KONAN_PUBLICATION_ENABLED", 9, "konan.publication.enabled", null, 2, null);
            $VALUES = projectPropertyArray;
        }

        @NotNull
        public final String getPropertyName() {
            return this.propertyName;
        }

        @Nullable
        public final String getDeprecatedPropertyName() {
            return this.deprecatedPropertyName;
        }

        private ProjectProperty(String propertyName, String deprecatedPropertyName) {
            this.propertyName = propertyName;
            this.deprecatedPropertyName = deprecatedPropertyName;
        }

        /* synthetic */ ProjectProperty(String string, int n, String string2, String string3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                string3 = null;
            }
            this(string2, string3);
        }

        public static ProjectProperty[] values() {
            return (ProjectProperty[])$VALUES.clone();
        }

        public static ProjectProperty valueOf(String string) {
            return Enum.valueOf(ProjectProperty.class, string);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/konan/KonanPlugin$Companion;", "", "()V", "ARTIFACTS_CONTAINER_NAME", "", "COMPILE_ALL_TASK_NAME", "KONAN_DOWNLOAD_TASK_NAME", "KONAN_EXTENSION_NAME", "KONAN_GENERATE_CMAKE_TASK_NAME", "REQUIRED_GRADLE_VERSION", "Lorg/gradle/util/GradleVersion;", "kotlin.jvm.PlatformType", "getREQUIRED_GRADLE_VERSION$kotlin_native_gradle_plugin", "()Lorg/gradle/util/GradleVersion;", "kotlin-native-gradle-plugin"})
    public static final class Companion {
        public final GradleVersion getREQUIRED_GRADLE_VERSION$kotlin_native_gradle_plugin() {
            return REQUIRED_GRADLE_VERSION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

