/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.PluginManager;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.experimental.internal.AbstractKotlinNativeBinary;
import org.jetbrains.kotlin.gradle.plugin.experimental.sourcesets.KotlinNativeSourceSetImpl;
import org.jetbrains.kotlin.gradle.plugin.experimental.tasks.KotlinNativeCompile;
import org.jetbrains.kotlin.gradle.plugin.konan.KonanPluginKt;
import org.jetbrains.kotlin.gradle.plugin.model.KonanModel;
import org.jetbrains.kotlin.gradle.plugin.model.KonanModelArtifact;
import org.jetbrains.kotlin.gradle.plugin.model.KonanModelArtifactImpl;
import org.jetbrains.kotlin.gradle.plugin.model.KonanModelImpl;
import shadow.org.jetbrains.kotlin.gradle.plugin.tasks.KonanBuildingTask;
import shadow.org.jetbrains.kotlin.konan.KonanVersion;
import shadow.org.jetbrains.kotlin.konan.KonanVersionGeneratedKt;
import shadow.org.jetbrains.kotlin.konan.target.CompilerOutputKind;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0014H\u0002R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/model/KonanToolingModelBuilder;", "Lorg/gradle/tooling/provider/model/ToolingModelBuilder;", "()V", "hasKonanPlugin", "", "Lorg/gradle/api/Project;", "getHasKonanPlugin", "(Lorg/gradle/api/Project;)Z", "hasKotlinNativePlugin", "getHasKotlinNativePlugin", "buildAll", "Lorg/jetbrains/kotlin/gradle/plugin/model/KonanModel;", "modelName", "", "project", "buildModelKonan", "buildModelKotlinNative", "canBuild", "toModelArtifact", "Lorg/jetbrains/kotlin/gradle/plugin/model/KonanModelArtifact;", "Lorg/jetbrains/kotlin/gradle/plugin/experimental/internal/AbstractKotlinNativeBinary;", "kotlin-native-gradle-plugin"})
public final class KonanToolingModelBuilder
implements ToolingModelBuilder {
    public static final KonanToolingModelBuilder INSTANCE;

    public boolean canBuild(@NotNull String modelName) {
        Intrinsics.checkParameterIsNotNull((Object)modelName, (String)"modelName");
        return Intrinsics.areEqual((Object)KonanModel.class.getName(), (Object)modelName);
    }

    /*
     * WARNING - void declaration
     */
    private final KonanModel buildModelKonan(Project project) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.toList((Iterable)CollectionsKt.flatten((Iterable)((Iterable)((Object)KonanPluginKt.getKonanArtifactsContainer(project)))));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KonanBuildingTask konanBuildingTask = (KonanBuildingTask)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            KonanModelArtifact konanModelArtifact = it.toModelArtifact$kotlin_native_gradle_plugin();
            collection.add(konanModelArtifact);
        }
        List artifacts = (List)destination$iv$iv;
        File file = project.file((Object)KonanPluginKt.getKonanHome(project));
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.file(project.konanHome)");
        return new KonanModelImpl(artifacts, file, KonanPluginKt.getKonanVersion(project), KonanPluginKt.getKonanExtension(project).getLanguageVersion(), KonanPluginKt.getKonanExtension(project).getApiVersion());
    }

    /*
     * WARNING - void declaration
     */
    private final KonanModel buildModelKotlinNative(Project project) {
        void $this$mapTo$iv$iv;
        NamedDomainObjectSet namedDomainObjectSet = project.getComponents().withType(AbstractKotlinNativeBinary.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)namedDomainObjectSet, (String)"project.components.withT\u2026NativeBinary::class.java)");
        Iterable $this$map$iv = (Iterable)namedDomainObjectSet;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AbstractKotlinNativeBinary abstractKotlinNativeBinary = (AbstractKotlinNativeBinary)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            KonanModelArtifact konanModelArtifact = INSTANCE.toModelArtifact((AbstractKotlinNativeBinary)v1);
            collection.add(konanModelArtifact);
        }
        List artifacts = (List)destination$iv$iv;
        File file = project.file((Object)KonanPluginKt.getKonanHome(project));
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.file(project.konanHome)");
        return new KonanModelImpl(artifacts, file, KonanVersionGeneratedKt.getCURRENT(KonanVersion.Companion), null, null);
    }

    /*
     * WARNING - void declaration
     */
    private final KonanModelArtifact toModelArtifact(@NotNull AbstractKotlinNativeBinary $this$toModelArtifact) {
        Collection<File> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        KotlinNativeCompile compileTask2 = (KotlinNativeCompile)((Object)$this$toModelArtifact.getCompileTask().get());
        Object object = $this$toModelArtifact.getComponent().getSources();
        boolean bl = false;
        boolean bl2 = false;
        KotlinNativeSourceSetImpl $this$with = object;
        boolean bl3 = false;
        Set set2 = $this$with.getKotlin().getSrcDirs();
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"kotlin.srcDirs");
        Set set3 = $this$with.getPlatformSources($this$toModelArtifact.getKonanTarget()).getSrcDirs();
        Intrinsics.checkExpressionValueIsNotNull((Object)set3, (String)"getPlatformSources(konanTarget).srcDirs");
        Set sourceRoots = SetsKt.plus((Set)set2, (Iterable)set3);
        String string = $this$toModelArtifact.getName();
        File file = compileTask2.getOutputFile();
        CompilerOutputKind compilerOutputKind = $this$toModelArtifact.getKind();
        String string2 = $this$toModelArtifact.getKonanTarget().getName();
        KotlinNativeCompile kotlinNativeCompile = compileTask2;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinNativeCompile), (String)"compileTask");
        String string3 = kotlinNativeCompile.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"compileTask.name");
        List list2 = CollectionsKt.toList((Iterable)sourceRoots);
        Set set4 = $this$toModelArtifact.getSources().getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set4, (String)"sources.files");
        List list3 = CollectionsKt.toList((Iterable)set4);
        Configuration configuration2 = $this$toModelArtifact.getKlibs();
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"klibs");
        Set set5 = configuration2.getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set5, (String)"klibs.files");
        List list4 = CollectionsKt.toList((Iterable)set5);
        Configuration configuration3 = $this$toModelArtifact.getKlibs();
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration3, (String)"klibs");
        Set set6 = configuration3.getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set6, (String)"klibs.files");
        object = set6;
        List list5 = list4;
        List list6 = list3;
        List list7 = list2;
        String string4 = string3;
        String string5 = string2;
        CompilerOutputKind compilerOutputKind2 = compilerOutputKind;
        File file2 = file;
        String string6 = string;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file3 = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            void v16 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v16, (String)"it");
            File file4 = v16.getParentFile();
            collection.add(file4);
        }
        Collection<File> collection2 = collection = (List)destination$iv$iv;
        List list8 = list5;
        List list9 = list6;
        List list10 = list7;
        String string7 = string4;
        String string8 = string5;
        CompilerOutputKind compilerOutputKind3 = compilerOutputKind2;
        File file5 = file2;
        String string9 = string6;
        return new KonanModelArtifactImpl(string9, file5, compilerOutputKind3, string8, string7, list10, list9, list8, (List<? extends File>)collection2);
    }

    private final boolean getHasKonanPlugin(@NotNull Project $this$hasKonanPlugin) {
        PluginManager pluginManager = $this$hasKonanPlugin.getPluginManager();
        boolean bl = false;
        boolean bl2 = false;
        PluginManager $this$with = pluginManager;
        boolean bl3 = false;
        return $this$with.hasPlugin("konan") || $this$with.hasPlugin("shadow.org.jetbrains.kotlin.konan");
    }

    private final boolean getHasKotlinNativePlugin(@NotNull Project $this$hasKotlinNativePlugin) {
        PluginManager pluginManager = $this$hasKotlinNativePlugin.getPluginManager();
        boolean bl = false;
        boolean bl2 = false;
        PluginManager $this$with = pluginManager;
        boolean bl3 = false;
        return $this$with.hasPlugin("kotlin-native") || $this$with.hasPlugin("kotlin-platform-native") || $this$with.hasPlugin("org.jetbrains.kotlin.native") || $this$with.hasPlugin("org.jetbrains.kotlin.platform.native");
    }

    @NotNull
    public KonanModel buildAll(@NotNull String modelName, @NotNull Project project) {
        KonanModel konanModel;
        Intrinsics.checkParameterIsNotNull((Object)modelName, (String)"modelName");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (this.getHasKotlinNativePlugin(project)) {
            konanModel = this.buildModelKotlinNative(project);
        } else if (this.getHasKonanPlugin(project)) {
            konanModel = this.buildModelKonan(project);
        } else {
            throw (Throwable)new IllegalStateException("The project '" + project.getPath() + "' has no Kotlin/Native plugin");
        }
        return konanModel;
    }

    private KonanToolingModelBuilder() {
    }

    static {
        KonanToolingModelBuilder konanToolingModelBuilder;
        INSTANCE = konanToolingModelBuilder = new KonanToolingModelBuilder();
    }
}

