/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.jetbrains.kotlin.compilerRunner;

import java.io.File;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.common.CompilationResultCategory;
import org.jetbrains.kotlin.daemon.common.CompilationResults;
import org.jetbrains.kotlin.daemon.common.CompileIterationResult;
import org.jetbrains.kotlin.daemon.common.LoopbackNetworkInterface;
import shadow.org.jetbrains.kotlin.compilerRunner.KotlinLogger;
import shadow.org.jetbrains.kotlin.gradle.utils.FileUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\"\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lshadow/org/jetbrains/kotlin/compilerRunner/GradleCompilationResults;", "Lorg/jetbrains/kotlin/daemon/common/CompilationResults;", "Ljava/rmi/server/UnicastRemoteObject;", "log", "Lshadow/org/jetbrains/kotlin/compilerRunner/KotlinLogger;", "projectRootFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;Ljava/io/File;)V", "icLogLines", "", "", "getIcLogLines", "()Ljava/util/List;", "setIcLogLines", "(Ljava/util/List;)V", "add", "", "compilationResultCategory", "", "value", "Ljava/io/Serializable;", "kotlin-gradle-plugin"})
public final class GradleCompilationResults
extends UnicastRemoteObject
implements CompilationResults {
    @Nullable
    private List<String> icLogLines;
    private final KotlinLogger log;
    private final File projectRootFile;

    @Nullable
    public final List<String> getIcLogLines() {
        return this.icLogLines;
    }

    public final void setIcLogLines(@Nullable List<String> list2) {
        this.icLogLines = list2;
    }

    public void add(int compilationResultCategory, @NotNull Serializable value) throws RemoteException {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        int n = compilationResultCategory;
        if (n == CompilationResultCategory.IC_COMPILE_ITERATION.getCode()) {
            CompileIterationResult compileIterationResult;
            Serializable serializable = value;
            if (!(serializable instanceof CompileIterationResult)) {
                serializable = null;
            }
            if ((compileIterationResult = (CompileIterationResult)serializable) != null) {
                Iterable sourceFiles = compileIterationResult.getSourceFiles();
                if (CollectionsKt.any((Iterable)sourceFiles)) {
                    KotlinLogger $receiver$iv = this.log;
                    boolean $i$f$kotlinDebug = false;
                    if ($receiver$iv.isDebugEnabled()) {
                        boolean bl = false;
                        String msg$iv = "compile iteration: " + FileUtilsKt.pathsAsStringRelativeTo(sourceFiles, this.projectRootFile);
                        $receiver$iv.debug("[KOTLIN] " + msg$iv);
                    }
                }
                String exitCode = compileIterationResult.getExitCode();
                KotlinLogger $receiver$iv = this.log;
                boolean $i$f$kotlinDebug = false;
                if ($receiver$iv.isDebugEnabled()) {
                    boolean bl = false;
                    String msg$iv = "compiler exit code: " + exitCode;
                    $receiver$iv.debug("[KOTLIN] " + msg$iv);
                }
            }
        } else if (n == CompilationResultCategory.BUILD_REPORT_LINES.getCode() || n == CompilationResultCategory.VERBOSE_BUILD_REPORT_LINES.getCode()) {
            Serializable serializable = value;
            if (!(serializable instanceof List)) {
                serializable = null;
            }
            this.icLogLines = (List)((Object)serializable);
        }
    }

    public GradleCompilationResults(@NotNull KotlinLogger log2, @NotNull File projectRootFile) {
        Intrinsics.checkParameterIsNotNull((Object)log2, (String)"log");
        Intrinsics.checkParameterIsNotNull((Object)projectRootFile, (String)"projectRootFile");
        super(0, (RMIClientSocketFactory)LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory(), (RMIServerSocketFactory)LoopbackNetworkInterface.INSTANCE.getServerLoopbackSocketFactory());
        this.log = log2;
        this.projectRootFile = projectRootFile;
    }
}

