/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.jetbrains.kotlin.gradle.plugin.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.konan.KonanCompileConfig;
import org.jetbrains.kotlin.gradle.plugin.konan.KonanInteropLibrary;
import org.jetbrains.kotlin.gradle.plugin.konan.KonanLibrary;
import org.jetbrains.kotlin.gradle.plugin.konan.KonanPluginKt;
import org.jetbrains.kotlin.gradle.plugin.konan.KonanProgram;
import shadow.org.jetbrains.kotlin.gradle.plugin.tasks.Call;
import shadow.org.jetbrains.kotlin.gradle.plugin.tasks.KonanBuildingTask;
import shadow.org.jetbrains.kotlin.gradle.plugin.tasks.KonanCompileLibraryTask;
import shadow.org.jetbrains.kotlin.gradle.plugin.tasks.KonanCompileProgramTask;
import shadow.org.jetbrains.kotlin.gradle.plugin.tasks.KonanCompileTask;
import shadow.org.jetbrains.kotlin.gradle.plugin.tasks.KonanInteropTask;
import shadow.org.jetbrains.kotlin.konan.target.Family;
import shadow.org.jetbrains.kotlin.konan.target.HostManager;
import shadow.org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0007J:\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00072\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00062\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00062\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\u00020\u0007*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\u00020\u0007*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\u00020\u0007*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0018\u0010\u0015\u001a\u00020\u0007*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u0018\u0010\u0017\u001a\u00020\u0007*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001a\u001a\u00020\u001b*\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006("}, d2={"Lshadow/org/jetbrains/kotlin/gradle/plugin/tasks/KonanGenerateCMakeTask;", "Lorg/gradle/api/DefaultTask;", "()V", "host", "Lshadow/org/jetbrains/kotlin/konan/target/KonanTarget;", "asCMakeSourceList", "", "", "Lorg/gradle/api/file/FileCollection;", "getAsCMakeSourceList", "(Lorg/gradle/api/file/FileCollection;)Ljava/util/List;", "cMakeCompilerOpts", "Lshadow/org/jetbrains/kotlin/gradle/plugin/tasks/KonanInteropTask;", "getCMakeCompilerOpts", "(Lorg/jetbrains/kotlin/gradle/plugin/tasks/KonanInteropTask;)Ljava/lang/String;", "cMakeLibraries", "Lshadow/org/jetbrains/kotlin/gradle/plugin/tasks/KonanCompileTask;", "getCMakeLibraries", "(Lorg/jetbrains/kotlin/gradle/plugin/tasks/KonanCompileTask;)Ljava/lang/String;", "cMakeLinkerOpts", "getCMakeLinkerOpts", "cMakeSources", "getCMakeSources", "crossPlatformPath", "getCrossPlatformPath", "(Ljava/lang/String;)Ljava/lang/String;", "relativePath", "Ljava/io/File;", "getRelativePath", "(Ljava/io/File;)Ljava/io/File;", "generateCMake", "", "generateCMakeLists", "projectName", "interops", "Lorg/jetbrains/kotlin/gradle/plugin/konan/KonanInteropLibrary;", "libraries", "Lorg/jetbrains/kotlin/gradle/plugin/konan/KonanLibrary;", "programs", "Lorg/jetbrains/kotlin/gradle/plugin/konan/KonanProgram;", "kotlin-native-gradle-plugin"})
public class KonanGenerateCMakeTask
extends DefaultTask {
    private final KonanTarget host = HostManager.Companion.getHost();

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void generateCMake() {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        void $this$filterIsInstanceTo$iv$iv3;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Iterable $this$filterIsInstance$iv = CollectionsKt.toList((Iterable)((Iterable)((Object)KonanPluginKt.getKonanArtifactsContainer(project))));
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv3) {
            if (!(element$iv$iv instanceof KonanInteropLibrary)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List interops = (List)destination$iv$iv;
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        Iterable $this$filterIsInstance$iv2 = CollectionsKt.toList((Iterable)((Iterable)((Object)KonanPluginKt.getKonanArtifactsContainer(project2))));
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv = $this$filterIsInstance$iv2;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof KonanLibrary)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List libraries2 = (List)destination$iv$iv2;
        Project project3 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        Iterable $this$filterIsInstance$iv3 = CollectionsKt.toList((Iterable)((Iterable)((Object)KonanPluginKt.getKonanArtifactsContainer(project3))));
        boolean $i$f$filterIsInstance3 = false;
        destination$iv$iv2 = $this$filterIsInstance$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterIsInstanceTo3 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KonanProgram)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List programs = (List)destination$iv$iv3;
        Project project4 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
        String string = project4.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
        String cMakeLists = this.generateCMakeLists(string, interops, libraries2, programs);
        Project project5 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project5, (String)"project");
        FilesKt.writeText$default((File)new File(project5.getProjectDir(), "CMakeLists.txt"), (String)cMakeLists, null, (int)2, null);
        Project project6 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project6, (String)"project");
        new File(project6.getProjectDir(), "KotlinCMakeModule").mkdir();
    }

    private final String generateCMakeLists(String projectName, List<? extends KonanInteropLibrary> interops, List<? extends KonanLibrary> libraries2, List<? extends KonanProgram> programs) {
        boolean bl;
        Call call;
        StringBuilder stringBuilder;
        String cMakeCurrentListDir = "${CMAKE_CURRENT_LIST_DIR}";
        boolean bl2 = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder2;
        boolean bl5 = false;
        StringBuilder stringBuilder3 = $this$buildString;
        Iterator<KonanCompileConfig> iterator = StringsKt.trimIndent((String)("\n                cmake_minimum_required(VERSION 3.8)\n\n                set(CMAKE_MODULE_PATH " + cMakeCurrentListDir + "/KotlinCMakeModule)\n\n                project(" + projectName + " Kotlin)\n            "));
        boolean bl6 = false;
        StringBuilder stringBuilder4 = stringBuilder3.append((String)((Object)iterator));
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder4, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder4);
        StringsKt.appendln((StringBuilder)$this$buildString);
        for (KonanInteropLibrary konanInteropLibrary : interops) {
            KonanInteropTask task;
            if ((KonanInteropTask)konanInteropLibrary.get$kotlin_native_gradle_plugin(this.host) == null) {
                continue;
            }
            stringBuilder = $this$buildString;
            Call call2 = new Call("cinterop").arg("NAME", konanInteropLibrary.getName());
            String string = this.getRelativePath(task.getDefFile()).toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"task.defFile.relativePath.toString()");
            call = call2.arg("DEF_FILE", this.getCrossPlatformPath(string)).arg("COMPILER_OPTS", this.getCMakeCompilerOpts(task));
            bl = false;
            StringBuilder stringBuilder5 = stringBuilder.append(call);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder5, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder5);
        }
        for (KonanLibrary konanLibrary : libraries2) {
            KonanCompileLibraryTask task;
            if ((KonanCompileLibraryTask)konanLibrary.get$kotlin_native_gradle_plugin(this.host) == null) {
                continue;
            }
            stringBuilder = $this$buildString;
            call = new Call("konanc_library").arg("NAME", konanLibrary.getName()).arg("SOURCES", this.getCMakeSources(task)).arg("LIBRARIES", this.getCMakeLibraries(task)).arg("LINKER_OPTS", this.getCMakeLinkerOpts(task));
            bl = false;
            StringBuilder stringBuilder6 = stringBuilder.append(call);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder6, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder6);
        }
        for (KonanProgram konanProgram : programs) {
            KonanCompileProgramTask task;
            if ((KonanCompileProgramTask)konanProgram.get$kotlin_native_gradle_plugin(this.host) == null) {
                continue;
            }
            stringBuilder = $this$buildString;
            call = new Call("konanc_executable").arg("NAME", konanProgram.getName()).arg("SOURCES", this.getCMakeSources(task)).arg("LIBRARIES", this.getCMakeLibraries(task)).arg("LINKER_OPTS", this.getCMakeLinkerOpts(task));
            bl = false;
            StringBuilder stringBuilder7 = stringBuilder.append(call);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder7, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder7);
        }
        String string = stringBuilder2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final File getRelativePath(@NotNull File $this$relativePath) {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        File file = project.getProjectDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.projectDir");
        return FilesKt.relativeTo((File)$this$relativePath, (File)file);
    }

    private final String getCrossPlatformPath(@NotNull String $this$crossPlatformPath) {
        return this.host.getFamily() == Family.MINGW ? StringsKt.replace$default((String)$this$crossPlatformPath, (char)'\\', (char)'/', (boolean)false, (int)4, null) : $this$crossPlatformPath;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getAsCMakeSourceList(@NotNull FileCollection $this$asCMakeSourceList) {
        void $this$mapTo$iv$iv;
        Set set2 = $this$asCMakeSourceList.getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"files");
        Iterable $this$map$iv = set2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            String string = this.getRelativePath((File)v1).toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.relativePath.toString()");
            String string2 = this.getCrossPlatformPath(string);
            collection.add(string2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final String getCMakeCompilerOpts(@NotNull KonanInteropTask $this$cMakeCompilerOpts) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = $this$cMakeCompilerOpts.getIncludeDirs().getAllHeadersDirs();
        Collection collection2 = $this$cMakeCompilerOpts.getCompilerOpts();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("-I");
            String string = it.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.absolutePath");
            String string2 = stringBuilder.append(this.getCrossPlatformPath(string)).toString();
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)collection2, (Iterable)collection), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String getCMakeSources(@NotNull KonanCompileTask $this$cMakeSources) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$cMakeSources.getAllSources();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FileCollection it = (FileCollection)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.getAsCMakeSourceList(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String getCMakeLibraries(@NotNull KonanCompileTask $this$cMakeLibraries) {
        Object list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        String string;
        FileCollection it;
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        boolean bl = false;
        List list2 = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List $this$apply = list2;
        boolean bl4 = false;
        Iterable iterable = $this$cMakeLibraries.getLibraries().getArtifacts();
        List list3 = $this$apply;
        boolean $i$f$map = false;
        void var10_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            KonanBuildingTask konanBuildingTask = (KonanBuildingTask)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl5 = false;
            string = it.getArtifactName();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        list3.addAll((Collection)collection);
        $this$apply.addAll((Collection)$this$cMakeLibraries.getLibraries().getNamedKlibs());
        $this$map$iv = $this$cMakeLibraries.getLibraries().getFiles();
        list3 = $this$apply;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (FileCollection)element$iv$iv;
            boolean bl6 = false;
            list$iv$iv = it.getFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        collection = (List)destination$iv$iv;
        $this$flatMap$iv = collection;
        $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl7 = false;
            FileCollection fileCollection = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"it");
            String string2 = fileCollection.getCanonicalPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.canonicalPath");
            string = this.getCrossPlatformPath(string2);
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        list3.addAll(collection);
        return CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    private final String getCMakeLinkerOpts(@NotNull KonanCompileTask $this$cMakeLinkerOpts) {
        return StringsKt.replace$default((String)CollectionsKt.joinToString$default((Iterable)$this$cMakeLinkerOpts.getLinkerOpts(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), (char)'\\', (char)'/', (boolean)false, (int)4, null);
    }
}

