/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.jetbrains.kotlin.gradle.targets.js.npm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.attributes.Usage;
import org.gradle.api.tasks.TaskContainer;
import org.jetbrains.annotations.NotNull;
import shadow.org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension;
import shadow.org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtension;
import shadow.org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import shadow.org.jetbrains.kotlin.gradle.dsl.KotlinSingleTargetExtension;
import shadow.org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import shadow.org.jetbrains.kotlin.gradle.plugin.KotlinPlatformType;
import shadow.org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import shadow.org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import shadow.org.jetbrains.kotlin.gradle.plugin.KotlinTargetConfiguratorKt;
import shadow.org.jetbrains.kotlin.gradle.plugin.mpp.KotlinJsCompilation;
import shadow.org.jetbrains.kotlin.gradle.plugin.mpp.KotlinUsages;
import shadow.org.jetbrains.kotlin.gradle.targets.js.RequiredKotlinJsDependency;
import shadow.org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsExtensionKt;
import shadow.org.jetbrains.kotlin.gradle.targets.js.npm.GradleNodeModule;
import shadow.org.jetbrains.kotlin.gradle.targets.js.npm.NpmDependency;
import shadow.org.jetbrains.kotlin.gradle.targets.js.npm.NpmGradleDependencies;
import shadow.org.jetbrains.kotlin.gradle.targets.js.npm.NpmProject;
import shadow.org.jetbrains.kotlin.gradle.targets.js.npm.NpmProjectKt;
import shadow.org.jetbrains.kotlin.gradle.targets.js.npm.NpmProjectPackage;
import shadow.org.jetbrains.kotlin.gradle.targets.js.npm.NpmProjects;
import shadow.org.jetbrains.kotlin.gradle.targets.js.npm.NpmResolver;
import shadow.org.jetbrains.kotlin.gradle.targets.js.npm.PackageJson;
import shadow.org.jetbrains.kotlin.gradle.targets.js.npm.RequiresNpmDependencies;
import shadow.org.jetbrains.kotlin.gradle.targets.js.npm.SemverKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\nH\u0002J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0012H\u0002J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\tH\u0002J&\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0#2\u0006\u0010$\u001a\u00020%H\u0002J\u0006\u0010&\u001a\u00020'J\u0010\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020\u0019H\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u000e0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lshadow/org/jetbrains/kotlin/gradle/targets/js/npm/NpmProjectVisitor;", "", "resolver", "Lshadow/org/jetbrains/kotlin/gradle/targets/js/npm/NpmResolver;", "project", "Lorg/gradle/api/Project;", "(Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmResolver;Lorg/gradle/api/Project;)V", "byCompilation", "", "Lshadow/org/jetbrains/kotlin/gradle/plugin/mpp/KotlinJsCompilation;", "Lshadow/org/jetbrains/kotlin/gradle/targets/js/npm/NpmProjectPackage;", "byNpmDependency", "Lshadow/org/jetbrains/kotlin/gradle/targets/js/npm/NpmDependency;", "npmProjects", "", "getProject", "()Lorg/gradle/api/Project;", "requiredFromTasksByCompilation", "Lshadow/org/jetbrains/kotlin/gradle/targets/js/npm/RequiresNpmDependencies;", "getResolver", "()Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmResolver;", "taskRequirements", "", "Lshadow/org/jetbrains/kotlin/gradle/targets/js/RequiredKotlinJsDependency;", "addNpmProject", "", "resolved", "addTaskRequirements", "task", "visitCompilation", "compilation", "visitConfiguration", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "npmDependencies", "", "gradleDependencies", "Lshadow/org/jetbrains/kotlin/gradle/targets/js/npm/NpmGradleDependencies;", "visitProject", "Lshadow/org/jetbrains/kotlin/gradle/targets/js/npm/NpmProjects;", "visitTarget", "target", "Lshadow/org/jetbrains/kotlin/gradle/plugin/KotlinTarget;", "visitTasksRequiredDependencies", "kotlin-gradle-plugin"})
public final class NpmProjectVisitor {
    private final List<NpmProjectPackage> npmProjects;
    private final Map<KotlinJsCompilation, NpmProjectPackage> byCompilation;
    private final Map<NpmDependency, NpmProjectPackage> byNpmDependency;
    private final Map<RequiresNpmDependencies, Collection<RequiredKotlinJsDependency>> taskRequirements;
    private final Map<KotlinJsCompilation, List<RequiresNpmDependencies>> requiredFromTasksByCompilation;
    @NotNull
    private final NpmResolver resolver;
    @NotNull
    private final Project project;

    /*
     * WARNING - void declaration
     */
    private final void addTaskRequirements(RequiresNpmDependencies task) {
        Object object;
        void $this$getOrPut$iv;
        List requirements = CollectionsKt.toList((Iterable)task.getRequiredNpmDependencies());
        this.taskRequirements.put(task, requirements);
        Map<KotlinJsCompilation, List<RequiresNpmDependencies>> map2 = this.requiredFromTasksByCompilation;
        KotlinJsCompilation key$iv = task.getCompilation();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            boolean bl2 = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((List)object).add(task);
    }

    private final void addNpmProject(NpmProjectPackage resolved) {
        KotlinJsCompilation compilation = resolved.getNpmProject().getCompilation();
        this.byCompilation.put(compilation, resolved);
        Iterable $this$forEach$iv = resolved.getNpmDependencies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NpmDependency it = (NpmDependency)element$iv;
            boolean bl = false;
            this.byNpmDependency.put(it, resolved);
        }
        this.npmProjects.add(resolved);
    }

    @NotNull
    public final NpmProjects visitProject() {
        this.visitTasksRequiredDependencies();
        KotlinProjectExtension kotlin = KotlinProjectExtensionKt.getKotlinExtensionOrNull(this.project);
        if (kotlin != null) {
            KotlinProjectExtension kotlinProjectExtension = kotlin;
            if (kotlinProjectExtension instanceof KotlinSingleTargetExtension) {
                this.visitTarget(((KotlinSingleTargetExtension)kotlin).getTarget());
            } else if (kotlinProjectExtension instanceof KotlinMultiplatformExtension) {
                Iterable $this$forEach$iv = (Iterable)((KotlinMultiplatformExtension)kotlin).getTargets();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KotlinTarget it = (KotlinTarget)element$iv;
                    boolean bl = false;
                    KotlinTarget kotlinTarget = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinTarget, (String)"it");
                    this.visitTarget(kotlinTarget);
                }
            }
        }
        return new NpmProjects(this.project, this.npmProjects, this.byCompilation, this.byNpmDependency, this.taskRequirements);
    }

    private final void visitTasksRequiredDependencies() {
        TaskContainer taskContainer = this.project.getTasks();
        Intrinsics.checkExpressionValueIsNotNull((Object)taskContainer, (String)"project.tasks");
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)((Iterable)taskContainer));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Task task = (Task)element$iv;
            boolean bl = false;
            Task task2 = task;
            Intrinsics.checkExpressionValueIsNotNull((Object)task2, (String)"task");
            if (!task2.getEnabled() || !(task instanceof RequiresNpmDependencies)) continue;
            this.addTaskRequirements((RequiresNpmDependencies)task);
        }
    }

    private final void visitTarget(KotlinTarget target2) {
        if (target2.getPlatformType() == KotlinPlatformType.js) {
            Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)((Iterable)target2.getCompilations()));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KotlinCompilation compilation = (KotlinCompilation)element$iv;
                boolean bl = false;
                if (!(compilation instanceof KotlinJsCompilation)) continue;
                this.visitCompilation((KotlinJsCompilation)compilation);
            }
        }
    }

    private final void visitCompilation(KotlinJsCompilation compilation) {
        Object it;
        Project project = compilation.getTarget().getProject();
        NpmProject npmProject = NpmProjectKt.getNpmProject(compilation);
        String name2 = npmProject.getName();
        PackageJson packageJson = new PackageJson(name2, SemverKt.fixSemver(project.getVersion().toString()));
        boolean bl = false;
        Set npmDependencies = new LinkedHashSet();
        NpmGradleDependencies gradleDeps = new NpmGradleDependencies();
        Configuration aggregateConfiguration2 = (Configuration)project.getConfigurations().create(name2 + "-npm", (Action)new Action<Configuration>(compilation){
            final /* synthetic */ KotlinJsCompilation $compilation;

            public final void execute(Configuration it) {
                Configuration configuration2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"it");
                KotlinTargetConfiguratorKt.usesPlatformOf(configuration2, this.$compilation.getTarget());
                it.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)KotlinUsages.INSTANCE.consumerRuntimeUsage$kotlin_gradle_plugin(this.$compilation.getTarget()));
                it.setVisible(false);
                it.setCanBeConsumed(false);
                it.setCanBeResolved(true);
                it.setDescription("NPM configuration for " + this.$compilation + '.');
            }
            {
                this.$compilation = kotlinJsCompilation;
            }
        });
        Iterable $this$forEach$iv = compilation.getAllKotlinSourceSets();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinSourceSet sourceSet = (KotlinSourceSet)element$iv;
            boolean bl2 = false;
            Iterable $this$forEach$iv2 = sourceSet.getRelatedConfigurationNames();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String configurationName = (String)element$iv2;
                boolean bl3 = false;
                Configuration configuration2 = project.getConfigurations().getByName(configurationName);
                aggregateConfiguration2.extendsFrom(new Configuration[]{configuration2});
            }
        }
        packageJson.setMain(npmProject.getMain());
        List<RequiresNpmDependencies> requiredByTasks = this.requiredFromTasksByCompilation.get(compilation);
        boolean nodeModulesRequired = false;
        if (requiredByTasks != null) {
            Collection collection = requiredByTasks;
            boolean element$iv = false;
            if (!collection.isEmpty()) {
                Configuration toolsConfiguration = (Configuration)project.getConfigurations().create(name2 + "-jsTools");
                Iterable $this$forEach$iv3 = requiredByTasks;
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    RequiresNpmDependencies it2 = (RequiresNpmDependencies)element$iv3;
                    boolean bl4 = false;
                    if (it2.getNodeModulesRequired()) {
                        nodeModulesRequired = true;
                    }
                    Iterable $this$forEach$iv4 = it2.getRequiredNpmDependencies();
                    boolean $i$f$forEach4 = false;
                    for (Object element$iv4 : $this$forEach$iv4) {
                        RequiredKotlinJsDependency requirement = (RequiredKotlinJsDependency)element$iv4;
                        boolean bl5 = false;
                        Configuration configuration3 = toolsConfiguration;
                        Intrinsics.checkExpressionValueIsNotNull((Object)configuration3, (String)"toolsConfiguration");
                        configuration3.getDependencies().add((Object)requirement.createDependency(project));
                    }
                }
                aggregateConfiguration2.extendsFrom(new Configuration[]{toolsConfiguration});
            }
        }
        Configuration configuration4 = aggregateConfiguration2;
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration4, (String)"aggregateConfiguration");
        this.visitConfiguration(configuration4, npmDependencies, gradleDeps);
        Iterable $this$forEach$iv5 = npmDependencies;
        boolean $i$f$forEach5 = false;
        for (Object element$iv : $this$forEach$iv5) {
            it = (NpmDependency)element$iv;
            boolean bl6 = false;
            packageJson.getDependencies().put(((NpmDependency)it).getKey(), this.resolver.chooseVersion(packageJson.getDependencies().get(((NpmDependency)it).getKey()), ((NpmDependency)it).getVersion()));
        }
        $this$forEach$iv5 = gradleDeps.getExternalModules();
        $i$f$forEach5 = false;
        for (Object element$iv : $this$forEach$iv5) {
            it = (GradleNodeModule)element$iv;
            boolean bl7 = false;
            packageJson.getDependencies().put(((GradleNodeModule)it).getName(), ((GradleNodeModule)it).getVersion());
        }
        $this$forEach$iv5 = gradleDeps.getInternalModules();
        $i$f$forEach5 = false;
        for (Object element$iv : $this$forEach$iv5) {
            Project target2 = (Project)element$iv;
            boolean bl8 = false;
            NpmProjectPackage resolvedTarget = this.resolver.findDependentResolvedNpmProject(project, target2);
            if (resolvedTarget == null) continue;
            packageJson.getDependencies().put(resolvedTarget.getPackageJson().getName(), resolvedTarget.getPackageJson().getVersion());
        }
        $this$forEach$iv5 = NodeJsExtensionKt.getNodeJs(project).getPackageJsonHandlers$kotlin_gradle_plugin();
        $i$f$forEach5 = false;
        for (Object element$iv : $this$forEach$iv5) {
            it = (Function1)element$iv;
            boolean bl9 = false;
            it.invoke((Object)packageJson);
        }
        NpmProjectPackage npmPackage = new NpmProjectPackage(project, npmProject, npmDependencies, gradleDeps, packageJson, nodeModulesRequired);
        npmPackage.getPackageJson().saveTo(npmProject.getPackageJsonFile());
        this.resolver.getPackageManager().resolveProject(npmPackage);
        this.addNpmProject(npmPackage);
    }

    private final void visitConfiguration(Configuration configuration2, Set<NpmDependency> npmDependencies, NpmGradleDependencies gradleDependencies) {
        this.resolver.getGradleNodeModules().collectDependenciesFromConfiguration(configuration2, gradleDependencies);
        DependencySet dependencySet = configuration2.getAllDependencies();
        Intrinsics.checkExpressionValueIsNotNull((Object)dependencySet, (String)"configuration.allDependencies");
        Iterable $this$forEach$iv = (Iterable)dependencySet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Dependency dependency = (Dependency)element$iv;
            boolean bl = false;
            Dependency dependency2 = dependency;
            if (!(dependency2 instanceof NpmDependency)) continue;
            npmDependencies.add((NpmDependency)dependency);
        }
    }

    @NotNull
    public final NpmResolver getResolver() {
        return this.resolver;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public NpmProjectVisitor(@NotNull NpmResolver resolver, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.resolver = resolver;
        this.project = project;
        NpmProjectVisitor npmProjectVisitor = this;
        boolean bl = false;
        Object object = new ArrayList();
        npmProjectVisitor.npmProjects = object;
        npmProjectVisitor = this;
        bl = false;
        npmProjectVisitor.byCompilation = object = (Map)new LinkedHashMap();
        npmProjectVisitor = this;
        bl = false;
        npmProjectVisitor.byNpmDependency = object = (Map)new LinkedHashMap();
        npmProjectVisitor = this;
        bl = false;
        npmProjectVisitor.taskRequirements = object = (Map)new LinkedHashMap();
        npmProjectVisitor = this;
        bl = false;
        npmProjectVisitor.requiredFromTasksByCompilation = object = (Map)new LinkedHashMap();
    }
}

