/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.jetbrains.kotlin.gradle.testing.internal;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.testing.AbstractTestTask;
import org.gradle.api.tasks.testing.JUnitXmlReport;
import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.api.tasks.testing.TestListener;
import org.gradle.api.tasks.testing.TestReport;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.api.tasks.testing.TestTaskReports;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shadow.org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import shadow.org.jetbrains.kotlin.gradle.testing.internal.KotlinTestReport;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Q\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u000e\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0000J\u0010\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020 H\u0002J\u0010\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020)H\u0002J\b\u0010\u0003\u001a\u00020#H\u0007J\b\u0010*\u001a\u00020#H\u0002J\u0010\u0010+\u001a\u00020#2\u0006\u0010&\u001a\u00020 H\u0002J\u000e\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020.J\b\u0010\u001a\u001a\u00020#H\u0002J\u000e\u0010/\u001a\u00020#2\u0006\u0010&\u001a\u00020 J\u0010\u00100\u001a\u00020#2\u0006\u0010&\u001a\u00020 H\u0002J\u0010\u00101\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0000H\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0006R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00148WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0017\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0006\"\u0004\b\u0019\u0010\bR\u0011\u0010\u001a\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0006R\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u00008\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\f\u00a8\u00062"}, d2={"Lshadow/org/jetbrains/kotlin/gradle/testing/internal/KotlinTestReport;", "Lorg/gradle/api/tasks/testing/TestReport;", "()V", "checkFailedTests", "", "getCheckFailedTests", "()Z", "setCheckFailedTests", "(Z)V", "children", "", "getChildren", "()Ljava/util/List;", "failedTestsListener", "shadow/org/jetbrains/kotlin/gradle/testing/internal/KotlinTestReport$failedTestsListener$1", "Lshadow/org/jetbrains/kotlin/gradle/testing/internal/KotlinTestReport$failedTestsListener$1;", "hasFailedTests", "getHasFailedTests", "hasOwnFailedTests", "htmlReportUrl", "", "getHtmlReportUrl", "()Ljava/lang/String;", "ignoreFailures", "getIgnoreFailures", "setIgnoreFailures", "overrideReporting", "getOverrideReporting", "parent", "projectProperties", "Lshadow/org/jetbrains/kotlin/gradle/plugin/PropertiesProvider;", "testTasks", "Lorg/gradle/api/tasks/testing/AbstractTestTask;", "getTestTasks", "addChild", "", "child", "addToParents", "task", "asClickableFileUrl", "path", "Ljava/io/File;", "disableIndividualTestTaskReportingAndFailing", "disableTestReporting", "maybeOverrideReporting", "graph", "Lorg/gradle/api/execution/TaskExecutionGraph;", "registerTestTask", "reportOn", "reportOnChildTasks", "kotlin-gradle-plugin"})
public class KotlinTestReport
extends TestReport {
    @Internal
    @NotNull
    private final List<AbstractTestTask> testTasks;
    @Internal
    private KotlinTestReport parent;
    @Internal
    @NotNull
    private final List<KotlinTestReport> children;
    private final PropertiesProvider projectProperties;
    @Input
    private boolean checkFailedTests;
    @Input
    private boolean ignoreFailures;
    private boolean hasOwnFailedTests;
    private final failedTestsListener.1 failedTestsListener;

    @NotNull
    public final List<AbstractTestTask> getTestTasks() {
        return this.testTasks;
    }

    @NotNull
    public final List<KotlinTestReport> getChildren() {
        return this.children;
    }

    @Input
    public final boolean getOverrideReporting() {
        return this.projectProperties.getIndividualTaskReports() == null;
    }

    public final boolean getCheckFailedTests() {
        return this.checkFailedTests;
    }

    public final void setCheckFailedTests(boolean bl) {
        this.checkFailedTests = bl;
    }

    public final boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    public final void setIgnoreFailures(boolean bl) {
        this.ignoreFailures = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getHasFailedTests() {
        KotlinTestReport it;
        if (this.hasOwnFailedTests) return true;
        Iterable $this$any$iv = this.children;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (KotlinTestReport)((Object)element$iv);
            boolean bl = false;
        } while (!it.getHasFailedTests());
        return true;
    }

    public final void addChild(@NotNull KotlinTestReport child) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)child), (String)"child");
        boolean bl = child.parent == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = (Object)((Object)child) + " already registers as child of " + (Object)((Object)child.parent);
            throw (Throwable)new IllegalStateException(string.toString());
        }
        child.parent = this;
        this.children.add(child);
        this.reportOnChildTasks(child);
    }

    private final void reportOnChildTasks(KotlinTestReport child) {
        Object it;
        Iterable $this$forEach$iv = child.testTasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AbstractTestTask)element$iv;
            boolean bl = false;
            this.reportOn((AbstractTestTask)it);
        }
        $this$forEach$iv = child.children;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (KotlinTestReport)((Object)element$iv);
            boolean bl = false;
            this.reportOnChildTasks((KotlinTestReport)((Object)it));
        }
    }

    public final void registerTestTask(@NotNull AbstractTestTask task) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        this.testTasks.add(task);
        task.addTestListener((TestListener)this.failedTestsListener);
        this.reportOn(task);
        this.addToParents(task);
    }

    private final void addToParents(AbstractTestTask task) {
        KotlinTestReport parent = this.parent;
        if (parent != null) {
            parent.reportOn(task);
            parent.addToParents(task);
        }
    }

    private final void reportOn(AbstractTestTask task) {
        this.reportOn(new Object[]{task.getBinResultsDir()});
    }

    @Internal
    @Nullable
    public String getHtmlReportUrl() {
        String string;
        File file = this.getDestinationDir();
        if (file != null) {
            File file2 = file;
            boolean bl = false;
            boolean bl2 = false;
            File it = file2;
            boolean bl3 = false;
            string = this.asClickableFileUrl(FilesKt.resolve((File)it, (String)"index.html"));
        } else {
            string = null;
        }
        return string;
    }

    private final String asClickableFileUrl(File path) {
        URI uRI = path.toURI();
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"path.toURI()");
        String string = new URI("file", "", uRI.getPath(), null, null).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"URI(\"file\", \"\", path.toU\u2026h, null, null).toString()");
        return string;
    }

    @TaskAction
    public final void checkFailedTests() {
        if (this.checkFailedTests && this.getHasFailedTests()) {
            StringBuilder message2 = new StringBuilder("There were failing tests.");
            String reportUrl = this.getHtmlReportUrl();
            if (reportUrl != null) {
                message2.append(" See the report at: " + reportUrl);
            }
            if (this.ignoreFailures) {
                this.getLogger().warn(message2.toString());
            } else {
                throw (Throwable)new GradleException(message2.toString());
            }
        }
    }

    public final void maybeOverrideReporting(@NotNull TaskExecutionGraph graph) {
        Intrinsics.checkParameterIsNotNull((Object)graph, (String)"graph");
        if (!this.getOverrideReporting()) {
            return;
        }
        if (!graph.hasTask((Task)this)) {
            return;
        }
        KotlinTestReport parent = this.parent;
        while (parent != null) {
            if (parent.getOverrideReporting() && graph.hasTask((Task)parent)) {
                return;
            }
            parent = parent.parent;
        }
        this.overrideReporting();
    }

    private final void overrideReporting() {
        this.ignoreFailures = false;
        this.checkFailedTests = true;
        this.disableIndividualTestTaskReportingAndFailing();
    }

    private final void disableIndividualTestTaskReportingAndFailing() {
        Object it;
        Iterable $this$forEach$iv = this.testTasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AbstractTestTask)element$iv;
            boolean bl = false;
            this.disableTestReporting((AbstractTestTask)it);
        }
        $this$forEach$iv = this.children;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (KotlinTestReport)((Object)element$iv);
            boolean bl = false;
            ((KotlinTestReport)((Object)it)).checkFailedTests = false;
            super.disableIndividualTestTaskReportingAndFailing();
        }
    }

    private final void disableTestReporting(AbstractTestTask task) {
        task.setIgnoreFailures(true);
        TestTaskReports testTaskReports = task.getReports();
        Intrinsics.checkExpressionValueIsNotNull((Object)testTaskReports, (String)"task.reports");
        DirectoryReport directoryReport = testTaskReports.getHtml();
        Intrinsics.checkExpressionValueIsNotNull((Object)directoryReport, (String)"task.reports.html");
        directoryReport.setEnabled(false);
        TestTaskReports testTaskReports2 = task.getReports();
        Intrinsics.checkExpressionValueIsNotNull((Object)testTaskReports2, (String)"task.reports");
        JUnitXmlReport jUnitXmlReport = testTaskReports2.getJunitXml();
        Intrinsics.checkExpressionValueIsNotNull((Object)jUnitXmlReport, (String)"task.reports.junitXml");
        jUnitXmlReport.setEnabled(false);
    }

    public KotlinTestReport() {
        List list2;
        KotlinTestReport kotlinTestReport = this;
        boolean bl = false;
        kotlinTestReport.testTasks = list2 = (List)new ArrayList();
        kotlinTestReport = this;
        bl = false;
        kotlinTestReport.children = list2 = (List)new ArrayList();
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        this.projectProperties = new PropertiesProvider(project);
        this.failedTestsListener = new TestListener(this){
            final /* synthetic */ KotlinTestReport this$0;

            public void beforeTest(@NotNull TestDescriptor testDescriptor) {
                Intrinsics.checkParameterIsNotNull((Object)testDescriptor, (String)"testDescriptor");
            }

            public void afterSuite(@NotNull TestDescriptor suite, @NotNull TestResult result2) {
                Intrinsics.checkParameterIsNotNull((Object)suite, (String)"suite");
                Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
            }

            public void beforeSuite(@NotNull TestDescriptor suite) {
                Intrinsics.checkParameterIsNotNull((Object)suite, (String)"suite");
            }

            public void afterTest(@NotNull TestDescriptor testDescriptor, @NotNull TestResult result2) {
                Intrinsics.checkParameterIsNotNull((Object)testDescriptor, (String)"testDescriptor");
                Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
                if (result2.getFailedTestCount() > 0L) {
                    KotlinTestReport.access$setHasOwnFailedTests$p(this.this$0, true);
                }
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public static final /* synthetic */ boolean access$getHasOwnFailedTests$p(KotlinTestReport $this) {
        return $this.hasOwnFailedTests;
    }

    public static final /* synthetic */ void access$setHasOwnFailedTests$p(KotlinTestReport $this, boolean bl) {
        $this.hasOwnFailedTests = bl;
    }
}

