/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.jetbrains.kotlin.konan.util;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FileAlreadyExistsException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shadow.org.jetbrains.kotlin.konan.util.DependencyDownloader;
import shadow.org.jetbrains.kotlin.konan.util.DependencyDownloader$WhenMappings;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 72\u00020\u0001:\u0004789:Bp\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012U\b\u0002\u0010\u0006\u001aO\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0007j\u0004\u0018\u0001`\u000f\u00a2\u0006\u0002\u0010\u0010J8\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)H\u0002J \u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020#2\u0006\u0010,\u001a\u00020'2\b\b\u0002\u0010-\u001a\u00020.J \u0010/\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#2\u0006\u00100\u001a\u0002012\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u00102\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020#2\u0006\u0010&\u001a\u00020'H\u0002J(\u00103\u001a\u00020\u000e*\u0002012\u0006\u0010\"\u001a\u00020#2\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020)05H\u0002J\u001e\u00103\u001a\u00020\u000e*\u0002012\u0006\u00106\u001a\u00020\u00032\b\b\u0002\u0010\"\u001a\u00020#H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cRW\u0010\u001d\u001aK\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\u0007j\u0002`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001e\u001a\u00020\b*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006;"}, d2={"Lshadow/org/jetbrains/kotlin/konan/util/DependencyDownloader;", "", "maxAttempts", "", "attemptIntervalMs", "", "customProgressCallback", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "url", "currentBytes", "totalBytes", "", "Lshadow/org/jetbrains/kotlin/konan/util/ProgressCallback;", "(IJLkotlin/jvm/functions/Function3;)V", "getAttemptIntervalMs", "()J", "setAttemptIntervalMs", "(J)V", "executor", "Ljava/util/concurrent/ExecutorCompletionService;", "getExecutor", "()Ljava/util/concurrent/ExecutorCompletionService;", "getMaxAttempts", "()I", "setMaxAttempts", "(I)V", "progressCallback", "humanReadable", "getHumanReadable", "(J)Ljava/lang/String;", "doDownload", "originalUrl", "Ljava/net/URL;", "connection", "Ljava/net/URLConnection;", "tmpFile", "Ljava/io/File;", "append", "", "download", "source", "destination", "replace", "Lshadow/org/jetbrains/kotlin/konan/util/DependencyDownloader$ReplacingMode;", "resumeDownload", "originalConnection", "Ljava/net/HttpURLConnection;", "tryDownload", "checkHTTPResponse", "predicate", "Lkotlin/Function1;", "expected", "Companion", "DownloadingProgress", "HTTPResponseException", "ReplacingMode", "kotlin-native-shared"})
public final class DependencyDownloader {
    private final Function3<String, Long, Long, Unit> progressCallback;
    @NotNull
    private final ExecutorCompletionService<Unit> executor;
    private int maxAttempts;
    private long attemptIntervalMs;
    public static final int DEFAULT_MAX_ATTEMPTS = 10;
    public static final long DEFAULT_ATTEMPT_INTERVAL_MS = 3000L;
    @NotNull
    public static final String TMP_SUFFIX = "part";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ExecutorCompletionService<Unit> getExecutor() {
        return this.executor;
    }

    private final void checkHTTPResponse(@NotNull HttpURLConnection $receiver, int expected, URL originalUrl) {
        if ($receiver.getResponseCode() != expected) {
            throw (Throwable)new HTTPResponseException(originalUrl, $receiver.getResponseCode());
        }
    }

    static /* synthetic */ void checkHTTPResponse$default(DependencyDownloader dependencyDownloader, HttpURLConnection httpURLConnection, int n, URL uRL, int n2, Object object) {
        if ((n2 & 2) != 0) {
            URL uRL2 = httpURLConnection.getURL();
            Intrinsics.checkExpressionValueIsNotNull((Object)uRL2, (String)"url");
            uRL = uRL2;
        }
        dependencyDownloader.checkHTTPResponse(httpURLConnection, n, uRL);
    }

    private final void checkHTTPResponse(@NotNull HttpURLConnection $receiver, URL originalUrl, Function1<? super Integer, Boolean> predicate) {
        if (!((Boolean)predicate.invoke((Object)$receiver.getResponseCode())).booleanValue()) {
            throw (Throwable)new HTTPResponseException(originalUrl, $receiver.getResponseCode());
        }
    }

    private final void doDownload(URL originalUrl, URLConnection connection, File tmpFile, long currentBytes, long totalBytes, boolean append) {
        DownloadingProgress progress = new DownloadingProgress(currentBytes);
        this.executor.submit(new Callable<Unit>(connection, tmpFile, append, progress, totalBytes){
            final /* synthetic */ URLConnection $connection;
            final /* synthetic */ File $tmpFile;
            final /* synthetic */ boolean $append;
            final /* synthetic */ DownloadingProgress $progress;
            final /* synthetic */ long $totalBytes;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void call() {
                Closeable closeable = this.$connection.getInputStream();
                boolean bl = false;
                Throwable throwable = null;
                try {
                    InputStream from = (InputStream)closeable;
                    boolean bl2 = false;
                    Closeable closeable2 = new FileOutputStream(this.$tmpFile, this.$append);
                    boolean bl3 = false;
                    Throwable throwable2 = null;
                    try {
                        FileOutputStream to = (FileOutputStream)closeable2;
                        boolean bl4 = false;
                        byte[] buffer = new byte[8192];
                        int read = from.read(buffer);
                        while (read != -1) {
                            if (Thread.interrupted()) {
                                throw (Throwable)new InterruptedException();
                            }
                            to.write(buffer, 0, read);
                            this.$progress.update(read);
                            read = from.read(buffer);
                        }
                        if (this.$progress.getCurrentBytes() != this.$totalBytes) {
                            throw (Throwable)new EOFException("The stream closed before end of downloading.");
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            {
                this.$connection = uRLConnection;
                this.$tmpFile = file;
                this.$append = bl;
                this.$progress = downloadingProgress;
                this.$totalBytes = l;
            }
        });
        Future<Unit> result2 = null;
        do {
            String string = originalUrl.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"originalUrl.toString()");
            this.progressCallback.invoke((Object)string, (Object)progress.getCurrentBytes(), (Object)totalBytes);
        } while ((result2 = this.executor.poll(1L, TimeUnit.SECONDS)) == null);
        String string = originalUrl.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"originalUrl.toString()");
        this.progressCallback.invoke((Object)string, (Object)progress.getCurrentBytes(), (Object)totalBytes);
        try {
            result2.get();
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = e;
            }
            throw throwable;
        }
    }

    private final void resumeDownload(URL originalUrl, HttpURLConnection originalConnection, File tmpFile) {
        originalConnection.connect();
        long totalBytes = originalConnection.getContentLengthLong();
        long currentBytes = tmpFile.length();
        if (currentBytes >= totalBytes || Intrinsics.areEqual((Object)originalConnection.getHeaderField("Accept-Ranges"), (Object)"bytes") ^ true) {
            this.doDownload(originalUrl, originalConnection, tmpFile, 0L, totalBytes, false);
        } else {
            originalConnection.disconnect();
            URLConnection uRLConnection = originalUrl.openConnection();
            if (uRLConnection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
            }
            HttpURLConnection rangeConnection = (HttpURLConnection)uRLConnection;
            rangeConnection.setRequestProperty("range", "bytes=" + currentBytes + '-');
            rangeConnection.connect();
            this.checkHTTPResponse(rangeConnection, originalUrl, (Function1<? super Integer, Boolean>)((Function1)resumeDownload.1.INSTANCE));
            this.doDownload(originalUrl, rangeConnection, tmpFile, currentBytes, totalBytes, true);
        }
    }

    private final void tryDownload(URL url, File tmpFile) {
        URLConnection connection = url.openConnection();
        URLConnection uRLConnection = connection;
        if (!(uRLConnection instanceof HttpURLConnection)) {
            uRLConnection = null;
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        if (httpURLConnection != null) {
            this.checkHTTPResponse(httpURLConnection, 200, url);
        }
        if (connection instanceof HttpURLConnection && tmpFile.exists()) {
            this.resumeDownload(url, (HttpURLConnection)connection, tmpFile);
        } else {
            connection.connect();
            URLConnection uRLConnection2 = connection;
            Intrinsics.checkExpressionValueIsNotNull((Object)uRLConnection2, (String)"connection");
            long totalBytes = uRLConnection2.getContentLengthLong();
            this.doDownload(url, connection, tmpFile, 0L, totalBytes, false);
        }
    }

    @NotNull
    public final File download(@NotNull URL source2, @NotNull File destination, @NotNull ReplacingMode replace) {
        File tmpFile;
        Intrinsics.checkParameterIsNotNull((Object)source2, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        Intrinsics.checkParameterIsNotNull((Object)((Object)replace), (String)"replace");
        if (destination.exists()) {
            switch (DependencyDownloader$WhenMappings.$EnumSwitchMapping$0[replace.ordinal()]) {
                case 1: {
                    return destination;
                }
                case 2: {
                    throw (Throwable)new FileAlreadyExistsException(destination, null, null, 6, null);
                }
                case 3: {
                }
            }
        }
        boolean bl = !(tmpFile = new File(destination.getCanonicalPath() + ".part")).isDirectory();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "A temporary file is a directory: " + tmpFile.getCanonicalPath() + ". Remove it and try again.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = !destination.isDirectory();
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "The destination file is a directory: " + destination.getCanonicalPath() + ". Remove it and try again.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        int attempt = 1;
        long waitTime = 0L;
        while (true) {
            try {
                this.tryDownload(source2, tmpFile);
            }
            catch (HTTPResponseException e) {
                throw (Throwable)e;
            }
            catch (IOException e) {
                if (attempt >= this.maxAttempts) {
                    throw (Throwable)e;
                }
                String string = "Cannot download a dependency: " + e + '\n' + "Waiting " + (double)(waitTime += this.attemptIntervalMs) / (double)1000 + " sec and trying again (attempt: " + ++attempt + '/' + this.maxAttempts + ").";
                boolean bl6 = false;
                System.out.println((Object)string);
                Thread.sleep(waitTime);
                continue;
            }
            break;
        }
        Files.move(tmpFile.toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
        String string = "Done.";
        boolean bl7 = false;
        System.out.println((Object)string);
        return destination;
    }

    @NotNull
    public static /* synthetic */ File download$default(DependencyDownloader dependencyDownloader, URL uRL, File file, ReplacingMode replacingMode, int n, Object object) {
        if ((n & 4) != 0) {
            replacingMode = ReplacingMode.RETURN_EXISTING;
        }
        return dependencyDownloader.download(uRL, file, replacingMode);
    }

    private final String getHumanReadable(long $receiver) {
        if ($receiver < 0L) {
            return "-";
        }
        if ($receiver < (long)1024) {
            return $receiver + " bytes";
        }
        int exp = (int)(Math.log($receiver) / Math.log(1024.0));
        char prefix = "kMGTPE".charAt(exp - 1);
        String string = "%.1f %siB";
        Object[] objectArray = new Object[]{(double)$receiver / Math.pow(1024.0, exp), Character.valueOf(prefix)};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
        return string2;
    }

    public final int getMaxAttempts() {
        return this.maxAttempts;
    }

    public final void setMaxAttempts(int n) {
        this.maxAttempts = n;
    }

    public final long getAttemptIntervalMs() {
        return this.attemptIntervalMs;
    }

    public final void setAttemptIntervalMs(long l) {
        this.attemptIntervalMs = l;
    }

    public DependencyDownloader(int maxAttempts, long attemptIntervalMs, @Nullable Function3<? super String, ? super Long, ? super Long, Unit> customProgressCallback) {
        this.maxAttempts = maxAttempts;
        this.attemptIntervalMs = attemptIntervalMs;
        Function3 function3 = customProgressCallback;
        if (function3 == null) {
            function3 = (Function3)new Function3<String, Long, Long, Unit>(this){
                final /* synthetic */ DependencyDownloader this$0;

                public final void invoke(@NotNull String url, long currentBytes, long totalBytes) {
                    Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                    String string = "\rDownloading dependency: " + url + " (" + DependencyDownloader.access$getHumanReadable$p(this.this$0, currentBytes) + '/' + DependencyDownloader.access$getHumanReadable$p(this.this$0, totalBytes) + "). ";
                    boolean bl = false;
                    System.out.print((Object)string);
                }
                {
                    this.this$0 = dependencyDownloader;
                    super(3);
                }
            };
        }
        this.progressCallback = function3;
        this.executor = new ExecutorCompletionService(Executors.newSingleThreadExecutor(new ThreadFactory(){

            @NotNull
            public Thread newThread(@Nullable Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("konan-dependency-downloader");
                thread.setDaemon(true);
                return thread;
            }
        }));
    }

    public /* synthetic */ DependencyDownloader(int n, long l, Function3 function3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        if ((n2 & 2) != 0) {
            l = 3000L;
        }
        if ((n2 & 4) != 0) {
            function3 = null;
        }
        this(n, l, (Function3<? super String, ? super Long, ? super Long, Unit>)function3);
    }

    public DependencyDownloader() {
        this(0, 0L, null, 7, null);
    }

    public static final /* synthetic */ String access$getHumanReadable$p(DependencyDownloader $this, long $receiver) {
        return $this.getHumanReadable($receiver);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lshadow/org/jetbrains/kotlin/konan/util/DependencyDownloader$ReplacingMode;", "", "(Ljava/lang/String;I)V", "REPLACE", "THROW", "RETURN_EXISTING", "kotlin-native-shared"})
    public static final class ReplacingMode
    extends Enum<ReplacingMode> {
        public static final /* enum */ ReplacingMode REPLACE;
        public static final /* enum */ ReplacingMode THROW;
        public static final /* enum */ ReplacingMode RETURN_EXISTING;
        private static final /* synthetic */ ReplacingMode[] $VALUES;

        static {
            ReplacingMode[] replacingModeArray = new ReplacingMode[3];
            ReplacingMode[] replacingModeArray2 = replacingModeArray;
            replacingModeArray[0] = REPLACE = new ReplacingMode();
            replacingModeArray[1] = THROW = new ReplacingMode();
            replacingModeArray[2] = RETURN_EXISTING = new ReplacingMode();
            $VALUES = replacingModeArray;
        }

        public static ReplacingMode[] values() {
            return (ReplacingMode[])$VALUES.clone();
        }

        public static ReplacingMode valueOf(String string) {
            return Enum.valueOf(ReplacingMode.class, string);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lshadow/org/jetbrains/kotlin/konan/util/DependencyDownloader$HTTPResponseException;", "Ljava/io/IOException;", "url", "Ljava/net/URL;", "responseCode", "", "(Ljava/net/URL;I)V", "getResponseCode", "()I", "getUrl", "()Ljava/net/URL;", "kotlin-native-shared"})
    public static final class HTTPResponseException
    extends IOException {
        @NotNull
        private final URL url;
        private final int responseCode;

        @NotNull
        public final URL getUrl() {
            return this.url;
        }

        public final int getResponseCode() {
            return this.responseCode;
        }

        public HTTPResponseException(@NotNull URL url, int responseCode) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            super("Server returned HTTP response code: " + responseCode + " for URL: " + url);
            this.url = url;
            this.responseCode = responseCode;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\f"}, d2={"Lshadow/org/jetbrains/kotlin/konan/util/DependencyDownloader$DownloadingProgress;", "", "currentBytes", "", "(J)V", "getCurrentBytes", "()J", "setCurrentBytes", "update", "", "readBytes", "", "kotlin-native-shared"})
    public static final class DownloadingProgress {
        private volatile long currentBytes;

        public final void update(int readBytes) {
            this.currentBytes += (long)readBytes;
        }

        public final long getCurrentBytes() {
            return this.currentBytes;
        }

        public final void setCurrentBytes(long l) {
            this.currentBytes = l;
        }

        public DownloadingProgress(long currentBytes) {
            this.currentBytes = currentBytes;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lshadow/org/jetbrains/kotlin/konan/util/DependencyDownloader$Companion;", "", "()V", "DEFAULT_ATTEMPT_INTERVAL_MS", "", "DEFAULT_MAX_ATTEMPTS", "", "TMP_SUFFIX", "", "kotlin-native-shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

