/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.jetbrains.kotlin.konan.util;

import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import shadow.org.jetbrains.kotlin.konan.file.ZipUtilKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lshadow/org/jetbrains/kotlin/konan/util/DependencyExtractor;", "", "()V", "archiveExtension", "", "getArchiveExtension$kotlin_native_shared", "()Ljava/lang/String;", "useZip", "", "getUseZip$kotlin_native_shared", "()Z", "extract", "", "archive", "Ljava/io/File;", "targetDirectory", "extractTarGz", "tarGz", "Companion", "kotlin-native-shared"})
public final class DependencyExtractor {
    private final boolean useZip;
    @NotNull
    private final String archiveExtension;
    private static final long extractionTimeout = 3600L;
    @NotNull
    private static final TimeUnit extractionTimeoutUntis;
    public static final Companion Companion;

    public final boolean getUseZip$kotlin_native_shared() {
        return this.useZip;
    }

    @NotNull
    public final String getArchiveExtension$kotlin_native_shared() {
        return this.archiveExtension;
    }

    private final void extractTarGz(File tarGz, File targetDirectory) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        boolean bl = false;
        boolean bl2 = false;
        ProcessBuilder $receiver = processBuilder;
        boolean bl3 = false;
        $receiver.command("tar", "-xzf", tarGz.getCanonicalPath());
        $receiver.directory(targetDirectory);
        $receiver.inheritIO();
        Process tarProcess = processBuilder.start();
        boolean finished = tarProcess.waitFor(extractionTimeout, extractionTimeoutUntis);
        if (finished && tarProcess.exitValue() != 0) {
            throw (Throwable)new RuntimeException("Cannot extract archive with dependency: " + tarGz.getCanonicalPath() + ".\n" + "Tar exit code: " + tarProcess.exitValue() + '.');
        }
        if (!finished) {
            tarProcess.destroy();
            throw (Throwable)new RuntimeException("Cannot extract archive with dependency: " + tarGz.getCanonicalPath() + ".\n" + "Tar process hasn't finished in " + extractionTimeoutUntis.toSeconds(extractionTimeout) + " sec.");
        }
    }

    public final void extract(@NotNull File archive, @NotNull File targetDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)archive, (String)"archive");
        Intrinsics.checkParameterIsNotNull((Object)targetDirectory, (String)"targetDirectory");
        if (this.useZip) {
            Path path = archive.toPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"archive.toPath()");
            Path path2 = targetDirectory.toPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"targetDirectory.toPath()");
            ZipUtilKt.unzipTo(path, path2);
        } else {
            this.extractTarGz(archive, targetDirectory);
        }
    }

    public DependencyExtractor() {
        String string = System.getProperty("os.name");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"os.name\")");
        this.useZip = StringsKt.startsWith$default((String)string, (String)"Windows", (boolean)false, (int)2, null);
        this.archiveExtension = this.useZip ? "zip" : "tar.gz";
    }

    static {
        Companion = new Companion(null);
        extractionTimeout = 3600L;
        extractionTimeoutUntis = TimeUnit.SECONDS;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lshadow/org/jetbrains/kotlin/konan/util/DependencyExtractor$Companion;", "", "()V", "extractionTimeout", "", "getExtractionTimeout", "()J", "extractionTimeoutUntis", "Ljava/util/concurrent/TimeUnit;", "getExtractionTimeoutUntis", "()Ljava/util/concurrent/TimeUnit;", "kotlin-native-shared"})
    public static final class Companion {
        public final long getExtractionTimeout() {
            return extractionTimeout;
        }

        @NotNull
        public final TimeUnit getExtractionTimeoutUntis() {
            return extractionTimeoutUntis;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

