/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

public final class PackageClassUtils {
    public static final String PACKAGE_CLASS_NAME_SUFFIX = "Package";
    private static final String DEFAULT_PACKAGE_CLASS_NAME = "_DefaultPackage";

    private PackageClassUtils() {
    }

    @NotNull
    public static String getPackageClassName(@NotNull FqName packageFQN) {
        if (packageFQN.isRoot()) {
            return DEFAULT_PACKAGE_CLASS_NAME;
        }
        return PackageClassUtils.capitalizeNonEmptyString(packageFQN.shortName().asString()) + PACKAGE_CLASS_NAME_SUFFIX;
    }

    @NotNull
    private static String capitalizeNonEmptyString(@NotNull String s) {
        return Character.isUpperCase(s.charAt(0)) ? s : Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    @NotNull
    public static FqName getPackageClassFqName(@NotNull FqName packageFQN) {
        return packageFQN.child(Name.identifier(PackageClassUtils.getPackageClassName(packageFQN)));
    }

    @NotNull
    public static ClassId getPackageClassId(@NotNull FqName packageFQN) {
        return new ClassId(packageFQN, Name.identifier(PackageClassUtils.getPackageClassName(packageFQN)));
    }

    @NotNull
    public static String getPackageClassInternalName(@NotNull FqName packageFQN) {
        return JvmClassName.byFqNameWithoutInnerClasses(PackageClassUtils.getPackageClassFqName(packageFQN)).getInternalName();
    }

    public static boolean isPackageClassFqName(@NotNull FqName fqName2) {
        return !fqName2.isRoot() && PackageClassUtils.getPackageClassFqName(fqName2.parent()).equals(fqName2);
    }
}

